 //----------------------------------------------------------------------
//EASTRISING TECHNOLOGY CO,.LTD.//
// Module    : ER-OLED1.45-2C  1.69 INCH OLED  160RGB*128 DOTS
// Lanuage   : C51 Code
// Create    : JAVEN LIU
// Date      : 2022-07-04
// Drive IC  : SSD1333
// INTERFACE : 4 Wire SPI
// MCU 		 : STC12LE5C60S2
// VDD		 : 3 V
//----------------------------------------------------------------------

#include <stc12c5a.h>
#include <stdio.h>
#include <intrins.h>
#include<SSD1333.h>
#include<SD.h>


//============================================================
//Main 	
main()
{
 unsigned char  num; 		  
 unsigned long j;  
  unsigned int i=0;
  unsigned long AddTemp;//SD card first address . Use Win HXE software check physical addresses.  SD CARD is different, the address is different yet.

  	IE=0x81;
	IP=0x01;
	TCON=0x01;
	int0=1;
					  
 	P2M1=0x00; //Set P1 port as push-pull output
  	P2M0=0xff;

 	P3M1=0x00; //Set P3 port as push-pull output
	P3M0=0xff;


 	P1=0xff;
 	P2=0xff;
 	P3=0xff;
 	P0=0xff;
	Initial();
	Fill_RAM(0x00,0x00);			// Clear Screen
	SdInit();         //SD Initial
while(1)
 {
	dispBmp(pic);
	Delay(3);




	ColorSet(0xf800);	//red
	Delay(3);
	ColorSet(0x07e0);	//green
	Delay(3);
	ColorSet(0x001f);  	//blue
	Delay(3);
	ColorSet(0xffff);	//white
	Delay(3);
	ColorSet(0x07ff);	//lightblue
	Delay(3);
	ColorSet(0xffe0);	//yellow
	Delay(3);
	ColorSet(0xf81f);	//pink
	Delay(3);
	ColorSet(0x0000);  	//black
	Delay(3);
	Display1();
	Delay(3);
	Display2();
	Delay(3);
		 
		 AddTemp=422400;

			num=6;		//picture number
		 while(num--)
		 {
		Set_Column_Address(0x00,0x9F);
		Set_Row_Address(0x00,0x7F);
		Set_Write_RAM();
		 for(j=0;j<80;j++)   //A picture contains 48 x512 bytes data
		    {
		    SdReadBlock(DATA,AddTemp+(j*512),512);//One time read 512 byte to buffer 
		    for(i=0;i<256;i++)                    //Write buffer data to display.one dots tow byte .512/2=256 dots
			   {   
		   	   DataWrite(DATA[2*i]);
			   DataWrite(DATA[2*i+1]); 	
		       }
		     } 
		     AddTemp = AddTemp+((j+16)*512);        // 20 This value is not data area, SD Card is different, this value, there may be different. Use Win HXE software check the value.
		     Delay(3);                     //Press the STOP button,display next picture
		
			 
		 } 
 }


}


