

/* SSD2828 interface define */

sbit SDI_2828	  =    P1^5;
sbit SCLK_2828    =    P1^7;
sbit SDO_2828    =    P1^6;	
sbit CS_2828	  =	P3^4;	  //  3.6
sbit RST_2828	  =	P1^4;	  //  3.4



 
#define	HBPD  20
#define	HFPD  12 
#define	HSPW  3
   
#define	VBPD  20
#define	VFPD  20
#define	VSPW  20  


//=================================================
/*--LCDֶ--------------------------*/
#define hsize 480
#define vsize 480



									
SSD2828_Reset(void)
 {



   		RST_2828=0;						   
		delay_ms(30);
 		RST_2828=1;
		delay_ms(50);


  	CS_2828=1;
	SCLK_2828 =0;
	SDI_2828=1;

 }




void SPI_3W_SET_Cmd(unsigned int Sdata) { 
	unsigned char i;
	
	CS_2828=0;
	SDI_2828=0;
	SCLK_2828 =0; 
	SCLK_2828 =1;
	
	for(i=8; i>0; i--) {
		if(Sdata&0x80)
			SDI_2828=1;
		else
			SDI_2828=0;
		SCLK_2828 =0; 
		SCLK_2828 =1;
		Sdata <<= 1;
	}
	SCLK_2828 =0;
	CS_2828=1;
}

void SPI_3W_SET_PAs(unsigned int Sdata) {
	unsigned char i;
	
	CS_2828=0;
	SDI_2828=1;
	SCLK_2828 =0; 
	SCLK_2828 =1;
	
	for(i=8; i>0; i--) {
		if(Sdata&0x80)
			SDI_2828=1;
		else
			SDI_2828=0;
		SCLK_2828 =0; 
		SCLK_2828 =1;
		Sdata <<= 1;
	}
	SCLK_2828 =0;
	CS_2828=1;
}

unsigned char SPI_ReadData(void) {	 
	unsigned char i;
	unsigned char Value = 0;
	
	CS_2828=0;
	SCLK_2828 =0;
	
	for(i=0; i<8; i++) {
		SCLK_2828 =0; 
		SCLK_2828 =1;
		Value <<= 1;
		if(SDO_2828==1)
			Value |= 0x01;
	}
	CS_2828=1;
	
	return Value;
}

void SPI_WriteData(unsigned char value) 
{
	SPI_3W_SET_PAs(value);
}

void SPI_WriteCmd(unsigned char value) 
{
	SPI_3W_SET_Cmd(value);
}


//2014-08-29 ȥbd be
void GP_COMMAD_PA(unsigned int num) 
{
	SPI_WriteCmd(0xbc);
	SPI_WriteData(num&0xff);	
	SPI_WriteData((num>>8)&0xff);	
	SPI_WriteCmd(0xbf);
}


void  LCD_initial()
{


   	GP_COMMAD_PA(6);
	SPI_WriteData(0xFF);
	SPI_WriteData(0x77);
	SPI_WriteData(0x01);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x10);

  	GP_COMMAD_PA(3);	
	SPI_WriteData(0xC0);
	SPI_WriteData(0x3B);//Scan line	
	SPI_WriteData(0x00);

  	GP_COMMAD_PA(3);	
	SPI_WriteData(0xC1);
	SPI_WriteData(0x0B);	//VBP
	SPI_WriteData(0x02);

  	GP_COMMAD_PA(3);	
	SPI_WriteData(0xC2);
	SPI_WriteData(0x07);
	SPI_WriteData(0x02);

  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xCC);
	SPI_WriteData(0x10);

  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xCD);//RGB format
	SPI_WriteData(0x08);        //565ʱ    666

  	GP_COMMAD_PA(17);	
	SPI_WriteData(0xB0); // IPS   
	SPI_WriteData(0x00); // 255 
	SPI_WriteData(0x11); // 251    
	SPI_WriteData(0x16); // 247  down
	SPI_WriteData(0x0e); // 239    
	SPI_WriteData(0x11); // 231    
	SPI_WriteData(0x06); // 203    
	SPI_WriteData(0x05); // 175 
	SPI_WriteData(0x09); // 147    
	SPI_WriteData(0x08); // 108    
	SPI_WriteData(0x21); // 80  
	SPI_WriteData(0x06); // 52   
	SPI_WriteData(0x13); // 24    
	SPI_WriteData(0x10); // 16    
	SPI_WriteData(0x29); // 8    down
	SPI_WriteData(0x31); // 4    
	SPI_WriteData(0x18); // 0   

  	GP_COMMAD_PA(17);	
	SPI_WriteData(0xB1);//  IPS	   
	SPI_WriteData(0x00);//  255 
	SPI_WriteData(0x11);//  251
	SPI_WriteData(0x16);//  247   down
	SPI_WriteData(0x0e);//  239
	SPI_WriteData(0x11);//  231
	SPI_WriteData(0x07);//  203    
	SPI_WriteData(0x05);//  175
	SPI_WriteData(0x09);//  147  
	SPI_WriteData(0x09);//  108  
	SPI_WriteData(0x21);//  80 
	SPI_WriteData(0x05);//  52   
	SPI_WriteData(0x13);//  24 
	SPI_WriteData(0x11);//  16 
	SPI_WriteData(0x2a);//  8  down 
	SPI_WriteData(0x31);//  4  
	SPI_WriteData(0x18);//  0  

  	GP_COMMAD_PA(6);	
	SPI_WriteData(0xFF);
	SPI_WriteData(0x77);
	SPI_WriteData(0x01);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x11);

  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xB0);  //VOP  3.5375+ *x 0.0125
	SPI_WriteData(0x5d);  //5D
  	GP_COMMAD_PA(2);	 
	SPI_WriteData(0xB1); 	//VCOM amplitude setting  
	SPI_WriteData(0x37);  //
  	GP_COMMAD_PA(2);	  
	SPI_WriteData(0xB2); 	//VGH Voltage setting  
	SPI_WriteData(0x81);	//12V
  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xB3);
	SPI_WriteData(0x80);
  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xB5); 	//VGL Voltage setting  
	SPI_WriteData(0x43);	//-8.3V
  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xB7);
	SPI_WriteData(0x85);
  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xB8);
	SPI_WriteData(0x20);
  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xC1);
	SPI_WriteData(0x78);
  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xC2);
	SPI_WriteData(0x78);
  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xD0);
	SPI_WriteData(0x88);

  	GP_COMMAD_PA(4);	
	SPI_WriteData(0xE0);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x02);

  	GP_COMMAD_PA(12);	
	SPI_WriteData(0xE1);
	SPI_WriteData(0x03);	
	SPI_WriteData(0xA0);
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);
	SPI_WriteData(0x04);	
	SPI_WriteData(0xA0);
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);
	SPI_WriteData(0x20);
	SPI_WriteData(0x20);

  	GP_COMMAD_PA(14);	
	SPI_WriteData(0xE2);
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	  
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);

  	GP_COMMAD_PA(5);	
	SPI_WriteData(0xE3);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x11);
	SPI_WriteData(0x00);

  	GP_COMMAD_PA(3);	
	SPI_WriteData(0xE4);
	SPI_WriteData(0x22);
	SPI_WriteData(0x00);

  	GP_COMMAD_PA(17);	
	SPI_WriteData(0xE5);		
	SPI_WriteData(0x05);	
	SPI_WriteData(0xEC);	
	SPI_WriteData(0xA0);
	SPI_WriteData(0xA0);
	SPI_WriteData(0x07);	
	SPI_WriteData(0xEE);	
	SPI_WriteData(0xA0);
	SPI_WriteData(0xA0);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	
  	GP_COMMAD_PA(5);
	SPI_WriteData(0xE6);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x11);
	SPI_WriteData(0x00);

  	GP_COMMAD_PA(3);	
	SPI_WriteData(0xE7);
	SPI_WriteData(0x22);
	SPI_WriteData(0x00);

  	GP_COMMAD_PA(17);	
	SPI_WriteData(0xE8);		
	SPI_WriteData(0x06);	
	SPI_WriteData(0xED);	
	SPI_WriteData(0xA0);
	SPI_WriteData(0xA0);
	SPI_WriteData(0x08);	
	SPI_WriteData(0xEF);	
	SPI_WriteData(0xA0); 
	SPI_WriteData(0xA0);
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);	
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	
  	GP_COMMAD_PA(8);
	SPI_WriteData(0xEB);
	SPI_WriteData(0x00); 	
	SPI_WriteData(0x00);
	SPI_WriteData(0x40);
	SPI_WriteData(0x40);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);  

  	GP_COMMAD_PA(17);	
	SPI_WriteData(0xED);  
	SPI_WriteData(0xFF); 
	SPI_WriteData(0xFF);  
	SPI_WriteData(0xFF); 	
	SPI_WriteData(0xBA); 		
	SPI_WriteData(0x0A); 	
	SPI_WriteData(0xBF); 	
	SPI_WriteData(0x45); 	
	SPI_WriteData(0xFF); 
	SPI_WriteData(0xFF);  
	SPI_WriteData(0x54); 	
	SPI_WriteData(0xFB); 	
	SPI_WriteData(0xA0); 	
	SPI_WriteData(0xAB); 	
	SPI_WriteData(0xFF); 
	SPI_WriteData(0xFF); 
	SPI_WriteData(0xFF); 

  	GP_COMMAD_PA(7);	
	SPI_WriteData(0xEF);
	SPI_WriteData(0x10); 
	SPI_WriteData(0x0D); 
	SPI_WriteData(0x04); 
	SPI_WriteData(0x08); 
	SPI_WriteData(0x3F); 
	SPI_WriteData(0x1F);

  	GP_COMMAD_PA(6);	
	SPI_WriteData(0xFF);
	SPI_WriteData(0x77);
	SPI_WriteData(0x01);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x13);

  	GP_COMMAD_PA(2);	
	SPI_WriteData(0xEF);
	SPI_WriteData(0x08);

  	GP_COMMAD_PA(6);	
	SPI_WriteData(0xFF);
	SPI_WriteData(0x77);
	SPI_WriteData(0x01);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);
	
  	GP_COMMAD_PA(2);
	SPI_WriteData(0x36);
	SPI_WriteData(0x00);
  	GP_COMMAD_PA(2);	
	SPI_WriteData(0x3A);
	SPI_WriteData(0x77);  

   
  	GP_COMMAD_PA(1);
	SPI_WriteData(0x11);     
	delay_ms(120);      //ms
	
 	GP_COMMAD_PA(1);
	SPI_WriteData(0x29);  
 	delay_ms(10);  				
		 
}


void  SSD2828_initial()
{
   //SSD2828_Initial
	SPI_WriteCmd(0xb7);
	SPI_WriteData(0x50);//50=TX_CLK 70=PCLK
	SPI_WriteData(0x00);   //Configuration Register

	SPI_WriteCmd(0xb8);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);   //VC(Virtual ChannelID) Control Register

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x00);//1=PLL disable
	SPI_WriteData(0x00);
	 //TX_CLK/MS should be between 5Mhz to100Mhz
	SPI_WriteCmd(0xBA);//PLL=(TX_CLK/MS)*NS 8228=480M 4428=240M  061E=120M 4214=240M 821E=360M 8219=300M
	SPI_WriteData(0x14);//D7-0=NS(0x01 : NS=1)
	SPI_WriteData(0x42);//D15-14=PLLΧ 00=62.5-125 01=126-250 10=251-500 11=501-1000  DB12-8=MS(01:MS=1)

	SPI_WriteCmd(0xBB);//LP Clock Divider LP clock = 400MHz / LPD / 8 = 240 / 8 / 4 = 7.5MHz
	SPI_WriteData(0x03);//D5-0=LPD=0x1 C Divide by 2
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x01);//1=PLL disable
	SPI_WriteData(0x00);
	//MIPI lane configuration
	SPI_WriteData(0xDE);//ͨ
	SPI_WriteData(0x01);//11=4LANE 10=3LANE 01=2LANE 00=1LANE
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xc9);
	SPI_WriteData(0x02);
	SPI_WriteData(0x23);   //p1: HS-Data-zero  p2: HS-Data- prepare  --> 8031 issue
	 delay_ms(100);



	//LCD driver initialization
 	//==Video Mode Initial Code	    				    
	SPI_WriteCmd(0xB7);
	SPI_WriteData(0x50);//10=TX_CLK 30=PCLK
	SPI_WriteData(0x02);

	SPI_WriteCmd(0xBD);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);

     LCD_initial();//LCD driver initialization	  

  
/////////////////SSD2828_Initial////////////////

	SPI_WriteCmd(0xb7);
	SPI_WriteData(0x50);
	SPI_WriteData(0x00);   //Configuration Register

	SPI_WriteCmd(0xb8);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);   //VC(Virtual ChannelID) Control Register

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x00);//1=PLL disable
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xBA);//PLL=(TX_CLK/MS)*NS 8228=480M 4428=240M  061E=120M 4214=240M 821E=360M 8219=300M 8225=444M 8224=432
	SPI_WriteData(0x27);//D7-0=NS(0x01 : NS=1)
	SPI_WriteData(0x82);//D15-14=PLLΧ 00=62.5-125 01=126-250 10=251-500 11=501-1000  DB12-8=MS(01:MS=1)

	SPI_WriteCmd(0xBB);//LP Clock Divider LP clock = 400MHz / LPD / 8 = 480 / 8/ 8 = 7MHz
	SPI_WriteData(0x07);//D5-0=LPD=0x1 C Divide by 2
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x01);//1=PLL disable
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xc9);
	SPI_WriteData(0x02);
	SPI_WriteData(0x23);   //p1: HS-Data-zero  p2: HS-Data- prepare  --> 8031 issue
	delay_ms(100);

	SPI_WriteCmd(0xCA);
	SPI_WriteData(0x01);//CLK Prepare
	SPI_WriteData(0x23);//Clk Zero

	SPI_WriteCmd(0xCB); //local_write_reg(addr=0xCB,data=0x0510)
	SPI_WriteData(0x10); //Clk Post
	SPI_WriteData(0x05); //Clk Per

	SPI_WriteCmd(0xCC); //local_write_reg(addr=0xCC,data=0x100A)
	SPI_WriteData(0x05); //HS Trail
	SPI_WriteData(0x10); //Clk Trail

	SPI_WriteCmd(0xD0);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);

		//RGB interface configuration
	SPI_WriteCmd(0xB1);
	SPI_WriteData(HSPW);//HSPW 07
	SPI_WriteData(VSPW);//VSPW 05

	SPI_WriteCmd(0xB2);
	SPI_WriteData(HBPD);//HBPD 0x64=100
	SPI_WriteData(VBPD);//VBPD 8 С

	SPI_WriteCmd(0xB3);
	SPI_WriteData(HFPD);//HFPD 8
	SPI_WriteData(VFPD);//VFPD 10

	SPI_WriteCmd(0xB4);//Horizontal active period 
	SPI_WriteData(hsize);//013F=319 02D0=720
	SPI_WriteData(hsize>>8);//

	SPI_WriteCmd(0xB5);//Vertical active period 
	SPI_WriteData(vsize);//01DF=479 0500=1280
	SPI_WriteData(vsize>>8);//

	SPI_WriteCmd(0xB6);//RGB CLK  16BPP=00 18BPP=01
	SPI_WriteData(0x07);//D7=0 D6=0 D5=0  D1-0=11 C 24bpp
	SPI_WriteData(0x00);//D15=VS D14=HS D13=CLK D12-9=NC D8=0=Video with blanking packet. 00-F0



		//MIPI lane configuration
	SPI_WriteCmd(0xDE);//ͨ
	SPI_WriteData(0x01);//11=4LANE 10=3LANE 01=2LANE 00=1LANE
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xD6);//  05=BGR  04=RGB
	SPI_WriteData(0x05);//D0=0=RGB 1:BGR D1=1=Most significant byte sent first
	SPI_WriteData(0x00);


	SPI_WriteCmd(0xB7);
	SPI_WriteData(0x4B);
	SPI_WriteData(0x02); 


}

