
/* touch panel interface define */
sbit SDA	   =    P3^0;
sbit SCL       =    P3^1;
sbit PEN       =    P3^2;	
sbit RESET	   =	P3^3;


#define uchar      unsigned char
#define uint       unsigned int
#define ulong      unsigned long

#define WHITE          0xFFFF
#define BLACK          0x0000
#define GRAY           0xF7DE
#define BLUE           0x001F
#define BLUE2          0x051F
#define RED            0xF800
#define PURPLE         0xF81F
#define GREEN          0x07E0
#define CYAN           0x7FFF
#define YELLOW         0xFFE0
#define DGREEN         0x07E0


//Touch Status	 
#define Key_Down 0x01
#define Key_Up   0x00 

struct _ts_event
{
    uint    x1;
    uint    y1;
    uint    x2;
    uint    y2;
    uchar     touch_point;
	uchar     Key_Sta;	
};

struct _ts_event ts_event; 

#define WRITE_ADD	0x70  
#define READ_ADD	0x71  

void TOUCH_Init(void);
void TOUCH_Start(void);
void TOUCH_Stop(void);
uchar TOUCH_Wait_Ack(void);
void TOUCH_Ack(void);
void TOUCH_NAck(void);

void TOUCH_Send_Byte(uchar txd);
uchar TOUCH_Read_Byte(unsigned char ack);
void TOUCH_Wr_Reg(uchar RegIndex,uchar RegValue1);
void TOUCH_RdParFrPCTPFun(uchar *PCTP_Par,uchar ValFlag);
uchar   TOUCH_Read_Reg(uchar RegIndex);
void Draw_Big_Point(uint x,uint y,uint colour);
uchar ft3267_read_data(void);


//IIC start
void TOUCH_Start(void)
{ 
	SDA=1;  
	delay_us(5);	  
	SCL=1;
	delay_us(5);
	SDA=0;  
	delay_us(5);
	SCL=0;
	delay_us(5);
}	  


//IIC stop
void TOUCH_Stop(void)
{
	SDA=0;
	delay_us(5);
	SCL=1;
	delay_us(5);
	SDA=1;
	delay_us(5);
	SCL=0;
	delay_us(5);							   	
}


//Wait for an answer signal
uchar TOUCH_Wait_Ack(void)
{	uchar errtime=0;

	SDA=1;
	delay_us(5);
	SCL=1;
	delay_us(5);
  	while(SDA)
	{
	    errtime++;
	    if(errtime>250)
		    {
		      TOUCH_Stop();
		      return 1;
		    }	
	
	   ;
	}
	SCL=0;
	delay_us(5);

	return 0;
}



//Acknowledge
void TOUCH_Ack(void)
{	SCL=0;
	delay_us(5);
	SDA=0;
	delay_us(5);
	SCL=1;
	delay_us(5);
	SCL=0;
	delay_us(5);
}



//NO Acknowledge		    
void TOUCH_NAck(void)
{	SCL=0;
	delay_us(5);
	SDA=1;
	delay_us(5);
	SCL=1;
	delay_us(5);
	SCL=0;
	delay_us(5);
}	
	

//IIC send one byte		  
void TOUCH_Send_Byte(uchar Byte)
{	uchar t;  		

    for(t=0;t<8;t++)
    { 	SCL=0;            
	   	SDA=(bit)(Byte & 0x80) ;
	   	Byte <<=1;
	delay_us(5);
	   	SCL=1;
	delay_us(5);
	   	SCL=0;
	delay_us(5);
    }	
 

} 




//Read one byteack=0Send Acknowledgeack=1NO Acknowledge   
uchar TOUCH_Read_Byte(uchar ack)
{	uchar t,receive=0;

	SCL=0;
	delay_us(5);
	SDA=1;
	delay_us(5);
	for(t = 0; t < 8; t++)
	{	
	 	SCL = 1;
		delay_us(5);
	 	receive<<=1;
	 	if(SDA == 1)
	 	receive=receive|0x01;
		delay_us(5);
	 	SCL=0;
		delay_us(5);
	}

					 
   	if (ack)  TOUCH_NAck();//NO Acknowledge 
   	else       TOUCH_Ack(); //Send Acknowledge   
    
	 return receive;
}


void TOUCH_Wr_Reg(uchar RegIndex,uchar RegValue1)
{
	TOUCH_Start();
	TOUCH_Send_Byte(WRITE_ADD);
	TOUCH_Wait_Ack();	
	TOUCH_Send_Byte(RegIndex);
	TOUCH_Wait_Ack();
	
	TOUCH_Send_Byte(RegValue1);
	TOUCH_Wait_Ack();

	TOUCH_Stop();
	delay_us(10);
}


void TOUCH_RdParFrPCTPFun(uchar *PCTP_Par,uchar ValFlag)
{	uchar k;

  	TOUCH_Start();
	TOUCH_Send_Byte(WRITE_ADD);
	TOUCH_Wait_Ack();
	TOUCH_Send_Byte(0x00);
	TOUCH_Wait_Ack();


	TOUCH_Start();
	TOUCH_Send_Byte(READ_ADD);
	TOUCH_Wait_Ack();	
	for(k=0;k<ValFlag;k++)
	{
		if(k==(ValFlag-1))  *(PCTP_Par+k)=TOUCH_Read_Byte(1);
		else                *(PCTP_Par+k)=TOUCH_Read_Byte(0);
	}		
	TOUCH_Stop();
}


uchar TOUCH_Read_Reg(uchar RegIndex)
{	uchar receive=0;

	TOUCH_Start();
	TOUCH_Send_Byte(WRITE_ADD);
	TOUCH_Wait_Ack();
	TOUCH_Send_Byte(RegIndex);
	TOUCH_Wait_Ack();
	
	TOUCH_Start();
	TOUCH_Send_Byte(READ_ADD);
	TOUCH_Wait_Ack();	
	receive=TOUCH_Read_Byte(1);
	TOUCH_Stop();
 	 
	return receive;
}


void ft3267_i2c_txdata(uchar *txdata, uchar length)
{	uchar ret =0;	uint num;

  	TOUCH_Start();
  	TOUCH_Send_Byte(WRITE_ADD);      
  	TOUCH_Wait_Ack();
  	for(num=0;num<length;num++)
  	{
		TOUCH_Send_Byte(txdata[num]); 
    	TOUCH_Wait_Ack();      
  	}                   
  	TOUCH_Stop();
 	delay_us(5);


}

uchar ft3267_i2c_rxdata(uchar *rxdata, uchar length)
{	uchar num;	uchar *rxdatatmp =  rxdata;

  	TOUCH_Start();
  	TOUCH_Send_Byte(READ_ADD);
  	TOUCH_Wait_Ack();            
	for(num=0;num<length;num++)
  	{
		if(num==(length-1))  
		rxdatatmp[num]=TOUCH_Read_Byte(0);   
        else 
    	rxdatatmp[num]=TOUCH_Read_Byte(1);   
  	}

  	TOUCH_Stop();
	
  	return rxdatatmp;
}

uchar ft3267_read_data(void)
{	uchar buf[13] = {0}; uchar ret = 0;


		TOUCH_RdParFrPCTPFun(buf, 13);


  	ts_event.touch_point = buf[2] & 0xf;

		if(ts_event.touch_point==0)	return ; 

					switch (ts_event.touch_point) 
					{

						
						    case 1:
						           	ts_event.x1 = (uint)(buf[3] & 0x0F)<<8 | (uint)buf[4];
						           	ts_event.y1 = (uint)(buf[5] & 0x0F)<<8 | (uint)buf[6];

						    case 2: ts_event.x1 = (uint)(buf[3] & 0x0F)<<8 | (uint)buf[4];
						           	ts_event.y1 = (uint)(buf[5] & 0x0F)<<8 | (uint)buf[6];

						           	ts_event.x2 = (uint)(buf[9] & 0x0F)<<8 | (uint)buf[10];
						           	ts_event.y2 = (uint)(buf[11] & 0x0F)<<8 | (uint)buf[12];

				
						    break;
						    default:
						    return 0;
					}


    
	return ret;
}


void inttostr(uint value,uchar *str)
{
	str[0]=value/1000+48;
	str[1]=value%1000/100+48;
	str[2]=value%100/10+48;
	str[3]=value%100%10+48;

}


////////////////////////////////////
void  counter0(void) interrupt 0
{
 	if(PEN==0)										//Detect the occurrence of an interrupt
 	{
		ts_event.Key_Sta=Key_Down;                              

 	}
}

void TOUCH_Init(void)
{
		SDA=1;
		SCL=1;
		RESET=0;
		delay_ms(100);
		RESET=1;;
		delay_ms(10);

}





/******************************************************************************************
*Function nameDraw_Big_Point(u16 x,u16 y)
* Parameteruint16_t x,uint16_t y xy
* Return Valuevoid
* FunctionDraw touch pen nib point 2 * 2
*********************************************************************************************/		   
void Draw_Big_Point(uint x,uint y,uint colour)
{    
	LCD_SetCursor(x,y);
  	LCD_WriteRAM_Prepare();
	LCD_DataWrite(colour);
	LCD_DataWrite(colour>>8);
	LCD_DataWrite(colour);
	LCD_DataWrite(colour>>8);

  	LCD_SetCursor(x,y+1);//Memory write position
  	LCD_WriteRAM_Prepare();					   
	LCD_DataWrite(colour);
	LCD_DataWrite(colour>>8);
	LCD_DataWrite(colour);
	LCD_DataWrite(colour>>8);



}

void LCD_DrawCircle_Fill
(
 unsigned short XCenter         
,unsigned short YCenter           
,unsigned short R                
,unsigned long ForegroundColor 
)
{
	Foreground_color_65k(ForegroundColor);
	Circle_Center_XY(XCenter,YCenter);
  Circle_Radius_R(R);
  Start_Circle_or_Ellipse_Fill();
  Check_2D_Busy(); 
}


void TPTEST(void)
{
	uchar ss[4];uchar a=1,k=1;	
	 IT0=1;        //Falling edge trigger  
	 EX0=1;
	 EA=1;

	
//	P3M0 |= (1<<2); // INT
//	P3M1 &= ~(1<<2);

	P3M0 &= ~(1<<2); // INT	
	P3M1 |= (1<<2); // INT

   
	ts_event.x1=0;
	ts_event.y1=0;
	ts_event.x2=0;
	ts_event.y2=0;

	 TOUCH_Init();


  	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);							
	Main_Window_Start_XY(0,0);

	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);//
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT ,LCD_YSIZE_TFT);

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT ,LCD_YSIZE_TFT);
	Start_Square_Fill();


 ///////////////////////////Square

	Foreground_color_65k(Red);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1 ,LCD_YSIZE_TFT-1);
	Start_Square();
	delay_ms(50);

  
	Foreground_color_65k(White);
	Background_color_65k(Black);

		Font_Select_8x16_16x16();
		Goto_Text_XY(40,200);	
		Show_String("Capacitive touch screen test");
		Goto_Text_XY(LCD_XSIZE_TFT/2-20,5);
		Show_String("Clear");   
		Goto_Text_XY(LCD_XSIZE_TFT/2-20,LCD_YSIZE_TFT-25);
		Show_String("Exit");

		/*   ///////////test I2C address
  			while(1)		
				{
 				TOUCH_Start();	
 				TOUCH_Send_Byte(a);   	//д 	 
				k=TOUCH_Wait_Ack();
				TOUCH_Stop();
				 if(k==0){	Foreground_color_65k(Green);
					Background_color_65k(Black);
					Goto_Text_XY(60,300);   //Set the display position	
					Show_String("test ok  I2C address:");  
					inttostr(a,ss);
					Text_Mode();
					LCD_CmdWrite(0x04);	
				  	LCD_DataWrite(ss[0]);
					//Delay1ms(1);
				  	LCD_DataWrite(ss[1]);
					//Delay1ms(1);
				  	LCD_DataWrite(ss[2]);
					//Delay1ms(1);
 				  	LCD_DataWrite(ss[3]); 
				//	while(1);  
				delay_ms(20000);
				   }

		         else{  
		           Foreground_color_65k(Red);
					Background_color_65k(Black);
					inttostr(a,ss);
					Goto_Text_XY(100,330);   //Set the display position	
					Text_Mode();	   
					LCD_CmdWrite(0x04);	
				  	LCD_DataWrite(ss[0]);
					//Delay1ms(1);
				  	LCD_DataWrite(ss[1]);
					//Delay1ms(1);
				  	LCD_DataWrite(ss[2]);
					//Delay1ms(1);
 				  	LCD_DataWrite(ss[3]); 
				  	delay_ms(300);
					}
					a+=1;
				}

			*/



	while(next)
	{	

	
			if(ts_event.Key_Sta==Key_Down)        //The touch screen is pressed
			{
				EX0=0;//Close interrupt
				do
				{
					ft3267_read_data();
					ts_event.Key_Sta=Key_Up;
		
				    if((ts_event.x1>LCD_XSIZE_TFT/2-30)&&(ts_event.x1<LCD_XSIZE_TFT/2+30)&&(ts_event.y1>440))return; 
					if((ts_event.x1>LCD_XSIZE_TFT/2-30)&&(ts_event.x1<LCD_XSIZE_TFT/2+30)&&(ts_event.y1<40))
						{ 	Foreground_color_65k(Black);
							Line_Start_XY(0,0);
							Line_End_XY(LCD_XSIZE_TFT ,LCD_YSIZE_TFT);
							Start_Square_Fill();
						
						
						 ///////////////////////////Square
						
							Foreground_color_65k(Red);
							Line_Start_XY(0,0);
							Line_End_XY(LCD_XSIZE_TFT-1 ,LCD_YSIZE_TFT-1);
							Start_Square();
							delay_ms(50);
						
						  
							Foreground_color_65k(White);
							Background_color_65k(Black);
						
							Font_Select_8x16_16x16();
							Goto_Text_XY(40,200);	
							Show_String("Capacitive touch screen test");
							Goto_Text_XY(LCD_XSIZE_TFT/2-20,5);
							Show_String("Clear");   
							Goto_Text_XY(LCD_XSIZE_TFT/2-20,LCD_YSIZE_TFT-25);
							Show_String("Exit");
								break;
						} 

					inttostr(ts_event.x1,ss);	

					Foreground_color_65k(White);
					Background_color_65k(Black);
					CGROM_Select_Internal_CGROM();
					Font_Select_8x16_16x16();
					Goto_Text_XY(100,60);
					Show_String("X = ");	

					Text_Mode();
					LCD_CmdWrite(0x04);							
				  	LCD_DataWrite(ss[0]);
					//Delay1ms(1);
				  	LCD_DataWrite(ss[1]);
					//Delay1ms(1);
				  	LCD_DataWrite(ss[2]);
					//Delay1ms(1);
 				  	LCD_DataWrite(ss[3]);	 

					inttostr(ts_event.y1,ss);
					Goto_Text_XY(100,140);   //Set the display position
				  	LCD_CmdWrite(0x02);
					Show_String("Y = ");	
					Text_Mode();
					LCD_CmdWrite(0x04);	
				  	LCD_DataWrite(ss[0]);
					//Delay1ms(1);
				  	LCD_DataWrite(ss[1]);
					//Delay1ms(1);
				  	LCD_DataWrite(ss[2]);
					//Delay1ms(1);
 				  	LCD_DataWrite(ss[3]);


    			/*	Graphic_Mode(); //back to graphic mode
					Draw_Big_Point(ts_event.x1,ts_event.y1,Red);
					Draw_Big_Point(ts_event.x2,ts_event.y2,Green);*/	
	
			   	

					LCD_DrawCircle_Fill(ts_event.x1,ts_event.y1,2,Red);
					LCD_DrawCircle_Fill(ts_event.x2,ts_event.y2,2,Green);


                     
				}   while(PEN==0);
			    	EX0=1;
			}

    }

	 IT0=0;        //Falling edge trigger  
	 EA=0;

}

