



   #define layer1_start_addr 0 		 
  #define layer2_start_addr 460800   
  #define layer3_start_addr 921600    
  #define layer4_start_addr 1382400
  #define layer5_start_addr 1843200 
  #define layer6_start_addr 2304000   
  #define layer7_start_addr 2764800   
  #define layer8_start_addr 3225600
  #define layer9_start_addr 3686400
  #define layer10_start_addr 4147200

 #define  Picture_1_Addr     0


void ER_PWM1(unsigned short Compare_Buffer)             

{  	  
	Select_PWM1();
	Set_PWM_Prescaler_1_to_256(20);
    Select_PWM1_Clock_Divided_By_1();
	Set_Timer1_Count_Buffer(100); 
	Set_Timer1_Compare_Buffer(Compare_Buffer); 
	Start_PWM1(); 

}



 void Geometric(void)
{unsigned int i;
	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();

   	for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Red);
	Line_Start_XY(0+i,0+i);
	Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
	Start_Square();
	delay_ms(50);
	}

    for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Black);
	Line_Start_XY(0+i,0+i);
	Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
	Start_Square();
	delay_ms(50);
	}
 	delay_ms(2000);
///////////////////////////Square Of Circle
   	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();

   for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Green);
	Line_Start_XY(0+i,0+i);
	Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
	Circle_Square_Radius_RxRy(10,10);
	Start_Circle_Square();
	delay_ms(50);
	}

    for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Black);
	Line_Start_XY(0+i,0+i);
	Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
	Circle_Square_Radius_RxRy(10,10);
	Start_Circle_Square();
	delay_ms(50);
	}
   	delay_ms(2000);

///////////////////////////Circle
  	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();

   for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Blue);
	Circle_Center_XY(LCD_XSIZE_TFT/2,LCD_YSIZE_TFT/2);
	Circle_Radius_R(i);
	Start_Circle_or_Ellipse();
	delay_ms(50);
	}

    for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Black);
	Circle_Center_XY(LCD_XSIZE_TFT/2,LCD_YSIZE_TFT/2);
	Circle_Radius_R(i);
	Start_Circle_or_Ellipse();
	delay_ms(50);
	}
   	delay_ms(2000);

///////////////////////////Ellipse
  	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();

   for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(White);
	Circle_Center_XY(LCD_XSIZE_TFT/2,LCD_YSIZE_TFT/2);
	Ellipse_Radius_RxRy(i+100,i);
	Start_Circle_or_Ellipse();
	delay_ms(50);
	}

    for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Black);
	Circle_Center_XY(LCD_XSIZE_TFT/2,LCD_YSIZE_TFT/2);
	Ellipse_Radius_RxRy(i+100,i);
	Start_Circle_or_Ellipse();
	delay_ms(50);
	}
   	delay_ms(2000);

 ////////////////////////////Triangle
   	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();

    for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Yellow);
	Triangle_Point1_XY(LCD_XSIZE_TFT/2,i);
	Triangle_Point2_XY(i,LCD_YSIZE_TFT-1-i);
	Triangle_Point3_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
	Start_Triangle();
	delay_ms(50);
	}

    for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
	{Foreground_color_65k(Black);
	Triangle_Point1_XY(LCD_XSIZE_TFT/2,i);
	Triangle_Point2_XY(i,LCD_YSIZE_TFT-1-i);
	Triangle_Point3_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
	Start_Triangle();
	delay_ms(50);
	}
   	delay_ms(2000);


 ////////////////////////////line
   	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();

    for(i=0;i<=LCD_XSIZE_TFT;i+=8)
	{Foreground_color_65k(Red);
	Line_Start_XY(i,0);
	Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1);
	Start_Line();
	delay_ms(50);
	}
	for(i=0;i<=LCD_XSIZE_TFT;i+=8)
	{Foreground_color_65k(Red);
	Line_Start_XY(0,LCD_YSIZE_TFT-1-i);
	Line_End_XY(LCD_XSIZE_TFT-1,i);
	Start_Line();
	delay_ms(50);
	}


    for(i=0;i<=LCD_XSIZE_TFT;i+=8)
	{Foreground_color_65k(Black);
	Line_Start_XY(i,0);
	Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1);
	Start_Line();
	delay_ms(50);
	}
	for(i=0;i<=LCD_XSIZE_TFT;i+=8)
	{Foreground_color_65k(Black);
	Line_Start_XY(0,LCD_YSIZE_TFT-1-i);
	Line_End_XY(LCD_XSIZE_TFT-1,i);
	Start_Line();
	delay_ms(50);
	}


   	delay_ms(2000);


}


 
void Text_Demo(void)
{	unsigned int i,j;

	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	
 
  
 	Foreground_color_65k(White);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();


	Foreground_color_65k(Black);
	Background_color_65k(White);
	CGROM_Select_Internal_CGROM();
	Font_Select_8x16_16x16();
	Goto_Text_XY(0,10);
	Show_String("Embedded 8x16 ASCII Character");

	Font_Select_12x24_24x24();
	Goto_Text_XY(0,26);
	Show_String("Embedded 12x24 ASCII Character");

	Font_Select_16x32_32x32();
	Goto_Text_XY(0,50);
	Show_String("Embedded 16x32 ASCII Character");



	Font_Select_8x16_16x16();
	Font_Width_X1();
	Font_Height_X1();
	Goto_Text_XY(0,100);
	Show_String("Supporting Character ROM with 8x16/12x24/16X32 dots Font.");



 	  Foreground_color_65k(color65k_blue); 
	  Font_Background_select_Transparency();

  	  Active_Window_XY(0,180);
	  Active_Window_WH(80,80);
	  Goto_Pixel_XY(0,180);
	  Show_picture(80*80,pic_80x80); 
	  Active_Window_XY(0,0);
	  Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);


	  Font_Select_12x24_24x24();
	  Goto_Text_XY(0,190);
   	  Show_String("Demo text transparent");




	

	  Font_Background_select_Color();  
	  Foreground_color_65k(color65k_black); 
	  Background_color_65k(color65k_white);

	  Font_Select_8x16_16x16();
	  Goto_Text_XY(0,100);
   	  Show_String("Demo text cursor:");	 
	  Goto_Text_XY(0,124);
	  Show_String("0123456789");
	  Text_cursor_initial();
	 delay_ms(1000);

	  for(i=0;i<14;i++)
	  {
	   delay_ms(100);
	   Text_Cursor_H_V(1+i,15-i);	   
	  }
	  	 delay_ms(2000);

	  Disable_Text_Cursor();



	  Foreground_color_65k(color65k_blue); 
	  Goto_Text_XY(0,150);
   	  Show_String("Demo graphic cursor:");

	  Set_Graphic_Cursor_Color_1(0xff);
      Set_Graphic_Cursor_Color_2(0x00);

	  Graphic_cursor_initial();

	  Graphic_Cursor_XY(0,180);
	  Select_Graphic_Cursor_1();  
	  	 delay_ms(2000);
	  Select_Graphic_Cursor_2();
	  delay_ms(2000);
	  Select_Graphic_Cursor_3();
	  delay_ms(2000);
	  Select_Graphic_Cursor_4();
	  delay_ms(2000);
	  Select_Graphic_Cursor_2(); 

	  for(j=0;j<2;j++)
	  {
	   for(i=0;i<LCD_XSIZE_TFT;i++)
	   {
	    Graphic_Cursor_XY(i,180+j*20);	
		delay_ms(2);   
	   }
	  }
	   Graphic_Cursor_XY(0,180);	

	 delay_ms(2000);
	 Disable_Graphic_Cursor();

	NextStep();


 }


 
void mono_Demo(void)
{

	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	


	Foreground_color_65k(Red);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();
	NextStep();
	Foreground_color_65k(Green);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();
	NextStep();
 	Foreground_color_65k(Blue);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();
	NextStep();
	Foreground_color_65k(Cyan);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();
	NextStep();
	Foreground_color_65k(Yellow);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();
	NextStep();
  	Foreground_color_65k(Magenta);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();
	NextStep();
 	Foreground_color_65k(White);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();
	NextStep();
  	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();
	NextStep();
}


void gray(void)
{ int i,col,line;
	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	


	 col=0;line=0;
	for(i=0;i<32;i++)
   	{	Foreground_color_65k(i<<11);
		Line_Start_XY(col,line);
		Line_End_XY(col+LCD_XSIZE_TFT/32,line+LCD_YSIZE_TFT/4);
		Start_Square_Fill();
		col+=LCD_XSIZE_TFT/32;
	}
	  

	 col=0;line=LCD_YSIZE_TFT/4;
	for(i=0;i<64;i+=2)
   	{	Foreground_color_65k(i<<5);
		Line_Start_XY(col,line);
		Line_End_XY(col+LCD_XSIZE_TFT/32,line+LCD_YSIZE_TFT/4);
		Start_Square_Fill();
		col+=LCD_XSIZE_TFT/32;

	}


	 col=0;line=LCD_YSIZE_TFT/2;
	for(i=0;i<32;i++)
   	{	Foreground_color_65k(i);
		Line_Start_XY(col,line);
		Line_End_XY(col+LCD_XSIZE_TFT/32,line+LCD_YSIZE_TFT/4);
		Start_Square_Fill();
		col+=LCD_XSIZE_TFT/32;
	}

	 col=0;line=(LCD_YSIZE_TFT/4)*3;
	for(i=0;i<32;i++)
   	{	Foreground_color_65k((i<<11)+(i<<6)+i);
		Line_Start_XY(col,line);
		Line_End_XY(col+LCD_XSIZE_TFT/32,line+LCD_YSIZE_TFT/4);
		Start_Square_Fill();
		col+=LCD_XSIZE_TFT/32;
	}


	  delay_ms(1000);
 	NextStep();
}



void BTE_Compare(void)
{
   unsigned int i,temp;
	unsigned long im=1;


  	Select_Main_Window_16bpp();
	Main_Image_Start_Address(0);				
	Main_Image_Width(LCD_XSIZE_TFT);							
	Main_Window_Start_XY(0,0);

	Canvas_Image_Start_address(0);//Layer 1
	Canvas_image_width(LCD_XSIZE_TFT);//
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-25);
	Start_Square_Fill();

	Foreground_color_65k(Blue2);
	Line_Start_XY(0,LCD_YSIZE_TFT-24);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();


	Foreground_color_65k(White);
	Background_color_65k(Blue2);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(0,LCD_YSIZE_TFT-24);
	Show_String("  Demo BTE Compare");
	Foreground_color_65k(Black);
	Background_color_65k(White);
	Font_Select_8x16_16x16();
	Goto_Text_XY(0,LCD_YSIZE_TFT-48);
	Show_String("Execute Logic 'OR' 0xf000");




      Active_Window_XY(20,40);
	  Active_Window_WH(80,80);
	  Goto_Pixel_XY(20,40);
	  Show_picture(80*80,pic_80x80); 


 
      Active_Window_XY(20+80+20,40);
	  Active_Window_WH(80,80);
	  Goto_Pixel_XY(120,40);
	  Show_picture(80*80,pic_80x80);
	  
	
 
      Active_Window_XY(20+80+20+80+20,40);
	  Active_Window_WH(80,80);
	  Goto_Pixel_XY(220,40);
	  Show_picture(80*80,pic_80x80);	
	   

	  Active_Window_XY(0,0);
	  Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);
 	Foreground_color_65k(Black);
	Background_color_65k(White);
	CGROM_Select_Internal_CGROM();
    Font_Select_8x16_16x16();
	Goto_Text_XY(20,130 );
	Show_String("Without BTE");
 	Goto_Text_XY(120,130 );
	Show_String("BTE Write");
  	Goto_Text_XY(120,150 );
	Show_String("ROP");
  	Goto_Text_XY(220,130 );
	Show_String("BTE Move");
  	Goto_Text_XY(220,150 );
	Show_String("ROP");

	delay_ms(1000);


	   Active_Window_XY(20,40);
	   Active_Window_WH(80,80);
	 
	    Goto_Pixel_XY(20,40);
	    LCD_CmdWrite(0x04);
	    temp = LCD_DataRead();
		 Check_Mem_RD_FIFO_not_Empty();  //dummy

	    for(i=0; i<80*80;i++)
	  {				
		   temp = LCD_DataRead();
		   
		   temp=temp|(LCD_DataRead()<<8);
		   Check_Mem_RD_FIFO_not_Empty();
		   temp |= 0xf000; 
		   LCD_DataWrite(temp);
		   LCD_DataWrite(temp>>8);
		   Check_Mem_WR_FIFO_not_Full();
		   }

	  Active_Window_XY(0,0);
	  Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);


	   delay_ms(1000);

	  //second block, MCU write with BTE ROP 

	

	   BTE_S0_Color_16bpp();

       BTE_S1_Color_16bpp();
       BTE_S1_Memory_Start_Address(0);
       BTE_S1_Image_Width(LCD_XSIZE_TFT);
       BTE_S1_Window_Start_XY(120,40);

       BTE_Destination_Color_16bpp();  
       BTE_Destination_Memory_Start_Address(0);
       BTE_Destination_Image_Width(LCD_XSIZE_TFT);
       BTE_Destination_Window_Start_XY(120,40);  
       BTE_Window_Size(80,80);

	   BTE_ROP_Code(14);
       BTE_Operation_Code(0); //BTE write
       BTE_Enable();

       LCD_CmdWrite(0x04);
       	for(i=0; i<80*80;i++)
		  {				
		   LCD_DataWrite(0xf000);
		   LCD_DataWrite(0xf000>>8);
		   Check_Mem_WR_FIFO_not_Full();
		   }
       Check_Mem_WR_FIFO_Empty();//gˬd
       Check_BTE_Busy();

		delay_ms(1000);
	   
	   
	  //third block, BTE MOVE with ROP

	   	Canvas_Image_Start_address(layer2_start_addr);//
	 	Canvas_image_width(LCD_XSIZE_TFT);//
        Active_Window_XY(0,0);
	    Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);

 
 	    Foreground_color_65k(0xf000);
 	    Background_color_65k(Black);
	    Line_Start_XY(0,40);
	    Line_End_XY(80,120);
	    Start_Square_Fill();  
   
   
		BTE_S0_Color_16bpp();
		BTE_S0_Memory_Start_Address(layer2_start_addr);
		BTE_S0_Image_Width(LCD_XSIZE_TFT);
	    BTE_S0_Window_Start_XY(0,40);

        BTE_S1_Color_16bpp();
        BTE_S1_Memory_Start_Address(layer1_start_addr);
        BTE_S1_Image_Width(LCD_XSIZE_TFT);
        BTE_S1_Window_Start_XY(220,40);

        BTE_Destination_Color_16bpp();  
        BTE_Destination_Memory_Start_Address(layer1_start_addr);
        BTE_Destination_Image_Width(LCD_XSIZE_TFT);
        BTE_Destination_Window_Start_XY(220,40);  
        BTE_Window_Size(80,80);

	    BTE_ROP_Code(14);
        BTE_Operation_Code(2); //BTE write
        BTE_Enable();
		Check_BTE_Busy();

	 
			delay_ms(1000);
			NextStep();

}



void BTE_Color_Expansion(void)
{   
 

	 unsigned int i,j;
    unsigned long im=1;

 	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-25);
	Start_Square_Fill();

	Foreground_color_65k(Blue2);
	Line_Start_XY(0,LCD_YSIZE_TFT-24);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();


	Foreground_color_65k(White);
	Background_color_65k(Blue2);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(0,LCD_YSIZE_TFT-24);
	Show_String(" Demo BTE Color Expansion");


    //DMA initial setting
	Enable_SFlash_SPI();
    Select_SFI_1();
    Select_SFI_DMA_Mode();
    Select_SFI_24bit_Address();

    //Select_SFI_Waveform_Mode_0();
    Select_SFI_Waveform_Mode_3();

    //Select_SFI_0_DummyRead();	//normal read mode
    Select_SFI_8_DummyRead(); //1byte dummy cycle
    //Select_SFI_16_DummyRead();
    //Select_SFI_24_DummyRead();

    Select_SFI_Single_Mode();
    //Select_SFI_Dual_Mode0();
    //Select_SFI_Dual_Mode1();

    SPI_Clock_Period(0);


	SFI_DMA_Destination_Upper_Left_Corner(0,0);
    SFI_DMA_Transfer_Width_Height(480,480);
    SFI_DMA_Source_Width(LCD_XSIZE_TFT);//

	SFI_DMA_Source_Start_Address(im*LCD_XSIZE_TFT*LCD_YSIZE_TFT*2*3+Picture_1_Addr);//
	Start_SFI_DMA();
    Check_Busy_SFI_DMA();



	//color expansion and bte memory copy(move) 

  j=0;
 do
 {
   for(i=0;i<3;i++)
   {
	 //switch to layer2 update screen, and execute color expansion and copy to layer1
	 Canvas_Image_Start_address(layer2_start_addr);//
 	 Foreground_color_65k(Black);
	 Line_Start_XY(0,0);
	 Line_End_XY(LCD_XSIZE_TFT-1,LCD_XSIZE_TFT-25);
	 Start_Square_Fill();

	 Start_SFI_DMA();
     Check_Busy_SFI_DMA();

	 BTE_S0_Color_16bpp();
 
     BTE_S1_Color_16bpp();

     BTE_Destination_Color_16bpp();  
     BTE_Destination_Memory_Start_Address(layer2_start_addr);
     BTE_Destination_Image_Width(LCD_XSIZE_TFT);
     BTE_Destination_Window_Start_XY(80+70,40+70);  
     BTE_Window_Size(160,160);
	 Foreground_color_65k(color65k_blue);
     Background_color_65k(color65k_red);
	 BTE_ROP_Code(15);
     BTE_Operation_Code(8); //BTE color expansion

	 BTE_Enable();
	 LCD_CmdWrite(0x04);

	 switch(i)
	 {
	  case 0 :	          	 
			  Show_picture1(10*160,f1); 
			  Check_Mem_WR_FIFO_Empty();  	  
	          Check_BTE_Busy();
			  break;
	  case 1 :
			  Show_picture1(10*160,f2); 
			  Check_Mem_WR_FIFO_Empty();  	  
	          Check_BTE_Busy();
			  break;
	  case 2 :
			  Show_picture1(10*160,f3); 
			  Check_Mem_WR_FIFO_Empty();  	  
	          Check_BTE_Busy();
			  break;
	   default:
			  break;
	 }

	
		Foreground_color_65k(Black);
	Background_color_65k(White);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(80+70,40+70+160+20);
	Show_String("Color Expansion");



	 Foreground_color_65k(color65k_blue);
     Background_color_65k(color65k_red);

	 BTE_Operation_Code(9); //BTE color expansion with chroma key
	 BTE_Destination_Window_Start_XY(80+320+70,40+70);  
	 BTE_Enable();
	 LCD_CmdWrite(0x04);

	 switch(i)
	 {
	  case 0 :	          	
			  Show_picture1(10*160,f1); 
			  Check_Mem_WR_FIFO_Empty();  	  
	          Check_BTE_Busy();
			  break;
	  case 1 :
			  Show_picture1(10*160,f2); 
			  Check_Mem_WR_FIFO_Empty();  	  
	          Check_BTE_Busy();
			  break;
	  case 2 :
			  Show_picture1(10*160,f3); 
			  Check_Mem_WR_FIFO_Empty();  	  
	          Check_BTE_Busy();
			  break;
	   default:
			  break;
	 }
	 

	Foreground_color_65k(Black);
	Background_color_65k(White);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(80+320+70,40+70+160+20);
	Show_String("Color Expansion");
	Goto_Text_XY(80+320+70,40+70+160+20+24);
	Show_String("Color With chroma key");

  	 Foreground_color_65k(color65k_blue);
     Background_color_65k(color65k_red);

	   //BTE memory(move) layer2 to layer1
	   //BTE_S0_Color_16bpp();
       BTE_S0_Memory_Start_Address(layer2_start_addr);
       BTE_S0_Image_Width(LCD_XSIZE_TFT);
       BTE_S0_Window_Start_XY(0,0);

       //BTE_Destination_Color_16bpp();  
       BTE_Destination_Memory_Start_Address(layer1_start_addr);
       BTE_Destination_Image_Width(LCD_XSIZE_TFT);
       BTE_Destination_Window_Start_XY(0,0);  
       BTE_Window_Size(LCD_XSIZE_TFT,LCD_XSIZE_TFT-25);

       BTE_ROP_Code(12); 
       BTE_Operation_Code(2); //BTE move
       BTE_Enable();		  //memory copy s0(layer2) to layer1  
       Check_BTE_Busy();

	 
	  j++;
	}

   }while(j<8);

 			NextStep();




}



void PIP_Demo(void)
{   unsigned long i;	 
 	 unsigned long im=1;

	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-25);
	Start_Square_Fill();

	Foreground_color_65k(Blue2);
	Line_Start_XY(0,LCD_YSIZE_TFT-24);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();


	Foreground_color_65k(White);
	Background_color_65k(Blue2);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(0,LCD_YSIZE_TFT-24);
	Show_String("   Demo PIP");


     //gJPIP1
	 Memory_16bpp_Mode();
	 delay_ms(20);
	 Canvas_Image_Start_address(layer2_start_addr);//Layer 2
	 Canvas_image_width(LCD_XSIZE_TFT);//
     Active_Window_XY(0,0);
	 Active_Window_WH(100,100);
     Goto_Pixel_XY(0,0);
	 LCD_CmdWrite(0x04);
	 for(i=0;i<10000;i++)
	 {
	  LCD_DataWrite(color65k_blue);
	  LCD_DataWrite(color65k_blue>>8);
	  //Check_Mem_WR_FIFO_not_Full();
 	 }
	  Check_Mem_WR_FIFO_Empty();



	//gJPIP2
	Canvas_Image_Start_address(layer3_start_addr);//Layer 3
	Canvas_image_width(LCD_XSIZE_TFT);//
    Active_Window_XY(0,0);
	Active_Window_WH(100,100);
    Goto_Pixel_XY(0,0);
	LCD_CmdWrite(0x04);
	for(i=0;i<10000;i++)
	{
	 LCD_DataWrite(color65k_red);
	 LCD_DataWrite(color65k_red>>8);
	 //Check_Mem_WR_FIFO_not_Full();
 	}
	Check_Mem_WR_FIFO_Empty();


 	//PIP1
 	Select_PIP1_Window_16bpp();//	
	Select_PIP1_Parameter();
	PIP_Image_Start_Address(layer2_start_addr);
	PIP_Image_Width(LCD_XSIZE_TFT);
	PIP_Window_Width_Height(100,100);
	PIP_Window_Image_Start_XY(0,0);
	PIP_Display_Start_XY(80,40);
	Enable_PIP1();
	delay_ms(50);

	//PIP2
    Select_PIP2_Window_16bpp(); //`N			
	Select_PIP2_Parameter();
	PIP_Image_Start_Address(layer3_start_addr);
	PIP_Image_Width(LCD_XSIZE_TFT);
	PIP_Window_Width_Height(100,100);
	PIP_Window_Image_Start_XY(0,0);
	PIP_Display_Start_XY(80+100,40+100);
	Enable_PIP2();
	delay_ms(50);


     for(i=0;i<160;i++)
	 {
	  Select_PIP1_Parameter();
	  PIP_Display_Start_XY(80+i,40+i);
	  // PIP_Display_Start_XY(80,40+i);
	  delay_ms(1);
	  Select_PIP2_Parameter();
	  PIP_Display_Start_XY(80+100-i,40+100-i);
	  //PIP_Display_Start_XY(80+320,40+240-i);
	  delay_ms(10);
	 }

	 for(i=0;i<160;i++)
	 {
	  Select_PIP1_Parameter();
	  PIP_Display_Start_XY(80+159-i,40+159-i);
	  //PIP_Display_Start_XY(80+159,40+159-i);
	  delay_ms(1);
	  Select_PIP2_Parameter();
	  PIP_Display_Start_XY(80+100-159+i,40+100-159+i);
	   //PIP_Display_Start_XY(80+320-159,40+240-159+i);
	  delay_ms(10);
	  }
  
	  delay_ms(2000);

 		NextStep();

	  Disable_PIP1();
	  Disable_PIP2();

}


 
 void DMA_Demo(void)
{

		unsigned long i;

 ///////////////////////////////////////////////////////////////

	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT);
	Start_Square_Fill();


    //DMA initial setting
	Enable_SFlash_SPI();
    Select_SFI_1();
    Select_SFI_DMA_Mode();
    Select_SFI_24bit_Address();

    //Select_SFI_Waveform_Mode_0();
    Select_SFI_Waveform_Mode_3();

    //Select_SFI_0_DummyRead();	//normal read mode
    Select_SFI_8_DummyRead(); //1byte dummy cycle
    //Select_SFI_06_DummyRead();
   //Select_SFI_24_DummyRead();

    Select_SFI_Single_Mode();
    //Select_SFI_Dual_Mode0();
   // Select_SFI_Dual_Mode1();

    SPI_Clock_Period(0);



	SFI_DMA_Destination_Upper_Left_Corner(0,0);
    SFI_DMA_Transfer_Width_Height(LCD_XSIZE_TFT,LCD_YSIZE_TFT);
    SFI_DMA_Source_Width(LCD_XSIZE_TFT);//

  

	 for(i=0;i<4;i++)
	 {
	  SFI_DMA_Source_Start_Address(i*LCD_XSIZE_TFT*LCD_YSIZE_TFT*2+Picture_1_Addr);//
	  Start_SFI_DMA();
      Check_Busy_SFI_DMA();
	  delay_ms(30);
 	NextStep();
	 }

	
}

void App_Demo_Waveform(void)
{
    unsigned int i,h;

	unsigned int point1y,point2y;
	unsigned int point21y,point22y;
	unsigned int point31y,point32y;
	point2y = 0; //initial value
	point22y = 0; //initial value
	point32y = 0; //initial value

  #define grid_width 601
  #define grid_high  401
  #define grid_gap 50
    
	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-25);
	Start_Square_Fill();

	Foreground_color_65k(Blue2);
	Line_Start_XY(0,LCD_YSIZE_TFT-24);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();


 	Foreground_color_65k(White);
	Background_color_65k(Blue2);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(0,LCD_YSIZE_TFT-24);
	Show_String("BTE memory copy + Geometric draw demo waveform");




	Canvas_Image_Start_address(layer2_start_addr);//Layer 2



    Foreground_color_65k(Black);  //clear layer2 to color black
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();

    for(i=0;i<=grid_width;i+=grid_gap)
	{
	 Foreground_color_65k(color65k_grayscale12);
	 Line_Start_XY(i,0);
     Line_End_XY(i,grid_high-1);
	 Start_Line();
	}

	 for(i=0;i<=grid_high;i+=grid_gap)
	{
	 Foreground_color_65k(color65k_grayscale12);
	 Line_Start_XY(0,i);
     Line_End_XY(grid_width-1,i);
	 Start_Line();
	}

	//BTE memory(move) grid to layer1
	   BTE_S0_Color_16bpp();
       BTE_S0_Memory_Start_Address(layer2_start_addr);
       BTE_S0_Image_Width(LCD_XSIZE_TFT);
       BTE_S0_Window_Start_XY(0,0);

//       BTE_S1_Color_16bpp();
//       BTE_S1_Memory_Start_Address(800*600*2*2);
//       BTE_S1_Image_Width(800);
//       BTE_S1_Window_Start_XY(0,0);

       BTE_Destination_Color_16bpp();  
       BTE_Destination_Memory_Start_Address(0);
       BTE_Destination_Image_Width(LCD_XSIZE_TFT);
       BTE_Destination_Window_Start_XY(100,40);  
       BTE_Window_Size(601,401);

	   //move with ROP 0 
       BTE_ROP_Code(12); //memory copy s0(layer2)grid to layer1  
       BTE_Operation_Code(2); //BTE move
       BTE_Enable();
       Check_BTE_Busy();


	   Canvas_Image_Start_address(0);//Layer 1
       
	 h=0;
	do{
	    for(i=0;i<600;i+=2)
	   {
		// copy layer2 grid column to layer1
		 BTE_S0_Window_Start_XY(i,0);

		 BTE_Destination_Window_Start_XY(100+i,40);  
         BTE_Window_Size(2,401);
		 BTE_Enable();
         Check_BTE_Busy();

	
		 point1y = point2y;
         point2y = rand()%90;//
		
		 point21y = point22y;
         point22y = rand()%99;//
//		
		 point31y = point32y;
         point32y = rand()%67;//
		 
		 Foreground_color_65k(color65k_yellow);//
		 Line_Start_XY(i+100,point1y+80);
		 Line_End_XY(i+1+100,point2y+80);
	     Start_Line();

		 Foreground_color_65k(color65k_purple);//
		 Line_Start_XY(i+100,point21y+200);
		 Line_End_XY(i+1+100,point22y+200);
	     Start_Line();
//
		 Foreground_color_65k(color65k_green);//
		 Line_Start_XY(i+100,point31y+300);
		 Line_End_XY(i+1+100,point32y+300);
	     Start_Line();

		 //delay_ms(1000);	
	    }
	   
	   h++;
	  }
	 while(h<5);  

 		NextStep();

}
void App_Demo_Scrolling_Text(void)
{
    unsigned int i; 

 
	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-25);
	Start_Square_Fill();

	Foreground_color_65k(Blue2);
	Line_Start_XY(0,LCD_YSIZE_TFT-24);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();



	Foreground_color_65k(White);
	Background_color_65k(Blue2);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(0,LCD_YSIZE_TFT-24);
	Show_String("               Demo Scrolling Text");
	Foreground_color_65k(White);
	Background_color_65k(Black);
	Font_Select_12x24_24x24();
	Goto_Text_XY(0,LCD_YSIZE_TFT-48);
	Show_String("Used Move BTE with Chroma Key ");


    //DMA initial setting
	Enable_SFlash_SPI();
    Select_SFI_1();
    Select_SFI_DMA_Mode();
    Select_SFI_24bit_Address();

    //Select_SFI_Waveform_Mode_0();
    Select_SFI_Waveform_Mode_3();

    //Select_SFI_0_DummyRead();	//normal read mode
    Select_SFI_8_DummyRead(); //1byte dummy cycle
    //Select_SFI_06_DummyRead();
    //Select_SFI_24_DummyRead();

    Select_SFI_Single_Mode();
    //Select_SFI_Dual_Mode0();
    //Select_SFI_Dual_Mode1();

    SPI_Clock_Period(0);


	SFI_DMA_Destination_Upper_Left_Corner(0,0);
    SFI_DMA_Transfer_Width_Height(LCD_XSIZE_TFT,LCD_YSIZE_TFT);
    SFI_DMA_Source_Width(LCD_XSIZE_TFT);//
	SFI_DMA_Source_Start_Address(Picture_1_Addr);//
	Start_SFI_DMA();
    Check_Busy_SFI_DMA();


	//BTE memory(move) layer2 to layer1
	   BTE_S0_Color_16bpp();
       BTE_S0_Memory_Start_Address(layer2_start_addr);
       BTE_S0_Image_Width(LCD_XSIZE_TFT);
       BTE_S0_Window_Start_XY(0,0);



       BTE_Destination_Color_16bpp();  
       BTE_Destination_Memory_Start_Address(layer1_start_addr);
       BTE_Destination_Image_Width(LCD_XSIZE_TFT);
       BTE_Destination_Window_Start_XY(0,0);  
       BTE_Window_Size(LCD_XSIZE_TFT,LCD_YSIZE_TFT);

       BTE_ROP_Code(12); 
       BTE_Operation_Code(2); //BTE move
       BTE_Enable();		  //memory copy s0(layer3) to layer1  
       Check_BTE_Busy();


	  //write text to layer3
	  Canvas_Image_Start_address(layer3_start_addr);
	  Canvas_image_width(LCD_XSIZE_TFT);//
      Active_Window_XY(0,0);
	  Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);

	  Foreground_color_65k(Red);
	  Line_Start_XY(0,0);
	  Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	  Start_Square_Fill();

	Foreground_color_65k(Green);
	Background_color_65k(Red);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(0,Line0);
	Show_String("Demo Scrolling Text");

	Foreground_color_65k(Yellow);
	Background_color_65k(Red);
	Goto_Text_XY(0,Line1);
	Show_String("Demo Scrolling Text");
	Foreground_color_65k(Magenta);
	Background_color_65k(Red);
	Goto_Text_XY(0,Line2);
	Show_String("Demo Scrolling Text");
	Foreground_color_65k(Grey);
	Background_color_65k(Red);
	Goto_Text_XY(0,Line3);
	Show_String("Demo Scrolling Text");


	  //Move BTE with chroma key layer3 to layer2 then move layer2 to layer1 to display

	  for(i=0;i<LCD_XSIZE_TFT;i+=8)
	  {   if(!next)return;	    	 
	   	Canvas_Image_Start_address(layer2_start_addr);
	    Canvas_image_width(LCD_XSIZE_TFT);//
        Active_Window_XY(0,0);
	    Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);

 	     Foreground_color_65k(Black);
	     Line_Start_XY(0,0);
	     Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-80);
	     Start_Square_Fill();

		 SFI_DMA_Destination_Upper_Left_Corner(0,40);
         SFI_DMA_Transfer_Width_Height(LCD_XSIZE_TFT,LCD_YSIZE_TFT-120);
         SFI_DMA_Source_Width(LCD_XSIZE_TFT);//
	     SFI_DMA_Source_Start_Address(Picture_1_Addr);//
	     Start_SFI_DMA();
         Check_Busy_SFI_DMA();

	  //BTE memory(move) layer3 to layer2
	   //BTE_S0_Color_16bpp();
       BTE_S0_Memory_Start_Address(layer3_start_addr);
       BTE_S0_Image_Width(LCD_XSIZE_TFT);
       BTE_S0_Window_Start_XY(0,0);


       //BTE_Destination_Color_16bpp();  
       BTE_Destination_Memory_Start_Address(layer2_start_addr);
       BTE_Destination_Image_Width(LCD_XSIZE_TFT);
       BTE_Destination_Window_Start_XY(LCD_XSIZE_TFT-8-i,72);  
       BTE_Window_Size(0+i,24*4);

	   Background_color_65k(Red);//

       BTE_ROP_Code(12); 
       BTE_Operation_Code(5); //BTE move with chroma key
       BTE_Enable();		  //memory copy s0(layer3) to layer1  
       Check_BTE_Busy();



   	  //BTE memory(move) layer2 to layer1
	   //BTE_S0_Color_16bpp();
       BTE_S0_Memory_Start_Address(layer2_start_addr);
       BTE_S0_Image_Width(LCD_XSIZE_TFT);
       BTE_S0_Window_Start_XY(0,0);

       //BTE_Destination_Color_16bpp();  
       BTE_Destination_Memory_Start_Address(layer1_start_addr);
       BTE_Destination_Image_Width(LCD_XSIZE_TFT);
       BTE_Destination_Window_Start_XY(0,0);  
       BTE_Window_Size(LCD_XSIZE_TFT,LCD_YSIZE_TFT);

       BTE_ROP_Code(12); 
       BTE_Operation_Code(2); //BTE move
       BTE_Enable();		  //memory copy s0(layer2) to layer1  
       Check_BTE_Busy();
	  }
      

	 		NextStep();

}




void App_Demo_slide_frame_buffer(void)
{		unsigned long im=1;
     unsigned int i,j;
    
    Select_Main_Window_16bpp();
	Main_Image_Start_Address(0);				
	Main_Image_Width(LCD_XSIZE_TFT);							
	Main_Window_Start_XY(0,0);

      //DMA initial setting
	Enable_SFlash_SPI();
    Select_SFI_1();
    Select_SFI_DMA_Mode();
    Select_SFI_24bit_Address();

    //Select_SFI_Waveform_Mode_0();
    Select_SFI_Waveform_Mode_3();

    //Select_SFI_0_DummyRead();	//normal read mode
    Select_SFI_8_DummyRead(); //1byte dummy cycle
    //Select_SFI_06_DummyRead();
    //Select_SFI_24_DummyRead();

    Select_SFI_Single_Mode();
    //Select_SFI_Dual_Mode0();
    //Select_SFI_Dual_Mode1();

    SPI_Clock_Period(0);

	SFI_DMA_Destination_Upper_Left_Corner(0,0);
    SFI_DMA_Transfer_Width_Height(LCD_XSIZE_TFT,LCD_YSIZE_TFT);
    SFI_DMA_Source_Width(LCD_XSIZE_TFT);//


	//Color_Bar_ON();
    
	//set canvas to 1600
    Select_Main_Window_16bpp();
	Main_Image_Start_Address(0);				
	Main_Image_Width(LCD_XSIZE_TFT*2);							
	Main_Window_Start_XY(0,0);	
	Canvas_Image_Start_address(0);
	Canvas_image_width(LCD_XSIZE_TFT*2);//
	Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT*2,LCD_YSIZE_TFT*2);
	
	Canvas_Image_Start_address(0);//

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT*2-1,LCD_YSIZE_TFT*2-1);
	Start_Square_Fill();

    SFI_DMA_Destination_Upper_Left_Corner(0,0);
	SFI_DMA_Source_Start_Address(Picture_1_Addr);//
	Start_SFI_DMA();
    Check_Busy_SFI_DMA();
 
    SFI_DMA_Destination_Upper_Left_Corner(LCD_XSIZE_TFT,0);
	SFI_DMA_Source_Start_Address(LCD_XSIZE_TFT*LCD_YSIZE_TFT*2+Picture_1_Addr);//
	Start_SFI_DMA();
    Check_Busy_SFI_DMA();

	SFI_DMA_Destination_Upper_Left_Corner(0,LCD_YSIZE_TFT);
	SFI_DMA_Source_Start_Address(LCD_XSIZE_TFT*LCD_YSIZE_TFT*4+Picture_1_Addr);//
	Start_SFI_DMA();
    Check_Busy_SFI_DMA();

	SFI_DMA_Destination_Upper_Left_Corner(LCD_XSIZE_TFT,LCD_YSIZE_TFT);
	SFI_DMA_Source_Start_Address(LCD_XSIZE_TFT*LCD_YSIZE_TFT*6+Picture_1_Addr);//
	Start_SFI_DMA();
    Check_Busy_SFI_DMA();


	
	//Color_Bar_OFF();


	for(i=0;i<LCD_XSIZE_TFT+1;i++)
	{
	 Main_Window_Start_XY(i,0);
	 delay_ms(5);
	}
    delay_ms(1);	
 
	for(j=0;j<LCD_YSIZE_TFT+1;j++)
	{
	 Main_Window_Start_XY(LCD_XSIZE_TFT,j);
	 delay_ms(5);
	}	
	delay_ms(1);


	for(i=LCD_XSIZE_TFT;i>0;i--)
	{
	 Main_Window_Start_XY(i,LCD_YSIZE_TFT);
	 delay_ms(5);
	}
	Main_Window_Start_XY(0,LCD_YSIZE_TFT);
	delay_ms(1);
    delay_ms(5);	
 
	for(j=LCD_YSIZE_TFT;j>0;j--)
	{
	 Main_Window_Start_XY(0,j);
	 delay_ms(5);
	}
	Main_Window_Start_XY(0,0);
	delay_ms(5);	
	delay_ms(1);

 		NextStep();
}


void App_Demo_multi_frame_buffer(void)
{    unsigned int i,j;
      unsigned long im=1;
    Select_Main_Window_16bpp();
	Main_Image_Start_Address(0);				
	Main_Image_Width(LCD_XSIZE_TFT);							
	Main_Window_Start_XY(0,0);

      //DMA initial setting
	Enable_SFlash_SPI();
    Select_SFI_1();
    Select_SFI_DMA_Mode();
    Select_SFI_24bit_Address();

    //Select_SFI_Waveform_Mode_0();
    Select_SFI_Waveform_Mode_3();

    //Select_SFI_0_DummyRead();	//normal read mode
    Select_SFI_8_DummyRead(); //1byte dummy cycle
    //Select_SFI_06_DummyRead();
    //Select_SFI_24_DummyRead();

    Select_SFI_Single_Mode();
    //Select_SFI_Dual_Mode0();
    //Select_SFI_Dual_Mode1();

    SPI_Clock_Period(0);

	SFI_DMA_Destination_Upper_Left_Corner(0,0);
    SFI_DMA_Transfer_Width_Height(480,480);
    SFI_DMA_Source_Width(LCD_XSIZE_TFT);//


 for(i=0;i<6;i++)
  {

	Select_Main_Window_16bpp();
	Main_Image_Start_Address(layer1_start_addr);				
	Main_Image_Width(LCD_XSIZE_TFT);
	Main_Window_Start_XY(0,0);
	Canvas_Image_Start_address(layer1_start_addr);
	Canvas_image_width(LCD_XSIZE_TFT);
    Active_Window_XY(0,0);
	Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	

 	Foreground_color_65k(Black);
	Line_Start_XY(0,0);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-25);
	Start_Square_Fill();

	Foreground_color_65k(Blue2);
	Line_Start_XY(0,LCD_YSIZE_TFT-24);
	Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
	Start_Square_Fill();


	Foreground_color_65k(White);
	Background_color_65k(Blue2);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(0,LCD_YSIZE_TFT-24);
	Show_String("             Demo Multi Frame Buffer");

	//LCD_DisplayString(0,Line23 ,"  Demo Mulit Frame Buffer",Black,White);


	

	  SFI_DMA_Source_Start_Address(im*480*480*2*i+Picture_1_Addr);//
	  Start_SFI_DMA();
      Check_Busy_SFI_DMA();
	  //delay_ms(500);
	  delay_ms(50);
	  Main_Image_Width(LCD_XSIZE_TFT);							
      Main_Window_Start_XY(0,0);
	  Main_Image_Start_Address(im*LCD_XSIZE_TFT*LCD_YSIZE_TFT*2*i);//switch display windows to 
	 }
	//delay_ms(2000);
//	Color_Bar_ON();
    
	//set canvas to 8188 
    Select_Main_Window_16bpp();
	Main_Image_Start_Address(0);				
	Main_Image_Width(8188);							
	Main_Window_Start_XY(0,0);	
	Canvas_Image_Start_address(0);
	Canvas_image_width(8188);//
	Active_Window_XY(0,0);
	Active_Window_WH(8188,LCD_XSIZE_TFT);
	
	for(im=0;im<6;im++)
    {
	Canvas_Image_Start_address(0);//Layer1~6

 	Foreground_color_65k(Black);
	Line_Start_XY(0+im*LCD_XSIZE_TFT,0);
	Line_End_XY(LCD_XSIZE_TFT-1+im*LCD_XSIZE_TFT,LCD_YSIZE_TFT-25);
	Start_Square_Fill();

	Foreground_color_65k(Blue2);
	Line_Start_XY(0+im*LCD_XSIZE_TFT,LCD_YSIZE_TFT-24);
	Line_End_XY(LCD_XSIZE_TFT-1+im*LCD_XSIZE_TFT,LCD_YSIZE_TFT-1);
	Start_Square_Fill();


    SFI_DMA_Destination_Upper_Left_Corner(im*LCD_XSIZE_TFT,0);
	SFI_DMA_Source_Start_Address(im*480*480*2+Picture_1_Addr);//
	Start_SFI_DMA();
    Check_Busy_SFI_DMA();


	Foreground_color_65k(White);
	Background_color_65k(Blue2);
	CGROM_Select_Internal_CGROM();
	Font_Select_12x24_24x24();
	Goto_Text_XY(im*LCD_XSIZE_TFT,LCD_YSIZE_TFT-24);
	Show_String("             Demo Mulit Frame Buffer"); 

	}
//	Color_Bar_OFF();

   for(j=0;j<5;j++)
   {
	for(i=0;i<LCD_XSIZE_TFT;i++)
	{
	 Main_Window_Start_XY(i+j*LCD_XSIZE_TFT,0);
	 delay_ms(1);
	}
    delay_ms(300);	
   }

   for(j=5;j>0;j--)
   {
	for(i=0;i<LCD_XSIZE_TFT;i++)
	{
	 Main_Window_Start_XY(j*LCD_XSIZE_TFT-i,0);
	 delay_ms(5);
	}

   }

   delay_ms(500);

    		NextStep();
}



