//----------------------------------------------------------------------
/*EASTRISING TECHNOLOGY CO,.LTD.*/
// Module    : ERC128128-3 Series   4 gray scale
// Create    : JAVEN
// Date      : 2009-06-18
// Drive IC  : ST7571
// INTERFACE : 4SPI
// MCU 		 : STC12LE5A60S2-35I-DIP40
// VDD		 : 3.0V   VLCD: 12.0V   5 times boosting
//----------------------------------------------------------------------

#include "reg51.h"
#include <intrins.h>

#define uint unsigned int
#define uchar unsigned char

////////////////////////////////////
//Define parameters

#define	ModeSet		0x38
#define	ModeSetP	0x54

#define Display_on 		0xaf
#define Display_off 	0xae

#define Regulator		0x27
#define Contrast_level	0x81



#define PowerControll_on1	0x2c
#define PowerControll_on2	0x2e
#define PowerControll_on3	0x2f

#define	LcdBias_12		0x57
#define	InterOsc_on		0xab
#define	EntireDisp_on	0xa5
#define	EntireDisp_off	0xa4
#define BoostLevel_6	0x67
#define BoostLevel_3	0x64
#define	Duty_set		0x48
#define	Duty_setP		0x80
#define Start_columnlsb	0x00
#define Start_columnmsb	0x10
#define Start_page		0xb0
#define	StartLine_set	0x40

#define FrcPwm_set		0x93
#define NLineInversion_on	0x4c	
#define ReverseDisp_on	0xa7
#define ReverseDisp_off	0xa6
#define AdcSelect		0xa1
#define ComScanDirection	0xc8


/////////////////////////////////////
//Define pins' name

sbit CS=P3^3;		//Chip Select This pin is the chip select input. The chip is enabled for MCU communication only when CS# is pulled high.	
sbit REST=P3^1;		//This pin is reset signal input. When the pin is low,initialization of the chip is executed.
sbit RS=P3^0;		//H:dtaa   L: command
sbit SDI=P1^7;		//serial data input
sbit SCL=P1^6;		//serial clock input
sbit	int0=P3^2;
sbit key_add=P0^1;
sbit key_dec=P0^2;

bit log=0;
uchar code map0[];
uchar code map1[];
uchar code map2[];
uchar Status;
uchar Contrast_levelP=24;


void Delay1(uint n);
void Write_command(uchar command);
void Write_number(uchar code *n,uchar k,uchar station_dot);
void display_Contrast_level(uchar number);
void adj_Contrast(void);
void Delay(uint n);
void Read_status(void);
void Checkkey(void);
void Write_data(uchar datas);
void Intilizate_lcd(void);
void Clear(uchar datas);
void Test(uchar code *test);
void Display_frame(void);
void Display_gray(void);
void Display_map(uchar code *map);


uchar code     test1[]={0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00};
uchar code	   test2[]={0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff};
uchar code	   test3[]={0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa};
uchar code	   test4[]={0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55};

uchar code	    num[]={0x00,0xF8,0xFC,0x04,0x04,0xFC,0xF8,0x00,0x00,0x03,0x07,0x04,0x04,0x07,0x03,0x00,  	   /*--  :  0~9  --*/
0x00,0x00,0x08,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0x04,0x07,0x07,0x04,0x00,0x00,  
0x00,0x18,0x1C,0x84,0xC4,0x7C,0x38,0x00,0x00,0x06,0x07,0x05,0x04,0x04,0x04,0x00,
0x00,0x08,0x0C,0x24,0x24,0xFC,0xD8,0x00,0x00,0x02,0x06,0x04,0x04,0x07,0x03,0x00,
0x80,0xE0,0x70,0x18,0xFC,0xFC,0x00,0x00,0x00,0x01,0x01,0x05,0x07,0x07,0x04,0x00,
0x00,0x7C,0x7C,0x24,0x24,0xE4,0xC4,0x00,0x00,0x03,0x07,0x04,0x04,0x07,0x03,0x00,
0x00,0xF0,0xF8,0x6C,0x24,0xEC,0xCC,0x00,0x00,0x03,0x07,0x04,0x04,0x07,0x03,0x00,
0x00,0x0C,0x0C,0xC4,0xFC,0x3C,0x04,0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x00,0x00,
0x00,0x98,0xFC,0x64,0x64,0xFC,0x98,0x00,0x00,0x03,0x07,0x04,0x04,0x07,0x03,0x00,
0x00,0x78,0xFC,0x84,0xC4,0xFC,0xF8,0x00,0x00,0x06,0x06,0x04,0x06,0x03,0x01,0x00};



void Step(void) interrupt 0 using 0
{
	Delay1(300);
	if(int0==0)
 // {	while(IE0);
	log=!log;
 // }
   while(!int0);
  return;

}




void Delay1(uint n)
{while(n--);
 
   
	return;
}


//////////////////////////////////////////////////
//Name:		wr_command
//Programmed by:Javen
//Data:		2008.07,29
//Description:	write one command to lcd controll
/////////////////////////////////////////////////

void Write_command(uchar COM)
{ unsigned char i;
 
    CS=0;
 	RS=0;   //COMMAND 	
    for(i=0;i<8;i++)
     {  SCL=0;
        if(COM&0x80) SDI=1;
       	else SDI=0;
       	SCL=1;
        COM=COM<<1;
     }
   	CS=1;


}

	


/////////////////////////////////////////
//Name:		Write_datas
//Programmed by:Javen
//Data:		2008.07,29
//Description:	write one data into controller
/////////////////////////////////////////

void Write_data(uchar DATA)
{ unsigned char i;
	 
    CS=0;
 	RS=1;   //DATA 
    for(i=0;i<8;i++)
     {  SCL=0;
        if(DATA&0x80) SDI=1;
       	else SDI=0;
       	SCL=1;
        DATA=DATA<<1;
     }
   	CS=1;
}



void Write_number(uchar code *n,uchar k,uchar station_dot)
{uchar i; 
			for(i=0;i<8;i++)
				{
				Write_data(*(n+16*k+i));
				Write_data(*(n+16*k+i));
				}
				
	Write_command(Start_page+1)	;
	Write_command(Start_columnlsb+station_dot*8);
	Write_command(Start_columnmsb);		
			for(i=8;i<16;i++)
				{
				Write_data(*(n+16*k+i));
				Write_data(*(n+16*k+i));
				}
}


void display_Contrast_level(uchar number)
{	uchar number1,number2;
	number1=number/10;number2=number%10;
    Write_command(StartLine_set);
	Write_command(0x00);
	Write_command(Start_columnlsb+0*8);
	Write_command(Start_columnmsb);
	Write_command(Start_page);
    Write_number(num,number1,0);
	Write_command(Start_columnlsb+1*8);
	Write_command(Start_columnmsb);
	Write_command(Start_page);
	Write_number(num,number2,1);

}



void adj_Contrast(void)
{	Delay1(300);
 	 if((key_add==0)||(key_dec==0))
		{		
		 if	(key_add==0) 
		  {Contrast_levelP+=1; if(Contrast_levelP>0x3f)(Contrast_levelP=0);
		  	Write_command(Contrast_level);	
		    Write_command(Contrast_levelP);
			display_Contrast_level(Contrast_levelP);
			Delay1(65000);

			while(key_add==0)
			{Contrast_levelP+=1; if(Contrast_levelP>0x3f)(Contrast_levelP=0);
			Write_command(Contrast_level);	
		    Write_command(Contrast_levelP);
			display_Contrast_level(Contrast_levelP);
			 Delay1(30000); 
			}
	
		  }
	
		 if(key_dec==0)
          {Contrast_levelP-=1;if((Contrast_levelP<=0xff)&&(Contrast_levelP>0x3f))(Contrast_levelP=0x3f);
		   	Write_command(Contrast_level);	
		    Write_command(Contrast_levelP);
			display_Contrast_level(Contrast_levelP);

			Delay1(65000);
			while(key_dec==0)
			{Contrast_levelP-=1;if((Contrast_levelP<=0xff)&&(Contrast_levelP>0x3f))(Contrast_levelP=0x3f);
		   	Write_command(Contrast_level);	
		    Write_command(Contrast_levelP);
			display_Contrast_level(Contrast_levelP);
		    Delay1(30000); 
		    }
		  }

	  	}
}


void Delay(uint n)
{while(n)
 {    if((key_add==0)||(key_dec==0)) adj_Contrast();
	  n--;
 }
 	for(;log==1;)
	{
 	 if((key_add==0)||(key_dec==0)) adj_Contrast();
	}

	return;
}


void Checkkey(void)
{
		Delay(65000);
	    Delay(65000);

}


///////////////////////////////////////////////////////
//Name:		Intilizate_lcd
//Programmed by:Javen
//Data:		2008.07,29
//Description:	intilizate the lcd controller's parameters
//////////////////////////////////////////////////////////

void Intilizate_lcd(void)
{	uint i;
	uchar Gray_Parameters[]={0x00,0x00,0xdd,0xdd,0xaa,0xaa,0xff,0xff};
	IE=0x81;
	IP=0x01;
	TCON=0x01;
//	EA=1;
//	EX0=1;
//	IT0=1;
//	IE0=0;
	int0=1;
	P1=0x0ff;

	REST=0;
	Delay(1000);
	REST=1;
	Delay(2000);
	
	Write_command(ModeSet);
	Write_command(ModeSetP);
	Write_command(InterOsc_on);
	Write_command(LcdBias_12);
	Write_command(Duty_set);
	Write_command(Duty_setP);
	Write_command(Regulator);
	Write_command(Contrast_level);
	Write_command(Contrast_levelP);
	Write_command(BoostLevel_3);
	Delay(1000);
	Write_command(PowerControll_on1);
	Delay(1000);
	Write_command(BoostLevel_6);        //6XVDD
	Write_command(PowerControll_on2);
	Delay(1000);
	Write_command(PowerControll_on3);
	Delay(1000);	

	Write_command(FrcPwm_set);
	for(i=0;i<8;i++)
		{
		Write_command(0x88+i);
		Write_command(Gray_Parameters[i]);
		}
	Write_command(AdcSelect);
	Write_command(ComScanDirection);
	Write_command(Display_on);
}
////////////////////////////////////////////////
//Name:		Clear
//Programmed by:Javen
//Data:		2008.07,29
//Description:	Clear display
/////////////////////////////////////////////////

void Clear(uchar datas)
{
	uint j,k;
	
	//Write_command(Display_on);

	Write_command(StartLine_set);
	Write_command(0x00);
	for(j=0;j<16;j++)
		{
		Write_command(Start_columnlsb);
		Write_command(Start_columnmsb);
		Write_command(Start_page+j);
		for(k=0;k<128;k++)
			{
			Write_data(datas);
			Write_data(datas);
			}
		}
	
	
}

////////////////////////////////////////////////
//Name:		Test
//Programmed by:Javen
//Data:		2008.07,29
//Description:	Test display
/////////////////////////////////////////////////

void Test(uchar code *test)
{
	uint i,j,k;
	
	//Write_command(Display_on);

	Write_command(StartLine_set);
	Write_command(0x00);
	for(j=0;j<16;j++)
		{
		Write_command(Start_columnlsb);
		Write_command(Start_columnmsb);
		Write_command(Start_page+j);
		for(k=0;k<16;k++)
			{
			for(i=0;i<16;i++)
				{
				Write_data(*(test+i));
				}
			}
		}
	
	
}

////////////////////////////////////////////////
//Name:		Display_frame
//Programmed by:Javen
//Data:		2008.07,29
//Description:	display a frame to test lcd edge
/////////////////////////////////////////////////

void Display_frame(void)
{
uint j,k,datas;

	Write_command(StartLine_set);
	Write_command(0x00);
	for(j=0;j<16;j++)
		{
		Write_command(Start_columnlsb);
		Write_command(Start_columnmsb);
		Write_command(Start_page+j);
		
		if(j==0) datas=0x01;
		else if(j==15) datas=0x80;
		else datas=0x00;
		
		Write_data(0xff);
		Write_data(0xff);
		for(k=0;k<252;k++) Write_data(datas);
		Write_data(0xff);
		Write_data(0xff);
		}
}
////////////////////////////////////////////////
//Name:		Display_gray
//Programmed by:Javen
//Data:		2008.07,29
//Description:	display four gray
/////////////////////////////////////////////////

void Display_gray(void)
{
uint i,j;
uchar data1,data2;

	Write_command(StartLine_set);
	Write_command(0x00);
	for(i=0;i<16;i++)
		{
		Write_command(Start_columnlsb);
		Write_command(Start_columnmsb);
		Write_command(Start_page+i);
		for(j=0;j<128;j++)
			{
			if(j<32) 	
				{
				data1=0x00;
				data2=0x00;
				}
				
			else if(j<64) 
				{
				data1=0xff;
				data2=0x00;
				}
			else if(j<96)
				{
				data1=0x00;
				data2=0xff;
				}
			else 	
				{
				data1=0xff;
				data2=0xff;
				}
			Write_data(data1);
			Write_data(data2);
			}
		}
}
			
			
////////////////////////////////////////////////
//Name:		Display_map
//Programmed by:Javen
//Data:		2008.07,29
//Description:	display a map to lcd
/////////////////////////////////////////////////
void Display_map(uchar code *map)
{
	uint i,P,j;
	
	//Write_command(Display_on);

	Write_command(StartLine_set);
	Write_command(0x00);
	for(j=0;j<16;j++)
		{
		Write_command(Start_columnlsb);
		Write_command(Start_columnmsb);
		Write_command(Start_page+j);
		for(i=0;i<128;i++)
			{
			Write_data(P=(*(map+j*128+i)));
			Write_data(P);
			//Delay(10,1);
			}
			
		}

	
}

///////////////////////////////////////////////////
//Name:		Main
//Programmed by:Javen
//Data:		2008.07,29
//Description:	main programme
/////////////////////////////////////////////////////

void main()
{
 
	Intilizate_lcd();


while(1)
	{//Key=1;


	Display_map(map0);
	Checkkey();
		Write_command(ReverseDisp_on);
		Checkkey();


	Display_map(map1);
	Checkkey();
 		Write_command(ReverseDisp_off);
		Checkkey();


	Display_map(map2);
	Checkkey();
 		Write_command(ReverseDisp_on);
		Checkkey();
		Write_command(ReverseDisp_off);


 //   sleepmode();
//	Clear(0x00);
	Clear(0xff);
    Checkkey();

	//

//	Test(test3);
//	Checkkey();
//	Test(test4);
//	Checkkey();
	Test(test1);
	Checkkey();	   
	Test(test2);
	Checkkey();
	Display_gray();
	Checkkey();
	Display_frame();
	Checkkey();


	}
	
}

//////////////////////////////////////////////////////////

uchar code map0[]={
/*--  һͼD:\Ʒļ\ʾͼƬ\128128LOGO.bmp  --*/
/*--  x߶=128x128  --*/
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xC1,0xE1,0xF1,0xF9,0xFD,0xFF,0x01,0x01,
0x81,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFE,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0xF8,
0xF8,0xF0,0xF0,0xF0,0xF0,0xE0,0xE0,0xE0,0xE0,0xC0,0xC0,0xC0,0x80,0x80,0x80,0x80,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x3F,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x3F,0xFE,0xFE,0xFC,0xFC,0xF8,0xF8,0xF8,
0xF0,0xF0,0xE0,0xE0,0xC0,0xC0,0xC0,0x80,0x80,0x01,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x1F,0x7F,0xFF,0xF0,0x81,
0x01,0x03,0x03,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x1F,0x00,0x00,0x0F,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x0F,0x3F,
0xF8,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xFF,0xC0,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x7F,0x7F,0x3F,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0xFC,0xFC,0xFC,0x84,0x84,0xE4,0x04,0x0C,
0x1D,0x07,0x1C,0x00,0xC0,0xC0,0xA0,0x20,0x20,0xE0,0xE0,0xC0,0x00,0xC0,0xE0,0xA0,
0x2F,0x7F,0xE0,0x00,0x20,0xE3,0xF3,0xFF,0x23,0x21,0x05,0x05,0xFD,0xFD,0xFD,0x05,
0x04,0x04,0x8C,0xFC,0xF8,0x70,0x00,0x00,0x20,0xEC,0xEC,0xEC,0x00,0xC0,0xE0,0xA0,
0x20,0x40,0xE0,0x00,0x20,0xEC,0xEC,0xEC,0x00,0x20,0xE0,0xE0,0xE0,0x40,0x20,0xE0,
0xE0,0xC0,0x00,0x00,0x80,0xC0,0xE0,0x20,0x20,0xE0,0xE0,0xA0,0x20,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x3F,0x3F,0x20,0x20,0x23,0x20,0x20,
0x30,0x3C,0x00,0x00,0x19,0x3D,0x3D,0x26,0x12,0x3F,0x3F,0x3F,0x20,0x39,0x13,0x27,
0x2F,0x3E,0x1C,0x00,0x00,0x1F,0x3F,0x3F,0x20,0x10,0x20,0x20,0x3F,0x3F,0x3F,0x21,
0x23,0x07,0x0F,0x1C,0x38,0x30,0x20,0x20,0x20,0x3F,0x3F,0x3F,0x20,0x39,0x13,0x27,
0x2F,0x3E,0x1C,0x00,0x20,0x3F,0x3F,0x3F,0x20,0x20,0x3F,0x3F,0x3F,0x20,0x00,0x3F,
0x3F,0x3F,0x20,0x00,0xB3,0x7B,0x77,0x74,0x74,0x77,0x73,0x71,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x58,0xD8,0xD8,0x18,0x18,0x18,0x18,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
0x18,0x18,0x58,0xD8,0xD8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
0x18,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,
0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x04,0xFF,0xFF,0x04,0x84,0x00,0xF8,0xFC,0x24,0x24,0x3C,
0xB8,0x00,0x00,0xF8,0xFC,0x04,0x0C,0x8C,0x00,0x00,0xFF,0xFF,0x08,0x04,0xFC,0xF8,
0x00,0x04,0xFC,0xFC,0x08,0x04,0xFC,0xF8,0x00,0x00,0xF8,0xFC,0x04,0x04,0xFC,0xF8,
0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xF8,0xFC,0x04,0x04,0xFC,0xF8,0x00,0x00,0xB8,
0x7C,0x44,0x44,0x7C,0x3C,0x04,0x04,0xFC,0xFC,0x00,0x00,0xF8,0xFC,0x24,0x24,0x3C,
0xB8,0x00,0x00,0x98,0x3C,0x74,0xE4,0xCC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,0x00,0x00,0x80,0x80,
0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
0x00,0x00,0x80,0x00,0x01,0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,0x00,
0x00,0x00,0x01,0x01,0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x87,
0xCB,0x0B,0x0B,0x0B,0x0B,0x06,0x01,0x01,0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x81,
0x00,0x00,0x00,0x01,0x01,0xC1,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0xFC,0x34,0x82,0x83,0xC7,0xFB,0xFF,0xF3,0xFF,0x2E,
0x23,0x03,0x00,0x00,0x00,0x00,0x00,0x98,0xD8,0xFF,0x4C,0x00,0xFC,0x18,0xC4,0xFC,
0x0C,0x00,0xFF,0x01,0x00,0x00,0x00,0x00,0x20,0x20,0xB0,0xF0,0x3E,0xDE,0x78,0x18,
0xFC,0x56,0xFE,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x74,0x64,0x66,
0x06,0xFE,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0xEC,0xDC,0x47,
0xFB,0x33,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x30,0xF2,0xBA,0xFF,0x6D,
0x69,0xB9,0xFF,0x22,0x20,0xFF,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x60,0x70,0xB1,
0xDF,0x68,0x30,0x10,0x78,0x4F,0xCC,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x03,0x06,0x0F,0x00,0x02,0x01,0x04,0x08,0x1F,0x01,
0x01,0x03,0xC2,0x40,0x40,0x40,0x40,0x01,0x01,0x00,0x00,0x03,0x00,0x00,0x00,0x00,
0x00,0x8C,0x1F,0x00,0x00,0xC0,0x40,0x40,0x42,0x82,0x01,0x40,0x00,0x03,0x06,0x04,
0x04,0x04,0x44,0x04,0x06,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x06,0x02,0x02,
0x04,0x4F,0x47,0xC0,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x08,0x1E,0x05,0x06,0x0A,
0xDF,0x01,0x01,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x1F,0xC1,
0x02,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x0B,
0x1C,0x05,0x05,0x05,0x07,0x03,0x07,0x0C,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x12,0x12,0x12,0x12,0x19,0x15,0x15,0x1F,0x00,0x12,0x15,0x15,0x09,
0x01,0x1F,0x11,0x00,0x00,0x1F,0x02,0x02,0x06,0x19,0x00,0x1F,0x00,0x12,0x15,0x15,
0x09,0x00,0x1F,0x00,0x1F,0x01,0x01,0x1E,0x00,0x2E,0x51,0x51,0x3F,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0x00,0x00,0x0E,0x15,0x15,0x16,0x00,0x0E,0x11,0x11,0x0A,0x00,
0x1F,0x01,0x01,0x1E,0x00,0x1F,0x01,0x01,0x1E,0x00,0x0E,0x11,0x11,0x0E,0x00,0x1F,
0x00,0x0E,0x11,0x11,0x0E,0x00,0x2E,0x51,0x51,0x3F,0x00,0x01,0x4E,0x30,0x0E,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xFD,0xFD,0x45,0x45,0x45,0x45,
0x01,0xFD,0xFD,0x45,0x45,0xC5,0xFD,0x39,0x01,0xF1,0xF9,0x0D,0x05,0x05,0x0D,0x09,
0x01,0x01,0x31,0x19,0xFD,0xFD,0x01,0x01,0x09,0x0D,0x85,0xC5,0x7D,0x39,0x01,0xB9,
0xFD,0x45,0x45,0xFD,0xB9,0x01,0x01,0x31,0x19,0xFD,0xFD,0x01,0x01,0x09,0x0D,0x85,
0xC5,0x7D,0x39,0x01,0xB9,0xFD,0x45,0x45,0xFD,0xB9,0x01,0x41,0x41,0x41,0x01,0x09,
0x0D,0x25,0x25,0xFD,0xD9,0x01,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x9F,0x90,0x97,0x97,0x94,0x94,0x94,0x94,
0x90,0x97,0x97,0x90,0x90,0x90,0x93,0x97,0x94,0x91,0x93,0x96,0x94,0x94,0x96,0x92,
0x90,0x90,0x90,0x90,0x97,0x97,0x90,0x90,0x96,0x97,0x95,0x94,0x94,0x94,0x90,0x93,
0x97,0x94,0x94,0x97,0x93,0x90,0x90,0x90,0x90,0x97,0x97,0x90,0x90,0x96,0x97,0x95,
0x94,0x94,0x94,0x90,0x93,0x97,0x94,0x94,0x97,0x93,0x90,0x90,0x90,0x90,0x90,0x92,
0x96,0x94,0x94,0x97,0x93,0x90,0x9F,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF
};




uchar code map1[]={
/*--  һͼD:\Ʒļ\ʾͼƬ\128128a.bmp  --*/
/*--  x߶=128x128  --*/
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x7F,0xFF,0xFF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0x7F,0x7F,0x7F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,
0x3F,0xBF,0xDF,0xEF,0xEF,0xEF,0xF3,0xFB,0xFB,0xFB,0xFD,0xFF,0xFE,0xFE,0xFE,0xFE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,
0xFE,0xFE,0xFD,0xFD,0xFD,0xFD,0xFB,0xFB,0xFB,0xFF,0xEF,0xEF,0xEF,0xDF,0xBF,0xBF,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x9F,0x8F,0xE7,0xE3,0xF3,0xF9,0xFE,0xFE,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x3F,0x3F,0x1F,0x0F,0x0F,0x07,0x83,0xC3,
0xE1,0xF8,0xFC,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0xFF,0xFF,0xBF,0xBF,0xBF,
0xFE,0xFE,0xFE,0xFB,0xFB,0xF7,0xE7,0xCF,0x9F,0x3F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,
0x1F,0xFF,0xE7,0xFB,0xF8,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFB,0x7B,0x33,0x03,
0x03,0x03,0x03,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,
0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x0C,0x0C,0x0E,0xEE,0xEE,0xEE,0xEE,0xEE,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFD,0xF1,0xE7,0xCF,0x9F,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x0F,0xE7,0xF8,0xFE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x7F,0x3F,0x3F,0x3F,0x0F,0x07,0x07,0x07,0x03,0x01,0x01,0x10,0x1C,0x1E,0x0E,
0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0x00,0x00,0xF0,0xF8,0xF8,
0xF0,0xF0,0xE0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x20,0xE0,0xE0,0xE0,0xC1,0x83,0x87,0x0F,0x1F,0x3F,0x7F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFC,0xF9,0xE3,0x8F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0x1F,0xF0,0xFC,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0xC3,0x81,0x00,0x00,
0x80,0xC0,0xE0,0xF0,0xF8,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xF8,0xF8,0xF8,0xF8,0xF8,
0xF8,0xF0,0xF0,0xF0,0xF8,0xFC,0xFE,0xFF,0xFF,0xFF,0x7F,0x7F,0x7E,0x3F,0x1F,0x1F,
0x0F,0x07,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x0F,0x3F,0xFF,0xFF,0xFE,0xFE,0xF8,0xF8,0xF1,
0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF8,0xE1,0x03,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x1F,0xE0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x7F,0x3F,0x1F,0x3F,0x1F,0x1E,0x3C,0x39,0x01,0x01,0x03,0x03,0x03,0x03,0x01,
0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xF0,
0xF8,0xF0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x1F,0x0F,0x07,0x03,0x03,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,
0x80,0xC0,0xC0,0xC0,0xC0,0x80,0x80,0x80,0x80,0x00,0x00,0x80,0x80,0x80,0xC0,0xC0,
0xC0,0xE0,0xE0,0xF0,0xF8,0xF8,0xF8,0xFC,0xFE,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x3F,0x00,0x00,0x00,0xC0,0xF0,0xFD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x7F,0x1F,0x07,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x60,0xFC,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF1,0xF1,0xF1,0xE3,0xC7,0xC7,0x87,0x0F,0x0F,0x0F,0x1F,0x1F,
0x1F,0x3F,0x7F,0x7F,0x7E,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0x00,0xE0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFC,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0x03,0x07,0x0E,0x0C,0x38,0x39,0x3B,0x3F,0x3F,0x3F,0x1F,0x3F,
0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x79,0x01,0x01,0x01,0x07,
0x07,0x0F,0x1F,0x0F,0x0F,0x03,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x07,0x07,0x0F,0x1F,0x3F,0x3F,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x07,0x00,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xC0,0xC3,0x7F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0xF0,0xF8,0xFE,0xFC,0xF8,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,
0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x01,0x00,0x80,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xF0,0xF8,0x7C,0xFE,0xFE,0xFE,0xFE,
0xFE,0xFE,0xFC,0xFC,0xF8,0xF8,0xF0,0xF0,0xF0,0xE0,0xC0,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0x03,0x0F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x7F,0x0F,0x03,0xC0,0xF0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0xF8,0xC3,0x87,
0x1F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x07,0x00,0x00,0xC0,0xF8,
0xFC,0xFF,0xFF,0xFF,0xFE,0xFE,0xFC,0xFC,0xF8,0xF8,0xF0,0xF0,0xF0,0xE0,0xF0,0xF0,
0xF0,0xE0,0xE0,0xE0,0xC0,0xC0,0x80,0x80,0x80,0x07,0x0F,0x1F,0x3F,0x7F,0xFF,0xFE,
0xF8,0xF8,0xF0,0xF0,0xE0,0xE0,0xC0,0xC0,0xE4,0xE4,0xEC,0xFE,0xFE,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0xFC,0xFE,0xF8,
0xC0,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x1F,
0x87,0xC1,0xF0,0xFC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0xFC,0xF8,0xE1,0xC7,0x9F,0x1F,0x3F,0xEF,0xF9,0xF0,0xF8,0xFE,0xFE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFC,0xF8,0xF8,0xF1,
0xE3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x0F,0x80,0xC0,0xE0,0xF8,0xFE,0xFF,0x7F,0x3F,0x1F,0x8F,0xC3,0xE1,0xF0,0xFC,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xF8,0xF9,0xF3,0xE7,0xCF,0x9F,0x9F,
0x3F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x3F,
0x9F,0x9F,0xC7,0xE7,0xE3,0xF1,0xF8,0xFC,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFE,0xFE,0xFE,0xF8,0xF9,0xFB,0xFB,0xEF,0xEF,0xEF,0xEF,0xEF,0xFF,0x9F,0xBF,
0xBF,0xBF,0xBF,0xBF,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x3F,0xBF,0xBF,0xBF,0xBF,
0xBF,0x9F,0xDF,0xCF,0xCF,0xEF,0xE7,0xE7,0xF3,0xFB,0xF9,0xF9,0xFE,0xFE,0xFE,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,
0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF


};



uchar code map2[]={
/*--  һͼD:\liu\ʾͼƬ\128128.bmp  --*/
/*--  x߶=128x128  --*/
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0xC1,0xE1,0xFD,0xFD,0xC1,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0xC1,0xC1,0xE1,
0xE1,0xE1,0xF1,0xF1,0xF1,0xE1,0xC1,0xC1,0x81,0x01,0x01,0x01,0x01,0x81,0x81,0xC1,
0xC1,0xC1,0xC1,0xD9,0xFD,0xFD,0xF9,0x31,0x31,0x61,0x41,0xC1,0xC1,0xC1,0x41,0x41,
0x61,0x61,0x21,0x21,0x61,0xE1,0xC1,0xC1,0xC1,0x41,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xF8,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF8,0xFC,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x3E,0x3E,0xFF,0x7B,0x31,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x41,0xC3,0xC6,0xC8,0xF0,0xE0,0x80,0x80,0x00,0x00,0x00,
0x00,0x80,0xC0,0xE0,0xF0,0xF0,0xF0,0xF0,0xF0,0xE0,0xE0,0xC0,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xC0,0xF0,0xFC,0xFE,0xFF,0x03,0x31,0x3C,
0x38,0x30,0x61,0x01,0x87,0xFF,0xFF,0xFC,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xFC,0xFC,0xFC,0xDE,0xCF,0x8F,0x8E,0x8E,0x0E,0x1E,
0x18,0x38,0x78,0xF0,0xE0,0xC0,0xC0,0xC0,0xC0,0xC0,0xE0,0xE0,0xF0,0xF0,0xF0,0xF0,
0xF0,0xF0,0x30,0x30,0x30,0x38,0x3C,0x3F,0x77,0x60,0xE0,0xC1,0x83,0x83,0x0E,0x3E,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x07,0x07,0x0F,0x0F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1E,
0x1E,0x1E,0x1E,0x1F,0x1F,0x1F,0x1F,0x3F,0x3F,0xF8,0xC0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE1,0x79,0x1F,0x07,0x01,0x00,
0x03,0x0F,0x1F,0x3F,0x7F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0x70,0x70,0x38,0x0F,0x07,0x01,0x01,0x0F,0x1F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFE,0xFE,0xE0,0xE1,0x7B,0x3F,0x00,0x00,
0x00,0x00,0x07,0x3F,0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x7F,0x3F,0x1F,0x07,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x1F,0xFF,0xF0,0x40,0x40,0x60,
0x60,0x60,0x40,0xC0,0x80,0x80,0x80,0xF0,0x7C,0x0F,0x01,0x80,0xC0,0xE0,0xF0,0xF0,
0xF8,0xF8,0xFC,0xFC,0xFC,0x7C,0x7C,0x7C,0xFF,0xFF,0xFF,0xFB,0xF3,0xE3,0x01,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0xE1,0xE1,0xE3,0xF3,
0xE3,0xE7,0xE7,0xE7,0xE7,0xC7,0x87,0x83,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x3C,0x06,0x07,0x0F,0x1F,0x18,0x98,0xF8,
0x08,0xC0,0xF0,0xF8,0x1F,0x0F,0x07,0x00,0xC0,0xF8,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,
0xDF,0x07,0x03,0x60,0x30,0x18,0x08,0x08,0x18,0x79,0xFF,0xFF,0x0F,0x0F,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFE,0x6F,0x67,0x63,0x73,0xE3,0xC3,0x83,
0x07,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xF8,0xF0,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x3E,0x70,0xE0,0xC0,0xC0,0xC0,0xC0,0xC3,
0x80,0x9F,0xFF,0xF0,0xC0,0x80,0x00,0x00,0x00,0x07,0x0F,0x1F,0x3F,0x3F,0x7F,0x7F,
0x7F,0x7F,0x7C,0x3C,0x38,0x38,0x1C,0x3E,0xFE,0xF0,0xF0,0x70,0x60,0x60,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x38,0x78,0xF0,0xF0,0xF0,0xF1,0xF1,
0xF8,0xFC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x1F,0x07,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
0x03,0x03,0x0F,0x7F,0xF7,0xCF,0x1C,0x38,0x70,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xC0,0x80,0x80,0x80,0xC0,
0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x03,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0xE0,0xF0,0x7E,0x1F,0x07,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0x03,0x3C,0x78,0xE0,0x80,0x01,0x03,0x07,0x0E,0x0C,0x1C,
0x18,0xF0,0xF0,0xE0,0xE0,0xC0,0x81,0x81,0x81,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x80,0x80,0x80,0xC0,0xC0,0xE0,0xF0,0xF0,0x90,0x18,0x0C,0x0E,0x06,0x03,
0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x1E,0xF8,0xE0,0x80,0x80,0xFC,
0xFF,0xFF,0x7F,0x1F,0x1F,0x07,0x07,0x03,0x03,0x01,0x01,0x01,0x03,0x03,0x03,0x06,
0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0xFE,0xFE,0xFE,0xFE,0xFF,0x3F,
0x1F,0x0F,0x0F,0x0F,0x1F,0x3F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFE,0xF0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC1,0xFF,0x3F,0x07,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0F,0x07,0x03,0x00,0x18,
0x70,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x0F,0x3F,0x7F,0xE0,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0x07,0xFE,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,
0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0x07,0xFC,0xFC,0xFE,0xFC,0x78,0x38,0x18,0x0C,0x06,0x03,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xE0,0xFE,0x07,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0F,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x06,0x04,0x0C,0x08,0x18,0xF8,0xF8,
0x1C,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0x7F,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x83,
0x87,0x8F,0x8E,0x9C,0x9C,0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x9C,0x9C,0x8F,0x8F,
0x8E,0x8C,0x98,0x98,0x98,0x98,0x98,0x90,0x90,0x90,0x90,0x90,0x98,0x98,0x8C,0x8C,
0x8E,0x83,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF
};
