
//----------------------------------------------------------------------
/*EASTRISING TECHNOLOGY CO,.LTD.*/
// Module    : ERC1606404-1 Series   
// Create    : JAVEN
// Date      : 2024-12-19
// Drive IC  : ST75160
// INTERFACE : 8080_8bit
// MCU 		 : STC12LE5A60S2

//----------------------------------------------------------------------
//////////////////////////////////


#include <STC12C5A.H>  
#include<intrins.h>

#define uint unsigned int
#define uchar unsigned char
#define	TIME 400  //80806800400(4spi)
//========================================================
sbit RES=P3^1;
sbit CS1=P3^3;
sbit A0=P3^0;
sbit E=P3^5;
sbit RW=P3^4;
sbit SCL=P1^6;
sbit SDA=P1^7;

sbit DB0=P1^0;
sbit DB1=P1^1;
sbit DB2=P1^2;
sbit DB3=P1^3;
sbit DB4=P1^4;
sbit DB5=P1^5;
sbit DB6=P1^6;
sbit DB7=P1^7;


bit log=0;

sbit	int0=P3^2;
sbit key_add=P0^1;
sbit key_dec=P0^2;






unsigned char R_Ratio=0x02;   //ֵΧ0x00~0x07
unsigned char Contrast_level=45;        //΢Χ0x00~0x3f0-63

unsigned char LcmXPixel=160;   //
unsigned char LcmYPixel=64;    //߶

unsigned char page=1;       //Starting page address  (䣺0x00~0x28)
unsigned char y_total=8;	//Ending page address
unsigned char column=1;	    //Starting column address  (䣺0x00~0xff)
unsigned char x_total=160;	//Ending column address
//========================================================

unsigned char code Chinese_horizontal_text_16x16[];
unsigned char code Chinese_text_16x16[];
uchar code map0[];
uchar code map1[];
uchar code map2[];
uchar code map3[];
char code ascii_table_8x16[95][16];
unsigned char code Chinese_code_16x16[];

void init();
void clealddram();
void font1();
void font2();
void font3();
void disp_test(uchar data1);
void showpic(char *k);
void showpic1(char *k);
void showpic2(char *k);
void write_com(int para);
void write_data(int para);
void delay(int t);

void adj_Contrast(void);
void disp_string_8x16_16x16(uchar page,uchar column,uchar reverse,uchar *text);
void display_string_16x16(uchar page,uchar column,uchar reverse,uchar *text);
 void display_string_8x16(uint page,uint column,uchar reverse,uchar *text);




void Delay1(uint n)
{  
while(n--)
  {_nop_();
	_nop_();
	_nop_();
	_nop_(); 
 	_nop_();
	_nop_();

   }
}


void Step(void) interrupt 0 using 0
{
	Delay1(300);
	if(int0==0)	log=!log;
   while(!int0);
  return;

}



void Display_Contrast(uchar number)
{	uchar num[]={0,1,2,3,4,5,6,7,8,9};
	uchar number1,number2;
	number1=number/10;number2=number%10;
  switch(number1)
	 { 
	  case(0): disp_string_8x16_16x16(1,2,0,"0" );break; 
	  case(1): disp_string_8x16_16x16(1,2,0,"1" );break; 
	  case(2): disp_string_8x16_16x16(1,2,0,"2" );break; 
	  case(3): disp_string_8x16_16x16(1,2,0,"3" );break;
	  case(4): disp_string_8x16_16x16(1,2,0,"4" );break; 
	  case(5): disp_string_8x16_16x16(1,2,0,"5" );break;	  
	  case(6): disp_string_8x16_16x16(1,2,0,"6" );break; 
	  case(7): disp_string_8x16_16x16(1,2,0,"7" );break;	  
	  case(8): disp_string_8x16_16x16(1,2,0,"8" );break; 
	  case(9): disp_string_8x16_16x16(1,2,0,"9" );break;	   
	 }
  switch(number2)
	 { 
	  case(0): disp_string_8x16_16x16(1,10,0,"0" );break;
	  case(1): disp_string_8x16_16x16(1,10,0,"1" );break;
	  case(2): disp_string_8x16_16x16(1,10,0,"2" );break; 
	  case(3): disp_string_8x16_16x16(1,10,0,"3" );break;
	  case(4): disp_string_8x16_16x16(1,10,0,"4" );break; 
	  case(5): disp_string_8x16_16x16(1,10,0,"5" );break;	  
	  case(6): disp_string_8x16_16x16(1,10,0,"6" );break; 
	  case(7): disp_string_8x16_16x16(1,10,0,"7" );break;	  
	  case(8): disp_string_8x16_16x16(1,10,0,"8" );break; 
	  case(9): disp_string_8x16_16x16(1,10,0,"9" );break;	  	  		  
	 }

}

void adj_Contrast(void)
{	Delay1(300);
 	 	   if(key_add==0)
            {
	       while(key_add==0)
                 {
	            if(Contrast_level<0x3f)//ԱȶֵΧ00-3F
                      {
	                 Contrast_level++;
	                 write_com(0x30);
	                 write_com(0x81);//˫ָ
	                 write_data(Contrast_level);
					 Display_Contrast(Contrast_level);
                        	Delay1(65000);	Delay1(40000); 
                      }
                  }
              }
	 else
	  if(key_dec==0)
	   {
	      while(key_dec==0)
	       {
	         if(Contrast_level>0)
	           {
	              Contrast_level--;
	              write_com(0x30);//˫ָ
	              write_com(0x81);//˫ָ
	              write_data(Contrast_level);
				  Display_Contrast(Contrast_level);
                     	Delay1(65000); Delay1(40000); 
                    }
                }
            }
        
	 	  	
}



void Delay(uint n)
{while(n)
 {    if((key_add==0)||(key_dec==0)) adj_Contrast();
	  n--; Delay1(3) ;
 }
 	for(;log==1;)
	{
 	 if((key_add==0)||(key_dec==0)) adj_Contrast();	

	}
}


//========================================================
void init()
{
    	RES=1;
    	RES=0;
    	delay(2000);
    	RES=1;
    	delay(2000);

   write_com(0x30);   	// EXT=0
	write_com(0x94);   	// Sleep out
	write_com(0x31);   	// EXT=1
	write_com(0xD7);   	// Autoread disable
	write_data(0x9F);   //

	write_com(0x32);   	//Analog Circuit Set
	write_data(0x00); 	//
	write_data(0x01);   // ѹƵ     00=3KHz   01=6KHz   02=12KHz   03=24KHz
	write_data(0x05);	  // Bias    05=1/9 Bias   04=1/10 Bias   03=1/11 Bias   02=1/12 Bias   01=1/13 Bias   00=1/14 Bias


	write_com(0x51);   	//Set booster level
	write_data(0xFA); 	//8X

	write_com(0x20);   	// Gray Level
	write_data(0x00);
	write_data(0x03);
	write_data(0x04);
	write_data(0x08);
	write_data(0x08);
	write_data(0x08);
	write_data(0x0F);
	write_data(0x10);
	write_data(0x12);
	write_data(0x13);
	write_data(0x15);
	write_data(0x16);
	write_data(0x16);
	write_data(0x16);
	write_data(0x1B);
	write_data(0x1E);

	write_com(0x30);    // EXT=0
	write_com(0xD1);   	// OSC on

	write_com(0xBC);   	// PARAMETER scan direction -----------
	write_data(0x00);   // Address direction -fang xiang-

	write_com(0xCa);   	// Display Control
	write_data(0x04);   //
	write_data(0x3f);	  // duty  A0=160   80=128    78=120    60=96    40=64
	write_data(0x00);   //

	write_com(0xA6);   	// Normal display
    write_com(0xF0);   	// Gray or mono
	write_data(0x10);   // mono

    write_com(0x30);   	// EXT=0
	write_com(0x81);   	// EV control
	write_data(Contrast_level); 	  // VPR[5-0]  4inch=0x1C ; 5inch=0x22   *******************************
	write_data(R_Ratio);   	// VPR[8-6] 0X00~0X07

	write_com(0x20);   	// Power control  ԴƵ·
	write_data(0x0B);   // D0=regulator ; D1=follower ; D3=booste,  on:1 off:0     0000 1011     -ѹ-0-ѹ--

	write_com(0x31);   	// EXT=1
	write_com(0xf0);   	//
	write_data(0x18);
	write_data(0x18);
	write_data(0x18);
	write_data(0x18);

	write_com(0x30);   	// EXT=0

	write_com(0x0c);   	//
//	write_com(0xab);   	//
//	write_data(0x00);

	write_com(0xAF);    	//Display on

}
//====================  ַ  ==========================

void lcd_address(int y,int x,y_total,x_total)
{
x=x-1;
	y=y-1;
         write_com(0x30);
	write_com(0x15);	//Set Column Address
	write_data(x);
	write_data(x+x_total-1);
	write_com(0x75);	//Set Page Address
	write_data(y);
	write_data(y+y_total-1);
	write_com(0x5c);
}
//====================  ʾ  ==========================
void disp_test(uchar data1)
{
	int i,j;
	lcd_address(page,column,y_total,x_total);
	for(i=0;i<LcmYPixel/8;i++)
	{
	for(j=0;j<LcmXPixel;j++)
	{
	write_data(data1);
	}
	}
}

//====================    ==========================
void font2()
{
	int i,j;
	lcd_address(page,column,y_total,x_total);
	for(i=0;i<LcmYPixel/8;i++)
	{
	for(j=0;j<LcmXPixel;j++)
	{
	write_data(0x00);
        write_data(0xff);
	}
	}
}
//====================    ==========================
void font3()
{
	int i,j;
	lcd_address(page,column,y_total,x_total);
	for(i=0;i<LcmYPixel/8;i++)
	{
	for(j=0;j<LcmXPixel;j++)
	{
	write_data(0x55);
	write_data(0xaa);
	}
	}
}
//====================  ʾͼƬ  ======================
void showpic(char *k)
{
	int i,j;
        lcd_address(page,column,y_total,x_total);
	for(i=0;i<LcmYPixel/8;i++)
	{
	for(j=0;j<LcmXPixel;j++)
	{
	write_data(*k++);
	}
	}
}

//========================================================
void write_com(int para)
{
	int i;
	i=8;
	if (TIME==8080)
		{
	    CS1=0;
	    A0=0;
	    E=1;
	    RW=0;
	    P1=para;
	    RW=1;
	    CS1=1;
    }
    if (TIME==6800)
		{
	    CS1=0;
	    A0=0;
	    E=1;
	    RW=0;
	    P1=para;
	    RW=1;
	    CS1=1;
    }
    if (TIME==400)
		{
	    CS1=0;
	    A0=0;
	  do
     {
  	  if(para&0x80)
    	 SDA=1;
  	  else
    	 SDA=0;
    	 SCL=0;
	//delay(2);
    	SCL=1;
  	  --i;
    	para<<=1;
     }
 	    while(i);
	    CS1=1;
    }
}
//========================================================
void write_data(int para)
{
	int i;
	i=8;
	if (TIME==8080)
		{
	    CS1=0;
	    A0=1;
	    E=1;
	    RW=0;
	    P1=para;
	    RW=1;
	    CS1=1;
    }
    if (TIME==6800)
		{
	    CS1=0;
	    A0=1;
	    E=1;
	    RW=0;
	    P1=para;
	    RW=1;
	    CS1=1;
    }
    if (TIME==400)
		{
	    CS1=0;
	    A0=1;
	  do
     {
  	  if(para&0x80)
    	 SDA=1;
  	  else
    	 SDA=0;
    	 SCL=0;
	//delay(2);
    	SCL=1;
  	  --i;
    	para<<=1;
     }
 	    while(i);
	    CS1=1;
    }
}


 /**********************************************************************************************
   ʾһ8x16ַ(ASCII)
   ĲֱΪҳУǷԣָ룩
  **********************************************************************************************/

 void display_string_8x16(uint page,uint column,uchar reverse,uchar *text)
{
	uint i=0,j,k,n,data1;
	while(text[i]>0x00)
	{
		if((text[i]>=0x20)&&(text[i]<=0x7e))
		{
			j=text[i]-0x20;
			for(n=0;n<2;n++)
			{
			       lcd_address(page+n,column,y_total,x_total);//lcd_address(page+n,column);
				for(k=0;k<8;k++)
				{
					if(reverse==1)	data1=~ascii_table_8x16[j][k+8*n];
					else	data1=ascii_table_8x16[j][k+8*n];
					write_data(data1);
				}
			}
			i++;
			column+=8;
		}
		else
		i++;
	}
}
/***********************************************************************/
//дһ16x16ĺַַ躬д֣
//Ĳ(ҳУַ

void display_string_16x16(uchar page,uchar column,uchar reverse,uchar *text)
{
    uchar i,j,k;
    uint address;

    j = 0;
    while(text[j] != '\0')
    {
        i = 0;
        address = 1;
        while(Chinese_text_16x16[i] > 0x7e)	  // >0x7f˵ASCIIַ
        {
            if(Chinese_text_16x16[i] == text[j])
            {
                if(Chinese_text_16x16[i + 1] == text[j + 1])
                {
                    address = i * 16;
                    break;
                }
            }
            i += 2;
        }

        if(column > (LcmXPixel-16) )
        {
            column = 0;
            page += 2;
        }

        if(address != 1)// ʾ
        {
          for(k=0;k<2;k++)
	    {
		 lcd_address(page+k,column,y_total,x_total);//lcd_address(page+k,column);
	            for(i = 0; i < 16; i++)
	            {
	                if(reverse==1)
			  write_data(~Chinese_code_16x16[address]);
			 else write_data(Chinese_code_16x16[address]);
	                 address++;
	            }
			 if(reverse==1)	write_data(0xff);
			 else	write_data(0x00);
   			}
            j += 2;
        }
        else              //ʾհַ
        {
			for(k=0;k<2;k++)
			{
				lcd_address(page+k,column,y_total,x_total);//lcd_address(page+k,column);
	            for(i = 0; i < 16; i++)
	            {
	                write_data(0x00);
	            }
   		}
                 j++;
        }

        column+=16;
    }
}
/***********************************************************************/
//ʾ16x16ĺֻASCII8x16ַַ
//Ĳ(ҳУַ
void disp_string_8x16_16x16(uchar page,uchar column,uchar reverse,uchar *text)
{
    uchar temp[3];
    uchar i = 0;

    while(text[i] != '\0')
    {
        if(text[i] > 0x7e)
        {
            temp[0] = text[i];
            temp[1] = text[i + 1];
            temp[2] = '\0';          //Ϊֽ
            display_string_16x16(page, column,reverse, temp);  //ʾ
            column += 16;
            i += 2;
        }
        else
        {
            temp[0] = text[i];
            temp[1] = '\0';          //ĸռһֽ
            display_string_8x16(page, column,reverse, temp);  //ʾĸ
            column += 8;
            i++;
        }
    }
}


main()
{

 P1M1=0x00; //P1Ϊ
P1M0=0xff;

 P3M1=0x00; //P3Ϊ
 P3M0=0xFF;


	IE=0x81;
	IP=0x01;
	TCON=0x01;
	int0=1;	
	init();
	//loop:
	init();
	delay(5);

while(1)
	{
/*	disp_test(0xFF);	//ȫ
    Delay(60000);
    Delay(60000);

	disp_test(0x00);
    Delay(60000);
    Delay(60000);	*/

        disp_test(0x00);         //
        disp_string_8x16_16x16(3,1,0," 1.ã45");     //˵ҳһʾ
        disp_string_8x16_16x16(5,1,1," 2.10.60v        ");     //˵ҳڶʾ
      
    	Delay(60000);
    	Delay(60000);
	
        font2();                  //
       
    	Delay(60000);
    	Delay(60000);

        font3();                  //
    
 		Delay(60000);
    	Delay(60000);

        showpic(map0);           //
   
    	Delay(60000);
    	Delay(60000);

        showpic(map1);           //
   
    	Delay(60000);
    	Delay(60000);

         showpic(map2);           //
   
    	Delay(60000);
    	Delay(60000);

         showpic(map3);           //
   
    	Delay(60000);
    	Delay(60000);


	    disp_test(0x00);         //
        disp_string_8x16_16x16(3,1,0,"HHHHHHHHHHHHHHHHHHHHHH");     //˵ҳһʾ
        disp_string_8x16_16x16(5,1,0,"         10.60v    ");     //˵ҳڶʾ



       
    	Delay(60000);
    	Delay(60000);



}
}



uchar code map0[]={
 /* 0X22,0X01,0XA0,0X00,0X40,0X00, */
0XFF,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,
0X01,0XF9,0X89,0X89,0X89,0X89,0X89,0X01,0X01,0X41,0X21,0X21,0X21,0XC1,0X01,0X01,
0XC1,0X21,0X21,0X21,0X41,0X01,0X21,0XF9,0X21,0X01,0XF9,0X89,0X89,0X89,0X89,0X89,
0X71,0X01,0X01,0XE9,0X01,0X01,0XC1,0X21,0X21,0X21,0X41,0X01,0X01,0XE9,0X01,0X01,
0XE1,0X41,0X21,0X21,0XC1,0X01,0X01,0XC1,0X21,0X21,0X41,0XE1,0X01,0X01,0X01,0X01,
0X09,0X09,0X09,0XF9,0X09,0X09,0X09,0X01,0XC1,0X21,0X21,0X21,0XC1,0X01,0X01,0XC1,
0X21,0X21,0X41,0X01,0X01,0XF9,0X41,0X21,0X21,0XC1,0X01,0X01,0XE1,0X41,0X21,0X21,
0XC1,0X01,0X01,0XC1,0X21,0X21,0X21,0XC1,0X01,0X01,0XF9,0X01,0X01,0XC1,0X21,0X21,
0X21,0XC1,0X01,0X01,0XC1,0X21,0X21,0X41,0XE1,0X01,0X61,0X81,0X01,0X81,0X61,0X01,
0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X0F,0X08,0X08,0X08,0X08,0X08,0X00,0X00,0X06,0X09,0X09,0X05,0X0F,0X00,0X00,
0X04,0X09,0X09,0X09,0X06,0X00,0X00,0X0F,0X08,0X00,0X0F,0X00,0X00,0X00,0X01,0X06,
0X08,0X00,0X00,0X0F,0X00,0X00,0X04,0X09,0X09,0X09,0X06,0X00,0X00,0X0F,0X00,0X00,
0X0F,0X00,0X00,0X00,0X0F,0X00,0X00,0X27,0X28,0X28,0X24,0X1F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X07,0X09,0X09,0X09,0X05,0X00,0X00,0X07,
0X08,0X08,0X04,0X00,0X00,0X0F,0X00,0X00,0X00,0X0F,0X00,0X00,0X0F,0X00,0X00,0X00,
0X0F,0X00,0X00,0X07,0X08,0X08,0X08,0X07,0X00,0X00,0X0F,0X00,0X00,0X07,0X08,0X08,
0X08,0X07,0X00,0X00,0X27,0X28,0X28,0X24,0X1F,0X00,0X00,0X23,0X1C,0X03,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X08,0XFF,0X08,0XF8,0X00,0XFE,0X92,0X92,
0X92,0XFE,0X00,0X00,0X00,0X00,0XFF,0X11,0X11,0X11,0X11,0X11,0X11,0XFF,0X00,0X00,
0X02,0X22,0X32,0XAA,0X26,0XFB,0X22,0X62,0XA2,0X22,0X02,0X00,0X04,0X04,0X04,0X84,
0X7C,0X15,0X16,0X14,0XF4,0X06,0X04,0X00,0X8A,0X6A,0XFE,0X29,0X49,0X80,0X92,0XA4,
0X80,0XFF,0X40,0X00,0X44,0X44,0XFF,0X24,0X00,0X64,0XA4,0X3F,0XA4,0X64,0X04,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X06,0X01,0X00,0X07,0X04,0X05,0X04,0X04,
0X04,0X05,0X06,0X00,0X00,0X00,0X07,0X02,0X02,0X02,0X02,0X02,0X02,0X07,0X00,0X00,
0X02,0X02,0X01,0X00,0X04,0X07,0X00,0X00,0X00,0X01,0X02,0X00,0X04,0X04,0X02,0X01,
0X00,0X04,0X04,0X04,0X03,0X00,0X00,0X00,0X01,0X00,0X07,0X00,0X00,0X00,0X00,0X00,
0X00,0X07,0X00,0X00,0X04,0X04,0X07,0X00,0X04,0X04,0X02,0X01,0X02,0X04,0X04,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X0F,0X01,0XFD,0XFD,0XCD,0XCD,0XCD,0XCD,0XCD,0XCD,0X01,0X01,0XFD,0XFD,0X8D,
0X8D,0X8D,0X8D,0X8D,0XFD,0X79,0X01,0X01,0XE1,0XF9,0X19,0X0D,0X0D,0X0D,0X1D,0X39,
0X11,0X01,0X01,0X61,0X31,0X19,0XFD,0XFD,0X01,0X01,0XF1,0XF9,0XDD,0XCD,0XCD,0XDD,
0X99,0X01,0XF1,0XF9,0X1D,0X0D,0X1D,0XF9,0XF1,0X01,0XF1,0XF9,0XDD,0XCD,0XCD,0XDD,
0X99,0X01,0X01,0X81,0XE1,0X39,0XFD,0XFD,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X01,
0X61,0X31,0X19,0XFD,0XFD,0X01,0X0F,0X00,0XC0,0X20,0X20,0X20,0X20,0X40,0X00,0X00,
0X80,0X80,0X80,0X00,0X00,0X80,0X00,0X80,0X00,0XA0,0X00,0X00,0X80,0X80,0X80,0X00,
0X00,0X00,0X80,0X80,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X78,0X40,0X5F,0X5F,0X58,0X58,0X58,0X58,0X58,0X58,0X40,0X40,0X5F,0X5F,0X41,
0X41,0X41,0X43,0X47,0X5E,0X5C,0X50,0X40,0X43,0X4F,0X4C,0X58,0X58,0X58,0X5C,0X4E,
0X44,0X40,0X40,0X40,0X40,0X40,0X5F,0X5F,0X40,0X40,0X47,0X4F,0X58,0X58,0X58,0X4F,
0X47,0X40,0X47,0X4F,0X5C,0X58,0X5C,0X4F,0X47,0X40,0X47,0X4F,0X58,0X58,0X58,0X4F,
0X47,0X40,0X47,0X47,0X46,0X46,0X5F,0X5F,0X46,0X40,0X40,0X43,0X43,0X43,0X43,0X40,
0X40,0X40,0X40,0X5F,0X5F,0X40,0X78,0X00,0X08,0X11,0X11,0X12,0X12,0X0C,0X00,0X0F,
0X12,0X12,0X12,0X0B,0X00,0X1F,0X01,0X00,0X00,0X1F,0X00,0X0F,0X12,0X12,0X12,0X0B,
0X00,0X09,0X12,0X12,0X14,0X09,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X80,0XC0,0X00,0X00,0X00,0X80,0X40,0X40,0X40,0X80,0X00,0X80,
0X40,0X40,0X40,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X40,0X40,0X40,0X80,
0X00,0X00,0X00,0X80,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X40,0X40,0X40,0X80,0X00,
0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XC0,0X20,0X20,0X20,0X40,0X00,0X20,0X20,0X20,0XE0,0X20,0X20,0X20,0X20,
0X20,0X20,0X20,0XA0,0X60,0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0X00,0X00,0X40,0X40,
0XE0,0X00,0X00,0X00,0X00,0X80,0X60,0X20,0X20,0X00,0X00,0X00,0X80,0X60,0X20,0X60,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X80,0X80,0X81,0X80,0XBF,0X80,0X80,0X80,0X9F,0XA2,0XA2,0XA2,0X9C,0X80,0X9F,
0XA0,0XA0,0XA0,0X9F,0X80,0XA1,0X92,0X8C,0X92,0XA1,0X80,0X9F,0XA2,0XA2,0XA2,0X9C,
0X80,0X8C,0X8B,0X88,0XBF,0X88,0X80,0X80,0X80,0X80,0XBF,0X84,0X84,0X84,0X83,0X80,
0XBF,0X80,0XA1,0X92,0X8C,0X92,0XA1,0X80,0X9E,0XA5,0XA5,0XA5,0X96,0X80,0XBF,0X80,
0X92,0XA5,0XA5,0XA9,0X92,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,
0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,
0X80,0X80,0X91,0XA2,0XA6,0XA4,0X98,0X80,0X80,0X80,0X80,0XBF,0X80,0X80,0X80,0X80,
0X80,0XB8,0X86,0X81,0X80,0X80,0X80,0XA1,0XA1,0XA1,0XB3,0X9E,0X80,0X80,0X80,0X80,
0XBF,0X80,0X80,0X80,0X80,0X9F,0XB1,0XA1,0XA1,0X9E,0X80,0X80,0X9F,0XB0,0XA0,0XB0,
0X8F,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0X80,0XFF,
};




uchar code map1[]={
/*--  һͼD:\Ʒļ\ʾͼƬ\16064LOGO.bmp  --*/
/*--  x߶=160x64  --*/
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0xC1,0xE1,0xF1,0xFD,0xFF,0xFF,0xFD,0x01,0x61,0xF1,0xE1,0xE1,0xE1,
0xE1,0xC1,0xC1,0xC1,0xC1,0xC1,0x81,0x81,0x81,0x81,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFD,
0x25,0x25,0x25,0x25,0x91,0x51,0x51,0xF1,0x01,0x21,0x51,0x51,0x91,0x11,0xF9,0x11,
0x01,0x01,0xFD,0x25,0x25,0x65,0x99,0x01,0xF5,0x01,0x21,0x51,0x51,0x91,0x01,0xF5,
0x01,0xF1,0x11,0x11,0xE1,0x01,0xE1,0x11,0x11,0xF1,0x01,0x01,0x01,0x01,0x05,0x05,
0xFD,0x05,0x05,0xE1,0x51,0x51,0x61,0x01,0xE1,0x11,0x11,0xA1,0x01,0xFD,0x11,0x11,
0xE1,0x01,0xF1,0x11,0x11,0xE1,0x01,0xE1,0x11,0x11,0xE1,0x01,0xFD,0x01,0xE1,0x11,
0x11,0xE1,0x01,0xE1,0x11,0x11,0xF1,0x01,0x11,0xE1,0x01,0xE1,0x11,0x01,0x01,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0F,0x7F,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,
0xFE,0xFE,0xFE,0xFC,0xFC,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0x01,0x01,0x81,0x01,0x81,0x01,0x81,0x01,0x80,0x01,0x81,0x01,0x80,0x00,0x81,0x01,
0x80,0x00,0x81,0x00,0x00,0x00,0x01,0xE0,0x81,0x80,0x01,0x01,0x81,0x00,0x00,0x81,
0x00,0x81,0x00,0x00,0x01,0x80,0x02,0x05,0x85,0x83,0xE0,0x00,0xA0,0x00,0x00,0x80,
0x81,0x80,0x00,0x80,0x81,0x81,0x01,0x00,0xE0,0x01,0x81,0x80,0x80,0x81,0x00,0x80,
0x01,0x00,0x01,0x80,0x00,0x01,0x00,0x00,0x01,0x81,0x80,0x00,0x01,0x00,0x80,0x81,
0x01,0x00,0x80,0x82,0x85,0x85,0x83,0x80,0x00,0x04,0x03,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x0F,0x3E,0xFE,0xFE,0xFC,0x3C,0x7C,0x78,
0x78,0xF0,0xF0,0xF0,0xE0,0xE0,0xC3,0x3F,0xFF,0xFF,0xFF,0xE0,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x7F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0x08,0x07,0x08,0x07,0x00,0x07,0x08,0x07,0x08,0x07,0x00,0x07,0x08,
0x07,0x08,0x07,0x00,0x00,0x08,0x00,0x0F,0x08,0x08,0x07,0x00,0x07,0x08,0x08,0x0F,
0x00,0x00,0x27,0x18,0x07,0x00,0x00,0x07,0x08,0x08,0x0F,0x00,0x0F,0x00,0x09,0x0A,
0x0A,0x04,0x00,0x3F,0x08,0x08,0x07,0x00,0x0F,0x00,0x0C,0x0A,0x0A,0x0F,0x00,0x00,
0x27,0x18,0x07,0x00,0x00,0x00,0x08,0x00,0x07,0x08,0x08,0x05,0x00,0x07,0x08,0x08,
0x07,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x1F,0x7E,0xF0,0x80,
0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x00,0x01,0x0F,0xFF,0xFF,0xC0,0x00,0x0F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x7F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x02,0xFE,0x02,0x02,0x70,0xA8,0xA8,0xB0,0x00,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6C,0x92,0x92,0x6C,0x00,0x7C,0x8A,0x8A,
0x74,0x00,0x20,0x20,0x00,0x02,0xE2,0x1A,0x06,0x00,0x58,0x8E,0x8A,0x72,0x00,0x58,
0x8E,0x8A,0x72,0x00,0x20,0x20,0x00,0x44,0x92,0x92,0x6C,0x00,0x44,0x92,0x92,0x6C,
0x00,0x48,0x8E,0x8A,0x72,0x00,0x7C,0x82,0x82,0x7C,0x00,0x44,0x92,0x92,0x6C,0x00,
0x6C,0x92,0x92,0x6C,0x00,0x02,0xE2,0x1A,0x06,0x00,0x44,0x92,0x92,0x6C,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0xE0,0xE0,0x21,0xA7,
0x60,0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x80,0x80,0x87,0x0F,0x80,0xE0,0xE3,
0x83,0x23,0xE3,0xE3,0x23,0x23,0xE3,0xC3,0x03,0x03,0x83,0xB3,0xB3,0x03,0x03,0x83,
0x83,0x80,0x00,0x80,0xB0,0xB0,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x80,
0x40,0x40,0xC0,0x80,0x00,0x00,0xFC,0x24,0x24,0x04,0x00,0x90,0x50,0x50,0xF0,0x00,
0x10,0xE0,0xE0,0x10,0x00,0x00,0x00,0x00,0xD8,0x24,0x24,0xD8,0x00,0xF8,0x14,0x14,
0xE8,0x00,0x40,0x40,0x00,0x04,0xC4,0x34,0x0C,0x00,0xB0,0x1C,0x14,0xE4,0x00,0xB0,
0x1C,0x14,0xE4,0x00,0x40,0x40,0x00,0x88,0x24,0x24,0xD8,0x00,0x88,0x24,0x24,0xD8,
0x00,0x90,0x1C,0x14,0xE4,0x00,0xF8,0x04,0x04,0xF8,0x00,0x88,0x24,0x24,0xD8,0x00,
0xD8,0x24,0x24,0xD8,0x00,0x04,0xC4,0x34,0x0C,0x00,0x10,0x08,0xFC,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x1F,0x1F,0x11,0x13,
0x18,0x00,0x1C,0x1E,0x12,0x1F,0x1F,0x10,0x1B,0x16,0x16,0x0D,0x00,0x00,0x1F,0x1F,
0x10,0x10,0x1F,0x1F,0x12,0x06,0x1D,0x18,0x10,0x00,0x10,0x1F,0x1F,0x10,0x1B,0x16,
0x16,0x0D,0x00,0x10,0x1F,0x1F,0x10,0x10,0x1F,0x1F,0x00,0x1F,0x1F,0x10,0x63,0xFF,
0x94,0x94,0xF7,0x73,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x80,
0x81,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x80,0x80,0x81,0x81,
0x80,0x00,0x00,0x00,0x00,0x80,0x81,0x80,0x80,0x80,0x80,0x81,0x01,0x00,0x00,0x00,
0x01,0x01,0x00,0x80,0x80,0x80,0x80,0x80,0x01,0x01,0x00,0x00,0x00,0x81,0x81,0x00,
0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x80,0x80,0x81,0x81,0x80,0x00,
0x00,0x01,0x01,0x80,0x80,0x80,0x01,0x00,0x00,0x00,0x00,0x80,0x81,0x80,0x00,0xFF,
0xFF,0x03,0xFB,0x23,0x23,0x23,0xC3,0x03,0xE3,0x03,0x03,0x03,0xE3,0x03,0x23,0xC3,
0x03,0xC3,0x23,0xC3,0x23,0x23,0x23,0xFB,0x03,0xEB,0x03,0x03,0x43,0xA3,0xA3,0x23,
0x03,0xE3,0x23,0x23,0x23,0xC3,0x03,0xFB,0x03,0x03,0x23,0xA3,0xA3,0xC3,0x03,0x23,
0xC3,0x03,0xC3,0x23,0x03,0x03,0x03,0xC3,0x23,0x23,0x43,0x03,0xC3,0x23,0x23,0x23,
0xC3,0x03,0xE3,0x23,0x23,0xC3,0x23,0x23,0xC3,0x03,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x03,0x01,0x01,0x01,0x01,
0x03,0x87,0x02,0x00,0x00,0xFF,0xFF,0x01,0x01,0x01,0x01,0x01,0x03,0xFF,0xFC,0x00,
0x00,0xC0,0xE7,0x3F,0x19,0x79,0xF9,0xCF,0x87,0xE0,0x40,0x00,0x00,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x03,0x01,0x01,0x01,0x01,0x03,0x87,
0x02,0x00,0x00,0xFF,0xFF,0x07,0x7E,0xF0,0x80,0xF0,0x7E,0x07,0xFF,0xFF,0x00,0xFF,
0xFF,0x80,0x83,0x82,0x82,0x82,0x81,0x80,0x81,0x82,0x82,0x82,0x83,0x80,0x88,0x89,
0x86,0x81,0x80,0x81,0x82,0x82,0x82,0x83,0x80,0x83,0x80,0x80,0x82,0x82,0x82,0x81,
0x80,0x8F,0x82,0x82,0x82,0x81,0x80,0x83,0x80,0x80,0x81,0x82,0x82,0x83,0x80,0x88,
0x89,0x86,0x81,0x80,0x80,0x82,0x80,0x81,0x82,0x82,0x81,0x80,0x81,0x82,0x82,0x82,
0x81,0x80,0x83,0x80,0x80,0x83,0x80,0x80,0x83,0x80,0x80,0x80,0x80,0x80,0x80,0x87,
0x87,0x86,0x86,0x86,0x86,0x86,0x86,0x80,0x80,0x80,0x83,0x83,0x86,0x86,0x86,0x86,
0x87,0x83,0x81,0x80,0x80,0x87,0x87,0x86,0x86,0x86,0x86,0x86,0x83,0x83,0x80,0x80,
0x80,0x81,0x83,0x86,0x86,0x86,0x86,0x83,0x83,0x83,0x87,0x82,0x80,0x87,0x87,0x86,
0x86,0x86,0x86,0x86,0x86,0x80,0x80,0x80,0x83,0x83,0x86,0x86,0x86,0x86,0x87,0x83,
0x81,0x80,0x80,0x87,0x87,0x80,0x80,0x83,0x87,0x83,0x80,0x80,0x87,0x87,0x80,0xFF,


};



uchar code map2[]={
/*--  һͼD:\Ʒļ\ʾͼƬ\16064p.bmp  --*/
/*--  x߶=160x64  --*/
0xFF,0x01,0x01,0x01,0x01,0x01,0xC1,0xF1,0xFD,0xFD,0x81,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0xC1,0xE1,0xF1,0xF9,0xF9,0xFD,0xFD,0xF9,0xF9,0x61,0xF1,0x51,0x01,
0x09,0x0D,0x0D,0x05,0x09,0x09,0x09,0x09,0x09,0x09,0x99,0xB9,0xC1,0x01,0x01,0x01,
0x81,0x81,0xC1,0xC1,0x81,0x01,0x01,0x01,0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xE1,0xF1,
0xF1,0xF1,0xE1,0xC1,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xF1,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0xFF,0x01,0x01,0x01,0x01,0x81,0xC1,0xC1,0x81,0x81,
0x01,0x01,0x01,0xC1,0xB9,0x99,0x09,0x09,0x09,0x09,0x09,0x09,0x05,0x0D,0x0D,0x09,
0x01,0x51,0xF1,0x61,0xF9,0xF9,0xFD,0xFD,0xF9,0xF9,0xF1,0xE1,0xC1,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x81,0xFD,0xFD,0xF1,0xC1,0x01,0x01,0x01,0x01,0x01,0xFF,
0xFF,0x30,0x30,0x78,0x7C,0x7F,0x71,0x66,0x60,0x71,0x7F,0x7C,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x07,0x8F,0x7F,0x1F,0x1F,0x3F,0x7F,0xFE,0xFE,0xFA,0xF3,0xF6,0xF6,
0xC4,0x48,0x18,0x18,0x78,0xF8,0xF8,0xF8,0xFC,0xF4,0xF4,0xEF,0xE8,0x99,0x71,0x06,
0x1F,0xFF,0xFF,0xFF,0xFF,0x7F,0x3E,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0xE0,0xFC,
0xFE,0xFE,0xFC,0x78,0x20,0x20,0x10,0x10,0x08,0x08,0x08,0x0C,0x04,0x04,0x07,0x07,
0x0F,0x0F,0x0F,0x0F,0x1F,0x10,0x10,0x20,0x20,0x40,0xC0,0x80,0xFF,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x3E,0x7F,0xFF,0xFF,0xFF,0xFF,0x1F,
0x06,0x71,0x99,0xE8,0xEF,0xF4,0xF4,0xFC,0xF8,0xF8,0xF8,0x78,0x18,0x18,0x48,0xC4,
0xF6,0xF6,0xF3,0xFA,0xFE,0xFE,0x7F,0x3F,0x1F,0x1F,0x7F,0x8F,0x07,0x00,0x00,0x00,
0x00,0x00,0x00,0x80,0x7C,0x7F,0x71,0x60,0x66,0x71,0x7F,0x7C,0x78,0x30,0x30,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x23,0x7C,0x48,0x48,
0x88,0x78,0x30,0x0C,0xE3,0xF0,0xF8,0xFC,0x1E,0x4E,0x4E,0x6F,0xDF,0x7D,0x31,0x01,
0x00,0x00,0x00,0xC0,0xB0,0x98,0x99,0x39,0xF9,0xF9,0xF9,0xF1,0xE1,0xC0,0x00,0x00,
0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xC0,0x70,0x08,0x07,
0x03,0x01,0x00,0x80,0x80,0x84,0x84,0x00,0x08,0x00,0x00,0x00,0x02,0x01,0xC0,0xF0,
0xF8,0xFC,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0x7C,0x7C,
0x30,0x60,0xC0,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,
0x00,0x00,0xC0,0xE1,0xF1,0xF9,0xF9,0xF9,0x39,0x99,0x98,0xB0,0xC0,0x00,0x00,0x00,
0x01,0x31,0x7D,0xDF,0x6F,0x4E,0x4E,0x1E,0xFC,0xF8,0xF0,0xE3,0x0C,0x30,0x78,0x88,
0x48,0x48,0x7C,0x23,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x08,0x18,0x10,0x10,
0x3F,0xF8,0x60,0xC0,0x83,0x07,0x0F,0x0F,0x0E,0x0C,0x04,0x0E,0x8C,0x88,0x00,0x80,
0x00,0x00,0x00,0x00,0x04,0x0C,0x1D,0x1D,0x3F,0x3F,0x3F,0x3F,0x1F,0x0F,0x00,0x00,
0x80,0xE0,0x3F,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xE0,0xFE,0xF1,0xFC,0xFC,0xFE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0x7E,0x7C,0x38,0x20,0x1F,0x3F,
0xFF,0xFF,0xCF,0xC7,0xE7,0xE3,0xF3,0xF3,0xF1,0xF9,0xF9,0xFC,0xFC,0xFC,0xFE,0x7E,
0x3F,0x00,0x01,0x1F,0xF0,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xE0,0x80,
0x00,0x00,0x0F,0x1F,0x3F,0x3F,0x3F,0x3F,0x1D,0x1D,0x0C,0x04,0x00,0x00,0x00,0x00,
0x80,0x00,0x88,0x8C,0x0E,0x04,0x0C,0x0E,0x0F,0x0F,0x07,0x83,0xC0,0x60,0xF8,0x3F,
0x10,0x10,0x18,0x08,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0x03,0x1C,0x71,0x83,0x02,0xE4,0xFC,0x78,0x39,0x11,0x10,0x10,0x10,0x20,
0x20,0x20,0x20,0x20,0xE0,0xE0,0xE0,0x70,0x30,0x30,0x78,0xF8,0xFC,0xE4,0x02,0x01,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x3F,0xCF,0x3F,0xFF,0xFF,0xC7,
0xE7,0xE3,0xF3,0xF3,0xF1,0xF9,0xF8,0xFC,0xFC,0xFC,0xFE,0xFE,0x7F,0x1F,0x03,0x00,
0x00,0x01,0x03,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x01,0x01,0x80,
0x40,0x20,0x18,0x0F,0x01,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0x01,0x02,0xE4,0xFC,0xF8,0x78,0x30,0x30,0x70,0xE0,0xE0,0xE0,0x20,0x20,0x20,0x20,
0x20,0x10,0x10,0x10,0x11,0x39,0x78,0xFC,0xE4,0x02,0x83,0x71,0x1C,0x03,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xF1,0x1F,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0x03,0x01,0x04,0x10,0x60,0x00,0x00,0x03,0x07,0x18,0xE0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x01,0x06,0x08,0x11,0x31,
0x23,0x43,0x47,0xC7,0x87,0x87,0x87,0x83,0x03,0x03,0x01,0x00,0x00,0x04,0x04,0x84,
0xA0,0x80,0x80,0xC0,0xC0,0x20,0x20,0x10,0x10,0x08,0x08,0x04,0xFE,0xC2,0xC1,0xE0,
0xF0,0x70,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xE0,0x18,0x07,0x03,0x00,0x00,0x60,0x10,0x04,0x01,0x03,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x1F,0xF1,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x83,0x3E,0x1E,0x0C,0x04,0x02,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xC0,0x40,0x40,0x40,0x80,0x00,0x01,0x01,0x01,0x01,0x07,0x07,0x03,0x03,0x07,
0x07,0x07,0x07,0x07,0x07,0x07,0x07,0xC7,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,
0x01,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x02,0x04,0x0C,0x1E,0x3E,0x83,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x87,0x90,0xA0,0xA0,0xC0,0xC1,0xC2,0xC2,0xA6,0xB6,
0xA2,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xA0,0x9E,0x8F,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0xBF,0x84,0x84,0x84,0x83,0x80,0x9A,0xA5,0xA5,0x95,0xBE,0x80,0xBF,0x81,0x81,
0x81,0xBE,0x80,0x9E,0xA1,0xA1,0x92,0xBF,0x80,0x9A,0xA5,0xA5,0x95,0xBE,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x8F,0x9E,0xA0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xA2,
0xB6,0xA6,0xC2,0xC2,0xC1,0xC0,0xA0,0xA0,0x90,0x87,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF

};

uchar code map3[]={
/*--  һͼD:\liu\ʾͼƬ\16064B.bmp  --*/
/*--  x߶=160x64  --*/
0x00,0x00,0x00,0x00,0x00,0xF8,0xFC,0xFC,0x06,0x72,0x8A,0x0A,0x8A,0x96,0xA4,0xAE,
0xAE,0xA2,0xBC,0x80,0xE0,0xF0,0xF8,0x08,0xE8,0x08,0xF8,0xF8,0xF0,0x30,0xC0,0x00,
0xBE,0xBE,0xBE,0xC0,0xFE,0xF8,0xFC,0xFC,0x06,0x72,0x8A,0x0A,0x8A,0x96,0xA4,0xAE,
0xAE,0xA2,0xBC,0x80,0xE0,0xF0,0xF8,0x08,0xE8,0x08,0xF8,0xF8,0xF0,0x30,0xC0,0x00,
0xBE,0xBE,0xBE,0xC0,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC3,0xFF,0xFC,0xF0,0xE0,0xE0,
0xE0,0xE0,0xE0,0xE0,0xC0,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x0B,0x0A,0x0A,0x0A,0x0A,0x0E,0x0B,0x0B,
0x0B,0x08,0x0E,0x02,0x03,0x05,0x0B,0x0A,0x0A,0x0A,0x0B,0x09,0x04,0x06,0x01,0x00,
0x0A,0x0A,0x0A,0x0A,0x0C,0x00,0x01,0x07,0x0B,0x0A,0x0A,0x0A,0x0A,0x0E,0x0B,0x0B,
0x0B,0x08,0x0E,0x02,0x03,0x05,0x0B,0x0A,0x0A,0x0A,0x0B,0x09,0x04,0x06,0x01,0x00,
0x0A,0x0A,0x8A,0x8A,0xCC,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,
0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xDC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFC,0xF8,0x80,0x00,0x00,0x00,
0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,
0xE0,0xF0,0xF8,0xF8,0xFC,0xFC,0xFE,0xFE,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFE,0xFE,0xFE,0xFE,0xFC,0xFC,0xF8,0xF8,0xF0,0xE0,0xC0,0xC0,0xF0,
0xFE,0xFF,0x1F,0x1F,0x0F,0x1F,0x1F,0x3F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0xF3,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0x02,0x00,0x80,
0xF8,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF0,0xF8,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x7F,0x7F,0x7F,
0x7F,0x7F,0xFF,0xFF,0xFF,0xBF,0x0F,0xFF,0xFF,0xFF,0xFF,0x0F,0x1F,0xFF,0xFF,0xFF,
0x7F,0x7F,0x3F,0x3E,0xFC,0xF8,0x70,0x20,0x00,0x00,0x01,0x03,0x07,0x0F,0x1F,0x3F,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,
0x9F,0xBD,0xF0,0xE0,0xE1,0xC3,0x87,0x0F,0x1F,0x3B,0x71,0xE0,0xE0,0xF8,0xFE,0xFF,
0xFF,0xFC,0xFC,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFC,0xFC,0xFC,
0xF8,0xF8,0xF0,0xE0,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x07,0xE3,0xF9,0xFC,0xFE,0xFE,0xFE,0xFF,0xFF,0xFE,
0xFE,0xFE,0xFE,0xFF,0xFF,0xFB,0xF0,0xFF,0xFF,0xFF,0xFF,0xF0,0xF8,0xFF,0xFF,0xE0,
0xC0,0x80,0x80,0x80,0xFF,0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0xC0,0xE1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFC,0xF8,0xF8,0xFD,0xFF,0xFF,0xFF,
0xFF,0xFF,0x7F,0x7F,0x3F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x3F,0x3F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFC,0xF0,0x80,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0xF0,0xC7,0x8F,0x9F,0x3F,0x7F,0x7F,0x7F,0x7F,0x7F,
0x7F,0x7F,0x3F,0x9F,0xCF,0xE7,0xF3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x00,0x00,0x03,0x07,0x0F,0x1F,0x1F,0x1F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
0x3F,0x3F,0x3F,0x3F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x81,0x01,0x02,0x04,0x04,0x08,0xF0,0x10,0x08,0x08,0x04,0x04,0x02,0x83,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x1F,0x3F,0x7F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFE,0xFE,
0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x7F,0x3F,0x1F,0x07,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x1F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFE,0xFC,0xFC,0xF8,0xFF,0xF8,0xF8,0xF8,0xFC,0xFE,0xFE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x3F,0x0F,0x01,0x00,0x00,0x00,0x00,0x00,
0x80,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
0xA0,0xA4,0xA4,0xA8,0xC0,0x88,0x88,0x98,0x80,0x80,0xC0,0xA0,0xA1,0xC0,0x80,0xA0,
0xA0,0x90,0x80,0x88,0x98,0x88,0xA0,0xE0,0xC0,0xA8,0x80,0x90,0x80,0xA0,0x83,0x83,
0xC7,0x8F,0x8F,0x9F,0x9F,0xBF,0xBF,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xBF,0xBF,0x9F,0x9F,0x8F,0x8F,0xC7,0xC3,0x81,0x80,
0x80,0xA0,0x80,0x80,0xA0,0x80,0x90,0x90,0xF0,0xE0,0xC0,0x80,0x80,0xA0,0x88,0xA0,
0x80,0x80,0x80,0xA0,0xB0,0x80,0xB0,0x80,0x80,0xA0,0x80,0xC0,0x90,0xDA,0x80,0xC0,
0x80,0x90,0xA0,0x80,0x80,0x90,0xB0,0x80,0x90,0x80,0x81,0xE3,0x87,0x8F,0x8F,0x9F,
0xBF,0xBF,0xBF,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xBF,0xBF,0xBF,
0x9F,0x9F,0x8F,0xC7,0x83,0xC3,0x90,0xC8,0x98,0xC0,0xC2,0xC2,0x80,0x84,0x80,0xD0,
0x90,0xB6,0xA2,0x80,0xC4,0x84,0xE8,0xA2,0xC4,0x84,0x90,0xC8,0x8B,0x9F,0xA0,0xC0
};

char code ascii_table_8x16[95][16]={

//8x16ASCIIĵݣ"JLX-GB2312"ͺŵֿICжĹġ
0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,		//- -(ո񡱣ASCII룺0X20
0x00,0x00,0x38,0xFC, 0xFC,0x38,0x00,0x00, 0x00,0x00,0x00,0x0D, 0x0D,0x00,0x00,0x00,		//-!-			ASCII룺0X21
0x00,0x0E,0x1E,0x00, 0x00,0x1E,0x0E,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,  	//-"-
0x20,0xF8,0xF8,0x20, 0xF8,0xF8,0x20,0x00, 0x02,0x0F,0x0F,0x02, 0x0F,0x0F,0x02,0x00,  	//-#-
0x38,0x7C,0x44,0x47, 0x47,0xCC,0x98,0x00, 0x06,0x0C,0x08,0x38, 0x38,0x0F,0x07,0x00,  	//-$-
0x30,0x30,0x00,0x80, 0xC0,0x60,0x30,0x00, 0x0C,0x06,0x03,0x01, 0x00,0x0C,0x0C,0x00,   	//-%-
0x80,0xD8,0x7C,0xE4, 0xBC,0xD8,0x40,0x00, 0x07,0x0F,0x08,0x08, 0x07,0x0F,0x08,0x00,		//-&-
0x00,0x10,0x1E,0x0E, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,		//-'-
0x00,0x00,0xF0,0xF8, 0x0C,0x04,0x00,0x00, 0x00,0x00,0x03,0x07, 0x0C,0x08,0x00,0x00,		//-(-
0x00,0x00,0x04,0x0C, 0xF8,0xF0,0x00,0x00, 0x00,0x00,0x08,0x0C, 0x07,0x03,0x00,0x00,		//-)-

0x80,0xA0,0xE0,0xC0, 0xC0,0xE0,0xA0,0x80, 0x00,0x02,0x03,0x01, 0x01,0x03,0x02,0x00,		//-*-			ASCII룺0X2A
0x00,0x80,0x80,0xE0, 0xE0,0x80,0x80,0x00, 0x00,0x00,0x00,0x03, 0x03,0x00,0x00,0x00,		//-+-
0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x10,0x1E, 0x0E,0x00,0x00,0x00,		//-,-
0x80,0x80,0x80,0x80, 0x80,0x80,0x80,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,		//---
0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x0C, 0x0C,0x00,0x00,0x00,		//-.-
0x00,0x00,0x00,0x80, 0xC0,0x60,0x30,0x00, 0x0C,0x06,0x03,0x01, 0x00,0x00,0x00,0x00,		//-/-
0xF8,0xF8,0x0C,0xC4, 0x0C,0xF8,0xF0,0x00, 0x03,0x07,0x0C,0x08, 0x0C,0x07,0x03,0x00,		//-0-		  	ASCII룺0X30
0x00,0x10,0x18,0xFC, 0xFC,0x00,0x00,0x00, 0x00,0x08,0x08,0x0F, 0x0F,0x08,0x08,0x00,		//-1-
0x08,0x0C,0x84,0xC4, 0x64,0x3C,0x18,0x00, 0x0E,0x0F,0x09,0x08, 0x08,0x0C,0x0C,0x00,		//-2-
0x08,0x0C,0x44,0x44, 0x44,0xFC,0xB8,0x00, 0x04,0x0C,0x08,0x08, 0x08,0x0F,0x07,0x00,		//-3-

0xC0,0xE0,0xB0,0x98, 0xFC,0xFC,0x80,0x00, 0x00,0x00,0x00,0x08, 0x0F,0x0F,0x08,0x00,		//-4-			ASCII룺0X34
0x7C,0x7C,0x44,0x44, 0x44,0xC4,0x84,0x00, 0x04,0x0C,0x08,0x08, 0x08,0x0F,0x07,0x00,		//-5-
0xF0,0xF8,0x4C,0x44, 0x44,0xC0,0x80,0x00, 0x07,0x0F,0x08,0x08, 0x08,0x0F,0x07,0x00,		//-6-
0x0C,0x0C,0x04,0x84, 0xC4,0x7C,0x3C,0x00, 0x00,0x00,0x0F,0x0F, 0x00,0x00,0x00,0x00,		//-7-
0xB8,0xFC,0x44,0x44, 0x44,0xFC,0xB8,0x00, 0x07,0x0F,0x08,0x08, 0x08,0x0F,0x07,0x00,		//-8-
0x38,0x7C,0x44,0x44, 0x44,0xFC,0xF8,0x00, 0x00,0x08,0x08,0x08, 0x0C,0x07,0x03,0x00,		//-9-
0x00,0x00,0x00,0x30, 0x30,0x00,0x00,0x00, 0x00,0x00,0x00,0x06, 0x06,0x00,0x00,0x00,		//-:-
0x00,0x00,0x00,0x30, 0x30,0x00,0x00,0x00, 0x00,0x00,0x08,0x0E, 0x06,0x00,0x00,0x00,		//-;-
0x00,0x80,0xC0,0x60, 0x30,0x18,0x08,0x00, 0x00,0x00,0x01,0x03, 0x06,0x0C,0x08,0x00,		//-<-
0x00,0x20,0x20,0x20, 0x20,0x20,0x20,0x00, 0x00,0x01,0x01,0x01, 0x01,0x01,0x01,0x00,		//-=-

0x00,0x08,0x18,0x30, 0x60,0xC0,0x80,0x00, 0x00,0x08,0x0C,0x06, 0x03,0x01,0x00,0x00,		//->-			ASCII룺0X3E
0x18,0x1C,0x04,0xC4, 0xE4,0x3C,0x18,0x00, 0x00,0x00,0x00,0x0D, 0x0D,0x00,0x00,0x00,		//-?-
0xF0,0xF0,0x08,0xC8, 0xC8,0xF8,0xF0,0x00, 0x07,0x0F,0x08,0x0B, 0x0B,0x0B,0x01,0x00,		//-@-
0xE0,0xF0,0x98,0x8C, 0x98,0xF0,0xE0,0x00, 0x0F,0x0F,0x00,0x00, 0x00,0x0F,0x0F,0x00,		//-A-			ASCII룺0X41
0x04,0xFC,0xFC,0x44, 0x44,0xFC,0xB8,0x00, 0x08,0x0F,0x0F,0x08, 0x08,0x0F,0x07,0x00,		//-B-
0xF0,0xF8,0x0C,0x04, 0x04,0x0C,0x18,0x00, 0x03,0x07,0x0C,0x08, 0x08,0x0C,0x06,0x00,		//-C-
0x04,0xFC,0xFC,0x04, 0x0C,0xF8,0xF0,0x00, 0x08,0x0F,0x0F,0x08, 0x0C,0x07,0x03,0x00,		//-D-
0x04,0xFC,0xFC,0x44, 0xE4,0x0C,0x1C,0x00, 0x08,0x0F,0x0F,0x08, 0x08,0x0C,0x0E,0x00,		//-E-
0x04,0xFC,0xFC,0x44, 0xE4,0x0C,0x1C,0x00, 0x08,0x0F,0x0F,0x08, 0x00,0x00,0x00,0x00,		//-F-
0xF0,0xF8,0x0C,0x84, 0x84,0x8C,0x98,0x00, 0x03,0x07,0x0C,0x08, 0x08,0x07,0x0F,0x00,		//-G-

0xFC,0xFC,0x40,0x40, 0x40,0xFC,0xFC,0x00, 0x0F,0x0F,0x00,0x00, 0x00,0x0F,0x0F,0x00,		//-H-			ASCII룺0X48
0x00,0x00,0x04,0xFC, 0xFC,0x04,0x00,0x00, 0x00,0x00,0x08,0x0F, 0x0F,0x08,0x00,0x00,		//-I-
0x00,0x00,0x00,0x04, 0xFC,0xFC,0x04,0x00, 0x07,0x0F,0x08,0x08, 0x0F,0x07,0x00,0x00,		//-J-
0x04,0xFC,0xFC,0xC0, 0xE0,0x3C,0x1C,0x00, 0x08,0x0F,0x0F,0x00, 0x01,0x0F,0x0E,0x00,		//-K-
0x04,0xFC,0xFC,0x04, 0x00,0x00,0x00,0x00, 0x08,0x0F,0x0F,0x08, 0x08,0x0C,0x0E,0x00,		//-L-
0xFC,0xFC,0x38,0x70, 0x38,0xFC,0xFC,0x00, 0x0F,0x0F,0x00,0x00, 0x00,0x0F,0x0F,0x00,		//-M-
0xFC,0xFC,0x38,0x70, 0xE0,0xFC,0xFC,0x00, 0x0F,0x0F,0x00,0x00, 0x00,0x0F,0x0F,0x00,		//-N-
0xF8,0xFC,0x04,0x04, 0x04,0xFC,0xF8,0x00, 0x07,0x0F,0x08,0x08, 0x08,0x0F,0x07,0x00,		//-O-
0x04,0xFC,0xFC,0x44, 0x44,0x7C,0x38,0x00, 0x08,0x0F,0x0F,0x08, 0x00,0x00,0x00,0x00,		//-P-
0xF8,0xFC,0x04,0x04, 0x04,0xFC,0xF8,0x00, 0x07,0x0F,0x08,0x0E, 0x3C,0x3F,0x27,0x00,		//-Q-

0x04,0xFC,0xFC,0x44, 0xC4,0xFC,0x38,0x00, 0x08,0x0F,0x0F,0x00, 0x00,0x0F,0x0F,0x00,		//-R-
0x18,0x3C,0x64,0x44, 0xC4,0x9C,0x18,0x00, 0x06,0x0E,0x08,0x08, 0x08,0x0F,0x07,0x00,		//-S-		 
0x00,0x1C,0x0C,0xFC, 0xFC,0x0C,0x1C,0x00, 0x00,0x00,0x08,0x0F, 0x0F,0x08,0x00,0x00,		//-T-
0xFC,0xFC,0x00,0x00, 0x00,0xFC,0xFC,0x00, 0x07,0x0F,0x08,0x08, 0x08,0x0F,0x07,0x00,		//-U-
0xFC,0xFC,0x00,0x00, 0x00,0xFC,0xFC,0x00, 0x01,0x03,0x06,0x0C, 0x06,0x03,0x01,0x00,		//-V-
0xFC,0xFC,0x00,0x00, 0x00,0xFC,0xFC,0x00, 0x07,0x0F,0x0E,0x03, 0x0E,0x0F,0x07,0x00,		//-W-
0x0C,0x3C,0xF0,0xE0, 0xF0,0x3C,0x0C,0x00, 0x0C,0x0F,0x03,0x01, 0x03,0x0F,0x0C,0x00,		//-X-
0x00,0x0C,0x7C,0xC0, 0xC0,0x7C,0x3C,0x00, 0x00,0x00,0x08,0x0F, 0x0F,0x08,0x00,0x00,		//-Y-
0x1C,0x0C,0x84,0xC4, 0x64,0x3C,0x1C,0x00, 0x0E,0x0F,0x09,0x08, 0x08,0x0C,0x0E,0x00,		//-Z-
0x00,0x00,0xFC,0xFC, 0x04,0x04,0x00,0x00, 0x00,0x00,0x0F,0x0F, 0x08,0x08,0x00,0x00,		//-[-

0x38,0x70,0xE0,0xC0, 0x80,0x00,0x00,0x00, 0x00,0x00,0x00,0x01, 0x03,0x07,0x0E,0x00,		//-\-
0x00,0x00,0x04,0x04, 0xFC,0xFC,0x00,0x00, 0x00,0x00,0x08,0x08, 0x0F,0x0F,0x00,0x00,		//-]-		  
0x08,0x0C,0x06,0x03, 0x06,0x0C,0x08,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,		//-^-
0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,		//-_-
0x00,0x00,0x03,0x07, 0x04,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,		//-`-
0x00,0xA0,0xA0,0xA0, 0xE0,0xC0,0x00,0x00, 0x07,0x0F,0x08,0x08, 0x07,0x0F,0x08,0x00,		//-a-			ASCII룺0X61
0x04,0xFC,0xFC,0x20, 0x60,0xC0,0x80,0x00, 0x00,0x0F,0x0F,0x08, 0x08,0x0F,0x07,0x00,		//-b-
0xC0,0xE0,0x20,0x20, 0x20,0x60,0x40,0x00, 0x07,0x0F,0x08,0x08, 0x08,0x0C,0x04,0x00,		//-c-
0x80,0xC0,0x60,0x24, 0xFC,0xFC,0x00,0x00, 0x07,0x0F,0x08,0x08, 0x07,0x0F,0x08,0x00,		//-d-
0xC0,0xE0,0xA0,0xA0, 0xA0,0xE0,0xC0,0x00, 0x07,0x0F,0x08,0x08, 0x08,0x0C,0x04,0x00,		//-e-

0x40,0xF8,0xFC,0x44, 0x0C,0x18,0x00,0x00, 0x08,0x0F,0x0F,0x08, 0x00,0x00,0x00,0x00,		//-f-
0xC0,0xE0,0x20,0x20, 0xC0,0xE0,0x20,0x00, 0x27,0x6F,0x48,0x48, 0x7F,0x3F,0x00,0x00,		//-g-		  
0x04,0xFC,0xFC,0x40, 0x20,0xE0,0xC0,0x00, 0x08,0x0F,0x0F,0x00, 0x00,0x0F,0x0F,0x00,		//-h-
0x00,0x00,0x20,0xEC, 0xEC,0x00,0x00,0x00, 0x00,0x00,0x08,0x0F, 0x0F,0x08,0x00,0x00,		//-i-
0x00,0x00,0x00,0x00, 0x20,0xEC,0xEC,0x00, 0x00,0x30,0x70,0x40, 0x40,0x7F,0x3F,0x00,		//-j-
0x04,0xFC,0xFC,0x80, 0xC0,0x60,0x20,0x00, 0x08,0x0F,0x0F,0x01, 0x03,0x0E,0x0C,0x00,		//-k-
0x00,0x00,0x04,0xFC, 0xFC,0x00,0x00,0x00, 0x00,0x00,0x08,0x0F, 0x0F,0x08,0x00,0x00,		//-l-
0xE0,0xE0,0x60,0xC0, 0x60,0xE0,0xC0,0x00, 0x0F,0x0F,0x00,0x07, 0x00,0x0F,0x0F,0x00,		//-m-
0x20,0xE0,0xC0,0x20, 0x20,0xE0,0xC0,0x00, 0x00,0x0F,0x0F,0x00, 0x00,0x0F,0x0F,0x00,		//-n-
0xC0,0xE0,0x20,0x20, 0x20,0xE0,0xC0,0x00, 0x07,0x0F,0x08,0x08, 0x08,0x0F,0x07,0x00,		//-o-

0x20,0xE0,0xC0,0x20, 0x20,0xE0,0xC0,0x00, 0x40,0x7F,0x7F,0x48, 0x08,0x0F,0x07,0x00,		//-p-
0xC0,0xE0,0x20,0x20, 0xC0,0xE0,0x20,0x00, 0x07,0x0F,0x08,0x48, 0x7F,0x7F,0x40,0x00,		//-q-	 		
0x20,0xE0,0xC0,0x60, 0x20,0xE0,0xC0,0x00, 0x08,0x0F,0x0F,0x08, 0x00,0x00,0x00,0x00,		//-r-
0x40,0xE0,0xA0,0x20, 0x20,0x60,0x40,0x00, 0x04,0x0C,0x09,0x09, 0x0B,0x0E,0x04,0x00,		//-s-
0x20,0x20,0xF8,0xFC, 0x20,0x20,0x00,0x00, 0x00,0x00,0x07,0x0F, 0x08,0x0C,0x04,0x00,		//-t-
0xE0,0xE0,0x00,0x00, 0xE0,0xE0,0x00,0x00, 0x07,0x0F,0x08,0x08, 0x07,0x0F,0x08,0x00,		//-u-
0x00,0xE0,0xE0,0x00, 0x00,0xE0,0xE0,0x00, 0x00,0x03,0x07,0x0C, 0x0C,0x07,0x03,0x00,		//-v-
0xE0,0xE0,0x00,0x80, 0x00,0xE0,0xE0,0x00, 0x07,0x0F,0x0C,0x07, 0x0C,0x0F,0x07,0x00,		//-w-
0x20,0x60,0xC0,0x80, 0xC0,0x60,0x20,0x00, 0x08,0x0C,0x07,0x03, 0x07,0x0C,0x08,0x00,		//-x-
0xE0,0xE0,0x00,0x00, 0x00,0xE0,0xE0,0x00, 0x47,0x4F,0x48,0x48, 0x68,0x3F,0x1F,0x00,		//-y-

0x60,0x60,0x20,0xA0, 0xE0,0x60,0x20,0x00, 0x0C,0x0E,0x0B,0x09, 0x08,0x0C,0x0C,0x00,		//-z-			//
0x00,0x40,0x40,0xF8, 0xBC,0x04,0x04,0x00, 0x00,0x00,0x00,0x07, 0x0F,0x08,0x08,0x00,		//-{-			
0x00,0x00,0x00,0xBC, 0xBC,0x00,0x00,0x00, 0x00,0x00,0x00,0x0F, 0x0F,0x00,0x00,0x00,		//-|-
0x00,0x04,0x04,0xBC, 0xF8,0x40,0x40,0x00, 0x00,0x08,0x08,0x0F, 0x07,0x00,0x00,0x00,		//-}-
0x08,0x0C,0x04,0x0C, 0x08,0x0C,0x04,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,		//-~-		   ASCII룺0X7E

};

unsigned char code Chinese_text_16x16[] = 
{
    "״̬ʹùʱӱ⿪ؼ˵ѽԼ˳ˢ"
	  "ڿѱ׼ֵѹ"
};

//ֵȡģ룬ÿ16x16λɣһλӦһ󣬹Ӧ16x16󣬻㣺16x16=256bits=32bytes

unsigned char code Chinese_code_16x16[] = 
{
//uchar code zhuang1[]={
/*--  :  ״  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x08,0x30,0x00,0xFF,0x20,0x20,0x20,0x20,0xFF,0x20,0xE1,0x26,0x2C,0x20,0x20,0x00,
0x04,0x02,0x01,0xFF,0x40,0x20,0x18,0x07,0x00,0x00,0x03,0x0C,0x30,0x60,0x20,0x00,
//};

//uchar code tai1[]={
//*--  :  ̬  --*/
//*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x04,0x04,0x04,0x84,0x44,0x34,0x4F,0x94,0x24,0x44,0x84,0x84,0x04,0x00,0x00,
0x00,0x60,0x39,0x01,0x00,0x3C,0x40,0x42,0x4C,0x40,0x40,0x70,0x04,0x09,0x31,0x00,
//};

//uchar code shi1[]={
/*--  :  ʹ  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x20,0xF0,0x1C,0x07,0xF2,0x94,0x94,0x94,0xFF,0x94,0x94,0x94,0xF4,0x04,0x00,
0x00,0x00,0x7F,0x00,0x40,0x41,0x22,0x14,0x0C,0x13,0x10,0x30,0x20,0x61,0x20,0x00,
//};

//uchar code yong1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x00,0xFE,0x22,0x22,0x22,0x22,0xFE,0x22,0x22,0x22,0x22,0xFE,0x00,0x00,
0x80,0x40,0x30,0x0F,0x02,0x02,0x02,0x02,0xFF,0x02,0x02,0x42,0x82,0x7F,0x00,0x00,
//};

//uchar code gong2[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x04,0x04,0x04,0xFC,0x04,0x14,0x14,0x10,0x90,0x7F,0x10,0x10,0xF0,0x00,0x00,
0x04,0x0C,0x04,0x04,0x03,0x42,0x22,0x11,0x0C,0x23,0x20,0x60,0x20,0x1F,0x00,0x00,	
//};

//uchar code neng1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x10,0xB8,0x97,0x92,0x90,0x94,0xB8,0x10,0x00,0x7F,0x48,0x48,0x44,0x74,0x20,0x00,
0x00,0xFF,0x0A,0x0A,0x4A,0x8A,0x7F,0x00,0x00,0x3F,0x44,0x44,0x42,0x72,0x20,0x00,	
//};

//uchar code she1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x41,0xCE,0x04,0x00,0x80,0x40,0xBE,0x82,0x82,0x82,0xBE,0xC0,0x40,0x40,0x00,
0x00,0x00,0x7F,0x20,0x90,0x80,0x40,0x43,0x2C,0x10,0x10,0x2C,0x43,0xC0,0x40,0x00,	
//};

//uchar code zhi1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x20,0x2F,0xA9,0xA9,0xAF,0xE9,0xB9,0xA9,0xAF,0xA9,0xA9,0x2F,0x20,0x00,0x00,
0x80,0x80,0x80,0xFF,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xFF,0x80,0x80,0x80,0x00,	
//};

//uchar code shi2[]={
/*--  :  ʱ  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0xFC,0x44,0x44,0x44,0xFC,0x10,0x90,0x10,0x10,0x10,0xFF,0x10,0x10,0x10,0x00,
0x00,0x07,0x04,0x04,0x04,0x07,0x00,0x00,0x03,0x40,0x80,0x7F,0x00,0x00,0x00,0x00,	
//};

//uchar code jian1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0xF8,0x01,0x06,0x00,0xF0,0x92,0x92,0x92,0x92,0xF2,0x02,0x02,0xFE,0x00,0x00,
0x00,0xFF,0x00,0x00,0x00,0x07,0x04,0x04,0x04,0x04,0x07,0x40,0x80,0x7F,0x00,0x00,	
//};

//uchar code ri1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x00,0xFE,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0xFE,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x3F,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x3F,0x00,0x00,0x00,0x00,	
//};

//uchar code qi1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x04,0xFF,0x54,0x54,0x54,0xFF,0x04,0x00,0xFE,0x22,0x22,0x22,0xFE,0x00,0x00,
0x42,0x22,0x1B,0x02,0x02,0x0A,0x33,0x62,0x18,0x07,0x02,0x22,0x42,0x3F,0x00,0x00,	
//};

//uchar code nao1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0xF9,0x12,0x90,0x92,0x96,0xFA,0x92,0x92,0x92,0x12,0x02,0xFE,0x00,0x00,
0x00,0x00,0xFF,0x00,0x1F,0x00,0x00,0x7F,0x00,0x08,0x1F,0x40,0x80,0x7F,0x00,0x00,	
//};

//uchar code zhong1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x30,0x2C,0xEB,0x28,0x28,0x00,0xF8,0x08,0x08,0xFF,0x08,0x08,0xF8,0x00,0x00,
0x01,0x01,0x01,0xFF,0x41,0x21,0x00,0x01,0x01,0x01,0xFF,0x01,0x01,0x01,0x00,0x00,	
//};

//uchar code bei1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x20,0x64,0x24,0x94,0x94,0xBF,0x80,0x80,0x9F,0xA4,0xA4,0xA2,0x22,0x38,0x00,0x00,
0x00,0x00,0x00,0xFF,0x12,0x12,0x12,0x12,0x12,0x52,0x92,0x7F,0x00,0x00,0x00,0x00,	
//};

//uchar code guang1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x40,0x42,0x44,0x5C,0xC8,0x40,0x7F,0x40,0xC0,0x50,0x4E,0x44,0x60,0x40,0x00,
0x00,0x80,0x40,0x20,0x18,0x07,0x00,0x00,0x00,0x3F,0x40,0x40,0x40,0x40,0x78,0x00,	
//};

//uchar code kai1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x42,0x42,0x42,0x42,0xFE,0x42,0x42,0x42,0x42,0xFE,0x42,0x42,0x42,0x42,0x00,
0x00,0x40,0x20,0x10,0x0C,0x03,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,	
//};

//uchar code guan1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x10,0x10,0x10,0x11,0x1E,0x14,0xF0,0x10,0x18,0x17,0x12,0x18,0x10,0x00,0x00,
0x01,0x81,0x41,0x21,0x11,0x09,0x05,0x03,0x05,0x09,0x31,0x61,0xC1,0x41,0x01,0x00,	
//};

// uchar code jian1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x30,0xEF,0x28,0x28,0x44,0x64,0xDC,0x10,0x54,0xFF,0x54,0x54,0x7C,0x10,0x00,
0x01,0x01,0x7F,0x21,0x51,0x22,0x14,0x0F,0x14,0x25,0x3F,0x45,0x45,0x45,0x44,0x00,	
//};

//uchar code yin1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x40,0x44,0x44,0x4C,0x74,0x44,0x45,0x46,0x64,0x5C,0x44,0x44,0x44,0x40,0x00,
0x00,0x00,0x00,0xFF,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0xFF,0x00,0x00,0x00,0x00,	
//};

//uchar code sheng1[]={
/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x80,0x60,0x1E,0x10,0x10,0x10,0x10,0xFF,0x12,0x10,0x10,0x98,0x10,0x00,0x00,
0x01,0x40,0x40,0x41,0x41,0x41,0x41,0x41,0x7F,0x41,0x41,0x41,0x41,0x61,0x40,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x02,0x02,0x32,0x52,0x92,0x1F,0x32,0x52,0x12,0x1F,0x92,0x52,0x32,0x02,0x02,0x00,
0x00,0x42,0x42,0x22,0x12,0x0A,0x06,0xFF,0x06,0x0A,0x12,0x32,0x62,0x22,0x02,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0xF8,0x28,0x29,0x2E,0x2A,0xF8,0x28,0x2C,0x2B,0x2A,0xF8,0x00,0x00,0x00,
0x08,0x08,0x0B,0x09,0x09,0x09,0x09,0xFF,0x09,0x09,0x09,0x09,0x0B,0x08,0x08,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x08,0x08,0x88,0xFF,0x48,0x88,0x80,0xBE,0xAA,0xAA,0xAA,0xAA,0xBE,0x80,0x00,0x00,
0x02,0x41,0x80,0x7F,0x40,0x30,0x1E,0x20,0x20,0x7F,0x44,0x44,0x44,0x44,0x40,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0xF2,0x12,0xFE,0x12,0xFE,0x12,0xF2,0x00,0xBE,0x2A,0xEA,0x2A,0x2A,0x3E,0x00,0x00,
0x7F,0x26,0x25,0x24,0x25,0x25,0x3F,0x42,0x49,0x49,0x7F,0x49,0x49,0x49,0x40,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x00,0xFF,0x49,0x49,0x49,0xFF,0xC9,0x49,0x49,0x49,0xFF,0x00,0x00,0x00,
0x00,0x08,0x08,0x84,0x44,0x22,0x1D,0x00,0x00,0xFD,0x02,0x02,0x04,0x0C,0x04,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x02,0xF2,0x12,0x12,0xFA,0x96,0x92,0x92,0xF2,0x12,0x12,0x12,0xF2,0x02,0x00,
0x00,0x00,0x7F,0x20,0x20,0x3F,0x24,0x24,0x24,0x3F,0x20,0x20,0x20,0x7F,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x00,0xF8,0x48,0x48,0x4C,0x4B,0x4A,0x48,0x48,0x48,0xF8,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0xFF,0x00,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x08,0x88,0x68,0xFF,0x28,0x48,0x10,0x48,0x44,0x43,0x44,0x48,0x50,0x10,0x10,0x00,
0x02,0x01,0x00,0x7F,0x00,0x20,0x22,0x2C,0x21,0x2E,0x30,0x28,0x27,0x22,0x20,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x40,0xFC,0x44,0x44,0x44,0x46,0xFA,0x42,0x43,0x43,0x42,0x40,0x00,0x00,
0x00,0x20,0x18,0x0C,0x07,0x12,0x20,0x40,0x3F,0x00,0x00,0x02,0x0C,0x38,0x10,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x41,0xC6,0x00,0x00,0xFE,0x4A,0x4A,0xCA,0x4A,0x4A,0x7E,0x80,0x00,0x00,0x00,
0x40,0x20,0x1F,0x20,0x40,0x5F,0x48,0x44,0x40,0x41,0x42,0x4D,0x58,0x40,0x40,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0xFC,0x40,0x40,0x40,0x40,0xFF,0x40,0x40,0x40,0x40,0x40,0xFC,0x00,0x00,
0x00,0x00,0x7E,0x20,0x20,0x20,0x20,0x3F,0x20,0x20,0x20,0x20,0x20,0x7E,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x42,0x4C,0xC4,0x00,0x22,0xAA,0xAA,0xAA,0xBF,0xAA,0xAA,0xAA,0x22,0x20,0x00,
0x00,0x00,0x00,0x7F,0x20,0x10,0xFF,0x0A,0x0A,0x0A,0x4A,0x8A,0x7F,0x00,0x00,0x00,

/*--  :  ˢ  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x80,0x7F,0x91,0x91,0x91,0xF1,0x91,0x9F,0x80,0x00,0xFC,0x00,0x00,0xFF,0x00,
0x20,0x1F,0x00,0x3F,0x00,0x00,0xFF,0x20,0x60,0x3F,0x00,0x0F,0x40,0x80,0x7F,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x40,0x40,0x40,0x40,0x40,0x40,0xFF,0x44,0x44,0x44,0x44,0x44,0x44,0x40,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x02,0x04,0x0C,0x38,0x10,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x02,0xF2,0x12,0x12,0x1E,0x00,0x80,0x80,0xFF,0xA0,0x90,0x88,0x86,0x84,0x80,0x00,
0x01,0x03,0x41,0x81,0x7F,0x00,0x00,0x40,0xFF,0x40,0x23,0x0C,0x10,0x60,0x20,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x04,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x04,0x00,0x00,
0x00,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x00,0x00,0x00,0xFF,0x11,0x11,0x11,0x11,0x11,0xFF,0x00,0x00,0x00,0x00,
0x00,0x40,0x20,0x10,0x0C,0x03,0x01,0x01,0x01,0x21,0x41,0x3F,0x00,0x00,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x00,0xFE,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0xFE,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x3F,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x3F,0x00,0x00,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x00,0xBE,0x2A,0x2A,0x2A,0xEA,0x2A,0x2A,0x2A,0x2A,0x3E,0x00,0x00,0x00,
0x00,0x48,0x46,0x41,0x49,0x49,0x49,0x7F,0x49,0x49,0x49,0x49,0x49,0x41,0x40,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x04,0xFF,0x54,0x54,0x54,0xFF,0x04,0x00,0xFE,0x22,0x22,0x22,0xFE,0x00,0x00,
0x42,0x22,0x1B,0x02,0x02,0x0A,0x33,0x62,0x18,0x07,0x02,0x22,0x42,0x3F,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x42,0x42,0x42,0x42,0xFE,0x42,0x42,0x42,0x42,0xFE,0x42,0x42,0x42,0x42,0x00,
0x00,0x40,0x20,0x10,0x0C,0x03,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x10,0x10,0x10,0x11,0x1E,0x14,0xF0,0x10,0x18,0x17,0x12,0x18,0x10,0x00,0x00,
0x01,0x81,0x41,0x21,0x11,0x09,0x05,0x03,0x05,0x09,0x31,0x61,0xC1,0x41,0x01,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0xF8,0x01,0x06,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0xFE,0x00,0x00,
0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x80,0x7F,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0xE2,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x7E,0x00,0x00,0x00,0x00,
0x00,0x00,0x3F,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3C,0x10,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x10,0x10,0xD0,0xFF,0x50,0x90,0x20,0x22,0x22,0x22,0xE2,0x22,0x22,0x22,0x20,0x00,
0x04,0x03,0x00,0xFF,0x00,0x09,0x04,0x03,0x40,0x80,0x7F,0x00,0x01,0x06,0x1C,0x00,

/*--  :  ׼  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x02,0x1C,0xC8,0x20,0x10,0xFF,0x4A,0x48,0x49,0xFE,0x48,0x68,0x4C,0x08,0x00,
0x02,0x02,0x7E,0x01,0x00,0x00,0x7F,0x22,0x22,0x22,0x3F,0x22,0x23,0x32,0x20,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x10,0x60,0x01,0x86,0x60,0x04,0x1C,0xE4,0x04,0x04,0x04,0xE4,0x1C,0x04,0x00,0x00,
0x04,0x04,0x7E,0x01,0x40,0x20,0x20,0x10,0x0B,0x04,0x0B,0x10,0x30,0x60,0x20,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x10,0x0C,0x24,0x24,0x24,0x25,0x26,0xA4,0x64,0x24,0x04,0x14,0x0C,0x00,0x00,
0x00,0x02,0x02,0x02,0x02,0x42,0x82,0x7F,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0xF8,0x88,0x88,0x88,0x88,0xFF,0x88,0x88,0x88,0x88,0xF8,0x00,0x00,0x00,
0x00,0x00,0x1F,0x08,0x08,0x08,0x08,0x7F,0x88,0x88,0x88,0x88,0x9F,0x80,0xF0,0x00,

/*--  :  ѹ  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0xFE,0x02,0x82,0x82,0x82,0x82,0xFA,0x82,0x82,0x82,0x82,0x82,0x02,0x00,
0x80,0x60,0x1F,0x40,0x40,0x40,0x40,0x40,0x7F,0x40,0x40,0x44,0x58,0x40,0x40,0x00,
};



//ȡģֽڲ
//ַԭ,ÿֵĹ룬ÿֵĹ2ֽڡ
unsigned char code Chinese_horizontal_text_16x16[] = 
{
    "״̬ʹùʱӱ⿪ؼ˵ѽԼ˳"
	  
};

//ֵȡģ룬ÿ16x16λɣһλӦһ󣬹Ӧ16x16󣬻㣺16x16=256bits=32bytes
unsigned char code Chinese_horizontal_code_16x16[] = 
{
/*--  :  ״  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x10,0xA0,0x10,0x90,0x10,0x98,0x90,0x88,0x50,0x80,0x5F,0xFE,0x10,0xA0,0x10,0xA0,
0x31,0x20,0x51,0x20,0x91,0x10,0x12,0x10,0x12,0x08,0x14,0x0E,0x18,0x04,0x10,0x00,

/*--  :  ̬  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x01,0x00,0x01,0x00,0x7F,0xFC,0x01,0x00,0x02,0x80,0x02,0x40,0x05,0x20,0x08,0x98,
0x30,0x06,0x01,0x00,0x04,0x88,0x24,0x84,0x24,0x12,0x64,0x12,0x43,0xF0,0x00,0x00,

/*--  :  ʹ  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x08,0x40,0x0C,0x40,0x1B,0xFE,0x10,0x40,0x37,0xFC,0x64,0x44,0xA4,0x44,0x27,0xFC,
0x24,0x44,0x22,0x40,0x21,0x80,0x20,0x80,0x21,0x70,0x22,0x1E,0x2C,0x04,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x1F,0xFC,0x10,0x84,0x10,0x84,0x10,0x84,0x1F,0xFC,0x10,0x84,0x10,0x84,
0x10,0x84,0x1F,0xFC,0x10,0x84,0x10,0x84,0x20,0x84,0x20,0x84,0x40,0x94,0x80,0x88,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x20,0x00,0x20,0x7F,0x20,0x08,0x20,0x0B,0xFC,0x08,0x24,0x08,0x24,0x08,0x44,
0x09,0x44,0x0E,0x44,0xF0,0x84,0x40,0x84,0x01,0x04,0x02,0x78,0x04,0x10,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x20,0x40,0x30,0x40,0x24,0x4C,0x42,0x70,0xFF,0x44,0x42,0x46,0x00,0x7C,0x7E,0x00,
0x42,0x40,0x7E,0x4C,0x42,0x70,0x7E,0x40,0x42,0x44,0x42,0x46,0x4A,0x3C,0x44,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x00,0x21,0xF0,0x31,0x10,0x21,0x10,0x01,0x10,0x01,0x10,0xE2,0x0E,0x25,0xF8,
0x21,0x08,0x21,0x08,0x20,0x90,0x20,0x90,0x28,0x60,0x30,0x90,0x23,0x0E,0x0C,0x04,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x3F,0xF8,0x24,0x48,0x24,0x48,0x3F,0xF8,0x01,0x00,0x7F,0xFC,0x02,0x00,0x1F,0xF0,
0x10,0x10,0x1F,0xF0,0x10,0x10,0x1F,0xF0,0x10,0x10,0x1F,0xF0,0x10,0x10,0xFF,0xFE,

/*--  :  ʱ  --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x10,0x00,0x10,0x7C,0x10,0x44,0x10,0x47,0xFE,0x44,0x10,0x7C,0x10,0x45,0x10,
0x44,0x90,0x44,0x90,0x7C,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x50,0x00,0x20,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x20,0x00,0x13,0xFC,0x10,0x04,0x40,0x04,0x47,0xE4,0x44,0x24,0x44,0x24,0x47,0xE4,
0x44,0x24,0x44,0x24,0x47,0xE4,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x14,0x40,0x08,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x1F,0xF0,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1F,0xF0,0x10,0x10,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1F,0xF0,0x10,0x10,0x00,0x00,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x22,0x00,0x22,0x7C,0x7F,0x44,0x22,0x44,0x3E,0x44,0x22,0x7C,0x3E,0x44,0x22,0x44,
0x22,0x44,0xFF,0x7C,0x00,0x44,0x24,0x84,0x22,0x84,0x43,0x14,0x81,0x08,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x20,0x00,0x17,0xFC,0x02,0x04,0x21,0x04,0x3F,0xF4,0x21,0x04,0x21,0x04,0x2F,0xE4,
0x29,0x24,0x29,0x24,0x29,0x24,0x29,0x64,0x29,0x24,0x21,0x04,0x21,0x14,0x20,0x08,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x10,0x20,0x10,0x20,0x20,0x20,0x3D,0xFC,0x41,0x24,0x7D,0x24,0x91,0x24,0x11,0x24,
0xFD,0xFC,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x14,0x20,0x18,0x20,0x10,0x20,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x04,0x80,0x04,0x98,0x7C,0xE0,0x04,0x84,0x1C,0x84,0xE4,0x7C,0x40,0x00,0x1F,0xF0,
0x10,0x10,0x1F,0xF0,0x10,0x10,0x10,0x10,0x1F,0xF0,0x10,0x10,0x10,0x50,0x10,0x20,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x01,0x00,0x21,0x10,0x19,0x18,0x0D,0x10,0x09,0x20,0x01,0x04,0x7F,0xFE,0x04,0x40,
0x04,0x40,0x04,0x40,0x04,0x40,0x08,0x42,0x08,0x42,0x10,0x42,0x20,0x3E,0x40,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x7F,0xFE,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0xFF,0xFE,0x04,0x20,
0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x20,0x10,0x20,0x20,0x20,0x40,0x20,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x08,0x20,0x04,0x30,0x06,0x20,0x04,0x48,0x7F,0xFC,0x01,0x00,0x01,0x00,0x01,0x00,
0xFF,0xFE,0x01,0x00,0x02,0x80,0x04,0x40,0x08,0x20,0x10,0x30,0x20,0x1C,0x40,0x08,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x20,0x20,0x20,0x20,0x27,0x7C,0x39,0x24,0x41,0xFE,0x7A,0x24,0xA7,0x7C,0x21,0x20,
0xF9,0x7C,0x25,0x20,0x23,0xFE,0x21,0x20,0x2A,0xA0,0x34,0x60,0x28,0x1E,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x01,0x00,0x00,0x80,0x3F,0xFC,0x08,0x20,0x04,0x20,0x04,0x40,0xFF,0xFE,0x00,0x00,
0x1F,0xF0,0x10,0x10,0x10,0x10,0x1F,0xF0,0x10,0x10,0x10,0x10,0x1F,0xF0,0x10,0x10,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x80,0x10,0xC0,0x10,0x80,0x10,0x88,0x1F,0xFC,0x20,0x80,0x20,0x80,0x40,0x88,
0x9F,0xFC,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x84,0x7F,0xFE,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x04,0x40,0xFF,0xFE,0x04,0x40,0x04,0x40,0x3F,0xF8,0x22,0x08,0x11,0x10,0x08,0x20,
0x01,0x00,0x7F,0xFE,0x03,0x80,0x05,0x40,0x09,0x30,0x11,0x1C,0x61,0x08,0x01,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x08,0x20,0x06,0x30,0x04,0x40,0x3F,0xF8,0x21,0x08,0x3F,0xF8,0x21,0x08,0x21,0x08,
0x3F,0xF8,0x21,0x08,0x01,0x00,0xFF,0xFE,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x10,0x00,0x11,0xF8,0x11,0x08,0xFD,0xF8,0x11,0x08,0x11,0xF8,0x18,0x00,0x37,0xFC,
0x50,0x40,0x92,0x40,0x12,0x7C,0x12,0x40,0x16,0x40,0x15,0xC0,0x58,0x7E,0x20,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0xFE,0xFC,0x28,0x84,0x28,0xFC,0xFE,0x84,0xAA,0xFC,0xAA,0x20,0xAA,0xA0,
0xAE,0xFC,0xC3,0x20,0xFE,0x20,0x82,0xFC,0x82,0x20,0xFE,0x20,0x81,0xFE,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x1F,0xF8,0x11,0x08,0x11,0x08,0x1F,0xF8,0x11,0x08,0x11,0x08,0x1F,0xF8,0x11,0x88,
0x02,0x40,0x04,0x30,0x1A,0x4E,0x62,0x44,0x02,0x40,0x04,0x40,0x08,0x40,0x10,0x40,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x00,0x7F,0xFE,0x02,0x00,0x04,0x00,0x3F,0xFC,0x24,0x44,0x24,0x44,0x27,0xC4,
0x24,0x44,0x24,0x44,0x27,0xC4,0x24,0x44,0x24,0x44,0x3F,0xFC,0x20,0x04,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x01,0x00,0x01,0x80,0x02,0x00,0x1F,0xF8,0x10,0x08,0x10,0x08,0x1F,0xF8,0x10,0x08,
0x10,0x08,0x10,0x08,0x1F,0xF8,0x10,0x08,0x10,0x08,0x10,0x08,0x1F,0xF8,0x10,0x08,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x10,0x40,0x10,0x40,0x10,0xA0,0xFD,0x10,0x12,0x0E,0x38,0x00,0x35,0xF8,0x50,0x00,
0x50,0x88,0x92,0x4C,0x11,0x48,0x11,0x50,0x10,0x20,0x17,0xFE,0x10,0x00,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x00,0x30,0x01,0xF8,0x1F,0x00,0x10,0x80,0x10,0x80,0x10,0x80,0x3F,0xFC,0x10,0x80,
0x08,0x80,0x0C,0x90,0x18,0x88,0x30,0x8C,0x24,0x86,0x42,0x84,0x01,0x00,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x40,0x00,0x27,0xF0,0x24,0x10,0x07,0xF0,0x04,0x10,0x04,0x10,0xE7,0xF0,0x24,0x88,
0x24,0x50,0x24,0x20,0x25,0x10,0x26,0x18,0x24,0x08,0x50,0x00,0x8F,0xFE,0x00,0x00,

/*--  :    --*/
/*--  12;  ¶ӦĵΪx=16x16   --*/
0x01,0x00,0x01,0x00,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x3F,0xFC,0x21,0x04,
0x01,0x00,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x3F,0xFC,0x20,0x04,0x00,0x00,

};	
