/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
****************************************************/

#include "ER-EPD075-3.h"
#include "Debug.h"

/******************************************************************************
function :	Software reset
parameter:
******************************************************************************/
static void EPD_075_3_Reset(void)
{
    DEV_Digital_Write(EPD_RST_PIN, 1);
    DEV_Delay_ms(200);
    DEV_Digital_Write(EPD_RST_PIN, 0);
    DEV_Delay_ms(10);
    DEV_Digital_Write(EPD_RST_PIN, 1);
    DEV_Delay_ms(200);
}

/******************************************************************************
function :	send command
parameter:
     Reg : Command register
******************************************************************************/
static void EPD_075_3_SendCommand(UBYTE Reg)
{
    DEV_Digital_Write(EPD_DC_PIN, 0);
    DEV_Digital_Write(EPD_CS_PIN, 0);
    DEV_SPI_WriteByte(Reg);
    DEV_Digital_Write(EPD_CS_PIN, 1);
}

/******************************************************************************
function :	send data
parameter:
    Data : Write data
******************************************************************************/
static void EPD_075_3_SendData(UBYTE Data)
{ 
    DEV_Digital_Write(EPD_CS_PIN, 0);
    DEV_Digital_Write(EPD_DC_PIN, 1);
    DEV_SPI_WriteByte(Data);
    DEV_Digital_Write(EPD_CS_PIN, 1);
}

/******************************************************************************
function :	Wait until the busy_pin goes LOW
parameter:
******************************************************************************/
void EPD_075_3_WaitUntilIdle(void)
{
    Debug("e-Paper busy\r\n");
    while(DEV_Digital_Read(EPD_BUSY_PIN)==0){
        DEV_Delay_ms(10);
    }
    DEV_Delay_ms(200);      
    Debug("e-Paper busy release\r\n");
}

/******************************************************************************
function :	Turn On Display
parameter:
******************************************************************************/
static void EPD_075_3_TurnOnDisplay(void)
{
  

    EPD_075_3_SendCommand(0x12);
    DEV_Delay_ms(100);        
    EPD_075_3_WaitUntilIdle();       //waiting for the electronic paper IC to release the idle signal

}

/******************************************************************************
function :	Initialize the e-Paper register
parameter:
******************************************************************************/
UBYTE EPD_075_3_Init(void)
{
    EPD_075_3_Reset();

   
    EPD_075_3_SendCommand(0x01);			//POWER SETTING
    EPD_075_3_SendData(0x07);
    EPD_075_3_SendData(0x07);    //VGH=20V,VGL=-20V
    EPD_075_3_SendData(0x3f);		//VDH=15V
    EPD_075_3_SendData(0x3f);		//VDL=-15V

    EPD_075_3_SendCommand(0x04); //POWER ON
    DEV_Delay_ms(100);
    EPD_075_3_WaitUntilIdle();

    EPD_075_3_SendCommand(0X00);			//PANNEL SETTING
    EPD_075_3_SendData(0x0F);   //KW-3f   KWR-2F	BWROTP 0f	BWOTP 1f

    EPD_075_3_SendCommand(0x61);        	//tres
    EPD_075_3_SendData(0x03);		//source 800
    EPD_075_3_SendData(0x20);
    EPD_075_3_SendData(0x01);		//gate 480
    EPD_075_3_SendData(0xE0);

    EPD_075_3_SendCommand(0X15);
    EPD_075_3_SendData(0x00);

    EPD_075_3_SendCommand(0X50);			//VCOM AND DATA INTERVAL SETTING
    EPD_075_3_SendData(0x11);
    EPD_075_3_SendData(0x07);

    EPD_075_3_SendCommand(0X60);			//TCON SETTING
    EPD_075_3_SendData(0x22);

    return 0;
}

/******************************************************************************
function :	Clear screen
parameter:
******************************************************************************/
void EPD_075_3_Clear(void)
{
 UWORD Width, Height;
    Width =(EPD_075_3_WIDTH % 8 == 0)?(EPD_075_3_WIDTH / 8 ):(EPD_075_3_WIDTH / 8 + 1);
    Height = EPD_075_3_HEIGHT;

    UWORD i;
    EPD_075_3_SendCommand(0x10);
    for(i=0; i<Width*Height; i++) {
        EPD_075_3_SendData(0xff);

    }
    EPD_075_3_SendCommand(0x13);
    for(i=0; i<Width*Height; i++)	{
        EPD_075_3_SendData(0x00);

    }
    EPD_075_3_TurnOnDisplay();


}




/******************************************************************************
function :	Sends the image buffer in RAM to e-Paper and displays
parameter:
******************************************************************************/
void EPD_075_3_Display(const UBYTE *blackimage, const UBYTE *ryimage)
{
     UDOUBLE Width, Height,j,i;
    Width =(EPD_075_3_WIDTH % 8 == 0)?(EPD_075_3_WIDTH / 8 ):(EPD_075_3_WIDTH / 8 + 1);
    Height = EPD_075_3_HEIGHT;
  
 //send black data
    EPD_075_3_SendCommand(0x10);
    for ( j = 0; j < Height; j++) {
        for ( i = 0; i < Width; i++) {
            EPD_075_3_SendData(blackimage[i + j * Width]);
        }
    }
 

    //send red data
    EPD_075_3_SendCommand(0x13);
    for ( j = 0; j < Height; j++) {
        for ( i = 0; i < Width; i++) {
            EPD_075_3_SendData(~ryimage[i + j * Width]);
        }
    }

    EPD_075_3_TurnOnDisplay();
}



/******************************************************************************
function :	Enter sleep mode
parameter:
******************************************************************************/
void EPD_075_3_Sleep(void)
{
    EPD_075_3_SendCommand(0x02); // POWER OFF
    EPD_075_3_WaitUntilIdle();

    EPD_075_3_SendCommand(0x07);  	//deep sleep
    EPD_075_3_SendData(0xA5);

}
