/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
Examples for ER-EPD075-3R 
Display is Hardward SPI 4-Wire SPI Interface 
Tested and worked with: 
Works with Raspberry pi
****************************************************/
#include <stdlib.h>     //exit()
#include <signal.h>     //signal()
#include "ER-EPD075-3.h"
#include "DEV_Config.h"
#include "GUI_Paint.h"
#include "GUI_BMPfile.h"
#include "ImageData.h"
#include "Debug.h"
#include <time.h> 

void  Handler(int signo)
{
    //System Exit
    printf("\r\nHandler:exit\r\n");
    DEV_Module_Exit();

    exit(0);
}



int main(void)
{
    
    signal(SIGINT, Handler);


  printf("EPD_075_3_test Demo\r\n");
    if(DEV_Module_Init()!=0){
        return -1;
    }

    printf("e-Paper Init and Clear...\r\n");
    EPD_075_3_Init();

    struct timespec start={0,0}, finish={0,0}; 
    clock_gettime(CLOCK_REALTIME,&start);

    EPD_075_3_Clear();

    clock_gettime(CLOCK_REALTIME,&finish);
    printf("%ld S\r\n",finish.tv_sec-start.tv_sec);

    DEV_Delay_ms(500);

    //Create a new image cache named IMAGE_BW and fill it with white
    UBYTE *BlackImage, *RYImage;
    UWORD Imagesize = ((EPD_075_3_WIDTH % 8 == 0)? (EPD_075_3_WIDTH / 8 ): (EPD_075_3_WIDTH / 8 + 1)) * EPD_075_3_HEIGHT;
    if((BlackImage = (UBYTE *)malloc(Imagesize )) == NULL) {
        printf("Failed to apply for black memory...\r\n");
        return -1;
    }
    if((RYImage = (UBYTE *)malloc(Imagesize )) == NULL) {
        printf("Failed to apply for red memory...\r\n");
        return -1;
    }
    printf("NewImage:BlackImage and RYImage\r\n");
    Paint_NewImage(BlackImage, EPD_075_3_WIDTH, EPD_075_3_HEIGHT , 0, WHITE);
    Paint_NewImage(RYImage, EPD_075_3_WIDTH, EPD_075_3_HEIGHT , 0, WHITE);

    //Select Image
    Paint_SelectImage(BlackImage);
    Paint_Clear(WHITE);
    Paint_SelectImage(RYImage);
    Paint_Clear(WHITE);

#if 1   // show bmp

    printf("show red bmp------------------------\r\n");
    Paint_SelectImage(BlackImage);
    GUI_ReadBmp("./pic/075-3rb1.bmp", 0, 0);
    Paint_SelectImage(RYImage);
    GUI_ReadBmp("./pic/075-3rr1.bmp", 0, 0);
    EPD_075_3_Display(BlackImage, RYImage);
    DEV_Delay_ms(3000);


    printf("show red bmp------------------------\r\n");
    Paint_SelectImage(BlackImage);
    GUI_ReadBmp("./pic/075-3rb2.bmp", 0, 0);
    Paint_SelectImage(RYImage);
    GUI_ReadBmp("./pic/075-3rr2.bmp", 0, 0);
    EPD_075_3_Display(BlackImage, RYImage);
    DEV_Delay_ms(3000);


    Paint_SelectImage(BlackImage);
    Paint_Clear(WHITE);
    Paint_SelectImage(RYImage);
    Paint_Clear(WHITE);
    printf("show window BMP-----------------\r\n");
    Paint_SelectImage(BlackImage);
    GUI_ReadBmp("./pic/100x100.bmp", 50, 50);
    Paint_SelectImage(RYImage);
    Paint_Clear(WHITE);    
    EPD_075_3_Display(BlackImage, RYImage);
    DEV_Delay_ms(3000);


#endif    
    
#if 0   // show image for array    
    printf("show image for array\r\n");
    EPD_075_3_Display(gImage_075_3_b, gImage_075_3_ry);
    DEV_Delay_ms(3000);
#endif

#if 1   // Drawing on the image
    /*Horizontal screen*/
    //1.Draw black image
    Paint_NewImage(BlackImage, EPD_075_3_WIDTH, EPD_075_3_HEIGHT , 0, WHITE);
    Paint_Clear(WHITE);

   Paint_DrawPoint(25, 50, BLACK, DOT_PIXEL_1X1, DOT_STYLE_DFT);
    Paint_DrawPoint(25, 70, BLACK, DOT_PIXEL_2X2, DOT_STYLE_DFT);
    Paint_DrawPoint(25, 90, BLACK, DOT_PIXEL_3X3, DOT_STYLE_DFT);
    Paint_DrawPoint(25, 110, BLACK, DOT_PIXEL_4X4, DOT_STYLE_DFT);

    Paint_DrawLine(50, 50, 150, 150, BLACK, DOT_PIXEL_1X1, LINE_STYLE_SOLID);
    Paint_DrawLine(150, 50, 50, 150, BLACK, DOT_PIXEL_1X1, LINE_STYLE_SOLID);
    Paint_DrawLine(100, 200, 100, 300, BLACK, DOT_PIXEL_1X1, LINE_STYLE_DOTTED);
    Paint_DrawLine(50, 250, 150, 250, BLACK, DOT_PIXEL_1X1, LINE_STYLE_DOTTED);

    Paint_DrawString_EN(10, 345, "www.buydisplay.com", &Font24, BLACK, WHITE);
     
    //Draw red/yellow picture
    Paint_NewImage(RYImage, EPD_075_3_WIDTH, EPD_075_3_HEIGHT , 0, WHITE); 
    Paint_Clear(WHITE);
    
    Paint_DrawRectangle(50, 50, 150, 150, RED, DOT_PIXEL_1X1, DRAW_FILL_EMPTY);
    Paint_DrawRectangle(200, 50, 300, 150, RED, DOT_PIXEL_1X1, DRAW_FILL_FULL);

    Paint_DrawCircle(100, 250, 50, RED, DOT_PIXEL_1X1, DRAW_FILL_EMPTY);
    Paint_DrawCircle(250, 250, 50, RED, DOT_PIXEL_1X1, DRAW_FILL_FULL);


    Paint_DrawString_EN(10, 310, "hello! EPD", &Font24, WHITE, BLACK);
    Paint_DrawString_EN(10, 400, "123456789", &Font24, RED, WHITE);

  
  printf("EPD_Display\r\n");
    EPD_075_3_Display(BlackImage, RYImage);
    DEV_Delay_ms(3000);
#endif

    printf("Clear...\r\n");
    EPD_075_3_Clear();

    printf("Goto Sleep...\r\n");
    EPD_075_3_Sleep();
    free(BlackImage);
    free(RYImage);
    BlackImage = NULL;
    RYImage = NULL;

    DEV_Module_Exit();
    
    return 0;  
    
  
}
