/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
Examples for ER-OLEDM0.71-1
Display is Hardward SPI 4-Wire SPI Interface 
Tested and worked with: 
Works with Raspberry pi
****************************************************/

#include <bcm2835.h>
#include <stdio.h>
#include <time.h>
#include "ssd1306.h"

char value[10] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
int main(int argc, char **argv)
{
    time_t now;
    struct tm *timenow;
    if(!bcm2835_init())
    {
        return -1;
    }
    printf("OLED begin\r\n");
    SSD1306_begin();
    printf("OLED bitmap\r\n");
    SSD1306_bitmap(0, 0, PIC1, 48, 64);
    SSD1306_display();
    bcm2835_delay(3000);
    printf("OLED clear\r\n");
    SSD1306_clear();
    printf("OLED bitmap\r\n");
    SSD1306_bitmap(0, 0, PIC2, 48, 64);
    SSD1306_display();
    bcm2835_delay(3000);
    printf("OLED clear\r\n");
    SSD1306_clear();
    printf("OLED display time\r\n");
    while(1)
    {
       time(&now);
        timenow = localtime(&now);

       SSD1306_bitmap(0, 0, Signal816, 16, 8); 
        SSD1306_bitmap(20, 0, Bluetooth88, 8, 8); 
        SSD1306_bitmap(32, 0, Msg816, 16, 8); 

     
	if((timenow->tm_sec % 2)==0)
        SSD1306_string(0, 44, "buydispl", 12, 0); 
        else
        SSD1306_string(0, 44, "buydispl", 12, 1); 

        SSD1306_char(0, 20, value[timenow->tm_hour / 10], 12, 1);
        SSD1306_char(6, 20, value[timenow->tm_hour % 10], 12, 1);
        SSD1306_char(12, 20, ':' , 12, 1);
        SSD1306_char(18, 20, value[timenow->tm_min / 10], 12, 1);
        SSD1306_char(24, 20, value[timenow->tm_min % 10], 12, 1);
        SSD1306_char(30, 20, ':' , 12, 1);
        SSD1306_char(36, 20, value[timenow->tm_sec / 10], 12, 1);
        SSD1306_char(42, 20, value[timenow->tm_sec % 10], 12, 1);
        
        SSD1306_display();
    }
    bcm2835_spi_end();
    bcm2835_close();
    return 0;
}

