/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
Examples for ER-OLEDM1.04-1
Display is Hardward I2C 2-Wire I2C Interface 
Tested and worked with: 
Works with Raspberry pi
****************************************************/

#include <bcm2835.h>
#include <stdio.h>
#include <time.h>
#include "ssd1306.h"

char value[10] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
int main(int argc, char **argv)
{
    time_t now;
    struct tm *timenow;
    if(!bcm2835_init())
    {
        return -1;
    }
    printf("OLED begin\r\n");
    SSD1306_begin();
    printf("OLED bitmap\r\n");
    SSD1306_bitmap(0, 0, PIC1, 128, 32);
    SSD1306_display();
    bcm2835_delay(3000);

    I2C_Write_Byte(0xA7, 0X00);
    bcm2835_delay(3000);
    I2C_Write_Byte(0xA6, 0X00);


    printf("OLED clear\r\n");
    SSD1306_clear();
    printf("OLED bitmap\r\n");
    SSD1306_bitmap(0, 0, PIC2, 128, 32);
    SSD1306_display();
    bcm2835_delay(3000);

    I2C_Write_Byte(0xA7, 0X00);
    bcm2835_delay(3000);
    I2C_Write_Byte(0xA6, 0X00);

    printf("OLED clear\r\n");
    SSD1306_clear();
    printf("OLED display time\r\n");
    while(1)
    {
        time(&now);
        timenow = localtime(&now);

     /*   SSD1306_bitmap(0, 18, Signal816, 16, 8); 
        SSD1306_bitmap(24, 18, Bluetooth88, 8, 8); 
        SSD1306_bitmap(40, 18, Msg816, 16, 8); 
        SSD1306_bitmap(64, 18, GPRS88, 8, 8); 
        SSD1306_bitmap(90, 18, Alarm88, 8, 8); 
        SSD1306_bitmap(112, 18, Bat816, 16, 8); 
     */
	if((timenow->tm_sec % 2)==0)
        SSD1306_string(7, 20, "www.buydisplay.com", 12, 0); 
        else
        SSD1306_string(7, 20, "www.buydisplay.com", 12, 1); 

        SSD1306_char(0, 0, value[timenow->tm_hour / 10], 16, 1);
        SSD1306_char(16, 0, value[timenow->tm_hour % 10], 16, 1);
        SSD1306_char(32, 0, ':' , 16, 1);
        SSD1306_char(48, 0, value[timenow->tm_min / 10], 16, 1);
        SSD1306_char(64, 0, value[timenow->tm_min % 10], 16, 1);
        SSD1306_char(80, 0, ':' , 16, 1);
        SSD1306_char(96, 0, value[timenow->tm_sec / 10], 16, 1);
        SSD1306_char(112, 0, value[timenow->tm_sec % 10], 16, 1);

    
        SSD1306_display();


    }
    bcm2835_i2c_end();
    bcm2835_close();
    return 0;
}

