#ifndef _EPD_H_
#define _EPD_H_

#include "my_spi.h"


#define EPD_W 240
#define EPD_H 416
#define ALLSCREEN_BYTES ((EPD_W % 4) ? (EPD_W / 4 + 1) : (EPD_W / 4)) * EPD_H



#define BLACK 0x00
#define WHITE 0x01
#define YELLOW 0x02
#define RED 0x03



#define EPD_RES_GPIO_PIN 8
#define EPD_DC_GPIO_PIN 9
#define EPD_BUSY_GPIO_PIN 7



#define EPD_RES_Set() digitalWrite(EPD_RES_GPIO_PIN, HIGH)
#define EPD_RES_Clr() digitalWrite(EPD_RES_GPIO_PIN, LOW)

#define EPD_DC_Set() digitalWrite(EPD_DC_GPIO_PIN, HIGH)
#define EPD_DC_Clr() digitalWrite(EPD_DC_GPIO_PIN, LOW)

#define EPD_ReadBUSY digitalRead(EPD_BUSY_GPIO_PIN)



void EPD_WR_REG(uint8_t reg);
void EPD_WR_DATA8(uint8_t dat);
void EPD_READBUSY(void);
void EPD_HW_RESET(void);
void EPD_Sleep(void);
void EPD_Update(void);
void EPD_All_Fill(uint8_t color);
void EPD_DisplayImage(const uint8_t *ImageBW);
void EPD_DisplayImageFlash(const uint8_t *ImageBW);
void EPD_GPIOInit(void);
void EPD_Init(void);

#endif
