/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
****************************************************/
#include <SPI.h>
#include "er_oled.h"


void command(uint8_t cmd)
{
  digitalWrite(OLED_DC, LOW);
  digitalWrite(OLED_CS, LOW);
  SPI.transfer(cmd);
  digitalWrite(OLED_CS, HIGH);
}

void data(uint8_t dat)
{
  digitalWrite(OLED_DC, HIGH);
  digitalWrite(OLED_CS, LOW );
  SPI.transfer(dat);
  digitalWrite(OLED_CS, HIGH);
}


void er_oled_begin()
{
  pinMode(OLED_RST, OUTPUT);
  pinMode(OLED_DC, OUTPUT);
  pinMode(OLED_CS, OUTPUT);
  SPI.begin();
    
  SPI.setClockDivider(SPI_CLOCK_DIV128);
    
  digitalWrite(OLED_CS, LOW);
  digitalWrite(OLED_RST, HIGH);
  delay(10);
  digitalWrite(OLED_RST, LOW);
  delay(10);
  digitalWrite(OLED_RST, HIGH);
    
  command(0xae);//Set y Off
  command(0xD5);//Set Display Clock Divide Ratio/Oscillator Frequency
  command(0x11); 
  command(0xA8);//Set Multiplex Ratio 
  command(0x47); 
  command(0xA2);//Set Display Start Line
  command(0x00); 


  command(0xD3);//Set Display Offset
  command(0x74);
  command(0xa1);//Set COM Output Scan Direction
  command(0xC0); 
	
	
	
  command(0xDA);//SetSEGPinsHardwareConfiguration
  command(0x32);
	

  command(0x81);//Set Contrast Control
  command(0xdf);

  command(0xD9);//SSet Pre-Charge Priod
  command(0x72);
  command(0xDB);//Set VCOMH Deselect Level 
  command(0x20);
	
	
  command(0xAD);//Set Internal IREF Enable
  command(0x00);
  command(0xBC);
  command(0x1E); 
	
  command(0xA4);//Set Entire Display On/Off
  command(0xA6);
  command(0xaf);//Display on  
  
}


void OLED_ColorTurn(uint8_t i)
{
	if(i==0)
		{
		command(0xA6);
		}
	if(i==1)
		{
		command(0xA7);
		}
}

void er_oled_SetWindow(uint8_t Xstart, uint8_t Ystart, uint8_t Xend, uint8_t Yend)
{ 
  command(0x21);
  command(Xstart);
  command(Xend);
  command(0x22);
  command(Ystart);
  command(Yend);

}

void er_oled_clear(uint8_t a)
{int i,row;
  er_oled_SetWindow(0, 0, WIDTH-1, HEIGHT-1);
  for (row = 0; row < HEIGHT; row++) {              
        for(i = 0; i< WIDTH; i++ ) {
          data(a);// write data       
        }        
  }
}



void er_oled_bitmap(const uint8_t * pBuf)
{   uint8_t row,col; 
  er_oled_SetWindow(0, 0, WIDTH-1, HEIGHT-1);
  for (row = 0; row < HEIGHT; row++) {              
        for(col = 0;col<WIDTH; col++ ) {
        data(pgm_read_byte(pBuf));
        * pBuf++;
        }
  }    	
}

