/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
****************************************************/
  
#ifndef _er_oled_H_
#define _er_oled_H_

#include <avr/pgmspace.h>

#define OLED_X_MAXPIXEL 128  //OLED width maximum memory 
#define OLED_Y_MAXPIXEL  72 //OLED height maximum memory

#define WIDTH 128/2
#define HEIGHT 72

#define OLED_RST 8 
#define OLED_DC  9
#define OLED_CS 10


void er_oled_begin();
void command(uint8_t cmd);
void data(uint8_t dat);
void OLED_ColorTurn(uint8_t i);
void er_oled_SetWindow(uint8_t Xstart, uint8_t Ystart, uint8_t Xend, uint8_t Yend);
void er_oled_clear(uint8_t a);
void er_oled_char(uint8_t x, uint8_t y, const char  *acsii, uint8_t mode);
void er_oled_string(uint8_t x, uint8_t y, const char *pString,  uint8_t Mode);
void Data_processing(uint8_t temp);
void er_oled_bitmap(const uint8_t * pBuf);


const uint8_t PIC1[] PROGMEM =
{ /* 0X20,0X04,0X80,0X00,0X48,0X00, */
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,
0X00,0X00,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0XF0,0XFF,0XFF,0X00,0X00,0XF0,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0XFF,0XF0,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X00,
0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0X0F,0XF0,0XFF,0XFF,0X0F,0XFF,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0XFF,0X0F,0XF0,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0X0F,
0XF0,0XFF,0XFF,0X00,0XFF,0X0F,0XF0,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X0F,0XFF,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0XF0,0X00,0X00,0X00,0XF0,0X0F,0XF0,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,
0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,0XFF,0X0F,0XF0,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,
0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X0F,0X0F,0X00,0X00,
0X00,0XFF,0XFF,0X0F,0XF0,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,
0X00,0XFF,0X0F,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,
0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X0F,0X0F,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0XFF,0XFF,0X0F,
0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0X00,0XF0,0XFF,0XF0,0XFF,0XFF,0XFF,0X0F,0X00,0X00,
0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0XF0,0XFF,0XF0,0XFF,0XFF,
0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0X0F,0X00,0X00,
0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XF0,0XFF,0XFF,
0XFF,0XFF,0X0F,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0XF0,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0XF0,0XFF,0XFF,0XFF,0X00,0XF0,0XFF,0X00,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XF0,0XFF,0XFF,
0XFF,0XFF,0X0F,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XF0,0XFF,0XFF,0X00,0X00,0X00,
0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0XF0,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,0X0F,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0XF0,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X00,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XF0,0X0F,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0XF0,0XFF,0XFF,0X0F,0XF0,0X0F,0XF0,0X0F,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0XF0,0XFF,
0XFF,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X0F,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,
0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X0F,0X0F,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X0F,0XF0,0X00,0XFF,0X00,0XF0,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0XF0,0XFF,0XFF,
0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0XF0,
0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X0F,0X00,
0X00,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,0X0F,0X00,0X00,0X0F,0XF0,0XF0,0XF0,0X0F,0XF0,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0XF0,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0XF0,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0XFF,0X0F,0X00,
0X00,0XF0,0XFF,0XFF,0X00,0XFF,0XFF,0X00,0XFF,0XFF,0X00,0X00,0XF0,0X00,0X00,0XF0,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X0F,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,0XFF,0X00,
0X00,0X00,0X00,0XFF,0X00,0XFF,0XFF,0X00,0X0F,0XF0,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XF0,0X0F,0X00,0XFF,0XF0,0XFF,0XFF,0X0F,0XF0,
0XFF,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X0F,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0XF0,0X0F,0XF0,0X00,
0X00,0X00,0X00,0XFF,0X00,0XFF,0XFF,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,
0XFF,0X0F,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,
0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0XF0,0X0F,0X00,0X00,0XF0,0X0F,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0XF0,0X0F,0XF0,0X00,
0X00,0X00,0X00,0XFF,0X00,0XFF,0XFF,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0XFF,0XFF,
0XFF,0X00,0XFF,0XFF,0XFF,0X00,0XF0,0X0F,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XF0,
0X0F,0X00,0X00,0XFF,0X0F,0XF0,0XFF,0XFF,0X0F,0X00,0XF0,0X0F,0X00,0X00,0XF0,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0XF0,0X0F,0XF0,0X0F,
0X00,0X00,0X00,0XFF,0X00,0XFF,0XFF,0X0F,0X00,0XFF,0X00,0XFF,0X0F,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0X00,0XF0,0X00,0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0X0F,0XF0,
0X0F,0X00,0X00,0XFF,0XFF,0XF0,0XFF,0XFF,0X0F,0X00,0XF0,0X00,0X00,0X00,0XF0,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XF0,0X0F,0X00,0XFF,
0X00,0X00,0X00,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,0XFF,0X0F,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0X00,0XF0,0X00,0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0X00,0X0F,
0X00,0X00,0X00,0X0F,0XF0,0XF0,0XFF,0XFF,0XFF,0X00,0XF0,0X0F,0X00,0X00,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X0F,0X00,0X00,0XFF,
0X00,0X00,0X00,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XF0,0X00,0XF0,0X0F,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0X00,0XF0,0X0F,0X00,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0X0F,
0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0XF0,0X0F,0X00,0XF0,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0XF0,
0X00,0X00,0X00,0XFF,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,0XF0,0X0F,0XF0,0X0F,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0X00,0XF0,0X0F,0XF0,0XFF,0XFF,0XFF,0XFF,
0X0F,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0XF0,0X0F,0X00,0XF0,0X0F,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,
0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0X0F,0XFF,0X0F,0X00,0XFF,0XFF,0X0F,0XFF,
0X0F,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0XF0,0X0F,0X00,0XF0,0X0F,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0XF0,
0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0XF0,0X0F,0X00,0XF0,0X0F,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X0F,
0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X0F,
0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0XF0,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XF0,0X0F,
0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0XF0,0X0F,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X00,
0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XF0,0X0F,0X00,0XF0,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X0F,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,
0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XF0,
0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,
0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,
0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0XF0,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0X00,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0XF0,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XFF,0X00,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,
0X00,0X00,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0XF0,0XFF,0XFF,
0XFF,0XFF,0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0XFF,0XFF,0X00,
0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0XFF,0X0F,0X00,
0X00,0X00,0X00,0X00,0XFF,0X0F,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X0F,0X0F,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XFF,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X0F,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XF0,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XFF,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X0F,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X0F,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XF0,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,
0XFF,0X00,0XF0,0XFF,0XFF,0X00,0XFF,0X00,0XFF,0XF0,0X0F,0XFF,0X00,0XFF,0XFF,0X0F,
0XFF,0X00,0XFF,0X0F,0XF0,0XFF,0XFF,0X00,0XFF,0X00,0XFF,0X0F,0XF0,0X0F,0XFF,0X00,
0X00,0XF0,0XFF,0X00,0XF0,0XFF,0X0F,0XF0,0XFF,0X0F,0XFF,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XF0,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,
0XFF,0X00,0XF0,0X0F,0XF0,0X0F,0XFF,0X00,0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0XF0,0X0F,
0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0XF0,0X0F,0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0XFF,0X00,
0X00,0XFF,0XF0,0X0F,0XFF,0X00,0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XF0,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,
0XFF,0X00,0XF0,0X0F,0XF0,0X0F,0XFF,0X00,0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0XF0,0X0F,
0XFF,0XF0,0X0F,0X00,0XF0,0X0F,0XF0,0X0F,0XFF,0X00,0X00,0XFF,0XF0,0X0F,0XFF,0X00,
0X00,0XFF,0X00,0X00,0XFF,0X00,0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X0F,0X0F,0X0F,0XFF,0X0F,0X0F,0X0F,0XFF,0X0F,
0X0F,0X00,0XF0,0X0F,0XF0,0X0F,0XFF,0X00,0XFF,0X00,0X0F,0X0F,0XF0,0X0F,0XF0,0X0F,
0XFF,0XF0,0XFF,0XFF,0XF0,0X0F,0XF0,0X0F,0XFF,0X00,0XFF,0XFF,0X00,0X0F,0X0F,0X00,
0X00,0XFF,0X00,0X00,0XFF,0X00,0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,
0X0F,0X00,0XF0,0X0F,0XF0,0X0F,0XFF,0X00,0XFF,0X00,0X0F,0X0F,0XF0,0X0F,0XF0,0X0F,
0XFF,0X00,0X00,0XFF,0XF0,0X0F,0XF0,0X0F,0XFF,0XF0,0X0F,0XFF,0X00,0X0F,0X0F,0X00,
0X00,0XFF,0X00,0X00,0XFF,0X00,0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,
0X0F,0X00,0XF0,0X0F,0XF0,0X0F,0XFF,0X00,0XFF,0X00,0XFF,0X0F,0XF0,0X0F,0XF0,0X0F,
0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0XF0,0X0F,0XFF,0XF0,0X0F,0XFF,0X00,0XFF,0X0F,0X00,
0X00,0XFF,0XF0,0X0F,0XFF,0X00,0XFF,0XF0,0X0F,0XFF,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,0X0F,0XFF,
0X0F,0XFF,0XF0,0XFF,0XFF,0X00,0XF0,0XFF,0XFF,0X00,0XFF,0X0F,0X00,0XFF,0XFF,0X0F,
0XFF,0X00,0XFF,0X0F,0XF0,0XFF,0XFF,0X00,0XFF,0X00,0XFF,0XFF,0X00,0XFF,0X0F,0XF0,
0X0F,0XF0,0XFF,0X00,0XF0,0XFF,0X0F,0XF0,0X0F,0XFF,0XF0,0X0F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X0F,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
};

const uint8_t PIC2[] PROGMEM =
{
 /* 0X20,0X04,0X80,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0XEE,0XAB,0XCB,0XBB,0XBB,0XEB,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XEF,0XEE,0XDC,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XEF,0X9B,0XAA,0XA9,0XDC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XBA,0X9A,0X98,0X88,0X89,0X98,0XFD,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0XBC,
0XED,0XEF,0X9C,0X98,0X9A,0X79,0X97,0XBB,0XFD,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X8B,0X66,0X67,0X76,0X98,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X9A,0X88,0X99,0X68,0X55,0X77,0X65,0XD8,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0XDD,0XCD,0X7B,0X55,
0X95,0X79,0X45,0X44,0X67,0X55,0X86,0X99,0X8A,0XDA,0XFE,0XCF,0XDA,0XFF,0XFF,0XFF,
0XFF,0XAE,0X56,0X44,0X55,0X75,0X77,0XDA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XDF,0X88,0X99,0X99,0X58,0X45,0X63,0X56,0X86,0XFC,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X79,0X67,0X76,0X68,0X78,0X78,
0X85,0X58,0X44,0X43,0X45,0X54,0X75,0X89,0X88,0X99,0XB9,0X8A,0X76,0XEC,0XFF,0XFF,
0XDF,0X6A,0X54,0X44,0X55,0X65,0X87,0XA9,0XFD,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XBF,0X98,0XBB,0XA9,0X79,0X65,0X23,0X65,0X55,0XD7,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0XCD,0X9B,0X57,0X46,0X85,0X77,0X99,0XBB,
0X9B,0X79,0X56,0X55,0X44,0X44,0X54,0X66,0X88,0X76,0X78,0X88,0X66,0X86,0XDC,0XFE,
0X8D,0X46,0X54,0X34,0X54,0X76,0X98,0XA9,0XEC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X9B,0X98,0XBA,0X89,0XBA,0X69,0X36,0X62,0X46,0X75,
0XFC,0XFF,0XFF,0XFF,0XEF,0XDD,0XDD,0XBC,0XCC,0XCC,0XBE,0X79,0X86,0XB9,0XBA,0XCC,
0X8B,0X68,0X66,0X89,0X87,0X68,0X56,0X55,0X66,0X85,0X56,0XA9,0X97,0XC9,0XFF,0XCF,
0X58,0X44,0X55,0X45,0X54,0X87,0XA9,0XAA,0XCA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X8A,0X89,0X88,0XBA,0X89,0X68,0X77,0X23,0X67,0X44,
0XC6,0XFF,0XFF,0XBC,0X9B,0X77,0XA7,0XBB,0XDC,0XBB,0XCE,0X68,0X56,0XA7,0X87,0XB9,
0XCB,0X7A,0X87,0XAA,0XBC,0XBB,0X9B,0X77,0X77,0X76,0X76,0XCB,0XC9,0XFE,0XFF,0X8D,
0X56,0X64,0X66,0X45,0X34,0X64,0X97,0XBA,0XBA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XDF,0X78,0X88,0X97,0XAA,0XAA,0X89,0X76,0X47,0X62,0X45,
0X65,0XFC,0XCF,0XA9,0X9C,0X97,0X87,0XA9,0XB8,0X78,0XA9,0X9A,0X79,0X56,0X85,0XA7,
0XCB,0X57,0X75,0X78,0X9C,0XB9,0X78,0X98,0XA8,0X79,0XD9,0XCD,0XFD,0XFF,0XDF,0X69,
0X45,0X77,0X35,0X12,0X32,0X54,0X76,0XA8,0XAA,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X88,0XA9,0X9A,0XA9,0XCC,0XAB,0X68,0X87,0X26,0X55,
0X44,0XB4,0XCE,0XBB,0X4B,0XC7,0X89,0XCB,0XEC,0XAB,0XCB,0XAB,0X88,0X56,0XB7,0XBB,
0XAB,0X36,0X74,0X78,0X9A,0XA8,0X78,0XA9,0X97,0XAB,0XEB,0XDE,0XFE,0XFF,0X9D,0X67,
0X44,0X24,0X22,0X32,0X44,0X75,0X88,0X9A,0X99,0XFD,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XBF,0X97,0XA9,0X89,0X88,0XBA,0XBB,0XBB,0X99,0X7A,0X54,
0X44,0X43,0XCA,0XBC,0X3A,0XD6,0XBB,0XED,0XED,0XBE,0X8C,0X65,0X43,0X63,0XEC,0XCD,
0XCD,0X49,0X53,0X55,0XEA,0XCE,0XBD,0XCB,0XDB,0XDE,0XCC,0XEC,0XFF,0XEF,0X79,0X55,
0X55,0X44,0X55,0X44,0X65,0X87,0XAA,0XAA,0X99,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XBF,0X87,0XA9,0X99,0XCA,0XCD,0XBC,0XBC,0X9A,0XAA,0X68,
0X47,0X34,0X74,0XCB,0X47,0X76,0X99,0X88,0X77,0X5A,0X46,0X22,0X11,0X91,0XDE,0XFD,
0XEE,0X6B,0X23,0X23,0XE6,0XBE,0XBC,0XED,0XFF,0XFF,0X8D,0XE8,0XFF,0X9E,0X67,0X64,
0X89,0X46,0X33,0X64,0X98,0X78,0X88,0XA9,0X99,0XFB,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X78,0X98,0XA9,0XDC,0XCC,0XDD,0XDE,0X6B,0XA6,0X9A,
0X7A,0X45,0X34,0X75,0X24,0X14,0X32,0X12,0X12,0X24,0X33,0X32,0X43,0XD5,0X9D,0XEB,
0XDD,0X9C,0X25,0X22,0X82,0X69,0X65,0XCA,0XCC,0XDE,0X59,0XB5,0XEF,0X79,0X56,0X84,
0X36,0X22,0X53,0X87,0X99,0X99,0XA8,0X89,0X78,0XFA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X99,0X98,0XBA,0XBB,0XDB,0XEE,0XCE,0X58,0X23,0X86,
0XB9,0X46,0X25,0X22,0X11,0X12,0X10,0X01,0X00,0X22,0X96,0XB7,0XCB,0XFC,0XAD,0XEA,
0XAA,0XCB,0X6A,0X24,0X42,0X34,0X22,0X54,0X44,0X67,0X33,0X83,0X9C,0X56,0X46,0X65,
0X35,0X33,0X43,0XB7,0XDE,0X9C,0X98,0X78,0X77,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XDF,0X99,0X78,0XB9,0XAA,0XDD,0XDC,0X8B,0X45,0X34,0X74,
0XA8,0X37,0X24,0X23,0X11,0X11,0X11,0X01,0X30,0X78,0XFC,0XFF,0XEF,0XEE,0XBA,0XCA,
0X88,0XB8,0XCE,0X7A,0X45,0X56,0X23,0X21,0X23,0X12,0X22,0X42,0X75,0X55,0X45,0X77,
0X76,0X89,0XAA,0XBB,0XBB,0X9B,0X67,0X66,0X87,0XFD,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0X89,0X78,0X86,0XBA,0XED,0XCD,0X48,0X43,0X23,0X32,
0X86,0X36,0X23,0X33,0X23,0X22,0X32,0X23,0XA3,0XDF,0XED,0XFF,0XAA,0XCC,0XBA,0XB9,
0XB8,0X77,0X9C,0XDA,0X6C,0XA7,0X58,0X32,0X23,0X12,0X21,0X22,0X53,0X45,0X65,0X77,
0X56,0X56,0X76,0X67,0X87,0X78,0X55,0X86,0X86,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X8B,0X77,0X76,0XA8,0XCB,0X4A,0X54,0X45,0X44,0X43,
0X55,0X33,0X33,0X33,0X34,0X33,0X74,0X98,0XFB,0XCE,0XED,0XCF,0X75,0XBB,0X99,0XB8,
0XC9,0X5C,0X47,0XC3,0X9E,0X78,0XCC,0X68,0X45,0X34,0X33,0X32,0X43,0X43,0X44,0X55,
0X45,0X75,0X46,0X65,0X67,0X65,0X76,0X78,0XB8,0XFD,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X9E,0X77,0X65,0XA8,0XAB,0X44,0X45,0X22,0X34,0X54,
0X55,0X44,0X54,0X45,0X44,0X66,0XB8,0XFE,0XDF,0X9A,0XDB,0X5B,0X74,0X8C,0XC8,0XC9,
0XBB,0X6F,0X33,0X51,0X8B,0X37,0XFA,0XCE,0X79,0X77,0X46,0X44,0X44,0X33,0X32,0X44,
0X33,0X54,0X67,0X97,0X8A,0X67,0X77,0X77,0XDB,0XED,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X78,0X56,0X97,0X7A,0X96,0X68,0X45,0X53,0X89,
0X45,0X74,0X77,0X56,0X86,0XCA,0XED,0XFF,0X7B,0X44,0X86,0X57,0X87,0X88,0XDC,0X98,
0XB9,0X9F,0X32,0X22,0X33,0X34,0X85,0XFB,0XDE,0XAC,0X7A,0X66,0X44,0X34,0X22,0X43,
0X33,0X44,0X55,0X75,0X87,0X78,0X55,0XA6,0XCB,0XDC,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X8B,0X66,0X86,0X87,0XC9,0X9B,0X27,0X96,0X88,
0X45,0X84,0X99,0X68,0XB6,0XFE,0XFF,0XBF,0X45,0X32,0X34,0X52,0X55,0XC6,0XEF,0X58,
0XA8,0XDF,0X24,0X44,0X12,0X31,0X33,0XC5,0XFE,0XCF,0X8B,0X68,0X54,0X44,0X33,0X33,
0X23,0X22,0X44,0X34,0X65,0X66,0X76,0XC9,0XAA,0XEC,0XEE,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X99,0X88,0XC9,0XA9,0XCE,0X46,0X88,0X57,
0X54,0X75,0X98,0X99,0XD9,0XFF,0XFF,0X5D,0X23,0X32,0X12,0X42,0X86,0XEB,0XEE,0X47,
0X79,0XFD,0X39,0X94,0X38,0X32,0X33,0X52,0XEB,0XEF,0XAE,0X79,0X67,0X66,0X45,0X33,
0X22,0X22,0X22,0X22,0X32,0X75,0X89,0XAA,0X99,0XEC,0XED,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0XAC,0XCA,0XCB,0XCB,0XBD,0XA7,0X9A,0X58,
0X53,0X97,0X87,0XA8,0XED,0XFF,0XCF,0X38,0X23,0X32,0X33,0XA5,0XCC,0XDD,0XED,0X58,
0X69,0XFC,0X9E,0XB7,0XBE,0X89,0X13,0X22,0XB5,0XEE,0XDF,0X9B,0X88,0X88,0X56,0X44,
0X23,0X22,0X22,0X32,0X32,0X75,0X78,0XA9,0X99,0XDB,0XDD,0XFE,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCE,0XDD,0XBC,0XDC,0XCE,0XEB,0X8D,0X56,
0X54,0XA6,0X8A,0XAA,0XCA,0XCD,0X5B,0X23,0X22,0X42,0XB8,0XEC,0XDE,0XDD,0XFE,0X7B,
0X89,0XFD,0XEF,0XED,0XFF,0XEE,0X28,0X12,0X61,0XDB,0XFF,0X9E,0X99,0X99,0X78,0X45,
0X44,0X33,0X34,0X55,0X96,0XBA,0XAD,0X89,0X99,0XCB,0XDD,0XED,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFD,0XFF,0XBC,0XDB,0XDE,0XDD,0X9C,0X66,
0X76,0X87,0XBA,0XAB,0X98,0X99,0X29,0X22,0X32,0X96,0XFE,0XEF,0XEF,0XAC,0XED,0X9D,
0XA7,0XFE,0XFF,0XEE,0XFF,0XFF,0XAE,0X36,0X30,0XA7,0XDD,0X9C,0X99,0XB9,0X8A,0X45,
0X54,0X86,0X9A,0X89,0XDB,0XDE,0X9E,0X98,0XBA,0XBB,0XCC,0XDD,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XDF,0XFC,0XFF,0XAD,0XDB,0XDE,0XAE,0X88,0X67,
0X86,0X98,0XDA,0XAD,0X87,0X69,0X16,0X22,0X95,0XFC,0XFF,0XFE,0XBF,0X56,0XA7,0XBB,
0XB7,0XFE,0XFF,0X9D,0XFE,0XFF,0XFF,0X9D,0X45,0X43,0X96,0XA8,0XAA,0XC9,0X9C,0X56,
0X44,0XA6,0XCB,0XCC,0XEB,0XEF,0XAD,0X98,0XBA,0XCB,0XAB,0XCB,0XFE,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XBD,0XFC,0XFF,0XBD,0XCA,0XCD,0X8B,0X76,0X76,
0X87,0XA9,0XDD,0X8B,0X86,0X48,0X12,0X63,0XDC,0XFD,0XEF,0XCA,0X5D,0X42,0X53,0X96,
0X98,0XC8,0XDF,0X6B,0XBB,0XFC,0XFF,0XFF,0X7D,0X22,0X52,0X97,0XBA,0XDB,0XBC,0X8A,
0X55,0X76,0XD9,0XCE,0XBA,0XFF,0XAE,0X97,0XAA,0X9A,0XA9,0XDB,0XDD,0XFE,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XDF,0XBC,0XEC,0XEF,0XBB,0XBC,0XAA,0X58,0X54,0X87,
0XB9,0XDB,0XBE,0X67,0X76,0X25,0X21,0XB9,0XBB,0XC9,0XAD,0X77,0X27,0X23,0X33,0X94,
0X58,0X54,0X7A,0X47,0X68,0XD8,0XFE,0XFF,0XDF,0X49,0X32,0X44,0XD9,0XCD,0XCB,0X8B,
0X56,0X54,0XC8,0XCD,0X8A,0XFC,0XAE,0X87,0X99,0X98,0XCA,0XBC,0XDC,0XFD,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XBD,0XBB,0XDC,0XDF,0XAA,0X9B,0X77,0X57,0X55,0X97,
0XBA,0XED,0X8E,0X46,0X45,0X12,0X61,0XBC,0X46,0X54,0X57,0X43,0X33,0X33,0X33,0XA7,
0X48,0X33,0X44,0X33,0X44,0X74,0XA7,0XCA,0XFB,0XAE,0X03,0X21,0XD7,0XCD,0XBA,0XBB,
0X68,0X65,0XB7,0XCC,0X8B,0X77,0X9D,0X65,0X97,0X99,0XBB,0XBB,0XFD,0XEE,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XDE,0XCC,0XBC,0XCC,0XCC,0XBC,0X6A,0X44,0X66,0X88,0XAA,
0XBA,0XCC,0X6B,0X44,0X44,0X11,0X72,0X67,0X11,0X12,0X32,0X22,0X23,0X33,0X63,0XAD,
0X57,0X35,0X24,0X22,0X33,0X32,0X33,0X52,0X85,0XCA,0X05,0X10,0X85,0XCD,0XAA,0XAC,
0X68,0X45,0X75,0X87,0X8A,0X45,0XBA,0X77,0X99,0XA9,0XCA,0XBD,0XFD,0XEF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XEE,0XCD,0XCC,0XBC,0XDB,0X9B,0X9B,0X68,0X44,0X76,0XB9,0XDC,
0XAC,0X78,0X69,0X43,0X44,0X01,0X42,0X00,0X00,0X10,0X11,0X12,0X22,0X64,0XD9,0X7E,
0X85,0X7B,0X45,0X22,0X22,0X12,0X11,0X11,0X00,0X74,0X02,0X10,0X62,0X97,0XA8,0X99,
0X78,0X34,0X33,0X53,0XA7,0X78,0X9C,0X66,0X98,0XA9,0XCB,0XDC,0XDC,0XEF,0XFE,0XFF,
0XFF,0XFF,0XFF,0XEF,0XDD,0XCD,0XBC,0X9B,0XCA,0X9C,0X9A,0X67,0X55,0X86,0XCA,0XFD,
0XAE,0X66,0X89,0X33,0X22,0X01,0X21,0X01,0X00,0X00,0X11,0X12,0X32,0XC7,0XFF,0X5D,
0X84,0XEF,0X9C,0X33,0X11,0X01,0X10,0X22,0X00,0X10,0X00,0X00,0X21,0X63,0X76,0XB9,
0X8A,0X46,0X23,0X32,0X96,0X98,0X8C,0X77,0XA9,0XA9,0XCB,0XCC,0XAA,0XEE,0XFE,0XFF,
0XFF,0XFF,0XFF,0XDE,0XDE,0XCD,0XBB,0X9A,0XCA,0X9B,0X89,0X56,0X65,0XA9,0XCA,0XAC,
0X9B,0XA9,0X8B,0X24,0X11,0X01,0X41,0X78,0X23,0X12,0X01,0X11,0X93,0XFE,0XEF,0X5A,
0X74,0XFD,0XFF,0X6B,0X12,0X00,0X00,0X20,0X03,0X00,0X00,0X00,0X10,0X22,0X53,0XC8,
0XBD,0X79,0X34,0X32,0X97,0X97,0X9C,0X77,0X98,0XAA,0XBB,0XCB,0XAB,0XDC,0XFE,0XFF,
0XFF,0XFF,0XEF,0XDD,0XCD,0XBC,0X9A,0X99,0XA9,0X8C,0X99,0X56,0X85,0XBA,0X9B,0X78,
0XB8,0XDC,0X6C,0X23,0X11,0X11,0X81,0XEE,0X9A,0X69,0X12,0X10,0XE7,0XFF,0XAF,0X44,
0X34,0XE9,0XFF,0XAF,0X15,0X10,0X00,0X30,0X8B,0X05,0X00,0X00,0X10,0X21,0X43,0X96,
0XDD,0X9B,0X37,0X32,0X86,0X86,0X9C,0X89,0X76,0XAA,0X99,0XBA,0XAA,0XFC,0XEE,0XFF,
0XFF,0XFF,0XDE,0XCC,0XCC,0XBC,0X99,0X99,0X97,0X9A,0XA9,0X68,0X86,0X87,0X8A,0X76,
0XEB,0XEE,0X5D,0X22,0X01,0X11,0X91,0XFF,0X9D,0X78,0X13,0X30,0XFA,0XDD,0X5B,0X43,
0X45,0XC3,0XDD,0XAE,0X57,0X11,0X10,0XB7,0XFF,0X1C,0X00,0X00,0X00,0X62,0X56,0X84,
0XBA,0XBC,0X47,0X34,0X54,0X55,0XBA,0X8A,0X98,0X9A,0X88,0XA9,0XAA,0XDB,0XEF,0XFF,
0XFF,0XEF,0XDE,0XBC,0XCB,0XBC,0X69,0X66,0X65,0X77,0XA9,0XBB,0XAB,0X79,0X76,0XC9,
0XFE,0XEF,0X3B,0X21,0X00,0X00,0X82,0XBB,0XBD,0X49,0X01,0X40,0XBB,0X89,0X35,0X52,
0X56,0X54,0X7A,0X79,0X88,0X13,0X30,0XFE,0XFF,0X3F,0X00,0X21,0X01,0XC4,0XAD,0X56,
0X64,0X89,0X46,0X22,0X33,0X34,0X84,0X9A,0X88,0X99,0X99,0X99,0X89,0XB8,0XEE,0XFE,
0XFF,0XEF,0XDE,0XBB,0XAA,0X9A,0X68,0X34,0X54,0X98,0XCA,0XFE,0XBE,0X7A,0X56,0XE9,
0XFF,0XEF,0X28,0X22,0X01,0X00,0X64,0X22,0XEB,0X4B,0X00,0X81,0X7C,0X45,0X22,0X63,
0X56,0X47,0X43,0X57,0X89,0X02,0X30,0XFF,0XBD,0X5D,0X00,0X92,0X05,0XA2,0XDB,0X7C,
0X44,0X65,0X56,0X23,0X32,0X33,0X22,0X85,0X99,0X99,0XAA,0X99,0X89,0XA8,0XED,0XFD,
0XFF,0XEF,0XBD,0XAB,0X9A,0X78,0X56,0X44,0X76,0XB9,0XDD,0XEF,0XAE,0X47,0X63,0XEB,
0XFF,0XDE,0X39,0X77,0X56,0X33,0X14,0X00,0XEA,0X3A,0X00,0XF4,0X5E,0X44,0X31,0X87,
0X49,0X89,0X11,0X67,0XB7,0X02,0X40,0XFF,0X17,0X67,0X00,0XA2,0X2A,0X31,0XFA,0XBF,
0X25,0X44,0X76,0X68,0X56,0X24,0X11,0X52,0XA9,0XAA,0XAA,0X9A,0X89,0X97,0XDC,0XFD,
0XEF,0XDE,0XAB,0XBA,0XAB,0X67,0X66,0X76,0XB9,0XED,0XEF,0XCC,0X78,0X34,0X74,0XED,
0XFF,0X9E,0X87,0XCC,0XCC,0X99,0X06,0X10,0XEC,0X29,0X00,0XF9,0X4D,0X34,0X83,0XCA,
0X4A,0XD9,0X14,0X73,0XF9,0X08,0X40,0XBC,0X03,0X44,0X01,0X91,0X6B,0X21,0XEB,0XEF,
0X38,0X32,0X94,0XFE,0XDF,0X6B,0X12,0X21,0X74,0XA9,0XBA,0X8A,0X88,0X87,0XDA,0XFE,
0XEE,0XCD,0X9A,0X99,0X99,0X46,0X65,0X87,0XCA,0XEF,0XCD,0X77,0X37,0X22,0X73,0XDC,
0XEE,0X7D,0XC6,0XDE,0XDD,0XBB,0X4A,0X40,0XEC,0X15,0X30,0XFE,0X2A,0X22,0XD7,0XA9,
0X37,0XE8,0X49,0X32,0XFC,0X0D,0X10,0XC6,0X08,0X20,0X26,0XC4,0XAD,0X23,0XB8,0XEF,
0X3A,0X11,0X83,0XEB,0XFF,0XCF,0X47,0X12,0X52,0XC9,0XBB,0X9A,0X89,0X67,0XC8,0XFE,
0XDE,0XBC,0X8A,0X88,0X57,0X44,0X54,0X97,0XCB,0XED,0X8C,0X25,0X33,0X33,0X86,0XAA,
0XDA,0X8D,0X89,0XD8,0XCD,0XDD,0X5B,0X50,0X9D,0X12,0X60,0XFF,0X29,0X63,0X9A,0X75,
0X35,0XC5,0XAD,0X15,0XFA,0X2E,0X00,0XB8,0X2A,0X80,0XAC,0XEC,0X9D,0X12,0XD5,0XCE,
0X37,0X01,0X52,0XA7,0XED,0XED,0XAD,0X26,0X32,0X96,0XC9,0XAB,0X79,0X77,0X96,0XED,
0XDE,0XAB,0X68,0X56,0X34,0X33,0X53,0XA7,0XDB,0XCE,0X7A,0X44,0X33,0X84,0X69,0X54,
0XD9,0X8D,0X45,0XB3,0XEE,0XED,0X4D,0X80,0X5F,0X00,0XB1,0XCF,0X25,0XB6,0X48,0X53,
0X35,0XA2,0XDC,0X1D,0XF7,0X8F,0X00,0XA3,0X2C,0XE5,0XFF,0XFF,0X3D,0X00,0XD7,0X6B,
0X13,0X11,0X11,0X62,0X99,0XFD,0XCF,0X68,0X44,0X33,0X95,0XAB,0X79,0X77,0X97,0XDC,
0XCD,0X9B,0X68,0X34,0X33,0X64,0X87,0XCB,0XED,0XBF,0X56,0X33,0X63,0X86,0X36,0X43,
0XE9,0X6C,0X12,0X51,0XEC,0X9C,0X8C,0X80,0X6D,0X00,0XF4,0X6D,0X42,0X99,0X23,0X42,
0X34,0X62,0XCD,0X5E,0XC3,0XBF,0X00,0XA2,0X2C,0XF8,0XFF,0XFF,0X08,0X00,0XB4,0X18,
0X10,0X22,0X11,0X42,0XA6,0XED,0XEF,0XCE,0X47,0X12,0X43,0X97,0X89,0X77,0X77,0XDB,
0XBC,0X8A,0X67,0X34,0X43,0X86,0X99,0XDB,0XEE,0XAE,0X67,0X44,0X84,0X69,0X24,0X62,
0XFB,0X4C,0X41,0X38,0X53,0X98,0X66,0X92,0X2B,0X00,0XF7,0X39,0X74,0X59,0X22,0X54,
0X33,0X32,0XAA,0X7B,0X61,0XDF,0X02,0X81,0X48,0XEB,0XEF,0X5A,0X00,0X00,0XC6,0X29,
0X00,0X32,0X24,0X12,0X62,0XEA,0XFF,0XDF,0X68,0X34,0X22,0X53,0X98,0X78,0X77,0XCA,
0XBB,0X9B,0X46,0X23,0X43,0X76,0XB9,0XEC,0XCE,0X7A,0X44,0X54,0XB9,0X48,0X33,0X84,
0XFD,0X8D,0X33,0X78,0X12,0X52,0X45,0X84,0X09,0X10,0XDB,0X75,0X89,0X25,0X33,0X56,
0X24,0X21,0X45,0X94,0X54,0XDE,0X01,0X40,0X46,0X99,0X5A,0X00,0X22,0X00,0XB6,0X39,
0X00,0X41,0X67,0X24,0X63,0XCA,0XFD,0XFF,0X9C,0X46,0X34,0X53,0X86,0X78,0X77,0XB8,
0XBB,0XAA,0X47,0X33,0X33,0X86,0XB9,0XEC,0XCE,0X68,0X34,0X64,0XBA,0X47,0X33,0XA6,
0XFE,0XBF,0X36,0X21,0X63,0X44,0X24,0X51,0X03,0X20,0XBC,0XD6,0X4A,0X23,0X54,0X43,
0X47,0X33,0X23,0X92,0X5A,0X9D,0X01,0X50,0X25,0X33,0X34,0X11,0X33,0X10,0XE9,0X7D,
0X01,0X10,0XA7,0X47,0X43,0X85,0XFC,0XFF,0XAD,0X56,0X33,0X43,0X85,0X79,0X77,0XA8,
0XBC,0X89,0X45,0X33,0X43,0X85,0XDB,0XEE,0X9C,0X45,0X43,0XA7,0XDC,0X69,0X44,0XB7,
0XFF,0XDF,0X7A,0X76,0XCA,0XEB,0X8D,0X54,0X26,0X41,0X9A,0XBA,0X47,0X33,0X47,0X42,
0X55,0X54,0X54,0X72,0X7E,0X56,0X12,0X51,0X01,0X51,0X54,0X34,0X01,0X50,0XED,0X5D,
0X00,0X10,0X94,0X8B,0X54,0XB7,0XFE,0XFF,0XAD,0X77,0X35,0X22,0X54,0X65,0X87,0X98,
0XAC,0X57,0X12,0X22,0X64,0X97,0XCB,0XDE,0X7A,0X34,0X64,0XCA,0XCE,0X68,0X43,0XE8,
0XEF,0XDE,0XCB,0XCC,0XEE,0XEC,0XFF,0X8C,0X68,0X62,0X8A,0X9C,0X54,0X68,0X4A,0X43,
0X51,0X65,0X55,0X56,0X8E,0X54,0X13,0X11,0X30,0XFB,0XFF,0XAE,0X57,0X63,0XFC,0X7E,
0X03,0X00,0X93,0X9D,0X34,0X84,0XFB,0XFF,0XCE,0X6A,0X44,0X23,0X32,0X53,0X87,0X98,
0X89,0X35,0X22,0X32,0X85,0XB9,0XDD,0XDE,0X6A,0X33,0X74,0XCA,0XAD,0X44,0X33,0XF9,
0XCF,0XDB,0XBC,0XFC,0XDF,0X97,0XFE,0XEA,0XCF,0X44,0X76,0X8A,0X95,0X69,0X3A,0X24,
0X31,0X56,0X36,0X39,0X87,0X45,0X02,0X41,0XC8,0XAA,0XDD,0XFF,0XDC,0XBC,0XDC,0XDE,
0X28,0X00,0X72,0X8A,0X14,0X41,0XEB,0XFE,0XDF,0X8B,0X36,0X22,0X22,0X63,0X77,0X88,
0X36,0X11,0X11,0X32,0X54,0X98,0XBB,0X9A,0X57,0X45,0X84,0XEC,0XBE,0X46,0X54,0XEC,
0X9C,0X98,0X37,0XC4,0XAF,0X76,0XFA,0XEF,0XFD,0X17,0X32,0XA8,0X89,0X55,0X44,0X24,
0X22,0X57,0X36,0X34,0X65,0X13,0X00,0XB6,0XCD,0X78,0X67,0XEA,0XAA,0XDB,0XCC,0XDD,
0X6B,0X01,0X71,0XDC,0X28,0X21,0XE8,0XED,0XFF,0XBD,0X69,0X34,0X22,0X32,0X53,0X76,
0X58,0X22,0X22,0X33,0X75,0X98,0XBB,0XBB,0X9A,0X66,0X96,0XFD,0XAE,0X56,0X65,0XAB,
0X99,0X69,0X01,0X50,0XBF,0X42,0XB7,0X9C,0XC8,0X1C,0X00,0XA6,0X47,0X43,0X54,0X34,
0X22,0X43,0X33,0X32,0X6A,0X00,0X30,0X68,0XF9,0X9F,0X45,0XD8,0X07,0X83,0X7A,0XB6,
0X8D,0X01,0X30,0XEA,0X39,0X22,0XD7,0XEE,0XDD,0XCD,0X8A,0X45,0X23,0X42,0X46,0X64,
0X33,0X23,0X43,0X55,0X76,0XA8,0XDC,0XBC,0X99,0X78,0X98,0XFC,0X9F,0X76,0X66,0X78,
0X76,0XCB,0X19,0X00,0XFA,0X26,0X65,0X56,0XB5,0X4F,0X00,0X94,0X66,0X44,0X43,0X63,
0X46,0X21,0X32,0X22,0X17,0X00,0X70,0X35,0X96,0X69,0X23,0XCB,0X03,0X10,0X45,0X52,
0X8B,0X11,0X40,0XFD,0X5B,0X12,0X93,0XEE,0XEE,0XDE,0XAB,0X47,0X22,0X32,0X64,0X77,
0X34,0X23,0X32,0X44,0X76,0XA8,0XCC,0XFE,0X8B,0X78,0XA7,0XFD,0XAF,0X57,0XA6,0X9C,
0X97,0XCB,0X9D,0X01,0XB1,0X9E,0X35,0X43,0XF9,0X8F,0X00,0X82,0X56,0X34,0X33,0X32,
0X46,0X23,0X32,0X44,0X05,0X00,0XC2,0X28,0X32,0X34,0X72,0X6E,0X00,0X81,0X8D,0X22,
0X66,0X03,0X30,0XEA,0X4A,0X11,0X41,0XCA,0XFE,0XDE,0X9B,0X57,0X24,0X21,0X54,0X65,
0X35,0X23,0X22,0X43,0X65,0XA8,0XDB,0XEE,0XCD,0X7A,0XA7,0XFD,0X9E,0X57,0XC6,0XAF,
0X77,0XDB,0XED,0X1A,0X20,0XC8,0XCE,0XCB,0XFE,0XCD,0X04,0X94,0X46,0X33,0X33,0X32,
0X23,0X34,0X21,0X43,0X05,0X00,0XC6,0X6E,0X22,0X42,0XD8,0X07,0X20,0XFB,0X7E,0X22,
0X76,0X14,0X41,0XEA,0X6C,0X12,0X72,0XED,0XFF,0XCE,0XAB,0X58,0X24,0X12,0X32,0X54,
0X45,0X44,0X44,0X55,0X76,0XA8,0XED,0XEF,0XCE,0X58,0XA6,0XFE,0X8E,0X65,0XE9,0XAF,
0X35,0X96,0XEB,0XDF,0X04,0X20,0XA6,0XEB,0XAD,0XFB,0X3A,0X98,0X36,0X43,0X34,0X43,
0X23,0X42,0X23,0X42,0X25,0X20,0X98,0XCC,0XCB,0XDC,0X5B,0X00,0XA1,0XFF,0X7F,0X73,
0XAB,0X14,0X42,0XEB,0X5A,0X01,0X51,0XFD,0XFF,0XEF,0XBC,0X7A,0X45,0X22,0X21,0X43,
0X56,0X44,0X54,0X75,0X77,0XA9,0XDB,0XCD,0X69,0X54,0XB7,0XFF,0X8C,0X66,0XFB,0X9E,
0X35,0X94,0X87,0XFD,0X6C,0X00,0X00,0X30,0XAA,0XFA,0XAE,0X8A,0X44,0X33,0X43,0X43,
0X23,0X32,0X33,0X33,0X54,0XA2,0X8A,0XAB,0X99,0X47,0X01,0X20,0XFB,0XFF,0X39,0X92,
0XCD,0X38,0X31,0XEA,0X4B,0X11,0X42,0XDA,0XEE,0XDD,0XCD,0X69,0X44,0X13,0X22,0X43,
0X78,0X44,0X33,0X44,0X75,0XB9,0XDC,0X8C,0X66,0X66,0XA7,0XFE,0X7A,0X88,0XFC,0X6D,
0X22,0X62,0X76,0XCB,0XEE,0X06,0X00,0X00,0XC6,0XFD,0XEF,0X7A,0X35,0X33,0X33,0X43,
0X24,0X22,0X22,0X23,0X74,0XFB,0X8D,0X38,0X00,0X00,0X00,0XD5,0XFF,0X8C,0X12,0X93,
0XEE,0X4A,0X11,0XE8,0X5B,0X12,0X63,0XBA,0XDD,0XBB,0XBA,0X69,0X23,0X22,0X22,0X42,
0X36,0X23,0X22,0X43,0X76,0XC9,0XEE,0XBD,0X79,0X66,0X97,0XFD,0X9D,0X78,0XFB,0X9F,
0X23,0X32,0X53,0X87,0XAA,0X38,0X00,0X00,0XC2,0XFF,0XCF,0X69,0X45,0X33,0X33,0X43,
0X23,0X22,0X22,0X22,0X64,0XFC,0XDF,0X07,0X00,0X00,0XB3,0XFF,0XBF,0X9B,0X23,0X42,
0XFC,0X4C,0X31,0XEA,0X3B,0X10,0X61,0XDB,0XCC,0XBB,0X78,0X66,0X23,0X22,0X22,0X32,
0X67,0X24,0X32,0X44,0X75,0XA8,0XEC,0XDE,0X9B,0X78,0X86,0XFD,0X9E,0X78,0XEA,0XEF,
0X9B,0X9A,0X54,0XC9,0X89,0X58,0X00,0X00,0XF4,0XFF,0XBD,0X78,0X56,0X34,0X33,0X44,
0X24,0X22,0X22,0X22,0X64,0XDA,0XFF,0X09,0X00,0X00,0XB5,0XEF,0XDC,0X5D,0X12,0X31,
0XFB,0X4B,0X42,0XEB,0X6D,0X01,0X21,0XA5,0XAB,0X89,0X47,0X44,0X23,0X12,0X32,0X23,
0X48,0X22,0X32,0X43,0X86,0XA9,0XCC,0XDD,0XAC,0X68,0XA6,0XFD,0X8D,0X57,0XC6,0XFF,
0XFF,0XEE,0X58,0XB7,0X9A,0X57,0X02,0X10,0XFC,0XFF,0X9D,0X67,0X56,0X45,0X34,0X54,
0X23,0X33,0X33,0X22,0X54,0XA9,0XFD,0X1E,0X00,0X00,0X96,0X9A,0XDD,0X26,0X02,0X20,
0XEB,0X38,0X32,0XFA,0X6C,0X01,0X32,0X75,0XCA,0X9A,0X78,0X34,0X23,0X12,0X32,0X44,
0X13,0X22,0X32,0X53,0X65,0X97,0XCB,0XCD,0XBD,0X78,0XA8,0XFD,0X8C,0X57,0XB5,0XFE,
0XFF,0XFF,0X5A,0X64,0X67,0X56,0X14,0X71,0XFE,0XDD,0X8B,0X66,0X66,0X46,0X44,0X33,
0X22,0X22,0X22,0X32,0X43,0X86,0XCB,0XAF,0X00,0X30,0X87,0X78,0X8A,0X43,0X44,0X95,
0XDE,0X14,0X32,0XFC,0X4B,0X01,0X41,0XB9,0XCB,0XAB,0X78,0X56,0X24,0X32,0X32,0X65,
0X34,0X33,0X33,0X33,0X54,0X86,0XBA,0XED,0XCE,0X67,0X97,0XFD,0X8E,0X45,0X63,0XDA,
0XFE,0XFF,0X8D,0XA8,0X68,0X56,0X34,0X85,0XBB,0XAA,0X68,0X64,0X66,0X55,0X43,0X22,
0X32,0X11,0X22,0X22,0X43,0X65,0XA9,0XDB,0X16,0X51,0X78,0X65,0X7B,0X55,0XD8,0XDD,
0X9E,0X13,0X22,0XEA,0X39,0X11,0X43,0XEA,0XCE,0X79,0X36,0X32,0X33,0X33,0X66,0X66,
0X44,0X34,0X22,0X43,0X56,0X87,0X98,0XEB,0XAD,0X89,0X75,0XFC,0X9E,0X45,0X34,0X54,
0XC8,0XED,0XCE,0X58,0X34,0X75,0X55,0X66,0X88,0X68,0X56,0X65,0X66,0X56,0X22,0X22,
0X32,0X22,0X22,0X23,0X32,0X53,0X76,0XAA,0X57,0X44,0X75,0X69,0X35,0X42,0XFC,0XEF,
0X17,0X20,0X12,0XD8,0X27,0X11,0X94,0XB9,0XCC,0X7A,0X46,0X12,0X22,0X22,0X64,0X98,
0X44,0X23,0X33,0X54,0X75,0X87,0X99,0XDB,0XED,0X8D,0X55,0XEA,0XAE,0X46,0X34,0X22,
0X42,0X54,0X69,0X54,0X97,0X78,0X34,0X75,0X66,0X65,0X45,0X75,0X57,0X34,0X22,0X22,
0X33,0X33,0X33,0X23,0X22,0X32,0X54,0X96,0X58,0X43,0X34,0X64,0X48,0X51,0XFC,0XAF,
0X02,0X20,0X42,0XBA,0X16,0X22,0XB5,0XCC,0X8A,0X67,0X45,0X23,0X12,0X11,0X52,0X88,
0X56,0X23,0X54,0X45,0X75,0X76,0X77,0XA8,0XEC,0XAE,0X56,0XE9,0XAE,0X46,0X23,0X22,
0X22,0X33,0X65,0XB9,0X9B,0X78,0X44,0X89,0X65,0X44,0X55,0X76,0X56,0X33,0X23,0X22,
0X32,0X44,0X34,0X32,0X23,0X23,0X43,0X86,0X59,0X54,0X44,0X43,0X66,0XB6,0XEE,0X29,
0X00,0X10,0X30,0XEC,0X05,0X94,0XFC,0XDF,0X6B,0X65,0X35,0X23,0X12,0X11,0X41,0X87,
0X47,0X54,0X34,0X53,0X56,0X65,0X76,0XC8,0XFE,0XBF,0X44,0XF9,0XAF,0X46,0X22,0X32,
0X34,0X64,0X98,0XAB,0XB9,0X79,0X83,0X69,0X44,0X55,0X55,0X67,0X45,0X23,0X22,0X33,
0X32,0X43,0X43,0X33,0X23,0X43,0X33,0X35,0X97,0X53,0X67,0X9A,0X97,0XFD,0XAE,0X02,
0X00,0X12,0X20,0XCA,0X04,0XA2,0XFF,0XFF,0XAD,0X45,0X23,0X11,0X11,0X21,0X21,0X74,
0X79,0X68,0X45,0X77,0X56,0X55,0X54,0XB8,0XFE,0X8E,0X34,0XC7,0XAE,0X34,0X23,0X53,
0X97,0XEC,0XFE,0XDF,0XBC,0X58,0XB8,0X36,0X33,0X45,0X66,0X67,0X56,0X23,0X22,0X22,
0X32,0X44,0X44,0X33,0X22,0X43,0X33,0X43,0X83,0X16,0X65,0X83,0X8B,0X86,0X48,0X00,
0X10,0X01,0X61,0X59,0X00,0XA3,0XFF,0XFF,0X7B,0X35,0X12,0X11,0X11,0X21,0X32,0X76,
0XBA,0X68,0X76,0X47,0X33,0X43,0X65,0XEA,0XFF,0X9E,0X24,0X93,0XAD,0X45,0X65,0X66,
0X95,0XFD,0XBD,0XEE,0X6A,0X75,0X69,0X33,0X54,0X55,0X66,0X67,0X45,0X22,0X22,0X32,
0X33,0X44,0X34,0X33,0X24,0X32,0X33,0X43,0X33,0X69,0X74,0X25,0X23,0X10,0X00,0X00,
0X00,0X00,0X81,0X38,0X00,0XA3,0XFF,0XEF,0X8B,0X46,0X12,0X11,0X11,0X11,0X21,0X85,
0X9B,0X87,0X57,0X23,0X32,0X54,0X96,0XFC,0XFF,0X6D,0X22,0X62,0XDC,0X68,0XD9,0X7D,
0X22,0X53,0X75,0XAA,0X35,0XA8,0X7A,0X34,0X42,0X56,0X66,0X66,0X46,0X33,0X32,0X24,
0X33,0X53,0X34,0X44,0X34,0X32,0X33,0X34,0X33,0X83,0X45,0X57,0X66,0X14,0X00,0X00,
0X00,0X00,0X51,0X04,0X00,0XB1,0XFF,0XFF,0X9C,0X45,0X24,0X12,0X11,0X11,0X31,0X54,
0X9C,0X89,0X24,0X22,0X54,0X45,0XA6,0XFD,0XEF,0X9C,0X34,0X43,0XC8,0X9B,0XEC,0XBF,
0X16,0X21,0XA7,0X58,0X83,0XAB,0X68,0X34,0X32,0X44,0X66,0X56,0X45,0X23,0X33,0X33,
0X23,0X43,0X34,0X44,0X44,0X33,0X34,0X23,0X32,0X32,0X47,0X73,0X93,0X7C,0X01,0X00,
0X00,0X00,0X41,0X02,0X00,0X50,0XFD,0XDF,0XAC,0X66,0X56,0X23,0X22,0X22,0X22,0X64,
0X9B,0X59,0X23,0X65,0X57,0X64,0XB9,0XED,0XFE,0XAF,0X34,0X33,0XB5,0XCB,0XFE,0XCE,
0X26,0X83,0X9C,0X15,0XD8,0X87,0X57,0X23,0X22,0X53,0X77,0X77,0X45,0X23,0X33,0X43,
0X33,0X33,0X33,0X43,0X45,0X33,0X33,0X22,0X32,0X34,0X74,0X31,0X34,0XDB,0X06,0X00,
0X53,0X12,0X22,0X00,0X00,0X60,0XFD,0XEF,0X9B,0X77,0X67,0X23,0X32,0X33,0X23,0X73,
0XAB,0X57,0X63,0X69,0X46,0X85,0XA9,0XBB,0XDC,0X8B,0X35,0X33,0XA5,0XED,0XEE,0XEE,
0X48,0XD9,0X3A,0X71,0XAF,0X74,0X57,0X23,0X32,0X65,0X86,0X88,0X47,0X22,0X32,0X33,
0X22,0X33,0X22,0X43,0X64,0X34,0X43,0X22,0X22,0X33,0X62,0X06,0X13,0X62,0X47,0X64,
0XB9,0X6A,0X14,0X00,0X30,0X96,0XFE,0XFF,0XAD,0X47,0X42,0X23,0X22,0X33,0X44,0X76,
0XAB,0X46,0X75,0X67,0X55,0X87,0X98,0X99,0X99,0XAB,0X66,0X87,0XC9,0XFF,0XCF,0XCB,
0X57,0X56,0X02,0XE4,0X5C,0X98,0X46,0X22,0X32,0X77,0X87,0X8A,0X45,0X23,0X23,0X33,
0X33,0X32,0X12,0X21,0X74,0X45,0X45,0X24,0X22,0X42,0X22,0X48,0X10,0X00,0X30,0XDA,
0XCC,0XAD,0X03,0X00,0X11,0XB6,0XE9,0XFF,0XAC,0X56,0X23,0X33,0X12,0X32,0X54,0X87,
0X9C,0X65,0X87,0X46,0X54,0X66,0X67,0X86,0XDA,0XAE,0XAA,0XCB,0XFE,0XFF,0XBF,0X86,
0X27,0X00,0X10,0XE7,0X58,0X89,0X45,0X12,0X53,0X86,0X99,0X7B,0X34,0X32,0X22,0X23,
0X32,0X33,0X22,0X22,0X74,0X76,0X56,0X35,0X22,0X43,0X03,0XB4,0X02,0X00,0X10,0XC8,
0XDB,0X9E,0X01,0X00,0X51,0X98,0X89,0XDD,0X8B,0X36,0X22,0X21,0X11,0X32,0X53,0X97,
};


const uint8_t PIC3[] PROGMEM =
{
/* 0X20,0X04,0X80,0X00,0X48,0X00, */
0XAD,0X77,0X66,0X67,0X76,0X67,0X66,0X66,0X45,0XA6,0X36,0XD7,0X5D,0X56,0X66,0XF8,
0X7C,0X98,0X88,0X98,0XBA,0XAA,0XAA,0XBB,0XCB,0XDD,0XAC,0XEC,0XDF,0XCC,0XDB,0XDD,
0XAC,0XBA,0XCB,0XED,0XCD,0XDC,0XCB,0XBB,0X98,0XAA,0X99,0X99,0XCA,0XAC,0X57,0X46,
0X84,0X88,0XCB,0XBC,0XBA,0X28,0X21,0X62,0X9A,0X9A,0X03,0X01,0X01,0X10,0X01,0X10,
0XDE,0X79,0X76,0X77,0X77,0X67,0X56,0X55,0X45,0X75,0X55,0XB5,0X8F,0X66,0X77,0XFA,
0X7B,0XB8,0X9A,0XA8,0XBB,0XBA,0XDC,0XED,0XEE,0XEF,0XCE,0XED,0XFF,0XEE,0XFF,0XCF,
0XFE,0XDE,0XED,0XFF,0XEF,0XDB,0XDB,0XEE,0X9A,0XCD,0XBB,0XBC,0XBB,0XAA,0X99,0XA9,
0X9A,0X9A,0X88,0X58,0X33,0X23,0X74,0XA9,0X57,0X33,0X13,0X11,0X33,0X00,0X00,0X00,
0XDB,0X7A,0X98,0X57,0X45,0X55,0X65,0X46,0X54,0X65,0X66,0X67,0XCC,0X77,0XA8,0XCD,
0X88,0XC9,0XAA,0XBA,0XCC,0XBB,0XEE,0XFF,0XFF,0XFF,0XEF,0XED,0XFF,0XFF,0XFF,0XDF,
0XFC,0XFF,0XFF,0XFF,0XFF,0XCE,0XBC,0XFF,0XAE,0XFC,0XDD,0XDE,0XDD,0XCC,0XAB,0X9A,
0X9A,0X9A,0X35,0X44,0X75,0X57,0X55,0X97,0X34,0X33,0X35,0X12,0X21,0X12,0X10,0X01,
0XDA,0X9C,0X98,0X78,0X45,0X44,0X76,0X67,0X66,0X88,0X88,0X78,0XCA,0X99,0XA9,0XBC,
0XBA,0XCC,0XDC,0XED,0XEE,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0XFE,0XFF,0XFF,
0XEE,0XFF,0XFF,0XFF,0XFF,0XDF,0XCE,0XFC,0XEF,0XDA,0XFF,0XEF,0XFD,0XEE,0XCD,0XAB,
0X89,0X88,0X66,0X68,0XA5,0X69,0X56,0X75,0X47,0X23,0X32,0X76,0X25,0X52,0X02,0X01,
0XC9,0XCF,0X57,0X86,0X88,0X87,0X87,0X88,0X77,0X88,0X89,0XA9,0X99,0XBA,0XBB,0XCC,
0XDD,0XDD,0XFE,0XFF,0XEF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFE,0XEF,0XFD,0XEF,
0XEF,0XED,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0XFF,0XBD,0XFF,0XFF,0XFF,0XFF,0XFF,0XDE,
0XBD,0XAB,0X78,0XAA,0X76,0X88,0X77,0X45,0X86,0X45,0X44,0X34,0X75,0X77,0X46,0X01,
0XA9,0XEF,0X69,0X54,0X66,0X54,0X86,0X89,0X88,0X87,0X88,0XBA,0XBA,0XCC,0XED,0XFE,
0XFF,0XEE,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0XFE,0XFF,0XED,0XFF,
0XEF,0XED,0XFF,0XFF,0XFF,0XEF,0XFE,0XBF,0XFC,0XEF,0XFD,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XEE,0XBD,0X99,0X66,0XAA,0XA9,0X7B,0X85,0X79,0X45,0X34,0X43,0X55,0X66,0X76,
0X99,0XBE,0XBA,0X58,0X65,0X65,0X77,0X98,0X9A,0X98,0X99,0XBB,0XCB,0XDD,0XFE,0XFF,
0XFF,0XEF,0XFF,0XFF,0XFF,0XEF,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,0XDE,0XFE,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFE,0XCE,0XEC,0XDC,0XEF,0XBC,0XFE,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X8D,0X65,0XE6,0X9C,0XAA,0X54,0X87,0X66,0X56,0X67,0X54,0X98,0X89,
0X7A,0XDD,0X78,0X9B,0X67,0X86,0X79,0XA8,0XCB,0XBA,0XBB,0XCB,0XEE,0XEF,0XFE,0XFF,
0XFF,0XEF,0XFF,0XFF,0XFF,0XEF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XDF,0XDD,0XFE,0XEF,
0XFF,0XEE,0XEF,0XFE,0XEF,0XFE,0XEF,0XFD,0XDE,0XFF,0XCF,0XDB,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XEF,0XEF,0X6A,0X84,0XCF,0X99,0X49,0X75,0X8A,0X87,0X78,0X34,0X64,0X75,
0X6B,0XF9,0X4B,0XF9,0XEF,0X9B,0X97,0XAA,0XDA,0XCC,0XDC,0XEB,0XFF,0XFF,0XFF,0XFF,
0XFF,0XEF,0XFF,0XFF,0XFF,0XFF,0XFF,0XDE,0XED,0XDE,0XDD,0XCC,0XEF,0XCB,0XDE,0XDD,
0XBB,0XBA,0XCF,0XDB,0XEF,0XBC,0XFD,0XED,0XFE,0XEE,0XFF,0XBB,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XDE,0X17,0XD5,0XAF,0X9A,0X85,0X78,0X68,0X77,0X65,0X47,0X54,
0X6B,0XC6,0XBE,0XDA,0XCD,0X7A,0X98,0XA9,0XCC,0XEE,0XFE,0XED,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XDD,0XDD,0XBB,0XBB,0XBA,0XAA,0XBA,0XDD,0X9A,0X8A,0XB8,
0X89,0X88,0XCD,0X98,0XED,0X8A,0XEB,0XBB,0XEE,0XAC,0XFB,0XBE,0XFC,0XFF,0XFF,0XFF,
0XFF,0XEF,0XFF,0XFF,0XFF,0XBF,0X55,0XDA,0XCB,0X58,0XAB,0XAA,0X77,0X49,0XD7,0XBB,
0X5D,0X95,0XEA,0X8B,0XD9,0XCE,0XBB,0XBB,0XDC,0XEE,0XEE,0XEF,0XFF,0XEF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XEE,0X9C,0XAA,0XBA,0X9A,0X99,0X67,0X76,0XB8,0X77,0X77,0X86,
0X67,0X56,0X96,0X87,0XBB,0X88,0XCB,0XA9,0XED,0X8A,0X96,0XAC,0XEB,0XFE,0XEF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XBE,0X64,0XCB,0X9C,0XA9,0XCA,0X8C,0X58,0X71,0XAB,
0X5E,0X71,0XA8,0X8B,0XBA,0XBC,0XCD,0XCB,0XFD,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XDF,0XDA,0XCA,0X7B,0X76,0X66,0X58,0X68,0X57,0X65,0X66,0X43,0X76,0X76,
0X58,0X74,0X56,0X77,0XA7,0X67,0X76,0X69,0XD9,0X67,0X57,0X66,0XC8,0XCA,0XCD,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X9E,0X96,0XCD,0XAC,0XAA,0XA9,0X68,0X54,0X75,
0XAB,0X95,0X8C,0XBB,0XAA,0XA9,0XCB,0XED,0XEF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XDE,0XCD,0XAE,0X98,0XA8,0X88,0X76,0X34,0X86,0X69,0X86,0X75,0X68,0X34,0X76,0X66,
0X46,0X54,0X55,0X68,0X76,0X67,0X64,0X77,0X65,0X63,0X46,0X44,0X76,0X86,0X98,0XCA,
0XFF,0XFF,0XFF,0XFF,0XFF,0XEF,0XEE,0XFF,0X6B,0XD8,0XDE,0X9C,0XA9,0X78,0X98,0X57,
0XB9,0XC8,0X8C,0XDA,0XBA,0XCB,0XDC,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCE,
0XBB,0X7A,0X99,0X47,0X67,0X76,0X88,0X67,0X89,0X76,0X77,0X76,0X86,0X35,0X64,0X66,
0X34,0X64,0X54,0X66,0X55,0X65,0X64,0X67,0X46,0X53,0X45,0X55,0X46,0X63,0X58,0X99,
0XEC,0XDC,0XFF,0XFF,0XFF,0XFF,0XEF,0XFF,0XDF,0X35,0XFB,0XAE,0XDC,0XAC,0X98,0X79,
0X88,0XD8,0X9D,0XC9,0XBD,0XDD,0XEF,0XFE,0XFF,0XFF,0XFF,0XFF,0XEF,0XFF,0XDD,0X8C,
0X66,0X56,0XC6,0X37,0X45,0X44,0X63,0X69,0X66,0X66,0X66,0X66,0X65,0X45,0X54,0X45,
0X34,0X43,0X34,0X64,0X55,0X64,0X75,0X67,0X78,0X57,0X45,0X76,0X26,0X51,0X38,0X64,
0XDC,0X99,0XED,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAE,0X66,0XFC,0XFF,0XCE,0X9B,0X76,
0X88,0XBB,0X9C,0XBB,0XCC,0XFF,0XFF,0XEF,0XFF,0XFF,0XFF,0XEF,0XDE,0XBC,0X98,0X69,
0X45,0X34,0X93,0X29,0X55,0X45,0X63,0X68,0X66,0X58,0X54,0X35,0X55,0X55,0X44,0X44,
0X55,0X43,0X65,0X34,0X65,0X54,0X55,0X76,0X76,0X56,0X54,0X45,0X15,0X10,0X53,0X33,
0X78,0X76,0X88,0XEA,0XFF,0XFF,0XFF,0XFF,0XEF,0XFF,0X4E,0XC3,0XFF,0XFF,0XCE,0X7A,
0X99,0XC9,0XAD,0XC8,0XED,0XFF,0XFF,0XFF,0XFF,0XEF,0XFF,0XBE,0XAA,0X68,0X65,0X87,
0X36,0X23,0X82,0X3A,0X65,0X47,0X76,0X55,0X65,0X56,0X44,0X44,0X65,0X67,0X55,0X66,
0X55,0X54,0X67,0X24,0X74,0X44,0X15,0X64,0X65,0X75,0X85,0X44,0X16,0X11,0X23,0X12,
0X34,0X54,0X65,0XE8,0XEF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X69,0XE8,0XFF,0XEF,0XCD,
0XAC,0XB9,0XDD,0XC8,0XFE,0XEF,0XFF,0XFF,0XFF,0XEF,0XBD,0XAC,0X88,0X57,0X33,0X85,
0X47,0X34,0X73,0X6B,0X65,0X58,0X76,0X45,0X44,0X65,0X46,0X75,0X87,0X88,0X98,0X98,
0X66,0X54,0X77,0X24,0X84,0X57,0X27,0X25,0X44,0X63,0X94,0X47,0X47,0X24,0X23,0X21,
0X03,0X22,0X52,0XCB,0XCB,0XCE,0XEC,0XFF,0XFF,0XFF,0XFE,0XBF,0XC5,0XFF,0XEF,0XDE,
0XCC,0XCC,0XDD,0XFD,0XEE,0XFF,0XFF,0XFF,0XDE,0XDE,0X8C,0X98,0X76,0X65,0X55,0X86,
0X44,0X55,0X64,0X9A,0X87,0X47,0X65,0X45,0X56,0X76,0X68,0X88,0X97,0X88,0XBB,0X9A,
0X87,0X55,0X84,0X35,0XA7,0X36,0X15,0X34,0X22,0X22,0X34,0X44,0X46,0X45,0X04,0X30,
0X12,0X22,0X32,0X79,0X75,0X8B,0XB8,0XED,0XFE,0XFF,0XFF,0XFF,0XFD,0XFF,0XFF,0XFF,
0XBA,0XDD,0XED,0XFE,0XFF,0XFF,0XFF,0XDF,0XCC,0X9A,0X8B,0X96,0X79,0X65,0X66,0X97,
0X45,0X64,0X54,0X99,0X86,0X66,0X56,0X66,0X67,0X87,0XA9,0X9A,0XA9,0XBA,0XDD,0X9A,
0XB8,0X37,0X73,0X67,0X67,0X23,0X14,0X35,0X12,0X33,0X24,0X52,0X43,0X55,0X14,0X51,
0X23,0X01,0X41,0X38,0X53,0X78,0X87,0X98,0XEC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XBA,0XDD,0XED,0XFF,0XFF,0XFF,0XEF,0XDD,0XAC,0X79,0X76,0X76,0X89,0X55,0X76,0X97,
0X78,0X65,0X66,0X97,0X8A,0X76,0X77,0X97,0X78,0XA8,0XCB,0XAC,0XD9,0XA9,0XEC,0X9E,
0X87,0X27,0X83,0X3A,0X52,0X52,0X14,0X46,0X04,0X31,0X57,0X75,0X43,0X63,0X44,0X73,
0X15,0X00,0X61,0X14,0X21,0X54,0X65,0X76,0XD9,0XDE,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,
0XCC,0XFE,0XFF,0XFF,0XFF,0XFF,0XCE,0XED,0X8C,0X76,0X77,0X44,0X66,0X46,0X75,0X54,
0X77,0X77,0X78,0X77,0X87,0X77,0X77,0X87,0X98,0XC9,0XDC,0XCD,0XE9,0X98,0XEB,0X9E,
0X27,0X56,0X75,0X17,0X51,0X55,0X12,0X35,0X06,0X42,0X68,0XB8,0X35,0X44,0X45,0X42,
0X12,0X01,0X51,0X01,0X11,0X41,0X44,0X44,0XB7,0X9A,0XCA,0XFF,0XFF,0XFF,0XFF,0XFF,
0XDD,0XFE,0XFF,0XFE,0XFF,0XEE,0XDE,0X8C,0X58,0X74,0X56,0X56,0X53,0X46,0X63,0X66,
0X86,0X88,0X77,0X76,0X98,0X78,0X77,0X98,0XA9,0XCA,0XDE,0XFF,0XBA,0X98,0X7A,0X84,
0X28,0X55,0X22,0X15,0X32,0X45,0X21,0X36,0X05,0X52,0X46,0XDC,0X45,0X46,0X54,0X43,
0X23,0X12,0X53,0X01,0X10,0X21,0X23,0X43,0X97,0X67,0X97,0XDD,0XFF,0XFF,0XFF,0XFF,
0XFE,0XEF,0XDD,0XFF,0XFF,0XBC,0XDC,0X6A,0X46,0X76,0X45,0X45,0X53,0X67,0X65,0X88,
0X86,0X66,0X76,0X87,0XA9,0X9A,0X98,0X99,0XA8,0XBE,0XED,0XFE,0X9C,0X37,0X56,0X72,
0X26,0X00,0X02,0X47,0X41,0X44,0X10,0X36,0X06,0X72,0X67,0XAF,0X75,0X46,0X55,0X35,
0X22,0X22,0X23,0X12,0X10,0X10,0X22,0X31,0X46,0X44,0X55,0X97,0XFE,0XFF,0XFF,0XFF,
0XFE,0XBE,0XDB,0XEF,0XCD,0X98,0XAA,0X69,0X66,0X67,0X57,0X56,0X53,0X77,0X88,0X87,
0X76,0X66,0X76,0X88,0XB9,0XAB,0X88,0X98,0XB9,0XAD,0XFF,0X9E,0X75,0X26,0X74,0X33,
0X22,0X00,0X12,0X46,0X51,0X54,0X10,0X46,0X04,0X71,0X89,0XAF,0X88,0X54,0X57,0X35,
0X32,0X23,0X11,0X12,0X00,0X01,0X10,0X32,0X23,0X42,0X44,0X75,0XD9,0XFF,0XFF,0XFF,
0XEF,0XDD,0XFE,0XEF,0XCE,0XB9,0XBA,0X69,0X76,0X56,0X77,0X75,0X67,0X96,0XA7,0X89,
0X86,0X87,0X88,0X99,0XCA,0XAC,0X97,0X9A,0XB8,0XAD,0X9C,0X54,0X52,0X26,0X31,0X22,
0X20,0X00,0X21,0X53,0X52,0X44,0X10,0X57,0X12,0X91,0XAA,0X8E,0XAB,0X64,0X78,0X46,
0X45,0X34,0X21,0X12,0X01,0X00,0X10,0X23,0X10,0X32,0X33,0X54,0XA6,0XFF,0XFF,0XEF,
0XCE,0XFD,0XEF,0XED,0XBC,0X7B,0X75,0X66,0X67,0X55,0X73,0X87,0X68,0X86,0X66,0X86,
0X87,0X87,0X9A,0XA9,0XBA,0X9B,0XB7,0XCE,0XCA,0X7A,0X65,0X63,0X24,0X02,0X10,0X12,
0X00,0X01,0X21,0X31,0X43,0X24,0X10,0X28,0X41,0XA2,0XBA,0XAD,0X9E,0X66,0X98,0X57,
0X46,0X34,0X63,0X14,0X01,0X00,0X10,0X04,0X10,0X33,0X21,0X43,0X95,0XFE,0XEE,0XEE,
0XCB,0XFE,0XDE,0XCC,0X8B,0X89,0X65,0X66,0X55,0X55,0X65,0X98,0X88,0X56,0X78,0X77,
0X87,0X97,0XAA,0XAA,0X9A,0X88,0XA8,0XDB,0X9B,0X55,0X54,0X10,0X04,0X00,0X00,0X13,
0X00,0X00,0X31,0X10,0X34,0X13,0X20,0X09,0X30,0XA1,0XAE,0XFF,0XAF,0X76,0XAA,0X77,
0X66,0X45,0X44,0X13,0X20,0X03,0X51,0X04,0X21,0X33,0X11,0X32,0X84,0XFD,0XCD,0XED,
0XFD,0XDE,0XCD,0X9A,0X8A,0X77,0X67,0X86,0X67,0X55,0X54,0X87,0X66,0X76,0X78,0X77,
0X77,0X77,0XA8,0XBB,0XCC,0XAB,0X89,0XD9,0X05,0X21,0X10,0X01,0X11,0X02,0X00,0X01,
0X00,0X00,0X51,0X00,0X25,0X03,0X20,0X04,0X10,0X92,0XAF,0XEE,0X7A,0X74,0X9B,0X97,
0X88,0X46,0X43,0X24,0X21,0X43,0X33,0X02,0X12,0X11,0X12,0X11,0X84,0XB9,0XAD,0XFB,
0XFF,0XBC,0XCC,0X9B,0X77,0X67,0X35,0X54,0X54,0X56,0X55,0X66,0X75,0X78,0X88,0X78,
0X88,0X78,0XDA,0XEE,0XFF,0XEE,0XBA,0X27,0X23,0X00,0X00,0X11,0X00,0X00,0X00,0X11,
0X00,0X00,0X40,0X00,0X36,0X02,0X40,0X01,0X00,0X94,0XAF,0XAE,0X75,0X95,0X9A,0X99,
0X89,0X57,0X54,0X14,0X01,0X31,0X11,0X21,0X01,0X00,0X42,0X22,0X54,0X75,0XCB,0XBB,
0XFE,0XBD,0X9A,0X89,0X88,0X67,0X56,0X35,0X54,0X45,0X67,0X65,0X75,0X67,0X77,0X78,
0X88,0X98,0XDC,0XCC,0XED,0XDD,0X8B,0X16,0X21,0X00,0X00,0X40,0X04,0X10,0X01,0X10,
0X00,0X00,0X20,0X10,0X42,0X00,0X52,0X00,0X00,0XB2,0XAF,0XBF,0X75,0XA6,0X89,0X9A,
0X8A,0X78,0X35,0X32,0X11,0X01,0X21,0X33,0X00,0X00,0X31,0X23,0X33,0X63,0XDA,0X9B,
0XDF,0XAC,0X88,0X69,0X97,0X89,0X98,0X67,0X67,0X55,0X46,0X65,0X65,0X66,0X76,0X88,
0X87,0XA8,0XDD,0XCD,0XBC,0X8A,0X37,0X43,0X01,0X00,0X00,0X60,0X0E,0X12,0X01,0X50,
0X05,0X00,0X21,0X01,0X31,0X00,0X25,0X00,0X00,0XF3,0XCC,0XBF,0X78,0X96,0X7A,0XBC,
0X99,0X78,0X46,0X63,0X33,0X02,0X30,0X14,0X00,0X00,0X20,0X11,0X22,0X63,0X98,0X99,
0XBC,0X9B,0X88,0X9A,0XB9,0X7A,0X77,0X77,0X56,0X63,0X69,0X67,0X77,0X77,0X77,0X88,
0X98,0X99,0XCC,0XCB,0XBB,0X7A,0X56,0X77,0X46,0X00,0X00,0X50,0X1C,0X10,0X00,0X91,
0X06,0X00,0X00,0X00,0X10,0X30,0X04,0X00,0X10,0XEC,0X99,0XDB,0XAD,0XAA,0X78,0XBA,
0XBA,0X78,0X67,0X45,0X44,0X11,0X42,0X02,0X00,0X00,0X10,0X12,0X32,0X43,0X76,0XA9,
0XBD,0XBB,0X9A,0X99,0X89,0X98,0X89,0X66,0X46,0X64,0X99,0X67,0X77,0X97,0X79,0X87,
0XAA,0XAA,0XBB,0XBB,0X9A,0X67,0X66,0X98,0XD8,0X7C,0X35,0X21,0X58,0X01,0X00,0XC6,
0X03,0X00,0X00,0X00,0X00,0X10,0X00,0X00,0XB2,0X9D,0X9A,0XCA,0XAD,0XBA,0X66,0X98,
0XAA,0X78,0X88,0X47,0X34,0X32,0X13,0X00,0X00,0X00,0X10,0X32,0X33,0X22,0X64,0X87,
0XCB,0XDD,0XBD,0X88,0XA9,0X89,0X87,0X57,0X45,0X64,0X87,0X86,0X87,0X99,0X78,0X77,
0XBA,0X9A,0XDA,0XAB,0X68,0X86,0XA9,0X88,0XA7,0XBE,0XB9,0X89,0X78,0X45,0X33,0X46,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X72,0XFD,0XDD,0XD8,0XBD,0X9C,0X98,0X67,0XA8,
0X9A,0X8A,0X98,0X58,0X32,0X35,0X12,0X00,0X00,0X00,0X11,0X22,0X22,0X22,0X64,0X65,
0XA8,0XAC,0XB8,0X88,0X88,0XA8,0X69,0X76,0X67,0X65,0X86,0X77,0X97,0XCA,0X79,0XB7,
0XBB,0XA9,0X98,0X99,0X78,0X66,0XA8,0X88,0X77,0XBB,0X78,0XB8,0X77,0X87,0X68,0X57,
0X45,0X33,0X34,0X33,0X34,0X75,0XA7,0XFD,0XBD,0X9E,0X90,0XDF,0X9A,0X9B,0X89,0X87,
0X98,0XAB,0XA9,0X58,0X43,0X14,0X11,0X01,0X10,0X00,0X10,0X11,0X11,0X32,0X54,0X55,
0XBA,0X9B,0XB8,0X79,0X88,0XB8,0X8A,0X66,0X98,0X68,0X78,0X65,0XB8,0XDC,0X8C,0XE7,
0XAE,0X89,0X98,0X56,0XA8,0X69,0X64,0X77,0X56,0XA5,0X69,0XA6,0X67,0X97,0X8B,0X88,
0X89,0X89,0X88,0X9A,0XBB,0X9B,0XEB,0XDF,0X12,0XDC,0X98,0XED,0XAC,0X9A,0X8A,0X65,
0X86,0XAA,0X99,0X79,0X35,0X12,0X00,0X11,0X11,0X20,0X23,0X11,0X12,0X43,0X53,0X46,
0XBC,0X8A,0XC9,0X8C,0X87,0X88,0X97,0X8A,0X66,0X76,0X76,0X87,0XCA,0XBC,0X8B,0XD7,
0XCC,0X99,0X8A,0X86,0X88,0X98,0X57,0X86,0X57,0X64,0X68,0XB6,0X6D,0XB8,0X9B,0X89,
0X88,0X9A,0X78,0X98,0X9A,0X77,0XEA,0XBE,0X14,0XD6,0XCD,0XDC,0XCB,0X79,0X78,0X86,
0X8A,0X87,0X99,0X88,0X47,0X12,0X11,0X00,0X11,0X42,0X25,0X11,0X22,0X32,0X42,0X57,
0XAB,0X8A,0XC9,0X8B,0X76,0X78,0X87,0X76,0X78,0X56,0X65,0X98,0XAA,0X9A,0X88,0XB5,
0XAA,0X8A,0X89,0X87,0X67,0X88,0X78,0X66,0X57,0X55,0X88,0X88,0X88,0XBB,0X9C,0XAA,
0X99,0X8A,0X65,0X67,0X56,0X76,0XBA,0XA8,0X08,0X83,0XBA,0XAD,0XDE,0X98,0X99,0XB9,
0XDE,0X69,0X97,0X89,0X46,0X22,0X11,0X11,0X22,0X13,0X21,0X43,0X44,0X34,0X32,0X65,
0X99,0XA9,0X9A,0XAA,0X79,0X76,0X77,0X46,0X75,0X68,0X76,0XB9,0X9A,0XAA,0X89,0X64,
0X79,0X76,0X87,0XB7,0X8B,0X47,0X85,0X57,0X76,0X65,0X97,0X89,0XDA,0XEE,0XDE,0XDC,
0XAC,0X9A,0X66,0X58,0X63,0X86,0X67,0X87,0X17,0X51,0XD8,0XCC,0X8C,0XCC,0XCA,0XCC,
0XED,0X9D,0X86,0X67,0X55,0X23,0X11,0X22,0X33,0X12,0X21,0X44,0X44,0X24,0X32,0X53,
0X89,0XB8,0X9D,0XA8,0X9B,0X67,0X57,0X57,0X64,0X67,0X86,0XBA,0XAA,0XBB,0X8A,0X54,
0XBB,0X68,0X66,0X66,0XA9,0X87,0X45,0X76,0X74,0X69,0XA9,0XDB,0XFF,0XFF,0XFF,0XFF,
0XDF,0XBC,0X8A,0X56,0X66,0X55,0X75,0X46,0X68,0X40,0X97,0X87,0XB8,0X9C,0XED,0XCD,
0X89,0XAC,0X66,0X55,0X54,0X24,0X02,0X11,0X01,0X00,0X21,0X21,0X43,0X22,0X31,0X43,
0X89,0XA9,0XCB,0XAB,0X89,0X89,0X77,0X65,0X66,0X66,0X87,0XA9,0XCB,0XFC,0XAE,0X65,
0X99,0X8B,0X64,0X56,0X54,0X55,0X67,0X75,0X68,0X98,0XFD,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XEE,0XAD,0X88,0X57,0X55,0X98,0X57,0X78,0X40,0XCA,0XB8,0XBE,0X88,0XDA,0XDE,
0XBD,0X68,0X46,0X54,0X65,0X35,0X12,0X11,0X11,0X00,0X22,0X21,0X44,0X23,0X32,0X43,
0XA9,0X9A,0X97,0X9B,0X8A,0XA9,0XAA,0X66,0X57,0X66,0X98,0X9A,0XB9,0XCC,0X8C,0X56,
0X76,0X98,0X46,0X66,0X34,0X45,0X65,0X54,0X89,0XEB,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XEF,0XAD,0X67,0X76,0X78,0X36,0X43,0X31,0X77,0XCB,0XBB,0X78,0XB8,0XBA,
0XED,0XAD,0X68,0X33,0X65,0X46,0X23,0X11,0X11,0X22,0X22,0X21,0X35,0X22,0X33,0X43,
0XB8,0X99,0X67,0X76,0X89,0X99,0X7A,0X86,0X68,0X76,0XA8,0XBB,0XAC,0X78,0X45,0X66,
0X96,0X79,0X76,0X54,0X35,0X65,0X65,0X56,0XC7,0XFF,0XFF,0XFF,0XEF,0XEE,0XEE,0XFF,
0XFF,0XFF,0XFF,0XBF,0X87,0X77,0X46,0X13,0X73,0X46,0XA4,0X9B,0X9A,0X97,0XCC,0XCC,
0XDC,0XCF,0XAA,0X47,0X65,0X55,0X33,0X02,0X01,0X21,0X12,0X21,0X46,0X22,0X33,0X32,
0XA9,0X88,0X67,0X85,0X9A,0X78,0X68,0X75,0X65,0X76,0XA9,0XCB,0XAB,0X46,0X64,0X66,
0XA6,0XDE,0X8A,0X45,0X56,0X43,0X57,0X87,0XFC,0XFF,0XEF,0XFF,0XEE,0XEE,0XDE,0XFE,
0XFF,0XFE,0XFF,0XEF,0X8A,0X67,0X45,0X54,0X98,0X25,0X84,0XB9,0X7B,0XB8,0XCD,0XAC,
0XDB,0X7A,0X88,0X68,0X66,0X66,0X34,0X12,0X01,0X10,0X21,0X11,0X33,0X22,0X43,0X34,
0X97,0X78,0X67,0X86,0XAA,0X8B,0X89,0X77,0X56,0X86,0XA9,0X89,0X68,0X75,0X69,0X97,
0X57,0X75,0X99,0X47,0X54,0X55,0X54,0XD8,0XFF,0XFF,0XFF,0XEF,0XEE,0XEE,0XEE,0XDE,
0XED,0XFE,0XFF,0XFF,0X8C,0X67,0X86,0X78,0X34,0X35,0X64,0X87,0X67,0X96,0X9A,0XB8,
0X9E,0X66,0X66,0X78,0X88,0X77,0X45,0X13,0X11,0X11,0X11,0X01,0X32,0X44,0X54,0X45,
0X87,0X77,0X78,0X87,0X98,0X69,0X86,0X89,0X66,0X87,0X88,0X68,0X86,0XBD,0XCB,0XDC,
0X7D,0X54,0X35,0X65,0X35,0X64,0X68,0XF9,0XFF,0XFF,0XEE,0XDE,0XDD,0XDD,0XDD,0XDD,
0XDD,0XEE,0XFF,0XFF,0XDF,0X98,0X8A,0X36,0X62,0X48,0XA5,0XEB,0X69,0XA8,0X9A,0XD9,
0X7B,0XBB,0X67,0X88,0X9B,0X78,0X46,0X12,0X01,0X10,0X12,0X32,0X66,0X76,0X56,0X45,
0X87,0X79,0X75,0X68,0X78,0X66,0X77,0X57,0X55,0X97,0X78,0X56,0XF9,0XAD,0XCA,0XAE,
0XDB,0X57,0X56,0X32,0X55,0X54,0X97,0XFE,0XFF,0XFF,0XEE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XED,0XFE,0XFF,0XFF,0X6A,0X25,0X52,0X77,0X66,0X96,0X9C,0X95,0XCB,0XAC,0X78,
0XA7,0XCD,0X7A,0XA8,0X9B,0X99,0X57,0X13,0X01,0X10,0X43,0X64,0X37,0X52,0X57,0X44,
0X87,0X99,0X88,0X78,0X67,0X55,0X97,0X67,0X66,0X97,0X89,0X77,0XBB,0XBA,0X8A,0XA9,
0X87,0X78,0X86,0X45,0X55,0X86,0X88,0XFE,0XFE,0XFF,0XEE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XED,0XFE,0XFF,0XFF,0X8C,0X67,0X97,0X76,0X68,0X44,0X45,0XC7,0XDD,0XBD,0XBA,
0XA8,0X9D,0X78,0X75,0X89,0XB9,0X59,0X24,0X00,0X11,0X33,0X53,0X34,0X42,0X56,0X34,
0X77,0XAA,0X89,0XB9,0X8B,0X45,0X76,0X66,0X56,0XA8,0XAB,0X67,0X87,0XAB,0X98,0X98,
0X68,0X76,0X46,0X65,0X66,0X55,0XA7,0XFD,0XFF,0XEF,0XEE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XEE,0XFF,0XFF,0XAE,0X98,0X79,0X77,0X36,0X41,0X96,0XEB,0XDF,0X88,0XFB,
0X8C,0X77,0XA8,0XBA,0X77,0XBA,0X6A,0X25,0X11,0X11,0X33,0X43,0X34,0X43,0X34,0X23,
0X78,0X99,0X77,0XA8,0X8A,0X89,0X88,0X76,0X65,0XB8,0X9B,0X78,0XA6,0XAB,0X78,0X89,
0X89,0X98,0X46,0X43,0X65,0X88,0XD7,0XFF,0XFF,0XEF,0XEE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XED,0XFF,0XEF,0XDF,0XA9,0X8A,0X46,0X24,0X42,0XA7,0XA9,0X6A,0X97,0X98,
0XCB,0X66,0XBB,0XFD,0XAC,0XBB,0X8C,0X35,0X11,0X11,0X33,0X33,0X43,0X43,0X45,0X23,
0X88,0X99,0X89,0X78,0X76,0X57,0X77,0X58,0X75,0XC9,0X9B,0X88,0X76,0X58,0X76,0X77,
0X98,0X87,0X6A,0X65,0X55,0X86,0XFB,0XFF,0XFF,0XEF,0XDE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XED,0XFF,0XFF,0XDF,0X57,0X45,0X23,0X54,0XA7,0X9A,0X89,0XC9,0XED,0XAA,
0XFD,0XA9,0XDD,0XBB,0XCD,0XCA,0X8C,0X35,0X11,0X32,0X22,0X34,0X33,0X32,0X54,0X34,
0X87,0X78,0X97,0X68,0X76,0X66,0X66,0X56,0X65,0X99,0XB9,0X69,0X33,0X33,0X74,0X8C,
0X98,0X99,0X78,0X56,0X55,0X87,0XFC,0XFF,0XFF,0XEF,0XDE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XDD,0XFE,0XFF,0XFF,0X6A,0X44,0X65,0X88,0X77,0X86,0XA9,0XCC,0XA9,0XBA,
0XBC,0X87,0XEA,0XAB,0XCD,0XAB,0X7A,0X25,0X11,0X32,0X33,0X44,0X33,0X43,0X44,0X44,
0X66,0X87,0X76,0X79,0X87,0X67,0X76,0X56,0X75,0X98,0X99,0X46,0X53,0X97,0X35,0XC7,
0XBB,0XDB,0X7A,0X45,0X44,0X63,0XFB,0XFF,0XFF,0XEF,0XDE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XDD,0XFE,0XFF,0XFF,0X9C,0X87,0X57,0X34,0X43,0X85,0XAA,0XA9,0X79,0XA9,
0X7C,0X65,0XA9,0X98,0XCA,0XAC,0X78,0X24,0X01,0X31,0X33,0X33,0X65,0X55,0X45,0X55,
0X67,0X76,0X66,0X76,0X67,0X67,0X66,0X55,0X75,0X88,0XBB,0X35,0XE9,0X9C,0X9A,0X35,
0X32,0X55,0X45,0X34,0X54,0X75,0XFC,0XFF,0XFF,0XEF,0XDE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XDD,0XFE,0XFF,0XFF,0X8C,0X57,0X44,0X65,0X86,0X88,0X88,0X99,0X98,0X89,
0X89,0X9B,0X97,0X8B,0XB7,0X8C,0X56,0X23,0X01,0X31,0X32,0X33,0X87,0X78,0X66,0X77,
0X77,0X65,0X77,0X66,0X56,0X66,0X56,0X44,0X66,0XA8,0X89,0X54,0XAE,0X88,0X87,0X89,
0X67,0X56,0X34,0X33,0X43,0X85,0XFC,0XFF,0XFF,0XEF,0XDE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XDD,0XFE,0XFF,0XFF,0X9D,0X78,0X57,0X44,0X86,0X88,0X79,0X87,0X89,0X76,
0X75,0XA9,0X6A,0X78,0XD6,0X8D,0X45,0X23,0X01,0X31,0X34,0X53,0X66,0X77,0X66,0X45,
0X77,0X66,0X66,0X67,0X56,0X65,0X56,0X45,0X65,0X87,0X24,0X63,0X8D,0X87,0X78,0X66,
0X88,0X88,0X67,0X35,0X43,0X75,0XFC,0XFF,0XFF,0XEF,0XDE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XDD,0XFE,0XFF,0XFF,0X6D,0X55,0X55,0X44,0X76,0XA7,0XA8,0XCB,0X9B,0XAD,
0X75,0XAA,0X89,0X77,0XC8,0X8C,0X35,0X23,0X11,0X32,0X66,0X75,0X67,0X55,0X44,0X34,
0X78,0X76,0X66,0X88,0X67,0X66,0X55,0X44,0X76,0X46,0X23,0X33,0X6B,0X95,0X78,0X34,
0X54,0X65,0X56,0X34,0X33,0X64,0XFC,0XFF,0XFF,0XEF,0XDE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XDD,0XFE,0XFF,0XEF,0X7C,0X87,0X77,0X66,0X86,0X98,0XAA,0XCB,0XDE,0XBC,
0XA6,0XBC,0XA9,0X99,0XAA,0X79,0X45,0X23,0X21,0X33,0X85,0X67,0X34,0X33,0X43,0X45,
0X78,0X65,0X78,0X88,0X76,0X78,0X45,0X54,0X66,0X46,0X33,0X23,0X53,0X56,0X44,0X95,
0X78,0X88,0X57,0X54,0X76,0X76,0XFC,0XFF,0XFF,0XEF,0XDE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XED,0XFF,0XFF,0XFF,0X8C,0X67,0X44,0X54,0X76,0X86,0XCA,0X9C,0XCA,0X89,
0XA8,0XAC,0X98,0X9A,0X99,0X67,0X45,0X23,0X22,0X43,0X64,0X77,0X55,0X67,0X65,0X55,
0X77,0X56,0X87,0X77,0X56,0X65,0X56,0X45,0X65,0X45,0X33,0X43,0X43,0X56,0X55,0X97,
0XAB,0X79,0X56,0X54,0X56,0X33,0XF9,0XFF,0XFF,0XEF,0XEE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XDD,0XEE,0XFF,0XFF,0XFF,0X5A,0X34,0X52,0X45,0X76,0XB9,0X99,0X79,0X66,0XA6,
0X7B,0X8A,0X66,0X79,0X66,0X66,0X34,0X33,0X12,0X42,0X54,0X65,0X76,0X89,0X67,0X55,
0X67,0X86,0X87,0X98,0X78,0X77,0X66,0X44,0X65,0X45,0X22,0X94,0X69,0X46,0X23,0X12,
0X22,0X32,0X55,0X33,0X23,0X62,0XE9,0XFF,0XFF,0XEF,0XEE,0XDD,0XDD,0XDD,0XDD,0XDD,
0XDD,0XED,0XEE,0XFF,0XFF,0XFF,0X69,0X67,0X44,0X44,0X65,0X76,0X78,0X86,0X97,0XBB,
0X6C,0X66,0X66,0X66,0X66,0X44,0X34,0X44,0X23,0X43,0X54,0X44,0X74,0X67,0X77,0X65,
0X68,0X66,0X66,0X88,0X78,0X66,0X66,0X45,0X65,0X46,0X33,0XC6,0XBB,0X38,0X42,0X34,
0X01,0X21,0X54,0X33,0X33,0X64,0XC7,0XFF,0XFF,0XFF,0XEE,0XDE,0XDD,0XDD,0XDD,0XDD,
0XDD,0XEE,0XFE,0XFF,0XFF,0XCF,0X77,0X77,0X77,0X35,0X44,0X76,0X87,0X79,0X87,0XCB,
0X6A,0X76,0X98,0X66,0X77,0X66,0X45,0X45,0X32,0X54,0X57,0X54,0X53,0X65,0X98,0X67,
0X87,0X69,0X87,0X66,0X66,0X87,0X56,0X55,0X55,0X55,0X44,0XB6,0XAA,0X25,0X54,0X55,
0X44,0X44,0X54,0X23,0X33,0X43,0X83,0XFE,0XFF,0XFF,0XEE,0XDE,0XDD,0XDD,0XDD,0XDD,
0XED,0XFE,0XFF,0XFF,0XFF,0X8D,0X57,0X44,0X77,0X65,0X45,0X53,0XA8,0XAB,0X9C,0X98,
0X58,0XA6,0X86,0X77,0X78,0X9A,0X54,0X35,0X32,0X43,0X85,0X7A,0X55,0X77,0X97,0X58,
0X75,0X87,0X66,0X55,0X76,0X78,0X55,0X45,0X65,0X56,0X55,0X54,0X48,0X81,0X7D,0X65,
0X45,0X54,0X55,0X56,0X45,0X33,0X73,0XFA,0XFF,0XFF,0XEF,0XDE,0XDE,0XDD,0XDD,0XDD,
0XEE,0XFE,0XFF,0XFF,0XEF,0X39,0X54,0X23,0X53,0X65,0XA7,0X7A,0X76,0X9A,0X89,0X98,
0X8A,0X93,0X7B,0X66,0X76,0X8A,0X54,0X34,0X33,0X43,0X54,0X89,0X88,0X68,0X75,0X47,
0X66,0X86,0X77,0X66,0X88,0X88,0X79,0X45,0X55,0X56,0X55,0X13,0X22,0XB4,0X68,0X54,
0X54,0X87,0X99,0X57,0X44,0X33,0X65,0X95,0XFE,0XFF,0XFF,0XDE,0XEE,0XEE,0XDE,0XDD,
0XEE,0XFE,0XFF,0XFF,0XCF,0X35,0X43,0X57,0X33,0X22,0X74,0XAB,0X58,0X54,0X66,0XC8,
0XDC,0X45,0X8C,0X67,0X86,0X7A,0X55,0X34,0X32,0X64,0X47,0X85,0X99,0X66,0X55,0X35,
0X67,0X65,0X77,0X88,0X77,0XB9,0X69,0X44,0X54,0X56,0X45,0X33,0X24,0X97,0X66,0X84,
0X78,0X56,0X54,0X66,0X45,0X64,0X25,0X85,0XFC,0XFF,0XFF,0XFF,0XEE,0XDE,0XEE,0XEE,
0XEE,0XFF,0XFF,0XFF,0X7C,0X58,0X44,0X97,0X78,0X98,0X26,0X75,0XDB,0X89,0X9A,0X96,
0XFD,0X09,0X62,0X45,0XC8,0X6A,0X45,0X23,0X43,0X54,0X76,0X56,0X86,0X67,0X45,0X23,
0X78,0X76,0X77,0X77,0X77,0X78,0X66,0X46,0X56,0X66,0X45,0X34,0X33,0X77,0X36,0X84,
0X58,0X65,0X97,0X89,0X36,0X55,0X52,0X66,0XD9,0XFF,0XFF,0XFF,0XDE,0XDD,0XEE,0XFE,
0XFF,0XFF,0XFF,0XDF,0X58,0X44,0X34,0X63,0X77,0XC9,0XBC,0X45,0X75,0XBB,0X89,0X86,
0X9B,0X07,0X20,0XA9,0XBB,0X57,0X46,0X22,0X53,0X55,0X74,0X59,0X74,0X68,0X45,0X23,
0X68,0X56,0X65,0X76,0X68,0X75,0X67,0X55,0X55,0X55,0X55,0X55,0X85,0X58,0X34,0X77,
0X65,0X87,0X87,0X67,0X35,0X35,0X54,0X84,0X78,0XFF,0XFF,0XFF,0XEF,0XFE,0XEF,0XFF,
0XFF,0XFF,0XFF,0X7C,0X75,0X23,0X44,0X45,0X53,0XB8,0XEC,0XBE,0X99,0XC7,0XFF,0X6B,
0X44,0X16,0X30,0XFC,0X6A,0X55,0X45,0X33,0X33,0X56,0X64,0X68,0X65,0X76,0X56,0X55,
0X78,0X56,0X55,0X66,0X56,0X76,0X77,0X65,0X56,0X54,0X66,0X75,0X77,0X98,0X65,0XAA,
0XA8,0X7B,0X76,0X47,0X43,0X44,0X44,0X77,0X94,0XCB,0XFF,0XFF,0XFF,0XFF,0XEF,0XFF,
0XFF,0XFF,0XCE,0X69,0X32,0X45,0X52,0X56,0X35,0X53,0XA6,0XBC,0XAA,0X79,0X89,0X68,
0XD9,0X18,0X21,0X98,0X35,0X64,0X45,0X54,0X43,0X45,0X65,0X67,0X76,0X67,0X56,0X45,
0X77,0X55,0X66,0X65,0X66,0X88,0XA9,0X79,0X55,0X55,0X66,0X75,0X69,0X54,0X74,0X78,
0X98,0X67,0X89,0X34,0X44,0X44,0X54,0X36,0XB4,0X86,0XCA,0XED,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCE,0X8A,0X67,0X12,0X61,0X57,0X54,0X76,0X36,0X22,0X54,0X45,0X75,0X98,0X67,
0X88,0X36,0X01,0X10,0X55,0X75,0X44,0X44,0X44,0X44,0X55,0X66,0X44,0X55,0X45,0X33,
0X67,0X56,0X65,0X76,0X98,0XA9,0X99,0X58,0X44,0X55,0X55,0X76,0X68,0X22,0X53,0X55,
0X45,0X74,0X36,0X65,0X45,0X65,0X45,0X44,0X77,0X85,0X87,0XB8,0XEC,0XFF,0XFF,0XFE,
0XCE,0X6B,0X77,0X48,0X32,0X12,0X97,0X56,0X53,0XCA,0X9B,0XA7,0XCD,0X6A,0X85,0X67,
0X54,0X59,0X31,0X31,0X86,0X78,0X45,0X45,0X84,0X58,0X43,0X65,0X45,0X54,0X45,0X23,
0X66,0X56,0X55,0X64,0X76,0X89,0X78,0X65,0X45,0X44,0X65,0X65,0X57,0X02,0X52,0X45,
0X33,0X22,0X74,0X55,0X55,0X68,0X44,0X54,0X45,0X66,0X56,0X55,0X76,0XA7,0XA9,0XA9,
0X79,0X58,0X43,0X67,0X33,0X55,0X72,0X9A,0X46,0XC7,0XDC,0X7B,0XB6,0XBB,0X45,0X67,
0XD8,0X9F,0X42,0X66,0X88,0X68,0X45,0X45,0X95,0X7A,0X34,0X75,0X55,0X44,0X34,0X33,
};


const uint8_t AsciiLib[] PROGMEM =
{
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    /*  */
    0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x18,0x18,0x00,0x00,    /* ! */
    0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x28,0x28,0x50,0x00,0x00,0x00,0x00,0x00,0x00,    /* " */
    0x00,0x00,0x00,0x14,0x14,0x7E,0x14,0x14,0x28,0x7E,0x28,0x28,0x28,0x00,0x00,0x00,    /* # */
    0x00,0x00,0x10,0x38,0x54,0x54,0x50,0x30,0x18,0x14,0x54,0x54,0x38,0x10,0x10,0x00,    /* $ */
    0x00,0x00,0x00,0x44,0xA4,0xA8,0xA8,0x50,0x14,0x2A,0x2A,0x4A,0x44,0x00,0x00,0x00,    /* % */
    0x00,0x00,0x00,0x20,0x50,0x50,0x50,0x7C,0xA8,0xA8,0x98,0x88,0x76,0x00,0x00,0x00,    /* & */
    0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x08,0x30,0x00,0x00,0x00,0x00,0x00,0x00,    /* ' */
    0x00,0x00,0x04,0x08,0x10,0x10,0x20,0x20,0x20,0x20,0x20,0x10,0x10,0x08,0x04,0x00,    /* ( */
    0x00,0x00,0x20,0x10,0x08,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x08,0x10,0x20,0x00,    /* ) */
    0x00,0x00,0x00,0x00,0x10,0x10,0xD6,0x38,0x38,0xD6,0x10,0x10,0x00,0x00,0x00,0x00,    /* * */
    0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0x10,0x10,0x10,0x00,0x00,0x00,0x00,    /* + */
    0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x08,0x30,0x00,0x00,0x00,0x00,0x00,0x00,    /* , */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    /* - */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    /* . */
    0x00,0x00,0x02,0x04,0x04,0x04,0x08,0x08,0x10,0x10,0x10,0x20,0x20,0x40,0x40,0x00,    /* / */
    0x00,0x00,0x00,0x18,0x24,0x42,0x42,0x42,0x42,0x42,0x42,0x24,0x18,0x00,0x00,0x00,    /* 0 */
    0x00,0x00,0x00,0x10,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,0x00,    /* 1 */
    0x00,0x00,0x00,0x3C,0x42,0x42,0x02,0x04,0x08,0x10,0x20,0x42,0x7E,0x00,0x00,0x00,    /* 2 */
    0x00,0x00,0x00,0x3C,0x42,0x42,0x04,0x18,0x04,0x02,0x42,0x42,0x3C,0x00,0x00,0x00,    /* 3 */
    0x00,0x00,0x00,0x08,0x08,0x18,0x28,0x48,0x48,0x7E,0x08,0x08,0x1E,0x00,0x00,0x00,    /* 4 */
    0x00,0x00,0x00,0x7E,0x40,0x40,0x5C,0x62,0x02,0x02,0x42,0x42,0x3C,0x00,0x00,0x00,    /* 5 */
    0x00,0x00,0x00,0x1C,0x24,0x40,0x40,0x5C,0x62,0x42,0x42,0x42,0x3C,0x00,0x00,0x00,    /* 6 */
    0x00,0x00,0x00,0x7E,0x44,0x44,0x08,0x08,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,    /* 7 */
    0x00,0x00,0x00,0x3C,0x42,0x42,0x42,0x3C,0x24,0x42,0x42,0x42,0x3C,0x00,0x00,0x00,    /* 8 */
    0x00,0x00,0x00,0x38,0x44,0x42,0x42,0x46,0x3A,0x02,0x02,0x24,0x38,0x00,0x00,0x00,    /* 9 */
    0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,    /* : */
    0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x10,0x00,0x00,0x00,    /* ; */
    0x00,0x00,0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,    /* < */
    0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,    /* = */
    0x00,0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00,    /* > */
    0x00,0x00,0x00,0x3C,0x42,0x42,0x42,0x02,0x04,0x08,0x08,0x00,0x18,0x18,0x00,0x00,    /* ? */
    0x00,0x00,0x00,0x38,0x44,0x9A,0xAA,0xAA,0xAA,0xAA,0xB4,0x42,0x3C,0x00,0x00,0x00,    /* @ */
    0x00,0x00,0x00,0x10,0x10,0x28,0x28,0x28,0x28,0x7C,0x44,0x44,0xEE,0x00,0x00,0x00,    /* A */
    0x00,0x00,0x00,0xFC,0x42,0x42,0x44,0x78,0x44,0x42,0x42,0x42,0xFC,0x00,0x00,0x00,    /* B */
    0x00,0x00,0x00,0x3E,0x42,0x82,0x80,0x80,0x80,0x80,0x82,0x44,0x38,0x00,0x00,0x00,    /* C */
    0x00,0x00,0x00,0xF8,0x44,0x42,0x42,0x42,0x42,0x42,0x42,0x44,0xF8,0x00,0x00,0x00,    /* D */
    0x00,0x00,0x00,0xFC,0x42,0x48,0x48,0x78,0x48,0x48,0x40,0x42,0xFC,0x00,0x00,0x00,    /* E */
    0x00,0x00,0x00,0xFC,0x42,0x48,0x48,0x78,0x48,0x48,0x40,0x40,0xE0,0x00,0x00,0x00,    /* F */
    0x00,0x00,0x00,0x3C,0x44,0x84,0x80,0x80,0x80,0x8E,0x84,0x44,0x38,0x00,0x00,0x00,    /* G */
    0x00,0x00,0x00,0xEE,0x44,0x44,0x44,0x7C,0x44,0x44,0x44,0x44,0xEE,0x00,0x00,0x00,    /* H */
    0x00,0x00,0x00,0x7C,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,0x00,    /* I */
    0x00,0x00,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0xF0,0x00,0x00,    /* J */
    0x00,0x00,0x00,0xEE,0x44,0x48,0x50,0x70,0x50,0x48,0x48,0x44,0xEE,0x00,0x00,0x00,    /* K */
    0x00,0x00,0x00,0xE0,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x42,0xFE,0x00,0x00,0x00,    /* L */
    0x00,0x00,0x00,0xEE,0x6C,0x6C,0x6C,0x54,0x54,0x54,0x54,0x54,0xD6,0x00,0x00,0x00,    /* M */
    0x00,0x00,0x00,0xEE,0x64,0x64,0x54,0x54,0x54,0x4C,0x4C,0x4C,0xE4,0x00,0x00,0x00,    /* N */
    0x00,0x00,0x00,0x38,0x44,0x82,0x82,0x82,0x82,0x82,0x82,0x44,0x38,0x00,0x00,0x00,    /* O */
    0x00,0x00,0x00,0xFC,0x42,0x42,0x42,0x7C,0x40,0x40,0x40,0x40,0xE0,0x00,0x00,0x00,    /* P */
    0x00,0x00,0x00,0x38,0x44,0x82,0x82,0x82,0x82,0x82,0xB2,0x4C,0x38,0x06,0x00,0x00,    /* Q */
    0x00,0x00,0x00,0xF8,0x44,0x44,0x44,0x78,0x50,0x48,0x48,0x44,0xE6,0x00,0x00,0x00,    /* R */
    0x00,0x00,0x00,0x3E,0x42,0x42,0x40,0x30,0x0C,0x02,0x42,0x42,0x7C,0x00,0x00,0x00,    /* S */
    0x00,0x00,0x00,0xFE,0x92,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,    /* T */
    0x00,0x00,0x00,0xEE,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x38,0x00,0x00,0x00,    /* U */
    0x00,0x00,0x00,0xEE,0x44,0x44,0x44,0x28,0x28,0x28,0x28,0x10,0x10,0x00,0x00,0x00,    /* V */
    0x00,0x00,0x00,0xD6,0x54,0x54,0x54,0x54,0x6C,0x28,0x28,0x28,0x28,0x00,0x00,0x00,    /* W */
    0x00,0x00,0x00,0xEE,0x44,0x28,0x28,0x10,0x10,0x28,0x28,0x44,0xEE,0x00,0x00,0x00,    /* X */
    0x00,0x00,0x00,0xEE,0x44,0x44,0x28,0x28,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,    /* Y */
    0x00,0x00,0x00,0x3E,0x44,0x04,0x08,0x08,0x10,0x10,0x20,0x22,0x7E,0x00,0x00,0x00,    /* Z */
    0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3C,0x00,    /* [ */
    0x00,0x00,0x40,0x40,0x20,0x20,0x10,0x10,0x10,0x08,0x08,0x04,0x04,0x04,0x02,0x00,    /* \ */
    0x00,0x00,0x3C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x3C,0x00,    /* ] */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    /* ^ */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    /* _ */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    /* ` */
    0x00,0x00,0x00,0x00,0x00,0x38,0x44,0x1C,0x24,0x44,0x44,0x3E,0x00,0x00,0x00,0x00,    /* a */
    0x00,0x00,0x00,0xC0,0x40,0x40,0x5C,0x62,0x42,0x42,0x42,0x42,0x7C,0x00,0x00,0x00,    /* b */
    0x00,0x00,0x00,0x00,0x00,0x1C,0x22,0x40,0x40,0x40,0x22,0x1C,0x00,0x00,0x00,0x00,    /* c */
    0x00,0x00,0x00,0x0C,0x04,0x04,0x7C,0x84,0x84,0x84,0x84,0x8C,0x76,0x00,0x00,0x00,    /* d */
    0x00,0x00,0x00,0x00,0x00,0x3C,0x42,0x7E,0x40,0x40,0x42,0x3C,0x00,0x00,0x00,0x00,    /* e */
    0x00,0x00,0x00,0x0E,0x12,0x10,0x7C,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,0x00,    /* f */
    0x00,0x00,0x00,0x00,0x3E,0x44,0x44,0x38,0x40,0x3C,0x42,0x42,0x3C,0x00,0x00,0x00,    /* g */
    0x00,0x00,0x00,0xC0,0x40,0x40,0x5C,0x62,0x42,0x42,0x42,0x42,0xE7,0x00,0x00,0x00,    /* h */
    0x00,0x00,0x00,0x30,0x30,0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,0x00,    /* i */
    0x00,0x00,0x0C,0x0C,0x00,0x1C,0x04,0x04,0x04,0x04,0x04,0x04,0x44,0x78,0x00,0x00,    /* j */
    0x00,0x00,0x00,0xC0,0x40,0x40,0x4E,0x48,0x50,0x68,0x48,0x44,0xEE,0x00,0x00,0x00,    /* k */
    0x00,0x00,0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,0x00,    /* l */
    0x00,0x00,0x00,0x00,0x00,0xF8,0x54,0x54,0x54,0x54,0x54,0xD6,0x00,0x00,0x00,0x00,    /* m */
    0x00,0x00,0x00,0x00,0x00,0xDC,0x62,0x42,0x42,0x42,0x42,0xE7,0x00,0x00,0x00,0x00,    /* n */
    0x00,0x00,0x00,0x00,0x00,0x18,0x24,0x42,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00,    /* o */
    0x00,0x00,0x00,0x00,0xDC,0x62,0x42,0x42,0x42,0x42,0x7C,0x40,0xE0,0x00,0x00,0x00,    /* p */
    0x00,0x00,0x00,0x00,0x7C,0x84,0x84,0x84,0x84,0x8C,0x74,0x04,0x0E,0x00,0x00,0x00,    /* q */
    0x00,0x00,0x00,0x00,0x00,0xEE,0x32,0x20,0x20,0x20,0x20,0xF8,0x00,0x00,0x00,0x00,    /* r */
    0x00,0x00,0x00,0x00,0x00,0x3C,0x44,0x40,0x38,0x04,0x44,0x78,0x00,0x00,0x00,0x00,    /* s */
    0x00,0x00,0x00,0x00,0x10,0x10,0x7C,0x10,0x10,0x10,0x10,0x10,0x0C,0x00,0x00,0x00,    /* t */
    0x00,0x00,0x00,0x00,0x00,0xC6,0x42,0x42,0x42,0x42,0x46,0x3B,0x00,0x00,0x00,0x00,    /* u */
    0x00,0x00,0x00,0x00,0x00,0xE7,0x42,0x24,0x24,0x28,0x10,0x10,0x00,0x00,0x00,0x00,    /* v */
    0x00,0x00,0x00,0x00,0x00,0xD6,0x54,0x54,0x54,0x28,0x28,0x28,0x00,0x00,0x00,0x00,    /* w */
    0x00,0x00,0x00,0x00,0x00,0x6E,0x24,0x18,0x18,0x18,0x24,0x76,0x00,0x00,0x00,0x00,    /* x */
    0x00,0x00,0x00,0x00,0xE7,0x42,0x24,0x24,0x28,0x18,0x10,0x10,0xE0,0x00,0x00,0x00,    /* y */
    0x00,0x00,0x00,0x00,0x00,0x7E,0x44,0x08,0x10,0x10,0x22,0x7E,0x00,0x00,0x00,0x00,    /* z */

};

#endif
