/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
Examples for ER-TFT21-2 with ER-PCBA6318-1   Capacitive touch screen test
Display is Hardward SPI 4-Wire SPI Interface and 5V Power Supply,CTP is I2C interface.
Tested and worked with:
Works with Arduino 1.6.0 IDE  
Test ok: Arduino UNO,Arduino MEGA2560 ,Arduino DUE
If using the DUE board, please disconnect the metal pins of IO0 and IO1, 
and connect the adapter board's IO0 to IO11, IO1 to IO13,and modify the IO definition in the LCD_init.H file
****************************************************/
#include <SPI.h>
#include <Wire.h>
#include "LCD.h"
#include "SSD2828.h"
#include <stdint.h>
#include "Arduino.h"
#include "Print.h"


uint8_t addr  = 0x38;  //CTP IIC ADDRESS

#define FT3267_RST 6
#define FT3267_INT   7  



enum {
  eNORMAL = 0,
  eTEST   = 0x04,
  eSYSTEM = 0x01
};


struct TouchLocation
{
  uint16_t x;
  uint16_t y;
};

TouchLocation touchLocations[2];

uint8_t readFT3267TouchRegister( uint8_t reg );
uint8_t readFT3267TouchLocation( TouchLocation * pLoc, uint8_t num );
uint8_t readFT3267TouchAddr( uint8_t regAddr, uint8_t * pBuf, uint8_t len );



uint8_t buf[20];

uint8_t readFT3267TouchRegister( uint8_t reg )
{
  Wire.beginTransmission(addr);
  Wire.write( reg );  // register 0
  uint8_t retVal = Wire.endTransmission();
  
  uint8_t returned = Wire.requestFrom(addr, uint8_t(1) );    // request 6 uint8_ts from slave device #2
  
  if (Wire.available())
  {
    retVal = Wire.read();
  }
  
  return retVal;
}

uint8_t readFT3267TouchAddr( uint8_t regAddr, uint8_t * pBuf, uint8_t len )
{
  Wire.beginTransmission(addr);
  Wire.write( regAddr );  // register 0
  uint8_t retVal = Wire.endTransmission();
  
  uint8_t returned = Wire.requestFrom(addr, len);    // request 1 bytes from slave device #2
  
  uint8_t i;
  for (i = 0; (i < len) && Wire.available(); i++)
  {
    pBuf[i] = Wire.read();
  }
  
  return i;
}

uint8_t readFT3267TouchLocation( TouchLocation * pLoc, uint8_t num )
{
  uint8_t retVal = 0;
  uint8_t i;
  uint8_t k;
  
  do
  {
    if (!pLoc) break; // must have a buffer
    if (!num)  break; // must be able to take at least one
    
    uint8_t status = readFT3267TouchRegister(2);
    
    static uint8_t tbuf[20];
    
    if ((status & 0x0f) == 0) break; // no points detected
    
    uint8_t hitPoints = status & 0x0f;
    
    Serial.print("number of hit points = ");
    Serial.println( hitPoints );
    
    readFT3267TouchAddr( 0x03, tbuf, hitPoints*6);
    
    for (k=0,i = 0; (i < hitPoints*6)&&(k < num); k++, i += 6)
    {
      pLoc[k].x = (tbuf[i+0] & 0x0f) << 8 | tbuf[i+1];
      pLoc[k].y = (tbuf[i+2] & 0x0f) << 8 | tbuf[i+3];
    }
    
    retVal = k;
    
  } while (0);
  
  return retVal;
}

void writeFT3267TouchRegister( uint8_t reg, uint8_t val)
{
  Wire.beginTransmission(addr);
  Wire.write( reg );  // register 0
  Wire.write( val );  // value
  
  uint8_t retVal = Wire.endTransmission();  
}




void setup() {uint8_t ss[4];
// Serial.begin(9600);
 Wire.setClock(100000);
  Wire.begin();        // join i2c bus (address optional for master)   
  
  pinMode     (FT3267_INT, INPUT);//CTP INT INPUT
  pinMode(FT3267_RST, OUTPUT);  //CTP RESET OUTPUT
  digitalWrite(FT3267_RST, HIGH);//on
  delay(10);
  digitalWrite(FT3267_RST, LOW);//on
  delay(10);
  digitalWrite(FT3267_RST, HIGH);//on  

   delay(100);
   SSD2828_Initial();   
  ER5517.Parallel_Init();
  ER5517.HW_Reset();
  ER5517.System_Check_Temp();
  delay(100);
  while(ER5517.LCD_StatusRead()&0x02);
  ER5517.initial();
  ER5517.Display_ON();

 
  
 }

  uint8_t flag = 1;
void loop() {
  static uint16_t w = LCD_XSIZE_TFT;
  static uint16_t h = LCD_YSIZE_TFT; 
   unsigned int i;
   double float_data;  
  uint8_t flag = 1;
  
  ER5517.Select_Main_Window_16bpp();
  ER5517.Main_Image_Start_Address(layer1_start_addr);        
  ER5517.Main_Image_Width(LCD_XSIZE_TFT);
  ER5517.Main_Window_Start_XY(0,0);
  ER5517.Canvas_Image_Start_address(0);
  ER5517.Canvas_image_width(LCD_XSIZE_TFT);
  ER5517.Active_Window_XY(0,0);
  ER5517.Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT); 
  
  ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
  ER5517.Start_Square_Fill(); 
  
   ER5517.Foreground_color_65k(White);
  ER5517.Background_color_65k(Black);
  ER5517.CGROM_Select_Internal_CGROM();  
   ER5517.Font_Height_X1(); 
   ER5517.Font_Width_X1();  
  ER5517.Font_Select_8x16_16x16();
  ER5517.Goto_Text_XY(40,200); 
  ER5517.Show_String( "Capacitive touch screen test"); 
  ER5517.Goto_Text_XY(LCD_XSIZE_TFT/2-20,5);
  ER5517.Show_String("Clear");   
  ER5517.Goto_Text_XY(LCD_XSIZE_TFT/2-20,LCD_YSIZE_TFT-25);
  ER5517.Show_String("Exit");       
  

  
  while(flag) 
  {uint8_t attention = digitalRead(FT3267_INT);
     if (!attention) 
    {  
      Serial.println("Touch: ");
      
      uint8_t count = readFT3267TouchLocation( touchLocations, 2 );
               
        for (i = 0; i < count; i++)
        {  
        if((touchLocations[i].x>LCD_XSIZE_TFT/2-30)&&(touchLocations[i].x<LCD_XSIZE_TFT/2+30)&&(touchLocations[i].y>440)) flag=0; 
	if((touchLocations[i].x>LCD_XSIZE_TFT/2-30)&&(touchLocations[i].x<LCD_XSIZE_TFT/2+30)&&(touchLocations[i].y<40))
              {    ER5517.Foreground_color_65k(Black);
                  ER5517.Line_Start_XY(0,0);
                  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
                  ER5517.Start_Square_Fill(); 
                  
                   ER5517.Foreground_color_65k(White);
                  ER5517.Background_color_65k(Black);
                  ER5517.CGROM_Select_Internal_CGROM();  
                  ER5517.Font_Select_8x16_16x16();
                 ER5517.Goto_Text_XY(40,200); 
                ER5517.Show_String( "Capacitive touch screen test"); 
                ER5517.Goto_Text_XY(LCD_XSIZE_TFT/2-20,5);
                ER5517.Show_String("Clear");   
                ER5517.Goto_Text_XY(LCD_XSIZE_TFT/2-20,LCD_YSIZE_TFT-25);
                ER5517.Show_String("Exit");
                  break;                  
              }  
              
          else{                                    
              snprintf((char*)buf,sizeof(buf),"(%3d,%3d)",touchLocations[i].x,touchLocations[i].y); 
            const  char *str=(const char *)buf;
             ER5517.Foreground_color_65k(Red);  
            ER5517.Text_Mode();
            ER5517.Goto_Text_XY(60,100+16*i);
            ER5517.LCD_CmdWrite(0x04);
            while(*str != '\0')
            {
            ER5517.LCD_DataWrite(*str);
            ER5517.Check_Mem_WR_FIFO_not_Full();      
            ++str; 
            } 
            ER5517.Check_2D_Busy();
            ER5517.Graphic_Mode(); //back to graphic mode;
           
            if(i==0)  ER5517.DrawCircle_Fill(touchLocations[i].x,touchLocations[i].y, 3, Red);  
            else if(i==1)  ER5517.DrawCircle_Fill(touchLocations[i].x,touchLocations[i].y, 3, Green); 
      
          }
        }
     } 
    
  }
  
  ////////Drawing
  ER5517.Select_Main_Window_16bpp();
  ER5517.Main_Image_Start_Address(layer1_start_addr);				
  ER5517.Main_Image_Width(LCD_XSIZE_TFT);
  ER5517.Main_Window_Start_XY(0,0);
  ER5517.Canvas_Image_Start_address(layer1_start_addr);
  ER5517.Canvas_image_width(LCD_XSIZE_TFT);
  ER5517.Active_Window_XY(0,0);
  ER5517.Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	

  ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
  ER5517.Start_Square_Fill();

  for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
  {ER5517.Foreground_color_65k(Red);
  ER5517.Line_Start_XY(0+i,0+i);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
  ER5517.Start_Square();
  delay(10);
  }

  for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
  {ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0+i,0+i);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
  ER5517.Start_Square();
  delay(10);
  }
 delay(100);
///////////////////////////Square Of Circle
  ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
  ER5517.Start_Square_Fill();

  for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
  {ER5517.Foreground_color_65k(Green);
  ER5517.Line_Start_XY(0+i,0+i);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
  ER5517.Circle_Square_Radius_RxRy(10,10);
  ER5517.Start_Circle_Square();
  delay(10);
  }

  for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
  {ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0+i,0+i);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
  ER5517.Circle_Square_Radius_RxRy(10,10);
  ER5517.Start_Circle_Square();
  delay(10);
  }
  delay(100);

///////////////////////////Circle
  ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
  ER5517.Start_Square_Fill();

  for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
  {ER5517.Foreground_color_65k(Blue);
  ER5517.Circle_Center_XY(LCD_XSIZE_TFT/2,LCD_YSIZE_TFT/2);
  ER5517.Circle_Radius_R(i);
  ER5517.Start_Circle_or_Ellipse();
  delay(10);
  }

  for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
  {ER5517.Foreground_color_65k(Black);
  ER5517.Circle_Center_XY(LCD_XSIZE_TFT/2,LCD_YSIZE_TFT/2);
  ER5517.Circle_Radius_R(i);
  ER5517.Start_Circle_or_Ellipse();
  delay(10);
  }
  delay(100);

///////////////////////////Ellipse
  ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
  ER5517.Start_Square_Fill();

  for(i=0;i<=LCD_XSIZE_TFT/2-100;i+=8)
  {ER5517.Foreground_color_65k(White);
  ER5517.Circle_Center_XY(LCD_XSIZE_TFT/2,LCD_YSIZE_TFT/2);
  ER5517.Ellipse_Radius_RxRy(i+100,i);
  ER5517.Start_Circle_or_Ellipse();
  delay(10);
  }

  for(i=0;i<=LCD_XSIZE_TFT/2-100;i+=8)
  {ER5517.Foreground_color_65k(Black);
  ER5517.Circle_Center_XY(LCD_XSIZE_TFT/2,LCD_YSIZE_TFT/2);
  ER5517.Ellipse_Radius_RxRy(i+100,i);
  ER5517.Start_Circle_or_Ellipse();
  delay(10);
  }
  delay(100);

 ////////////////////////////Triangle
  ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
  ER5517.Start_Square_Fill();

  for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
  {ER5517.Foreground_color_65k(Yellow);
  ER5517.Triangle_Point1_XY(LCD_XSIZE_TFT/2,i);
  ER5517.Triangle_Point2_XY(i,LCD_YSIZE_TFT-1-i);
  ER5517.Triangle_Point3_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
  ER5517.Start_Triangle();
  delay(10);
  }

  for(i=0;i<=LCD_XSIZE_TFT/2-10;i+=8)
  {ER5517.Foreground_color_65k(Black);
  ER5517.Triangle_Point1_XY(LCD_XSIZE_TFT/2,i);
  ER5517.Triangle_Point2_XY(i,LCD_YSIZE_TFT-1-i);
  ER5517.Triangle_Point3_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1-i);
  ER5517.Start_Triangle();
  delay(10);
  }
  delay(100);


 ////////////////////////////line
  ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
  ER5517.Start_Square_Fill();

  for(i=0;i<=LCD_XSIZE_TFT;i+=8)
  {ER5517.Foreground_color_65k(Red);
  ER5517.Line_Start_XY(i,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1);
  ER5517.Start_Line();
  delay(10);
  }
  for(i=0;i<=LCD_YSIZE_TFT;i+=8)
  {ER5517.Foreground_color_65k(Red);
  ER5517.Line_Start_XY(0,LCD_YSIZE_TFT-1-i);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,i);
  ER5517.Start_Line();
  delay(10);
  }


  for(i=0;i<=LCD_XSIZE_TFT;i+=8)
  {ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(i,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1-i,LCD_YSIZE_TFT-1);
  ER5517.Start_Line();
  delay(10);
  }
  for(i=0;i<=LCD_YSIZE_TFT;i+=8)
  {ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,LCD_YSIZE_TFT-1-i);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,i);
  ER5517.Start_Line();
  delay(10);
  }


  delay(100);  

/////////////Internal characters 
  ER5517.Select_Main_Window_16bpp();
  ER5517.Main_Image_Start_Address(layer1_start_addr);				
  ER5517.Main_Image_Width(LCD_XSIZE_TFT);
  ER5517.Main_Window_Start_XY(0,0);
  ER5517.Canvas_Image_Start_address(layer1_start_addr);
  ER5517.Canvas_image_width(LCD_XSIZE_TFT);
  ER5517.Active_Window_XY(0,0);
  ER5517.Active_Window_WH(LCD_XSIZE_TFT,LCD_YSIZE_TFT);	
 
  
  ER5517.Foreground_color_65k(Black);
  ER5517.Line_Start_XY(0,0);
  ER5517.Line_End_XY(LCD_XSIZE_TFT-1,LCD_YSIZE_TFT-1);
  ER5517.Start_Square_Fill();



  ER5517.Background_color_65k(Black);
  ER5517.Foreground_color_65k(Red);  
  ER5517.CGROM_Select_Internal_CGROM();
  ER5517.Font_Select_8x16_16x16();
   ER5517.Font_Width_X1(); 
  ER5517.Font_Height_X1();
  ER5517.Goto_Text_XY(0,10);
  ER5517.Show_String("buydisplay.com");
  
  ER5517.Foreground_color_65k(Green);
  ER5517.Font_Select_12x24_24x24();
  ER5517.Goto_Text_XY(0,26);
  ER5517.Show_String("buydisplay.com");

  ER5517.Foreground_color_65k(Blue);
  ER5517.Font_Select_16x32_32x32();
  ER5517.Goto_Text_XY(0,50);
  ER5517.Show_String("buydisplay.com");  
  
  ER5517.Foreground_color_65k(Yellow);
  ER5517.Font_Width_X4(); 
  ER5517.Font_Height_X4();
  ER5517.Goto_Text_XY(0,90);  
  ER5517.Show_String("buydisplay.com");    
  delay(2000); 
  
  
       unsigned long im;
 for(im=0;im<4;im++)
	 {
        ER5517.DMA_24bit_Block(1,0,0,0,LCD_XSIZE_TFT,LCD_YSIZE_TFT,LCD_XSIZE_TFT,im*LCD_XSIZE_TFT*LCD_YSIZE_TFT*2);
        // Select SPI : SCS��0       SCS��1
        // SPI Clock = System Clock /{(Clk+1)*2}
        // Transfer to SDRAM address:X1
         // Transfer to SDRAM address:Y1
        // DMA data width
        // DMA data height
        // Picture's width
        // Flash address	
	  delay(2000);
 	
	 }

}



