/*************************************************** 
// Web: http://www.buydisplay.com 
EastRising Technology Co.,LTD 
Examples for ER-TFT028A3-4-4158 with Capacitive Touch Panel 
Hardward SPI 4-Wire SPI Interface 5V Power Supply 
****************************************************/ 
#include <GFX.h>    // Core graphics library
#include <SPI.h>       // this is needed for display
#include <ST7789.h>
#include <Wire.h>      // this is needed for FT6206
#include <FT6206.h>

// The FT6206 uses hardware I2C (SCL/SDA)
FT6206 ctp = FT6206();
//Arduino DUE,Arduino mega2560,Arduino UNO
// The display also uses hardware SPI
#define TFT_CS 9
#define TFT_DC 7
#define TFT_RST 10
ST7789 tft = ST7789(TFT_CS, TFT_DC,TFT_RST);

// Size of the color selection boxes and the paintbrush size
#define BOXSIZE 40
#define PENRADIUS 3
int oldcolor, currentcolor;

void setup(void) {
  while (!Serial);     // used for leonardo debugging
 
  Serial.begin(115200);
  Serial.println(F("Cap Touch Paint!"));
  
  tft.begin();

  if (! ctp.begin(40)) {  // pass in 'sensitivity' coefficient
    Serial.println("Couldn't start FT6206 touchscreen controller");
    while (1);
  }

  Serial.println("Capacitive touchscreen started");
  
  tft.fillScreen(ST7789_BLACK);
  
  // make the color selection boxes
  tft.fillRect(0, 0, BOXSIZE, BOXSIZE, ST7789_RED);
  tft.fillRect(BOXSIZE, 0, BOXSIZE, BOXSIZE, ST7789_YELLOW);
  tft.fillRect(BOXSIZE*2, 0, BOXSIZE, BOXSIZE, ST7789_GREEN);
  tft.fillRect(BOXSIZE*3, 0, BOXSIZE, BOXSIZE, ST7789_CYAN);
  tft.fillRect(BOXSIZE*4, 0, BOXSIZE, BOXSIZE, ST7789_BLUE);
  tft.fillRect(BOXSIZE*5, 0, BOXSIZE, BOXSIZE, ST7789_MAGENTA);
 
  // select the current color 'red'
  tft.drawRect(0, 0, BOXSIZE, BOXSIZE, ST7789_WHITE);
  currentcolor = ST7789_RED;
}

void loop() {
  // Wait for a touch
  if (! ctp.touched()) {
    return;
  }

  // Retrieve a point  
  TS_Point p = ctp.getPoint();
  
 /*
  // Print out raw data from screen touch controller
  Serial.print("X = "); Serial.print(p.x);
  Serial.print("\tY = "); Serial.print(p.y);
  Serial.print(" -> ");
 */


  // flip it around to match the screen.
  p.x = map(p.x, 0, 240, 240, 0);
  p.y = map(p.y, 0, 320, 320, 0);


  // Print out the remapped (rotated) coordinates
  Serial.print("("); Serial.print(p.x);
  Serial.print(", "); Serial.print(p.y);
  Serial.println(")");
  

  if (p.y < BOXSIZE) {
     oldcolor = currentcolor;

     if (p.x < BOXSIZE) { 
       currentcolor = ST7789_RED; 
       tft.drawRect(0, 0, BOXSIZE, BOXSIZE, ST7789_WHITE);
     } else if (p.x < BOXSIZE*2) {
       currentcolor = ST7789_YELLOW;
       tft.drawRect(BOXSIZE, 0, BOXSIZE, BOXSIZE, ST7789_WHITE);
     } else if (p.x < BOXSIZE*3) {
       currentcolor = ST7789_GREEN;
       tft.drawRect(BOXSIZE*2, 0, BOXSIZE, BOXSIZE, ST7789_WHITE);
     } else if (p.x < BOXSIZE*4) {
       currentcolor = ST7789_CYAN;
       tft.drawRect(BOXSIZE*3, 0, BOXSIZE, BOXSIZE, ST7789_WHITE);
     } else if (p.x < BOXSIZE*5) {
       currentcolor = ST7789_BLUE;
       tft.drawRect(BOXSIZE*4, 0, BOXSIZE, BOXSIZE, ST7789_WHITE);
     } else if (p.x <= BOXSIZE*6) {
       currentcolor = ST7789_MAGENTA;
       tft.drawRect(BOXSIZE*5, 0, BOXSIZE, BOXSIZE, ST7789_WHITE);
     }

     if (oldcolor != currentcolor) {
        if (oldcolor == ST7789_RED) 
          tft.fillRect(0, 0, BOXSIZE, BOXSIZE, ST7789_RED);
        if (oldcolor == ST7789_YELLOW) 
          tft.fillRect(BOXSIZE, 0, BOXSIZE, BOXSIZE, ST7789_YELLOW);
        if (oldcolor == ST7789_GREEN) 
          tft.fillRect(BOXSIZE*2, 0, BOXSIZE, BOXSIZE, ST7789_GREEN);
        if (oldcolor == ST7789_CYAN) 
          tft.fillRect(BOXSIZE*3, 0, BOXSIZE, BOXSIZE, ST7789_CYAN);
        if (oldcolor == ST7789_BLUE) 
          tft.fillRect(BOXSIZE*4, 0, BOXSIZE, BOXSIZE, ST7789_BLUE);
        if (oldcolor == ST7789_MAGENTA) 
          tft.fillRect(BOXSIZE*5, 0, BOXSIZE, BOXSIZE, ST7789_MAGENTA);
     }
  }
  if (((p.y-PENRADIUS) > BOXSIZE) && ((p.y+PENRADIUS) < tft.height())) {
    tft.fillCircle(p.x, p.y, PENRADIUS, currentcolor);
  }
}
