/***************************************************
// web: http://www.buydisplay.com
EastRising Technology Co.,LTD
Examples for ER-TFT028A3-4-4158 with Resistive Touch Panel
Software SPI 4-Wire SPI Interface 5V Power Supply
****************************************************/

#include <UTFT.h>
#include <UTouch.h>
// Initialize display
// Library only supports software SPI at this time

UTFT myGLCD(ST7789_4L,3,2,9,10,7);    //LCD:  4Line  serial interface      SDI  SCL  /CS  /RST  D/C    NOTE:Only support  DUE   MEGA  UNO

UTouch  myTouch( 2, 6, 3, 4, 5);      //RTP: byte tclk, byte tcs, byte din, byte dout, byte irq

void setup()
{
 // The following two lines are needed for the  display
// module to enable the backlight. If you are using any other 
// display module these lines should be commented out.
// -------------------------------------------------------------
 // pinMode(41, OUTPUT);
 // digitalWrite(41, HIGH);
// -------------------------------------------------------------
   
  myGLCD.InitLCD();
  myGLCD.clrScr();

  myTouch.InitTouch();
  myTouch.setPrecision(PREC_MEDIUM);
}

void loop()
{
  long x, y;
  
  while (myTouch.dataAvailable() == true)
  {
    myTouch.read();
    x = myTouch.getX();
    y = myTouch.getY();
    if ((x!=-1) and (y!=-1))
    {
      myGLCD.drawPixel (x, y);
    }
  }
}

