// *** Hardwarespecific functions ***
void UTFT::_hw_special_init()
{
}

void UTFT::LCD_Writ_Bus(char VH,char VL, byte mode)
{   cbi(P_CS, B_CS);
	switch (mode)
	{
	case 1:
		if (display_serial_mode==SERIAL_4PIN)
		{
		if (VH==1)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
		}
		else
		{
		if (VH==1)
			sbi(P_RS, B_RS);
		else
			cbi(P_RS, B_RS);
		}

		if (VL & 0x80)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
		if (VL & 0x40)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
		if (VL & 0x20)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
		if (VL & 0x10)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
		if (VL & 0x08)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
		if (VL & 0x04)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
		if (VL & 0x02)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
		if (VL & 0x01)
			sbi(P_SDA, B_SDA);
		else
			cbi(P_SDA, B_SDA);
		pulse_low(P_SCL, B_SCL);
			sbi(P_CS, B_CS);
		break;
	case 8:
		cport (PORTD, 0xF0);
		sport (PORTD, (VH & 0x0F));
		cport (PORTB, 0xF0);
		sport (PORTB, (VH & 0xF0)>>4);
		pulse_low(P_WR, B_WR);
		cport (PORTD, 0xF0);
		sport (PORTD, (VL & 0x0F));
		cport (PORTB, 0xF0);
		sport (PORTB, (VL & 0xF0)>>4);
		pulse_low(P_WR, B_WR);
		break;
	case 16:
		cport (PORTD, 0x90);
		sport (PORTD, (VH & 0x0F) | ((VL & 0x03)<<5));
		PORTB = ((VH & 0xF0)>>4) | ((VL & 0x3C)<<2);
		cport (PORTA, 0x3F);
		sport (PORTA, ((VL & 0x40)<<1) | ((VL & 0x80)>>1));
		pulse_low(P_WR, B_WR);
		break;
	case LATCHED_16:
		cport (PORTD, 0xF0);
		sport (PORTD, (VH & 0x0F));
		cport (PORTB, 0xF0);
		sport (PORTB, (VH & 0xF0)>>4);
		cbi(P_ALE, B_ALE);
		pulse_high(P_ALE, B_ALE);
		cbi(P_CS, B_CS);
		cport (PORTD, 0xF0);
		sport (PORTD, (VL & 0x0F));
		cport (PORTB, 0xF0);
		sport (PORTB, (VL & 0xF0)>>4);
		pulse_low(P_WR, B_WR);
		sbi(P_CS, B_CS);
		break;
	}
}

void UTFT::_set_direction_registers(byte mode)
{
	DDRB |= 0x0F;
	DDRD |= 0x0F;
	if (mode==16)
	{
		DDRB =  0xFF;
		DDRD |= 0x6F;
		DDRA |= 0xC0;
	}

}

void UTFT::_fast_fill_16(int ch, int cl, long pix)
{
	long blocks;

	cport (PORTD, 0x90);
	sport (PORTD, (ch & 0x0F) | ((cl & 0x03)<<5));
	PORTB = ((ch & 0xF0)>>4) | ((cl & 0x3C)<<2);
	cport (PORTA, 0x3F);
	sport (PORTA, ((cl & 0x40)<<1) | ((cl & 0x80)>>1));

	blocks = pix/16;
	for (int i=0; i<blocks; i++)
	{
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);
	}
	if ((pix % 16) != 0)
		for (int i=0; i<(pix % 16)+1; i++)
		{
			pulse_low(P_WR, B_WR);
		}
}

void UTFT::_fast_fill_8(int ch, long pix)
{
	long blocks;

	cport (PORTD, 0xF0);
	sport (PORTD, (ch & 0x0F));
	cport (PORTB, 0xF0);
	sport (PORTB, (ch & 0xF0)>>4);

	blocks = pix/16;
	for (int i=0; i<blocks; i++)
	{
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
	}
	if ((pix % 16) != 0)
		for (int i=0; i<(pix % 16)+1; i++)
		{
			pulse_low(P_WR, B_WR);pulse_low(P_WR, B_WR);
		}
}
