#ifndef LCD_init_h
#define LCD_init_h
#include "Arduino.h"
//#include <avr/pgmspace.h>
#include <SPI.h>

#define  SPI_RST     5
#define  SPI_CS     2
#define  SPI_CLK    1  // DUE   13
#define  SPI_DI     0 //  DUE   11 


#define  SPI_RST_0   digitalWrite(SPI_RST, LOW)
#define  SPI_RST_1   digitalWrite(SPI_RST, HIGH)
#define  SPI_CS_0  digitalWrite(SPI_CS, LOW)
#define  SPI_CS_1  digitalWrite(SPI_CS, HIGH)
#define  SPI_CLK_0   digitalWrite(SPI_CLK, LOW)
#define  SPI_CLK_1   digitalWrite(SPI_CLK, HIGH)
#define  SPI_DI_0   digitalWrite(SPI_DI, LOW)
#define  SPI_DI_1   digitalWrite(SPI_DI, HIGH)

#define hsize 600
#define vsize 1024
#define LINE 4

void SPI_WriteCmd(unsigned char Sdata) { 
	unsigned char i;	
	SPI_CS_0;
	SPI_DI_0;
	SPI_CLK_0; 
	SPI_CLK_1;
	
	for(i=8; i>0; i--) {
		if(Sdata&0x80)
			SPI_DI_1;
		else
			SPI_DI_0;
		SPI_CLK_0; 
		SPI_CLK_1;
		Sdata <<= 1;
	}
	SPI_CLK_0;
	SPI_CS_1;
}

void SPI_WriteData(unsigned char Sdata) {
	unsigned char i;
	SPI_CS_0;
	SPI_DI_1;
	SPI_CLK_0; 
	SPI_CLK_1;
	
	for(i=8; i>0; i--) {
		if(Sdata&0x80)
			SPI_DI_1;
		else
			SPI_DI_0;
		SPI_CLK_0; 
		SPI_CLK_1;
		Sdata <<= 1;
	}
	SPI_CLK_0;
	SPI_CS_1;
}


void GP_COMMAD_PA(unsigned int num) 
{
	SPI_WriteCmd(0xbc);
	SPI_WriteData(num&0xff);	
	SPI_WriteData((num>>8)&0xff);	
	SPI_WriteCmd(0xbf);
}




void  LCD_initial()
{
  GP_COMMAD_PA(2);SPI_WriteData(0xE0);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0xE1);  SPI_WriteData(0x93);
     GP_COMMAD_PA(2);SPI_WriteData(0xE2);  SPI_WriteData(0x65);
     GP_COMMAD_PA(2);SPI_WriteData(0xE3);  SPI_WriteData(0xF8);
     GP_COMMAD_PA(2);SPI_WriteData(0x80);  SPI_WriteData(0x03);

     GP_COMMAD_PA(2);SPI_WriteData(0xE0);  SPI_WriteData(0x01);

     GP_COMMAD_PA(2);SPI_WriteData(0x00);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0x01);  SPI_WriteData(0x66); 
     GP_COMMAD_PA(2);SPI_WriteData(0x03);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0x04);  SPI_WriteData(0x43);

     GP_COMMAD_PA(2);SPI_WriteData(0x0C);  SPI_WriteData(0x74);

     GP_COMMAD_PA(2);SPI_WriteData(0x17);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0x18);  SPI_WriteData(0xB0);
     GP_COMMAD_PA(2);SPI_WriteData(0x19);  SPI_WriteData(0x01);
     GP_COMMAD_PA(2);SPI_WriteData(0x1A);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0x1B);  SPI_WriteData(0xB0);
     GP_COMMAD_PA(2);SPI_WriteData(0x1C);  SPI_WriteData(0x01);
     GP_COMMAD_PA(2);SPI_WriteData(0x24);  SPI_WriteData(0xFE);

     GP_COMMAD_PA(2);SPI_WriteData(0x35);  SPI_WriteData(0x28);

     GP_COMMAD_PA(2);SPI_WriteData(0x37);  SPI_WriteData(0x29);

     GP_COMMAD_PA(2);SPI_WriteData(0x38);  SPI_WriteData(0x05);
     GP_COMMAD_PA(2);SPI_WriteData(0x39);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0x3A);  SPI_WriteData(0x01);
     GP_COMMAD_PA(2);SPI_WriteData(0x3C);  SPI_WriteData(0x90);
     GP_COMMAD_PA(2);SPI_WriteData(0x3D);  SPI_WriteData(0xFF);
     GP_COMMAD_PA(2);SPI_WriteData(0x3E);  SPI_WriteData(0xFF);
     GP_COMMAD_PA(2);SPI_WriteData(0x3F);  SPI_WriteData(0xFF);

     GP_COMMAD_PA(2);SPI_WriteData(0x40);  SPI_WriteData(0x02);
     GP_COMMAD_PA(2);SPI_WriteData(0x41);  SPI_WriteData(0x80);
     GP_COMMAD_PA(2);SPI_WriteData(0x42);  SPI_WriteData(0x9D);
     GP_COMMAD_PA(2);SPI_WriteData(0x43);  SPI_WriteData(0x18);
     GP_COMMAD_PA(2);SPI_WriteData(0x44);  SPI_WriteData(0x0B);
     GP_COMMAD_PA(2);SPI_WriteData(0x45);  SPI_WriteData(0x28);

     GP_COMMAD_PA(2);SPI_WriteData(0x55);  SPI_WriteData(0x02);
     GP_COMMAD_PA(2);SPI_WriteData(0x57);  SPI_WriteData(0x89);
     GP_COMMAD_PA(2);SPI_WriteData(0x59);  SPI_WriteData(0x0A);
     GP_COMMAD_PA(2);SPI_WriteData(0x5A);  SPI_WriteData(0x28);
     GP_COMMAD_PA(2);SPI_WriteData(0x5B);  SPI_WriteData(0x15);

     GP_COMMAD_PA(2);SPI_WriteData(0x5D);  SPI_WriteData(0x7F);
     GP_COMMAD_PA(2);SPI_WriteData(0x5E);  SPI_WriteData(0x6A);
     GP_COMMAD_PA(2);SPI_WriteData(0x5F);  SPI_WriteData(0x60);
     GP_COMMAD_PA(2);SPI_WriteData(0x60);  SPI_WriteData(0x5A);
     GP_COMMAD_PA(2);SPI_WriteData(0x61);  SPI_WriteData(0x5D);
     GP_COMMAD_PA(2);SPI_WriteData(0x62);  SPI_WriteData(0x52);
     GP_COMMAD_PA(2);SPI_WriteData(0x63);  SPI_WriteData(0x59);
     GP_COMMAD_PA(2);SPI_WriteData(0x64);  SPI_WriteData(0x45);
     GP_COMMAD_PA(2);SPI_WriteData(0x65);  SPI_WriteData(0x5E);
     GP_COMMAD_PA(2);SPI_WriteData(0x66);  SPI_WriteData(0x5B);
     GP_COMMAD_PA(2);SPI_WriteData(0x67);  SPI_WriteData(0x58);
     GP_COMMAD_PA(2);SPI_WriteData(0x68);  SPI_WriteData(0x6F);
     GP_COMMAD_PA(2);SPI_WriteData(0x69);  SPI_WriteData(0x57);
     GP_COMMAD_PA(2);SPI_WriteData(0x6A);  SPI_WriteData(0x56);
     GP_COMMAD_PA(2);SPI_WriteData(0x6B);  SPI_WriteData(0x44);
     GP_COMMAD_PA(2);SPI_WriteData(0x6C);  SPI_WriteData(0x3B);
     GP_COMMAD_PA(2);SPI_WriteData(0x6D);  SPI_WriteData(0x2B);
     GP_COMMAD_PA(2);SPI_WriteData(0x6E);  SPI_WriteData(0x15);
     GP_COMMAD_PA(2);SPI_WriteData(0x6F);  SPI_WriteData(0x02);
     GP_COMMAD_PA(2);SPI_WriteData(0x70);  SPI_WriteData(0x67);
     GP_COMMAD_PA(2);SPI_WriteData(0x71);  SPI_WriteData(0x6A);
     GP_COMMAD_PA(2);SPI_WriteData(0x72);  SPI_WriteData(0x60);
     GP_COMMAD_PA(2);SPI_WriteData(0x73);  SPI_WriteData(0x5A);
     GP_COMMAD_PA(2);SPI_WriteData(0x74);  SPI_WriteData(0x5D);
     GP_COMMAD_PA(2);SPI_WriteData(0x75);  SPI_WriteData(0x52);
     GP_COMMAD_PA(2);SPI_WriteData(0x76);  SPI_WriteData(0x59);
     GP_COMMAD_PA(2);SPI_WriteData(0x77);  SPI_WriteData(0x45);
     GP_COMMAD_PA(2);SPI_WriteData(0x78);  SPI_WriteData(0x5E);
     GP_COMMAD_PA(2);SPI_WriteData(0x79);  SPI_WriteData(0x5B);
     GP_COMMAD_PA(2);SPI_WriteData(0x7A);  SPI_WriteData(0x58);
     GP_COMMAD_PA(2);SPI_WriteData(0x7B);  SPI_WriteData(0x6F);
     GP_COMMAD_PA(2);SPI_WriteData(0x7C);  SPI_WriteData(0x57);
     GP_COMMAD_PA(2);SPI_WriteData(0x7D);  SPI_WriteData(0x56);
     GP_COMMAD_PA(2);SPI_WriteData(0x7E);  SPI_WriteData(0x44);
     GP_COMMAD_PA(2);SPI_WriteData(0x7F);  SPI_WriteData(0x3B);
     GP_COMMAD_PA(2);SPI_WriteData(0x80);  SPI_WriteData(0x2B);
     GP_COMMAD_PA(2);SPI_WriteData(0x81);  SPI_WriteData(0x15);
     GP_COMMAD_PA(2);SPI_WriteData(0x82);  SPI_WriteData(0x02);


     GP_COMMAD_PA(2);SPI_WriteData(0xE0);  SPI_WriteData(0x02);

     GP_COMMAD_PA(2);SPI_WriteData(0x00);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x01);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x02);  SPI_WriteData(0x51);
     GP_COMMAD_PA(2);SPI_WriteData(0x03);  SPI_WriteData(0x50);
     GP_COMMAD_PA(2);SPI_WriteData(0x04);  SPI_WriteData(0x5E);
     GP_COMMAD_PA(2);SPI_WriteData(0x05);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x06);  SPI_WriteData(0x45);
     GP_COMMAD_PA(2);SPI_WriteData(0x07);  SPI_WriteData(0x47);
     GP_COMMAD_PA(2);SPI_WriteData(0x08);  SPI_WriteData(0x49);
     GP_COMMAD_PA(2);SPI_WriteData(0x09);  SPI_WriteData(0x4B);
     GP_COMMAD_PA(2);SPI_WriteData(0x0A);  SPI_WriteData(0x41);
     GP_COMMAD_PA(2);SPI_WriteData(0x0B);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x0C);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x0D);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x0E);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x0F);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x10);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x11);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x12);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x13);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x14);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x15);  SPI_WriteData(0x5F);


     GP_COMMAD_PA(2);SPI_WriteData(0x16);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x17);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x18);  SPI_WriteData(0x51);
     GP_COMMAD_PA(2);SPI_WriteData(0x19);  SPI_WriteData(0x50);
     GP_COMMAD_PA(2);SPI_WriteData(0x1A);  SPI_WriteData(0x5E);
     GP_COMMAD_PA(2);SPI_WriteData(0x1B);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x1C);  SPI_WriteData(0x44);
     GP_COMMAD_PA(2);SPI_WriteData(0x1D);  SPI_WriteData(0x46);
     GP_COMMAD_PA(2);SPI_WriteData(0x1E);  SPI_WriteData(0x48);
     GP_COMMAD_PA(2);SPI_WriteData(0x1F);  SPI_WriteData(0x4A);
     GP_COMMAD_PA(2);SPI_WriteData(0x20);  SPI_WriteData(0x40);
     GP_COMMAD_PA(2);SPI_WriteData(0x21);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x22);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x23);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x24);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x25);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x26);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x27);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x28);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x29);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x2A);  SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);SPI_WriteData(0x2B);  SPI_WriteData(0x5F);




     GP_COMMAD_PA(2);SPI_WriteData(0x58);  SPI_WriteData(0x40);
     GP_COMMAD_PA(2);SPI_WriteData(0x5B);  SPI_WriteData(0x10);
     GP_COMMAD_PA(2);SPI_WriteData(0x5C);  SPI_WriteData(0x07);
     GP_COMMAD_PA(2);SPI_WriteData(0x5D);  SPI_WriteData(0x40);
     GP_COMMAD_PA(2);SPI_WriteData(0x5E);  SPI_WriteData(0x01);
     GP_COMMAD_PA(2);SPI_WriteData(0x5F);  SPI_WriteData(0x02);
     GP_COMMAD_PA(2);SPI_WriteData(0x60);  SPI_WriteData(0x33);
     GP_COMMAD_PA(2);SPI_WriteData(0x61);  SPI_WriteData(0x01);
     GP_COMMAD_PA(2);SPI_WriteData(0x62);  SPI_WriteData(0x02);
     GP_COMMAD_PA(2);SPI_WriteData(0x63);  SPI_WriteData(0x68);
     GP_COMMAD_PA(2);SPI_WriteData(0x64);  SPI_WriteData(0x68);
     GP_COMMAD_PA(2);SPI_WriteData(0x65);  SPI_WriteData(0x54);
     GP_COMMAD_PA(2);SPI_WriteData(0x66);  SPI_WriteData(0x16);
     GP_COMMAD_PA(2);SPI_WriteData(0x67);  SPI_WriteData(0x73);
     GP_COMMAD_PA(2);SPI_WriteData(0x68);  SPI_WriteData(0x09);
     GP_COMMAD_PA(2);SPI_WriteData(0x69);  SPI_WriteData(0x68);
     GP_COMMAD_PA(2);SPI_WriteData(0x6A);  SPI_WriteData(0x68);
     GP_COMMAD_PA(2);SPI_WriteData(0x6B);  SPI_WriteData(0x08);
     GP_COMMAD_PA(2);SPI_WriteData(0x6C);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0x6D);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0x6E);  SPI_WriteData(0x00);
     GP_COMMAD_PA(2);SPI_WriteData(0x6F);  SPI_WriteData(0x88);

     GP_COMMAD_PA(2);SPI_WriteData(0xE0);  SPI_WriteData(0x00);


     GP_COMMAD_PA(2);SPI_WriteData(0x11);  SPI_WriteData(0x00);
     delay(120);
     GP_COMMAD_PA(2);SPI_WriteData(0x29);  SPI_WriteData(0x00);
     delay(10);
     GP_COMMAD_PA(2);  SPI_WriteData(0x35); SPI_WriteData(0x00);	 	 
		

}


void SSD2828_Initial(void)
{  
    pinMode(SPI_CS,   OUTPUT);   
    pinMode(SPI_CLK,   OUTPUT);
    pinMode(SPI_DI,   OUTPUT);
    pinMode(SPI_RST,   OUTPUT); 
    SPI_RST_1;
    SPI_CS_1;
    SPI_CLK_0;
    SPI_DI_1;
    SPI_RST_0;						   
    delay(30);
    SPI_RST_1;
    delay(50);	 
   
	SPI_WriteCmd(0xb7);
	SPI_WriteData(0x50);//50=TX_CLK 70=PCLK
	SPI_WriteData(0x00);   //Configuration Register

	SPI_WriteCmd(0xb8);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);   //VC(Virtual ChannelID) Control Register

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x00);//1=PLL disable
	SPI_WriteData(0x00);



 	SPI_WriteCmd(0xBA);//PLL=(TX_CLK/MS)*NS 
	SPI_WriteData(0x14);//14,D7-0=NS(0x01 : NS=1)
	SPI_WriteData(0x42);//42,D15-14=PLL00=62.5-125 01=126-250 10=251-500 11=501-1000  DB12-8=MS(01:MS=1)



	SPI_WriteCmd(0xBB);//LP Clock Divider LP clock = 400MHz / LPD / 8 = 480 / 8/ 8 = 7MHz
	SPI_WriteData(0x03);//D5-0=LPD=0x1 – Divide by 2
	SPI_WriteData(0x00);

	 SPI_WriteCmd(0xb9);
	SPI_WriteData(0x01);//1=PLL disable
	SPI_WriteData(0x00);
	//MIPI lane configuration
	SPI_WriteCmd(0xDE);
	SPI_WriteData(0x00);//11=4LANE 10=3LANE 01=2LANE 00=1LANE
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xc9);
	SPI_WriteData(0x02);
	SPI_WriteData(0x23);   //p1: HS-Data-zero  p2: HS-Data- prepare  --> 8031 issue
//	delay(100);


      LCD_initial();	  

				 

	SPI_WriteCmd(0xb7);
	SPI_WriteData(0x50);
	SPI_WriteData(0x00);   //Configuration Register

	SPI_WriteCmd(0xb8);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);   //VC(Virtual ChannelID) Control Register

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x00);//1=PLL disable
	SPI_WriteData(0x00);

       SPI_WriteCmd(0xBA);//
	SPI_WriteData(0x31);//14,D7-0=NS(0x01 : NS=1)		 //0x25
	SPI_WriteData(0x82);//42,D15-14=PLL00=62.5-125 01=126-250 10=251-500 11=501-1000  DB12-8=MS(01:MS=1)


	SPI_WriteCmd(0xBB);//LP Clock Divider LP clock = 400MHz / LPD / 8 = 480 / 8/ 8 = 7MHz
	SPI_WriteData(0x07);//D5-0=LPD=0x1 – Divide by 2
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x01);//1=PLL disable
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xc9);
	SPI_WriteData(0x02);
	SPI_WriteData(0x23);   //p1: HS-Data-zero  p2: HS-Data- prepare  --> 8031 issue
	delay(100);

	SPI_WriteCmd(0xCA);
	SPI_WriteData(0x01);//CLK Prepare
	SPI_WriteData(0x23);//Clk Zero

	SPI_WriteCmd(0xCB); //local_write_reg(addr=0xCB,data=0x0510)
	SPI_WriteData(0x10); //Clk Post
	SPI_WriteData(0x05); //Clk Per

	SPI_WriteCmd(0xCC); //local_write_reg(addr=0xCC,data=0x100A)
	SPI_WriteData(0x05); //HS Trail
	SPI_WriteData(0x10); //Clk Trail

	SPI_WriteCmd(0xD0);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);  



	
       SPI_WriteCmd(0xB1); //local_write_reg(addr=0xB2,data=0x1224)
	SPI_WriteData(LCD_HSPW); //HSA
	SPI_WriteData(LCD_VSPW); //VSA 


	SPI_WriteCmd(0xB2); //local_write_reg(addr=0xB2,data=0x1224)
	SPI_WriteData(LCD_HBPD); //HBP
	SPI_WriteData(LCD_VBPD); //VBP 

	SPI_WriteCmd(0xB3); //local_write_reg(addr=0xB3,data=0x060C)
	SPI_WriteData(LCD_HFPD); //HFP
	SPI_WriteData(LCD_VFPD); //VFP  

 
	SPI_WriteCmd(0xB4);//Horizontal active period
	SPI_WriteData(hsize);//
	SPI_WriteData(hsize>>8);

	SPI_WriteCmd(0xB5);//Vertical active period 
	SPI_WriteData(vsize);//
	SPI_WriteData(vsize>>8);

	
	SPI_WriteCmd(0xB6);//RGB CLK  16BPP=00 18BPP=01
	SPI_WriteData(0x0b);//D7=0 D6=0 D5=0  D1-0=11 – 24bpp	 //07
	SPI_WriteData(0x00);//D15=VS D14=HS D13=CLK D12-9=NC D8=0=Video with blanking packet. 00-F0
	 


	//MIPI lane configuration
	SPI_WriteCmd(0xDE);//
	SPI_WriteData(0x03);//11=4LANE 10=3LANE 01=2LANE 00=1LANE
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xD6);//  05=BGR  04=RGB
	SPI_WriteData(0x01);//D0=0=RGB 1:BGR D1=1=Most significant byte sent first
	SPI_WriteData(0x00);

 	SPI_WriteCmd(0xDB);
	SPI_WriteData(0x58);
	SPI_WriteData(0x00);


	SPI_WriteCmd(0xB7);
	SPI_WriteData(0x4B);   
	SPI_WriteData(0x02);

	SPI_WriteCmd(0x2c);		


}

#endif


