/*************************************************** 
  www.buydisplay.com
 ****************************************************/

#include "TFTM1.83-2.h"
#include <avr/pgmspace.h>
#include <limits.h>
#include "pins_arduino.h"
#include "wiring_private.h"
#include <SPI.h>

// Constructor when using software SPI.  All output pins are configurable.
NV3030B::NV3030B(int8_t cs, int8_t dc, int8_t mosi,
				   int8_t sclk, int8_t rst) : ERGFX(NV3030B_TFTWIDTH, NV3030B_TFTHEIGHT) {
  _cs   = cs;
  _dc   = dc;
  _mosi  = mosi;
  _sclk = sclk;
  _rst  = rst;
  hwSPI = false;
}


// Constructor when using hardware SPI.  Faster, but must use SPI pins
// specific to each board type (e.g. 11,13 for Uno, 51,52 for Mega, etc.)
NV3030B::NV3030B(int8_t cs, int8_t dc, int8_t rst) : ERGFX(NV3030B_TFTWIDTH, NV3030B_TFTHEIGHT) {
  _cs   = cs;
  _dc   = dc;
  _rst  = rst;
  hwSPI = true;
  _mosi  = _sclk = 0;
}

void NV3030B::spiwrite(uint8_t c) {

  //Serial.print("0x"); Serial.print(c, HEX); Serial.print(", ");

  if (hwSPI) {
#if defined (__AVR__)
      uint8_t backupSPCR = SPCR;
    SPCR = mySPCR;
    SPDR = c;
    while(!(SPSR & _BV(SPIF)));
    SPCR = backupSPCR;
#elif defined(TEENSYDUINO)
    SPI.transfer(c);
#elif defined (__arm__)
    SPI.setClockDivider(11); // 8-ish MHz (full! speed!)
    SPI.setBitOrder(MSBFIRST);
    SPI.setDataMode(SPI_MODE0);
    SPI.transfer(c);
#endif
  } else {
    // Fast SPI bitbang swiped from LPD8806 library
    for(uint8_t bit = 0x80; bit; bit >>= 1) {
      if(c & bit) {
	//digitalWrite(_mosi, HIGH); 
	*mosiport |=  mosipinmask;
      } else {
	//digitalWrite(_mosi, LOW); 
	*mosiport &= ~mosipinmask;
      }
      //digitalWrite(_sclk, LOW);
      *clkport &= ~clkpinmask;
       //digitalWrite(_sclk, HIGH);
      *clkport |=  clkpinmask;
    }
  }
}


void NV3030B::writecommand(uint8_t c) {
  *dcport &=  ~dcpinmask;
  //digitalWrite(_dc, LOW);
  //*clkport &= ~clkpinmask; // clkport is a NULL pointer when hwSPI==true
  //digitalWrite(_sclk, LOW);
  *csport &= ~cspinmask;
  //digitalWrite(_cs, LOW);

  spiwrite(c);

  *csport |= cspinmask;
  //digitalWrite(_cs, HIGH);
}


void NV3030B::writedata(uint8_t c) {
  *dcport |=  dcpinmask;
  //digitalWrite(_dc, HIGH);
  //*clkport &= ~clkpinmask; // clkport is a NULL pointer when hwSPI==true
  //digitalWrite(_sclk, LOW);
  *csport &= ~cspinmask;
  //digitalWrite(_cs, LOW);
  
  spiwrite(c);

  //digitalWrite(_cs, HIGH);
  *csport |= cspinmask;
} 

// If the SPI library has transaction support, these functions
// establish settings and protect from interference from other
// libraries.  Otherwise, they simply do nothing.
#ifdef SPI_HAS_TRANSACTION
static inline void spi_begin(void) __attribute__((always_inline));
static inline void spi_begin(void) {
  SPI.beginTransaction(SPISettings(8000000, MSBFIRST, SPI_MODE0));
}
static inline void spi_end(void) __attribute__((always_inline));
static inline void spi_end(void) {
  SPI.endTransaction();
}
#else
#define spi_begin()
#define spi_end()
#endif


void NV3030B::begin(void) {
  if (_rst > 0) {
    pinMode(_rst, OUTPUT);
    digitalWrite(_rst, LOW);
  }

  pinMode(_dc, OUTPUT);
  pinMode(_cs, OUTPUT);
  
  csport    = portOutputRegister(digitalPinToPort(_cs));
  cspinmask = digitalPinToBitMask(_cs);
  dcport    = portOutputRegister(digitalPinToPort(_dc));
  dcpinmask = digitalPinToBitMask(_dc);

  if(hwSPI) { // Using hardware SPI
#if defined (__AVR__)
    SPI.begin();
    SPI.setClockDivider(SPI_CLOCK_DIV2); // 8 MHz (full! speed!)
    SPI.setBitOrder(MSBFIRST);
    SPI.setDataMode(SPI_MODE0);
    mySPCR = SPCR;
#elif defined(TEENSYDUINO)
    SPI.begin();
    SPI.setClockDivider(SPI_CLOCK_DIV2); // 8 MHz (full! speed!)
    SPI.setBitOrder(MSBFIRST);
    SPI.setDataMode(SPI_MODE0);
#elif defined (__arm__)
      SPI.begin();
      SPI.setClockDivider(11); // 8-ish MHz (full! speed!)
      SPI.setBitOrder(MSBFIRST);
      SPI.setDataMode(SPI_MODE0);
#endif
  } else {
    pinMode(_sclk, OUTPUT);
    pinMode(_mosi, OUTPUT);

    clkport     = portOutputRegister(digitalPinToPort(_sclk));
    clkpinmask  = digitalPinToBitMask(_sclk);
    mosiport    = portOutputRegister(digitalPinToPort(_mosi));
    mosipinmask = digitalPinToBitMask(_mosi);
    *clkport   &= ~clkpinmask;
    *mosiport  &= ~mosipinmask;
  }

  // toggle RST low to reset
  if (_rst > 0) {
    digitalWrite(_rst, HIGH);
    delay(5);
    digitalWrite(_rst, LOW);
    delay(20);
    digitalWrite(_rst, HIGH);
    delay(150);
  }

  if (hwSPI) spi_begin();
  
 
	writecommand(0xfd);//private_access
	writedata(0x06);
	writedata(0x08);

	writecommand(0x61);//add
	writedata(0x07);//
	writedata(0x04);//
//bias
	writecommand(0x62);//bias setting
	writedata(0x00);//01
	writedata(0x44);//04 44
	writedata(0x45);//44 65 40

	writecommand(0x63);//
	writedata(0x41);//
	writedata(0x07);//
	writedata(0x12);//
	writedata(0x12);//

	writecommand(0x64);//
	writedata(0x37);//
//VSP
	writecommand(0x65);//Pump1=4.7MHz //PUMP1 VSP
	writedata(0x09);//D6-5:pump1_clk[1:0] clamp 28 2b
	writedata(0x10);//6.26
	writedata(0x21);
//VSN
	writecommand(0x66); //pump=2 AVCL
	writedata(0x09); //clamp 08 0b 09
	writedata(0x10); //10
	writedata(0x21);
//add source_neg_time
	writecommand(0x67);//pump_sel
	writedata(0x20);//21 20
	writedata(0x40);
//gamma vap/van
	writecommand(0x68);//gamma vap/van
	writedata(0x90);//
	writedata(0x4c);//
	writedata(0x7c);//
	writedata(0x66);//66  46  VCOM

	writecommand(0xb1);//frame rate
	writedata(0x0F);//0x0f fr_h[5:0] 0F
	writedata(0x02);//0x02 fr_v[4:0] 02
	writedata(0x01);//0x04 fr_div[2:0] 03

	writecommand(0xB4);
	writedata(0x01); //01:1dot 00:column
////porch
	writecommand(0xB5);
	writedata(0x02);//0x02 vfp[6:0]
	writedata(0x02);//0x02 vbp[6:0]
	writedata(0x0a);//0x0A hfp[6:0]
	writedata(0x14);//0x14 hbp[6:0]

	writecommand(0xB6);
	writedata(0x04);//
	writedata(0x01);//
	writedata(0x9f);//
	writedata(0x00);//
	writedata(0x02);//
////gamme sel
	writecommand(0xdf);//
	writedata(0x11);//gofc_gamma_en_sel=1
////gamma_test1 A1#_wangly
//3030b_gamma_new_
//GAMMA---------------------------------/////////////

//GAMMA---------------------------------/////////////
	writecommand(0xE2);	
	writedata(0x13);//vrp0[5:0]	V0
	writedata(0x00);//vrp1[5:0]	V1  
	writedata(0x00);//vrp2[5:0]	V2 
	writedata(0x30);//vrp3[5:0]	V61 
	writedata(0x33);//vrp4[5:0]	V62
	writedata(0x3f);//vrp5[5:0]	V63

	writecommand(0xE5);	
	writedata(0x3f);//vrn0[5:0]	V63
	writedata(0x33);//vrn1[5:0]	V62	
	writedata(0x30);//vrn2[5:0]	V61 
	writedata(0x00);//vrn3[5:0]	V2 
	writedata(0x00);//vrn4[5:0]	V1	
	writedata(0x13);//vrn5[5:0]  V0

	writecommand(0xE1);	
	writedata(0x00);//prp0[6:0]	V15
	writedata(0x57);//prp1[6:0]	V51 

	writecommand(0xE4);	
	writedata(0x58);//prn0[6:0]	V51 
	writedata(0x00);//prn1[6:0]  V15

	writecommand(0xE0);
	writedata(0x01);//pkp0[4:0]	V3 
	writedata(0x03);//pkp1[4:0]	V7  
	writedata(0x0d);//pkp2[4:0]	V21 
	writedata(0x0e);//pkp3[4:0]	V29 //
	writedata(0x0e);//pkp4[4:0]	V37 
	writedata(0x0c);//pkp5[4:0]	V45 
	writedata(0x15);//pkp6[4:0]	V56 
	writedata(0x19);//pkp7[4:0]	V60 

	writecommand(0xE3);	
	writedata(0x1a);//pkn0[4:0]	V60 
	writedata(0x16);//pkn1[4:0]	V56 
	writedata(0x0c);//pkn2[4:0]	V45 
	writedata(0x0f);//pkn3[4:0]	V37 
	writedata(0x0e);//pkn4[4:0]	V29 //
	writedata(0x0d);//pkn5[4:0]	V21 
	writedata(0x02);//pkn6[4:0]	V7  
	writedata(0x01);//pkn7[4:0]	V3 
//GAMMA---------------------------------/////////////


//source
	writecommand(0xE6);
	writedata(0x00);
	writedata(0xff);//SC_EN_START[7:0] f0

	writecommand(0xE7);
	writedata(0x01);//CS_START[3:0] 01
	writedata(0x04);//scdt_inv_sel cs_vp_en
	writedata(0x03);//CS1_WIDTH[7:0] 12
	writedata(0x03);//CS2_WIDTH[7:0] 12
	writedata(0x00);//PREC_START[7:0] 06
	writedata(0x12);//PREC_WIDTH[7:0] 12

	writecommand(0xE8); //source
	writedata(0x00); //VCMP_OUT_EN 81-
	writedata(0x70); //chopper_sel[6:4]
	writedata(0x00); //gchopper_sel[6:4] 60
////gate
	writecommand(0xEc);
	writedata(0x52);//52

	writecommand(0xF1);
	writedata(0x01);//te_pol tem_extend 00 01 03
	writedata(0x01);
	writedata(0x02);

	writecommand(0xF6);//
	writedata(0x09);//
	writedata(0x10);//
	writedata(0x00);//
	writedata(0x00);//40 3线2通道

	writecommand(0xfd);
	writedata(0xfa);
	writedata(0xfc);

	writecommand(0x3a);
	writedata(0x05);//SH 0x66

	writecommand(0x35);
	writedata(0x00);

	writecommand(0x36);//bgr_[3]
	writedata(0x08);//c0 
 
	writecommand(0x21); 

        writecommand(0x11);    //Exit Sleep 
        if (hwSPI) spi_end();
        delay(120); 		
        if (hwSPI) spi_begin();
        writecommand(0x29);    //Display on 
        if (hwSPI) spi_end();

}


void NV3030B::setAddrWindow(uint16_t x0, uint16_t y0, uint16_t x1,
 uint16_t y1) {
  y0+=20;y1+=20;
  writecommand(NV3030B_CASET); // Column addr set
  writedata(x0 >> 8);
  writedata(x0 & 0xFF);     // XSTART 
  writedata(x1 >> 8);
  writedata(x1 & 0xFF);     // XEND

  writecommand(NV3030B_PASET); // Row addr set
  writedata(y0>>8);
  writedata(y0);     // YSTART
  writedata(y1>>8);
  writedata(y1);     // YEND

  writecommand(NV3030B_RAMWR); // write to RAM
}


void NV3030B::pushColor(uint16_t color) {
  if (hwSPI) spi_begin();
  //digitalWrite(_dc, HIGH);
  *dcport |=  dcpinmask;
  //digitalWrite(_cs, LOW);
  *csport &= ~cspinmask;

  spiwrite(color >> 8);
  spiwrite(color);

  *csport |= cspinmask;
  //digitalWrite(_cs, HIGH);
  if (hwSPI) spi_end();
}

void NV3030B::drawPixel(int16_t x, int16_t y, uint16_t color) {

  if((x < 0) ||(x >= _width) || (y < 0) || (y >= _height)) return;

  if (hwSPI) spi_begin();
  setAddrWindow(x,y,x+1,y+1);

  //digitalWrite(_dc, HIGH);
  *dcport |=  dcpinmask;
  //digitalWrite(_cs, LOW);
  *csport &= ~cspinmask;

  spiwrite(color >> 8);
  spiwrite(color);

  *csport |= cspinmask;
  //digitalWrite(_cs, HIGH);
  if (hwSPI) spi_end();
}


void NV3030B::drawFastVLine(int16_t x, int16_t y, int16_t h,
 uint16_t color) {

  // Rudimentary clipping
  if((x >= _width) || (y >= _height)) return;

  if((y+h-1) >= _height) 
    h = _height-y;

  if (hwSPI) spi_begin();
  setAddrWindow(x, y, x, y+h-1);

  uint8_t hi = color >> 8, lo = color;

  *dcport |=  dcpinmask;
  //digitalWrite(_dc, HIGH);
  *csport &= ~cspinmask;
  //digitalWrite(_cs, LOW);

  while (h--) {
    spiwrite(hi);
    spiwrite(lo);
  }
  *csport |= cspinmask;
  //digitalWrite(_cs, HIGH);
  if (hwSPI) spi_end();
}


void NV3030B::drawFastHLine(int16_t x, int16_t y, int16_t w,
  uint16_t color) {

  // Rudimentary clipping
  if((x >= _width) || (y >= _height)) return;
  if((x+w-1) >= _width)  w = _width-x;
  if (hwSPI) spi_begin();
  setAddrWindow(x, y, x+w-1, y);

  uint8_t hi = color >> 8, lo = color;
  *dcport |=  dcpinmask;
  *csport &= ~cspinmask;
  //digitalWrite(_dc, HIGH);
  //digitalWrite(_cs, LOW);
  while (w--) {
    spiwrite(hi);
    spiwrite(lo);
  }
  *csport |= cspinmask;
  //digitalWrite(_cs, HIGH);
  if (hwSPI) spi_end();
}

void NV3030B::fillScreen(uint16_t color) {
  fillRect(0, 0,  _width, _height, color);
}

// fill a rectangle
void NV3030B::fillRect(int16_t x, int16_t y, int16_t w, int16_t h,
  uint16_t color) {

  // rudimentary clipping (drawChar w/big text requires this)
  if((x >= _width) || (y >= _height)) return;
  if((x + w - 1) >= _width)  w = _width  - x;
  if((y + h - 1) >= _height) h = _height - y;

  if (hwSPI) spi_begin();
  setAddrWindow(x, y, x+w-1, y+h-1);

  uint8_t hi = color >> 8, lo = color;

  *dcport |=  dcpinmask;
  //digitalWrite(_dc, HIGH);
  *csport &= ~cspinmask;
  //digitalWrite(_cs, LOW);

  for(y=h; y>0; y--) {
    for(x=w; x>0; x--) {
      spiwrite(hi);
      spiwrite(lo);
    }
  }
  //digitalWrite(_cs, HIGH);
  *csport |= cspinmask;
  if (hwSPI) spi_end();
}


// Pass 8-bit (each) R,G,B, get back 16-bit packed color
uint16_t NV3030B::color565(uint8_t r, uint8_t g, uint8_t b) {
  return ((r & 0xF8) << 8) | ((g & 0xFC) << 3) | (b >> 3);
}

 

