/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
Examples for ERM12864-8
Display is Hardward SPI 4-Wire SPI Interface 
Tested and worked with:
Works with Arduino 1.6.0 IDE  
NOTE: testOK:DUE    If you use MEGA and UNO board, you need to add level conversion.
****************************************************/

/*
  == Hardware connection ==
    LCD   =>    Arduino
  *1. CS        ->    10    
  *2. RES       ->    9 
  *3. A0/DC     ->    8
  *4. SCK       ->    SCK
  *5. SDI       ->    MOSI
  *6. GND       ->    GND
  *7. VCC       ->    3.3
  *8. LEDA(3V)  ->    7      
  *9. LEDK(0V)  ->    GND    

*/


#include <SPI.h>
#include "er_lcd.h"

uint8_t lcd_buf[WIDTH * HEIGHT / 8];

void setup() {
  Serial.begin(9600);
  Serial.print("LCD Example\n");

  er_lcd_begin();
 
}

void loop() {
 er_lcd_clear(lcd_buf);
  er_lcd_bitmap(0, 0, PIC1, 128, 64, lcd_buf);
  er_lcd_display(lcd_buf);
  delay(3000);  
  command(0xa7);//--set Negative display 
  delay(3000);
  command(0xa6);//--set normal display
  
  er_lcd_clear(lcd_buf);
  er_lcd_bitmap(0, 0, PIC2, 128, 64, lcd_buf);
  er_lcd_display(lcd_buf);
  delay(3000);
  
  command(0xa7);//--set Negative display 
  delay(3000); 
  command(0xa6);//--set normal display  
  
er_lcd_clear(lcd_buf);
  /* display images of bitmap matrix */
  er_lcd_bitmap(0, 2, Signal816, 16, 8, lcd_buf); 
  er_lcd_bitmap(24, 2,Bluetooth88, 8, 8, lcd_buf); 
  er_lcd_bitmap(40, 2, Msg816, 16, 8, lcd_buf); 
  er_lcd_bitmap(64, 2, GPRS88, 8, 8, lcd_buf); 
  er_lcd_bitmap(90, 2, Alarm88, 8, 8, lcd_buf); 
  er_lcd_bitmap(112, 2, Bat816, 16, 8, lcd_buf); 

  er_lcd_string(10, 52, "www.buydisplay.com", 12, 1, lcd_buf); 
 

  er_lcd_char3216(0, 16, '1', lcd_buf);
  er_lcd_char3216(16, 16, '2', lcd_buf);
  er_lcd_char3216(32, 16, ':', lcd_buf);
  er_lcd_char3216(48, 16, '3', lcd_buf);
  er_lcd_char3216(64, 16, '4', lcd_buf);
  er_lcd_char3216(80, 16, ':', lcd_buf);
  er_lcd_char3216(96, 16, '5', lcd_buf);
  er_lcd_char3216(112, 16, '6', lcd_buf);

  er_lcd_display(lcd_buf);
   delay(3000);
  
  
  char value[10] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}; 
  while(1){   
       uint8_t sec = 0;
    uint8_t sDev_time;
    uint8_t Hour = 12;
    uint8_t Min = 34;
    uint8_t Sec = 56;
    Serial.print("Show time\r\n");
    for (;;) {
      sec++;
      Sec = sec;
      if (sec == 60) {
        Min = Min + 1;
        sec = 0;
        if (Min == 60) {
          Hour =  Hour + 1;
          Min = 0;
          if (Hour == 24) {
            Hour = 0;
            Min = 0;
            Sec = 0;
          }
        }
      }
     er_lcd_char3216(0, 16,  value[Hour / 10], lcd_buf);
    er_lcd_char3216(16, 16, value[Hour % 10], lcd_buf);
    er_lcd_char3216(32, 16, ':', lcd_buf);
    er_lcd_char3216(48, 16, value[Min / 10], lcd_buf);
    er_lcd_char3216(64, 16, value[Min % 10], lcd_buf);
    er_lcd_char3216(80, 16, ':', lcd_buf);
    er_lcd_char3216(96, 16, value[Sec / 10], lcd_buf);
    er_lcd_char3216(112, 16, value[Sec % 10], lcd_buf);
       er_lcd_display(lcd_buf);
         delay(1000);//Analog clock 1s   

    }
  }
}

