/***************************************************
  This is our library for the   ILI9342 Breakout and Shield
  ----> http://www..com/products/1651

  Check out the links above for our tutorials and wiring diagrams
  These displays use SPI to communicate, 4 or 5 pins are required to
  interface (RST is optional)
   invests time and resources providing this open source code,
  please support  and open-source hardware by purchasing
  products from !

  Written by Limor Fried/Ladyada for  Industries.
  MIT license, all text above must be included in any redistribution
 ****************************************************/

#ifndef _ILI9342H_
#define _ILI9342H_

#if ARDUINO >= 100
 #include "Arduino.h"
 #include "Print.h"
#else
 #include "WProgram.h"
#endif
#include <GFX.h>
#include <avr/pgmspace.h>


#define ILI9342_TFTWIDTH  320
#define ILI9342_TFTHEIGHT 240

#define ILI9342_NOP     0x00
#define ILI9342_SWRESET 0x01
#define ILI9342_RDDID   0x04
#define ILI9342_RDDST   0x09

#define ILI9342_SLPIN   0x10
#define ILI9342_SLPOUT  0x11
#define ILI9342_PTLON   0x12
#define ILI9342_NORON   0x13

#define ILI9342_RDMODE  0x0A
#define ILI9342_RDMADCTL  0x0B
#define ILI9342_RDPIXFMT  0x0C
#define ILI9342_RDIMGFMT  0x0A
#define ILI9342_RDSELFDIAG  0x0F

#define ILI9342_INVOFF  0x20
#define ILI9342_INVON   0x21
#define ILI9342_GAMMASET 0x26
#define ILI9342_DISPOFF 0x28
#define ILI9342_DISPON  0x29

#define ILI9342_CASET   0x2A
#define ILI9342_PASET   0x2B
#define ILI9342_RAMWR   0x2C
#define ILI9342_RAMRD   0x2E

#define ILI9342_PTLAR   0x30
#define ILI9342_MADCTL  0x36
#define ILI9342_PIXFMT  0x3A

#define ILI9342_FRMCTR1 0xB1
#define ILI9342_FRMCTR2 0xB2
#define ILI9342_FRMCTR3 0xB3
#define ILI9342_INVCTR  0xB4
#define ILI9342_DFUNCTR 0xB6

#define ILI9342_PWCTR1  0xC0
#define ILI9342_PWCTR2  0xC1
#define ILI9342_PWCTR3  0xC2
#define ILI9342_PWCTR4  0xC3
#define ILI9342_PWCTR5  0xC4
#define ILI9342_VMCTR1  0xC5
#define ILI9342_VMCTR2  0xC7

#define ILI9342_RDID1   0xDA
#define ILI9342_RDID2   0xDB
#define ILI9342_RDID3   0xDC
#define ILI9342_RDID4   0xDD

#define ILI9342_GMCTRP1 0xE0
#define ILI9342_GMCTRN1 0xE1
/*
#define ILI9342_PWCTR6  0xFC

*/

// Color definitions
#define	ILI9342_BLACK   0x0000
#define	ILI9342_BLUE    0x001F
#define	ILI9342_RED     0xF800
#define	ILI9342_GREEN   0x07E0
#define ILI9342_CYAN    0x07FF
#define ILI9342_MAGENTA 0xF81F
#define ILI9342_YELLOW  0xFFE0  
#define ILI9342_WHITE   0xFFFF


class ILI9342 : public GFX {

 public:

  ILI9342(int8_t _CS, int8_t _DC, int8_t _MOSI, int8_t _SCLK,
		   int8_t _RST, int8_t _MISO);
  ILI9342(int8_t _CS, int8_t _DC, int8_t _RST = -1);

  void     begin(void),
           setAddrWindow(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1),
           pushColor(uint16_t color),
           fillScreen(uint16_t color),
           drawPixel(int16_t x, int16_t y, uint16_t color),
           drawFastVLine(int16_t x, int16_t y, int16_t h, uint16_t color),
           drawFastHLine(int16_t x, int16_t y, int16_t w, uint16_t color),
           fillRect(int16_t x, int16_t y, int16_t w, int16_t h,
             uint16_t color),
           setRotation(uint8_t r),
           invertDisplay(boolean i);
  uint16_t color565(uint8_t r, uint8_t g, uint8_t b);

  /* These are not for current use, 8-bit protocol only! */
  uint8_t  readdata(void),
    readcommand8(uint8_t reg, uint8_t index = 0);
  /*
  uint16_t readcommand16(uint8_t);
  uint32_t readcommand32(uint8_t);
  void     dummyclock(void);
  */  

  void     spiwrite(uint8_t),
    writecommand(uint8_t c),
    writedata(uint8_t d),
    commandList(uint8_t *addr);
  uint8_t  spiread(void);

 private:
  uint8_t  tabcolor;



  boolean  hwSPI;
#if defined (__AVR__) || defined(TEENSYDUINO)
  uint8_t mySPCR;
  volatile uint8_t *mosiport, *clkport, *dcport, *rsport, *csport;
  int8_t  _cs, _dc, _rst, _mosi, _miso, _sclk;
  uint8_t  mosipinmask, clkpinmask, cspinmask, dcpinmask;
#elif defined (__arm__)
    volatile RwReg *mosiport, *clkport, *dcport, *rsport, *csport;
    uint32_t  _cs, _dc, _rst, _mosi, _miso, _sclk;
    uint32_t  mosipinmask, clkpinmask, cspinmask, dcpinmask;
#endif
};

#endif
