/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
Examples for ER-OLEDM024-2
Display is Hardward or Software SPI 4-Wire SPI Interface 
Tested and worked with:
Works with Arduino 2.3.4 IDE  
NOTE: test OK:ESP32-WROOM-32  
****************************************************/

/*  == Hardward to ESP32  ==
    OLED   =>    ESP32
  *1. VSS      ->    GND
  *2. VCC       ->    3.3-5V 
  *4. A0/DC     ->    17 
  *5,6       ->    GND
  *7. SCK       ->    18 
  *8. SDI       ->    23  
  *10-14      ->    GND
  *15. CS        ->    5 
  *16. RES       ->    16    
*/


#include "er_oled.h"
#include <WiFi.h>


uint8_t oled_buf[128 * 64 / 8];

const char* ntpServer = "pool.ntp.org";    //"ntp1.aliyun.com";   
const long  gmtOffset_sec = 28800;
const int   daylightOffset_sec = 0;

const char *ssid = "EASTRISING-2"; //"your ssid";
const char *password = "er33503873";   //"your password";

struct tm timeinfo;

void setup() {

  Serial.begin(115200);
  er_oled_begin();
  Serial.print("OLED Example\n");
 
}


void loop() {

 
  set_display_rotate(ROTATE_0);
  er_oled_clear(oled_buf);
  er_oled_string(0, 0, "Hollow!", 12, 1, oled_buf); 
  er_oled_string(0, HEIGHT/2,  "buydisplay.com", 12, 1, oled_buf);   
  er_oled_string(0, HEIGHT-12, "EastRising", 12, 1, oled_buf);     
  er_oled_display(oled_buf);
  delay(1000); 


  set_display_rotate(ROTATE_90);
  er_oled_clear(oled_buf);
  er_oled_string(0, 0, "Hollow!", 12, 1, oled_buf);  
  er_oled_string(0, HEIGHT/2,  "buydisplay.com", 12, 1, oled_buf);  
  er_oled_string(0, HEIGHT-12, "EastRising", 12, 1, oled_buf);    
  er_oled_display(oled_buf);
  delay(1000); 


  set_display_rotate(ROTATE_180);
  er_oled_clear(oled_buf);
  er_oled_string(0, 0, "Hollow!", 12, 1, oled_buf);
  er_oled_string(0, HEIGHT/2,  "buydisplay.com", 12, 1, oled_buf);   
  er_oled_string(0, HEIGHT-12, "EastRising", 12, 1, oled_buf);     
  er_oled_display(oled_buf);
  delay(1000); 
  
  set_display_rotate(ROTATE_270);
  er_oled_clear(oled_buf);
  er_oled_string(0, 0, "Hollow!", 12, 1, oled_buf);  
  er_oled_string(0, HEIGHT/2,  "buydisplay.com", 12, 1, oled_buf); 
  er_oled_string(0, HEIGHT-12, "EastRising", 12, 1, oled_buf);    
  er_oled_display(oled_buf);
  delay(1000); 
  
  set_display_rotate(ROTATE_90);
  er_oled_clear(oled_buf);
  er_oled_bitmap(0, 0, PIC1_ROTATE_90, 64, 128, oled_buf);
  er_oled_display(oled_buf);
  delay(1000);  

 

  set_display_rotate(ROTATE_0);
  er_oled_clear(oled_buf);
  er_oled_bitmap(0, 0, PIC1, 128, 64, oled_buf);
  er_oled_display(oled_buf);
  delay(3000);  
  command(0xa7);//--set Negative display 
  delay(3000);
  command(0xa6);//--set normal display
  

  er_oled_clear(oled_buf);
  er_oled_bitmap(0, 0, PIC2, 128, 64, oled_buf);
  er_oled_display(oled_buf);
  delay(3000);  
  command(0xa7);//--set Negative display 
  delay(3000);
  command(0xa6);//--set normal display
  

 set_display_rotate(ROTATE_0);
 
  er_oled_clear(oled_buf);
  demo_sine(oled_buf);
 
 er_oled_clear(oled_buf);
  testLines(oled_buf);
 
  er_oled_clear(oled_buf);
  testFastLines(oled_buf);
 
  er_oled_clear(oled_buf);
  testRects(oled_buf);

  er_oled_clear(oled_buf);
  testFilledRects(oled_buf);

  er_oled_clear(oled_buf);
  testFilledCircles(10, oled_buf);

  er_oled_clear(oled_buf);
  testCircles(10,oled_buf);

  er_oled_clear(oled_buf); 
  testTriangles(oled_buf);

  er_oled_clear(oled_buf);
  testFilledTriangles(oled_buf);

  er_oled_clear(oled_buf);
  testRoundRects(oled_buf); 

  er_oled_clear(oled_buf);
  testFilledRoundRects(oled_buf); 

 er_oled_clear(oled_buf);
 demo_game(oled_buf);



 set_display_rotate(ROTATE_90);
 
  er_oled_clear(oled_buf);
  demo_sine(oled_buf);
 
 er_oled_clear(oled_buf);
  testLines(oled_buf);
 
  er_oled_clear(oled_buf);
  testFastLines(oled_buf);
 
  er_oled_clear(oled_buf);
  testRects(oled_buf);

  er_oled_clear(oled_buf);
  testFilledRects(oled_buf);

  er_oled_clear(oled_buf);
  testFilledCircles(10, oled_buf);

  er_oled_clear(oled_buf);
  testCircles(10,oled_buf);

  er_oled_clear(oled_buf); 
  testTriangles(oled_buf);

  er_oled_clear(oled_buf);
  testFilledTriangles(oled_buf);

  er_oled_clear(oled_buf);
  testRoundRects(oled_buf); 

  er_oled_clear(oled_buf);
  testFilledRoundRects(oled_buf); 



  Serial.printf("Connecting to %s ", ssid);
  set_display_rotate(ROTATE_0);
  er_oled_clear(oled_buf);
  er_oled_string(0, 2, "Connecting to wifi", 12, 1, oled_buf); 
  er_oled_display(oled_buf);
  
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) 
  {
      delay(500);
      Serial.print(".");
      er_oled_string(0, 16, ".....", 12, 1, oled_buf); 
      er_oled_display(oled_buf);
  }
      Serial.println("WiFi connected");
      Serial.println(WiFi.localIP());
      er_oled_string(0, 30, "WiFi connected", 12, 1, oled_buf); 
      er_oled_display(oled_buf);




  er_oled_clear(oled_buf);
  // display images of bitmap matrix 
  er_oled_bitmap(0, 0, Signal816, 16, 8, oled_buf); 
  er_oled_bitmap(24, 0,Bluetooth88, 8, 8, oled_buf); 
  er_oled_bitmap(40, 0, Msg816, 16, 8, oled_buf); 
  er_oled_bitmap(64, 0, GPRS88, 8, 8, oled_buf); 
  er_oled_bitmap(90, 0, Alarm88, 8, 8, oled_buf); 
  er_oled_bitmap(112, 0, Bat816, 16, 8, oled_buf); 

  er_oled_string(4, 52, "Wifi:EASTRISING-2", 12, 1, oled_buf); 
 

const String WDAY_NAMES[] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturd"};                
const String MONTH_NAMES[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}; 
  char value[10] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}; 
   while(1)
   {
  
  
  configTime(gmtOffset_sec, daylightOffset_sec,ntpServer);   
  while(!getLocalTime(&timeinfo));
  if(!getLocalTime(&timeinfo)){Serial.println("Failed to obtain time");}
  Serial.println(&timeinfo, "%a, %Y-%m-%d %H:%M:%S");  
    String date = WDAY_NAMES[timeinfo.tm_wday]; 
    timeinfo.tm_year += 1900 ; 
    timeinfo.tm_mon+=1; 
     
    er_oled_char3216(0, 8,  value[timeinfo.tm_hour / 10], oled_buf);
    er_oled_char3216(16, 8, value[timeinfo.tm_hour % 10], oled_buf);
    er_oled_char3216(32, 8, ':', oled_buf);
    er_oled_char3216(48, 8, value[timeinfo.tm_min / 10], oled_buf);
    er_oled_char3216(64, 8, value[timeinfo.tm_min % 10], oled_buf);
    er_oled_char3216(80, 8, ':', oled_buf);
    er_oled_char3216(96, 8, value[timeinfo.tm_sec / 10], oled_buf);
    er_oled_char3216(112, 8, value[timeinfo.tm_sec % 10], oled_buf);

  
    er_oled_char(0, 40,  value[timeinfo.tm_year / 1000],12, 1,oled_buf);
    er_oled_char(6, 40,  value[timeinfo.tm_year % 1000/100],12, 1,oled_buf);
    er_oled_char(12, 40,  value[timeinfo.tm_year %1000%100/10],12, 1,oled_buf);
    er_oled_char(18, 40,  value[timeinfo.tm_year %1000%100%10],12, 1,oled_buf);  
    er_oled_char(24, 40, '-',12, 1,oled_buf);
    er_oled_char(30, 40,  value[timeinfo.tm_mon / 10],12, 1,oled_buf);
    er_oled_char(36, 40,  value[timeinfo.tm_mon %  10],12, 1,oled_buf);  
    er_oled_char(42, 40, '-',12, 1,oled_buf);
    er_oled_char(48, 40,  value[timeinfo.tm_mday / 10],12, 1,oled_buf);
    er_oled_char(54, 40,  value[timeinfo.tm_mday %  10],12, 1,oled_buf); 

    er_oled_string(70, 40, WDAY_NAMES[timeinfo.tm_wday].c_str(), 12, 0, oled_buf);   
    
    er_oled_display(oled_buf);
         delay(1000);//Analog clock 1s   
  
    }
  

  
}
