#ifndef LCD_h
#define LCD_h
#include "Arduino.h"
//#include <avr/pgmspace.h>
#include <SPI.h>

#define Arduino_SPI     1 //1:use SPI to drive

  #define layer1_start_addr 0 		 
  #define layer2_start_addr 460800   
  #define layer3_start_addr 921600    
  #define layer4_start_addr 1382400
  #define layer5_start_addr 1843200 
  #define layer6_start_addr 2304000   
  #define layer7_start_addr 2764800   
  #define layer8_start_addr 3225600
  #define layer9_start_addr 3686400
  #define layer10_start_addr 4147200
  #define layer11_start_addr 4608000

#define LCD_XSIZE_TFT    480
#define LCD_YSIZE_TFT    480
  
#define	LCD_HBPD  60
#define	LCD_HFPD  60 
#define	LCD_HSPW  6
   
#define	LCD_VBPD  24
#define	LCD_VFPD  24
#define	LCD_VSPW  2	

#define LCD_PCLK_Falling_Rising     1      // 1:FallingEdge    0:RisingEdge
#define LCD_HSYNC_Active_Polarity   0      // 1:HighLevel    0:LowLevel
#define LCD_VSYNC_Active_Polarity   0      // 1:HighLevel    0:LowLevel
#define LCD_DE_Active_Polarity      1      // 1:HighLevel    0:LowLevel

#define  cSetb0    0x01
#define cSetb1    0x02
#define cSetb2    0x04
#define cSetb3    0x08
#define cSetb4    0x10
#define cSetb5    0x20
#define cSetb6    0x40
#define cSetb7    0x80
#define cClrb0    0xfe
#define cClrb1    0xfd
#define cClrb2    0xfb
#define cClrb3    0xf7
#define cClrb4    0xef
#define cClrb5    0xdf
#define cClrb6    0xbf
#define cClrb7    0x7f

#define Black   0x0000
#define White   0xffff
#define Red     0xf800
#define Green   0x07e0
#define Blue    0x001f
#define Yellow  Red|Green
#define Cyan    Green|Blue
#define Purple  Red|Blue
#define LIGHTRED      0xfc10
#define LIGHTGREEN    0x87f0
#define LIGHTBLUE     0x841f
#define LIGHTYELLOW   0xfff0

const unsigned char pic_80x80[] PROGMEM ={
/*
Image size:80 X 80 X 16BPP=12800 bytes.
*/

0X19,0X88,0X09,0X48,0X11,0XD2,0X01,0XD6,0X01,0X76,0X01,0X76,0X01,0X75,0X01,0X76,
0X01,0X96,0X01,0X96,0X00,0XF3,0X75,0X1D,0X21,0XEB,0X09,0XA7,0X09,0X87,0X01,0X4A,
0X01,0X0C,0X09,0XD3,0X00,0XD1,0X01,0X33,0X01,0X74,0X01,0X33,0X01,0XB5,0X01,0XD5,
0X01,0X52,0X01,0X53,0X00,0XD0,0X2B,0XB8,0X0B,0X14,0X34,0X99,0X02,0X30,0X01,0XCE,
0X0A,0XF3,0X1B,0XD7,0X13,0X75,0X0B,0X53,0X02,0X51,0X24,0X38,0X01,0XCE,0X01,0XD0,
0X13,0XF8,0X13,0XF7,0X13,0X75,0X24,0XB6,0X01,0X8B,0X12,0X0C,0X6B,0XD1,0XB5,0XB6,
0XE7,0X3B,0X84,0X10,0XA5,0X32,0XE6,0XD5,0XFF,0X14,0XFE,0X91,0XFE,0X30,0XFD,0XCF,
0XFD,0XAE,0XFD,0X8E,0XFD,0X8E,0XF5,0X6D,0XF5,0X0C,0XED,0X2D,0XF5,0X6E,0XF5,0X6F,
0XD4,0XEE,0X72,0XA7,0X42,0X6B,0X22,0X6F,0X22,0X0D,0X00,0XA6,0X00,0X03,0X00,0X84,
0X4C,0X10,0X3B,0X0B,0X3A,0XCB,0X18,0XE3,0X21,0X24,0X42,0X68,0X4A,0XA8,0X63,0X09,
0X09,0X6F,0X09,0XD6,0X01,0X76,0X01,0X76,0X01,0X76,0X01,0X96,0X01,0XB6,0X01,0X96,
0X01,0X76,0X01,0X96,0X01,0XB6,0X01,0X54,0X01,0XB4,0X01,0X73,0X01,0XF5,0X01,0XD6,
0X01,0X95,0X01,0XD6,0X01,0X74,0X01,0X54,0X01,0X74,0X01,0X33,0X01,0XD5,0X01,0XD5,
0X01,0X73,0X01,0X73,0X01,0X32,0X01,0XD2,0X13,0X35,0X12,0XD6,0X01,0XB2,0X34,0X18,
0X01,0X50,0X0A,0XF5,0X4E,0X7E,0X03,0X11,0X00,0XCD,0X24,0X98,0X02,0XD2,0X02,0X92,
0X5E,0XDF,0X3B,0X73,0X95,0XFA,0X8C,0XF4,0XAD,0XD5,0XBD,0XD7,0X83,0XEF,0X9D,0X76,
0X94,0XD4,0X73,0XD1,0XA5,0X52,0XFF,0XF6,0XFE,0X2E,0XFD,0XAD,0XF5,0X4C,0XF5,0X4D,
0XEC,0XEB,0XE4,0XCB,0XE4,0XAB,0XDC,0X29,0XD4,0X09,0XDC,0X4A,0XDC,0X6B,0XE4,0XAB,
0XEC,0XEC,0XF5,0X2C,0XEC,0XCB,0XCC,0X2B,0X8A,0XC8,0X51,0XC5,0X08,0X00,0X00,0X02,
0X00,0XA6,0X21,0XA7,0X4A,0XA9,0X30,0XC2,0X52,0X47,0X29,0X45,0X10,0X00,0X28,0XA1,
0X22,0X78,0X01,0X36,0X01,0X76,0X01,0X76,0X01,0X97,0X01,0X96,0X01,0XD7,0X01,0XB7,
0X01,0X96,0X01,0X96,0X01,0X96,0X01,0XD7,0X01,0XB6,0X01,0X97,0X01,0X96,0X01,0XB6,
0X01,0XB6,0X01,0X75,0X01,0X33,0X00,0XD2,0X00,0XD1,0X00,0XD1,0X01,0X54,0X01,0X53,
0X01,0X32,0X01,0X53,0X01,0X32,0X00,0XD0,0X00,0XB0,0X00,0X2D,0X00,0X4E,0X00,0XAF,
0X00,0XAE,0X3C,0XBB,0X3C,0XD7,0X23,0X52,0X4C,0X97,0X4C,0XD7,0X7D,0X39,0XBE,0XBC,
0XC6,0X9B,0X7C,0X51,0X63,0X8F,0X5B,0X6F,0X7C,0X51,0X31,0XA7,0XD6,0XD9,0X18,0XE8,
0X00,0X02,0X00,0X01,0X4A,0X88,0XFF,0XB7,0XED,0XAE,0XED,0X8E,0XD4,0XAB,0XDC,0XAC,
0XBB,0XEA,0X92,0X85,0X9B,0X48,0XD4,0XEE,0XD4,0XEE,0XD4,0XED,0XDD,0X0D,0XE5,0X0D,
0XE4,0XED,0XE4,0XAB,0XD4,0X49,0XDC,0X4A,0XF4,0XEC,0XEC,0XAA,0XFD,0X4D,0XE4,0XED,
0XAB,0XEB,0X7A,0X87,0XAC,0X2C,0X8B,0X08,0X93,0XAA,0X83,0X09,0X72,0X24,0XA3,0X8A,
0X5B,0XFB,0X01,0X56,0X01,0X97,0X01,0X97,0X01,0XB7,0X01,0XD7,0X01,0X36,0X01,0X55,
0X01,0X15,0X00,0XF5,0X01,0X35,0X01,0X35,0X01,0X55,0X01,0X35,0X01,0X14,0X01,0XD6,
0X12,0X77,0X33,0X79,0X54,0X38,0XA5,0XDD,0X6C,0X78,0X53,0X55,0X3B,0X35,0X1A,0X32,
0X09,0XD3,0X01,0X31,0X0A,0X14,0X4B,0XB8,0X64,0X18,0X7D,0X19,0X95,0X9B,0X74,0X55,
0XA5,0XF9,0XCE,0XFD,0XBE,0X7A,0X8D,0X16,0XA5,0XB6,0X8C,0XF3,0X9D,0X57,0X6B,0XCF,
0X74,0X12,0X00,0X62,0X11,0X25,0X00,0X22,0X22,0X49,0X09,0X26,0X7C,0XD4,0X2A,0X0B,
0X11,0XC9,0X09,0X46,0X00,0X84,0X74,0X0F,0XBD,0X2E,0X83,0X27,0X72,0X24,0X61,0X42,
0X61,0X64,0XFF,0X7C,0XFF,0XFB,0XFF,0XD9,0XFF,0XB7,0XFF,0X56,0XFF,0X34,0XFE,0XD2,
0XFE,0X30,0XFE,0X30,0XFE,0X0F,0XFD,0X8E,0XF5,0X4D,0XEC,0XEB,0XE4,0XEC,0XDC,0X8B,
0XDC,0X6B,0XE4,0XCC,0XE4,0XAA,0XD4,0X4A,0XE4,0XCB,0XCC,0X29,0XDC,0X8B,0XD4,0X4A,
0X5B,0XDA,0X01,0X96,0X01,0X77,0X01,0XB8,0X01,0XD8,0X01,0X56,0X54,0X5C,0X95,0X9B,
0X9E,0X1D,0X8D,0XDD,0X8D,0XFE,0X75,0X3B,0X8D,0XFE,0X7D,0X5C,0X96,0X3D,0X8D,0XBA,
0X9D,0XDA,0X8D,0X38,0X84,0XD6,0X74,0X54,0XA5,0X78,0XCE,0X38,0X7B,0XEF,0X63,0X4C,
0XCE,0XDA,0X95,0X35,0X9D,0X77,0X74,0X73,0X6C,0X51,0X7C,0XB3,0X3A,0XCC,0X2A,0X49,
0X5B,0XF0,0X3B,0X0D,0X43,0X4F,0X11,0X87,0X22,0X28,0X5B,0XEF,0X11,0X87,0X00,0X21,
0X00,0X84,0X00,0X64,0X2B,0XB1,0X0A,0X8F,0X34,0XD9,0X02,0X6F,0X00,0X25,0X01,0X4A,
0X09,0XCD,0X01,0X09,0X00,0XC9,0X11,0X47,0XC5,0X91,0XAC,0X2C,0XBC,0X6C,0XBC,0X4D,
0XB4,0X4F,0XFF,0XFE,0XFF,0XFA,0XFF,0X97,0XFF,0X35,0XFF,0X14,0XFE,0XF3,0XFE,0XB1,
0XFE,0X2F,0XFD,0XCD,0XFD,0X8C,0XF5,0X0B,0XFD,0X6B,0XFD,0X6C,0XF5,0X2B,0XE4,0XAA,
0XC3,0X87,0XD4,0X6B,0XDC,0X8C,0XD4,0X4A,0XCC,0X29,0XCB,0XC7,0XC3,0X87,0XCB,0XE9,
0X6C,0XBC,0X01,0XB7,0X01,0X97,0X01,0XD8,0X01,0XD8,0X01,0XB7,0X33,0X5B,0X7C,0XD8,
0XBE,0XBB,0XA6,0X39,0X84,0XD5,0X95,0X98,0X5B,0XF2,0X74,0XD6,0X09,0X69,0X00,0XC8,
0X12,0X2F,0X1A,0XB4,0X0A,0X55,0X01,0XF3,0X01,0XF4,0X4B,0X96,0XFF,0XFF,0X85,0X34,
0X74,0X92,0X21,0XE9,0X3B,0X0D,0X19,0XEA,0X1A,0X0A,0X09,0X47,0X22,0X0B,0X01,0X06,
0X09,0X68,0X12,0X6C,0X12,0XCD,0X01,0X88,0X01,0X89,0X12,0X6D,0X12,0X8E,0X0A,0X8F,
0X6F,0X1F,0X24,0X57,0X0B,0X33,0X02,0X90,0X1B,0X94,0X01,0X6A,0X01,0X09,0X0A,0X4F,
0X01,0XCC,0X01,0X09,0X01,0X2A,0X00,0X46,0X00,0X24,0X01,0X2A,0X4C,0XB6,0X01,0X4A,
0X00,0X45,0XF7,0XBD,0XFF,0XFB,0XFF,0X97,0XFE,0XF4,0XFE,0XD2,0XFE,0XB2,0XFE,0X50,
0XFD,0X8D,0XFD,0X8C,0XFD,0X4C,0XF4,0XEA,0XF5,0X2B,0XF5,0X0B,0XF4,0XEA,0XEC,0XAA,
0XE4,0X8B,0XEC,0XEB,0XD4,0X08,0XE4,0X8A,0XC3,0X87,0XC3,0XE8,0XA3,0X26,0XC4,0X2A,
0X5C,0X5D,0X22,0XB7,0X01,0X98,0X01,0XD8,0X01,0XF9,0X02,0X1A,0X01,0XD8,0X01,0X76,
0X02,0X57,0X1B,0X17,0X23,0X16,0X23,0X15,0X01,0XD1,0X02,0X14,0X0A,0X58,0X01,0XF8,
0X01,0XD8,0X02,0X19,0X01,0XF8,0X02,0X18,0X01,0XD7,0X01,0XD6,0X7D,0X9F,0X01,0XB1,
0X00,0XAD,0X01,0X2F,0X01,0XF3,0X0A,0X36,0X0A,0X76,0X01,0XF6,0X01,0X94,0X01,0X94,
0X01,0X12,0X3C,0XFC,0X24,0X58,0X2C,0X78,0X45,0X7B,0X0B,0X34,0X13,0X54,0X02,0XB3,
0X5E,0XDF,0X02,0XB1,0X34,0XD9,0X0A,0XF2,0X02,0X4F,0X01,0XED,0X0A,0X70,0X01,0XED,
0X00,0X26,0X01,0XED,0X09,0X48,0X31,0XC8,0X29,0X47,0X6C,0X31,0X52,0XEC,0X9D,0X54,
0X84,0X10,0XDE,0X57,0XFF,0XFB,0XFF,0X35,0XFE,0X91,0XFE,0X50,0XFE,0X0F,0XFD,0XEF,
0XF5,0X4D,0XF5,0X2C,0XEC,0XCB,0XE4,0XAA,0XE4,0X8A,0XF5,0X0C,0XEC,0XCA,0XDC,0X28,
0XE4,0X49,0XE4,0X49,0XCB,0XA6,0XD3,0XE7,0XB3,0X04,0XCB,0XA7,0XA2,0XA4,0X92,0X22,
0X43,0XBD,0X33,0X18,0X01,0X98,0X01,0XF9,0X02,0X1A,0X02,0X1A,0X02,0X5A,0X02,0X5A,
0X02,0X19,0X01,0XF8,0X01,0XD9,0X01,0XD8,0X02,0X19,0X01,0XF9,0X01,0XF8,0X01,0XD8,
0X02,0X19,0X02,0X5A,0X02,0X39,0X02,0X39,0X02,0X19,0X01,0XF8,0X01,0X76,0X01,0XD8,
0X01,0XD6,0X02,0X39,0X01,0XD7,0X01,0X96,0X01,0XB5,0X01,0XB5,0X01,0X95,0X01,0X94,
0X01,0X73,0X01,0X11,0X01,0XB3,0X2B,0XF9,0X02,0X91,0X0A,0XD4,0X24,0X39,0X2C,0XFB,
0X2D,0X5A,0X35,0X19,0X2C,0XD9,0X3D,0X58,0X01,0XCD,0X01,0X6A,0X22,0XCF,0X8D,0X13,
0XEF,0X17,0XEE,0XB5,0XFE,0XF5,0XFF,0X15,0XFE,0XF4,0XFE,0X92,0XFE,0X51,0XFE,0X51,
0XFE,0X0F,0XF5,0XB0,0XFF,0X37,0XDD,0X8F,0XDD,0X0D,0XCC,0X2B,0XCC,0X4B,0XCC,0X4A,
0XBB,0X88,0XC4,0X0B,0XDC,0X8D,0XBB,0XCA,0XCC,0X2B,0XDC,0X8C,0XDC,0X6A,0XD4,0X09,
0XC3,0X87,0XBB,0X67,0XCB,0XC8,0XAA,0XE5,0XB3,0X05,0XBB,0X46,0X92,0X22,0X92,0X02,
0X43,0XDD,0X4B,0XDB,0X01,0X98,0X02,0X1A,0X02,0X3A,0X02,0X3A,0X02,0X5B,0X02,0X3A,
0X02,0X39,0X02,0X19,0X02,0X19,0X02,0X3A,0X02,0X1A,0X02,0X3A,0X02,0X19,0X01,0XF9,
0X02,0X3A,0X02,0X19,0X02,0X19,0X02,0X19,0X02,0X18,0X01,0XF8,0X02,0X18,0X01,0XF8,
0X01,0XF7,0X02,0X18,0X02,0X17,0X01,0XB6,0X01,0XB6,0X01,0XD6,0X01,0XB5,0X01,0XB4,
0X01,0X73,0X01,0X53,0X01,0X12,0X01,0X11,0X01,0XF3,0X01,0XB3,0X02,0X53,0X24,0X79,
0X5E,0XFF,0X13,0X74,0X2D,0X19,0X34,0XB7,0X3D,0X39,0X1B,0X91,0XB6,0X16,0XFF,0XF9,
0XFF,0X96,0XFF,0X13,0XFE,0X50,0XFD,0XEE,0XFD,0XCE,0XFD,0XCE,0XFD,0XEE,0XFD,0XCE,
0XFD,0X6D,0XFD,0X8E,0XF5,0X8E,0XED,0X4E,0XEC,0XEC,0XF5,0X0C,0XF5,0X0B,0XF5,0X2D,
0XC3,0X66,0X89,0XE3,0X69,0X21,0X58,0XE1,0X61,0X63,0X59,0X42,0X59,0X43,0X51,0X02,
0X51,0X22,0X61,0X42,0X69,0X42,0X82,0X24,0XAB,0X69,0X92,0X65,0X68,0XE0,0X8A,0X02,
0X33,0X5B,0X85,0X3E,0X01,0X78,0X01,0XFA,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5B,
0X02,0X3A,0X02,0X1A,0X02,0X3A,0X02,0X5A,0X02,0X1A,0X02,0X3A,0X02,0X3A,0X02,0X3A,
0X02,0X59,0X02,0X19,0X02,0X17,0X0A,0X16,0X01,0XF7,0X01,0XD7,0X01,0XF7,0X01,0XD7,
0X02,0X18,0X02,0X18,0X01,0XF7,0X01,0XD7,0X01,0XD6,0X01,0XF6,0X01,0XB6,0X01,0XB5,
0X01,0X74,0X01,0X32,0X01,0X32,0X01,0X94,0X01,0X73,0X01,0X11,0X12,0X95,0X45,0XDE,
0X35,0X7B,0X1B,0XD6,0X67,0X5F,0X3D,0X39,0X1B,0XD4,0X33,0X50,0XFF,0XFE,0XFF,0X97,
0XFF,0X13,0XFE,0XB1,0XFE,0X2F,0XFD,0XCE,0XFD,0X6D,0XFD,0X4C,0XFD,0X4C,0XF5,0X2C,
0XFD,0X6D,0XF5,0X2C,0XFD,0X8D,0XF5,0X0C,0XFD,0X2D,0XEC,0XEB,0XF5,0X0C,0XFD,0X8E,
0XE4,0X4A,0XAA,0XC6,0X89,0XC4,0X81,0XE5,0X81,0XC5,0X82,0X05,0X71,0XC4,0X69,0X63,
0X71,0XC4,0X61,0X42,0X61,0X01,0X48,0X40,0X60,0XE0,0X9A,0XC5,0XC3,0XE9,0XEC,0XEB,
0X01,0X37,0X74,0XFD,0X01,0X98,0X02,0X3B,0X02,0X5C,0X02,0X5B,0X02,0X9C,0X02,0X5C,
0X02,0X5B,0X02,0X5B,0X02,0X7B,0X02,0X7B,0X02,0X3A,0X02,0X5A,0X02,0X5A,0X02,0X5A,
0X02,0X5A,0X02,0X16,0X5B,0XF3,0X53,0X91,0X3B,0X13,0X01,0XD5,0X01,0X76,0X01,0X95,
0X01,0XF7,0X01,0XF7,0X01,0XF8,0X01,0XF7,0X01,0XD7,0X01,0XD6,0X01,0XD6,0X01,0XB5,
0X01,0XB5,0X01,0X74,0X01,0X33,0X01,0X94,0X01,0X94,0X01,0X93,0X00,0XF0,0X24,0X79,
0X5E,0XFF,0X3D,0X9A,0X1B,0XF3,0X01,0X8A,0X6C,0X30,0XFF,0XBA,0XFF,0XFC,0XFF,0X76,
0XF6,0X50,0XF5,0XCE,0XF5,0X8E,0XED,0X0C,0XDC,0X6A,0XED,0X0C,0XF5,0X2D,0XE4,0XCB,
0XED,0X0C,0XED,0X2D,0XED,0X0D,0XF5,0X8E,0XF5,0XD0,0XFD,0XD0,0XEC,0XCC,0XE4,0X8A,
0XE4,0XAB,0XCB,0XA7,0XA2,0X85,0X92,0X45,0X82,0X05,0X82,0X25,0X58,0XE1,0X69,0X63,
0X82,0X64,0X93,0X06,0XAB,0XC8,0XFE,0X50,0XFE,0XB0,0XFD,0XED,0XFD,0X4B,0XF4,0XA9,
0X01,0X78,0X9D,0XFF,0X01,0X77,0X02,0X3B,0X02,0X7C,0X02,0X7C,0X02,0X7C,0X02,0X7C,
0X02,0X7C,0X02,0X5B,0X02,0X3B,0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X5A,0X02,0X39,
0X02,0X5A,0X01,0XD7,0X7C,0X90,0XB5,0XCC,0X94,0XCC,0X53,0X50,0X2A,0X71,0X11,0XD1,
0X0A,0X35,0X02,0X17,0X01,0XF8,0X01,0XD7,0X01,0XD7,0X01,0XD6,0X01,0XF6,0X01,0XD6,
0X01,0X95,0X01,0X73,0X01,0X74,0X01,0X94,0X01,0X53,0X01,0X93,0X01,0X11,0X34,0XDA,
0X02,0XD3,0X4E,0X3D,0X2C,0XB5,0X00,0XA7,0X7C,0XD3,0XFF,0X79,0XCD,0XF3,0XCE,0X76,
0XEE,0XD8,0XFF,0X37,0XFF,0X57,0XFE,0XF4,0XFE,0XF4,0XFF,0X55,0XFF,0X14,0XFE,0XB2,
0XFE,0X51,0XFE,0X92,0XFE,0X91,0XFE,0XB1,0XFE,0XD2,0XFE,0XB0,0XFE,0X4F,0XED,0X6D,
0XFE,0X70,0XF5,0X2C,0XDC,0X29,0XC3,0X68,0X8A,0X25,0X79,0XC3,0XBC,0XF0,0XFF,0XF9,
0XFF,0XF6,0XFF,0XF5,0XFE,0XD0,0XFE,0X2E,0XF5,0X4B,0XFD,0X4B,0XF5,0X0B,0XEC,0XCA,
0X01,0XB9,0X95,0XDF,0X02,0X17,0X02,0X5B,0X02,0X7C,0X02,0X7C,0X02,0X7C,0X02,0X5C,
0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X39,
0X02,0X5A,0X01,0XF8,0X32,0XF0,0XDE,0XE9,0XBD,0XC8,0XA4,0XA9,0X94,0X6B,0X94,0X6D,
0X3A,0XD2,0X01,0XD7,0X02,0X18,0X01,0XF7,0X01,0XF7,0X02,0X17,0X01,0XF7,0X01,0XD6,
0X01,0XB5,0X01,0X74,0X01,0X94,0X01,0X94,0X01,0X94,0X01,0X72,0X00,0XF1,0X45,0X3B,
0X13,0X95,0X56,0X3C,0X00,0XA6,0X0A,0X8F,0X65,0X78,0XAE,0X36,0XA4,0XB0,0X6A,0XEC,
0XFF,0XDD,0XFF,0XFB,0XFF,0X76,0XFF,0X34,0XFE,0XD3,0XFE,0X91,0XFE,0X50,0XFE,0X2F,
0XFE,0X2F,0XFD,0XEE,0XFD,0XAD,0XFD,0XCE,0XFD,0XAD,0XFD,0X6C,0XFD,0X8C,0XFD,0XAC,
0XFE,0X0E,0XFD,0XCE,0XFD,0X2C,0XE4,0X6A,0XDC,0X2A,0XB3,0X49,0XFF,0XFC,0XFF,0XB7,
0XF7,0X11,0XF6,0X8F,0XFE,0X6F,0XFE,0X6F,0XFE,0X2F,0XFD,0XAD,0XFD,0X4C,0XEC,0XAA,
0X01,0XD9,0X64,0XBF,0X12,0X57,0X02,0X3B,0X02,0X7C,0X02,0X7C,0X02,0X7C,0X02,0X7C,
0X02,0X7C,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X1A,0X02,0X19,0X02,0X19,
0X02,0X5A,0X02,0X5A,0X01,0XB3,0XC6,0XCA,0XD6,0XA6,0XB5,0X25,0XC5,0X48,0X84,0X2C,
0X01,0X94,0X01,0XF7,0X02,0X18,0X01,0XF7,0X02,0X18,0X01,0XD6,0X01,0XB5,0X01,0XB5,
0X01,0XB5,0X01,0XD5,0X01,0X95,0X01,0XB4,0X01,0XB4,0X01,0X52,0X01,0X11,0X35,0X1B,
0X13,0XB6,0X77,0X7F,0X02,0X6D,0X56,0X3E,0X85,0XD7,0XD6,0XD6,0XB5,0X30,0X6A,0X89,
0XFF,0XFD,0XFF,0XFA,0XFF,0X55,0XFE,0XF2,0XFE,0X91,0XFE,0X50,0XFD,0XEE,0XFD,0XEE,
0XFD,0XEF,0XFD,0XCE,0XFD,0X4C,0XFD,0X8E,0XFD,0XAE,0XFD,0X6D,0XFD,0X4C,0XFD,0X4D,
0XFD,0X8E,0XFD,0XAE,0XFD,0X6D,0XFD,0X0C,0XEC,0XCC,0XFF,0XBC,0XFF,0XFC,0XFF,0XF7,
0XFF,0XB4,0XFF,0X31,0XFE,0X6F,0XFE,0X2E,0XFD,0XCD,0XFD,0X4B,0XFC,0XEA,0XDC,0X28,
0X01,0XD9,0X75,0X3F,0X54,0X1A,0X02,0X1B,0X02,0X7C,0X02,0X9D,0X02,0X7C,0X02,0X7C,
0X02,0X9C,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X01,0XF8,0X02,0X36,0X22,0XF6,0X0A,0X55,
0X01,0XB6,0X02,0X19,0X01,0X36,0X85,0X0A,0XF7,0XE6,0XDE,0XC5,0XCE,0X6A,0X09,0X8E,
0X01,0XD7,0X02,0X18,0X02,0X18,0X02,0X38,0X01,0X72,0X01,0X2E,0X32,0XF7,0X01,0X94,
0X01,0X95,0X01,0XB5,0X01,0XD5,0X01,0X94,0X01,0X94,0X01,0X73,0X00,0XF1,0X1B,0X56,
0X3D,0X5B,0X2C,0XD8,0X24,0X75,0X23,0XF5,0X33,0XB2,0XD6,0XF9,0XD6,0X34,0XFF,0X56,
0XFF,0X7B,0XFF,0XD9,0XFE,0XD2,0XFE,0X71,0XFE,0X11,0XFD,0XD0,0XF5,0X6F,0XED,0X2F,
0XF5,0XB1,0XE5,0X4F,0XC4,0X4C,0XB3,0XEB,0XBC,0X0C,0XB3,0XEC,0XC4,0X6D,0XE5,0X2F,
0XFD,0XB1,0XFD,0X90,0XFD,0XF1,0XFD,0X90,0XED,0X0E,0XFF,0XDE,0XFF,0XFD,0XFF,0XF6,
0XFF,0X92,0XFE,0XCE,0XFD,0XEC,0XFD,0X6B,0XFD,0X6C,0XEC,0X68,0XDB,0XE7,0XBB,0X05,
0X01,0XDA,0X3B,0X9C,0X85,0X3D,0X01,0XDA,0X02,0X7C,0X02,0X7C,0X02,0X7C,0X02,0X7C,
0X02,0X7C,0X02,0X7C,0X02,0X3A,0X01,0XD8,0X2A,0XF5,0X7D,0X31,0X9D,0XCE,0X9D,0XEE,
0X7C,0XEF,0X22,0XD0,0X0A,0X10,0XA5,0XCD,0XFF,0XF2,0XFF,0XF1,0X4B,0X4E,0X01,0X34,
0X0A,0X38,0X0A,0X17,0X01,0XB4,0X00,0XCB,0X00,0X04,0XA5,0X9A,0X22,0X96,0X01,0X95,
0X01,0XB5,0X01,0X95,0X01,0XB5,0X01,0XB4,0X01,0X94,0X01,0X52,0X01,0X32,0X00,0XF0,
0X1B,0X77,0X5E,0X7E,0X4D,0X99,0X00,0XE9,0X4D,0X5A,0X01,0XCA,0XD7,0XDC,0XFF,0XD6,
0XF6,0X93,0XE7,0X37,0XCD,0XD2,0XC5,0X10,0XAC,0XAF,0X8B,0X6B,0X7B,0X0A,0X59,0XA5,
0X59,0X84,0X69,0XE5,0X59,0X63,0X59,0X02,0X51,0X01,0X61,0X23,0X58,0XE1,0X61,0X42,
0X69,0X63,0X61,0X63,0X71,0XC5,0X61,0X63,0X61,0X43,0XD6,0X38,0XFF,0XFC,0XFF,0X72,
0XFE,0XEF,0XFD,0XCB,0XEC,0XA9,0XDC,0X07,0XE4,0X49,0XC3,0X25,0XA2,0X63,0XA2,0X63,
0X02,0X3C,0X02,0X5A,0XC6,0XFF,0X01,0X97,0X02,0X5C,0X02,0X7C,0X02,0X7C,0X02,0X7C,
0X02,0X7C,0X02,0X5C,0X01,0XFA,0X1A,0X94,0XA6,0X30,0XCE,0XEA,0XCE,0XC8,0XCE,0XC7,
0XD7,0X28,0XC6,0XA8,0XE7,0X8A,0XFF,0XF5,0XFF,0XDC,0X7B,0X6B,0X08,0XA3,0X00,0X65,
0X00,0X86,0X00,0X65,0X00,0X01,0X00,0X01,0XC6,0X19,0XD7,0X1F,0X00,0XD1,0X01,0XD7,
0X01,0XD6,0X01,0X95,0X01,0XD5,0X01,0XB5,0X01,0X94,0X01,0X73,0X01,0X73,0X00,0XF1,
0X02,0X13,0X45,0X9A,0X02,0X6F,0X2C,0X55,0X3C,0XD8,0X1B,0XB4,0X7D,0X74,0XFF,0XF8,
0XFE,0XB3,0XFE,0X52,0XF5,0XAF,0XE5,0X4E,0XD4,0XEE,0X8B,0X6B,0X7B,0X2B,0X83,0X6C,
0X83,0X6C,0X83,0X4B,0X93,0X2A,0X8A,0XC9,0X9B,0X29,0X9B,0X29,0XA3,0X49,0XA3,0X08,
0XA2,0XE8,0X9A,0XE7,0X9A,0XE8,0X8A,0X66,0X69,0X42,0XC4,0XF3,0XFF,0XFB,0XF6,0X2D,
0XFD,0XCC,0XD4,0X07,0XB3,0X05,0XBB,0X26,0XB3,0X26,0X9A,0X64,0X79,0XC3,0X59,0X22,
0X02,0X5D,0X01,0XF9,0XC7,0X1F,0X12,0X36,0X02,0X3C,0X02,0X5C,0X02,0X5C,0X02,0X5C,
0X02,0X3B,0X02,0X3B,0X01,0XF7,0X74,0XF0,0XC6,0XC9,0XCE,0XE7,0XCE,0XC6,0XCE,0XE5,
0XCE,0XE4,0XDF,0X04,0XFF,0XF3,0XFF,0XFD,0X39,0X64,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XB5,0X97,0XFF,0XFF,0X3B,0X36,0X01,0X96,0X01,0XD6,
0X01,0XD6,0X01,0XD6,0X01,0XD5,0X01,0X94,0X01,0X94,0X01,0X93,0X01,0X73,0X00,0XF1,
0X12,0X94,0X3D,0X18,0X01,0XEE,0X45,0X9B,0X02,0X2F,0X55,0X9A,0X0A,0XCD,0X84,0XF3,
0X9C,0XD0,0X73,0XAD,0X9C,0X90,0XB4,0XD1,0XB4,0XD1,0XB4,0XF1,0XAC,0X8F,0X9C,0X2E,
0X9B,0XEE,0X93,0XAC,0X83,0X0A,0X8B,0X8C,0X72,0XEA,0X83,0X6B,0X72,0XA9,0X93,0X8C,
0X93,0X6B,0X93,0X4A,0XA3,0XCC,0XAB,0XCC,0X8A,0XE8,0X8B,0X4B,0XFF,0XFC,0XE5,0X2C,
0XC3,0XC7,0XAB,0X06,0X92,0XA5,0X61,0X62,0X30,0X80,0X38,0XC2,0X28,0X60,0X20,0X20,
0X02,0X9D,0X01,0X79,0XAE,0XBF,0X4B,0X77,0X01,0XFB,0X02,0X5C,0X02,0X5C,0X02,0X5C,
0X02,0X5B,0X02,0X1B,0X12,0X75,0XAE,0X2C,0XD7,0X06,0XCE,0XC5,0XD6,0XC5,0XD6,0XE4,
0XE7,0X45,0XFF,0XF4,0XFF,0XFE,0X4A,0X48,0X00,0X00,0X00,0X21,0X08,0X41,0X00,0X00,
0X00,0X00,0X31,0X46,0XCE,0X19,0XFF,0XDF,0XB6,0X1C,0X00,0XF0,0X02,0X17,0X01,0XD6,
0X01,0XF6,0X01,0XD6,0X01,0XB5,0X01,0X95,0X01,0X94,0X01,0X74,0X01,0X94,0X01,0X52,
0X00,0XAF,0X5E,0X7E,0X13,0X53,0X66,0XFF,0X02,0XF1,0X3C,0XD7,0X2C,0X14,0X02,0XAE,
0X01,0X49,0X21,0XE8,0X3A,0X07,0X6A,0XC9,0X5A,0X69,0X31,0X66,0X18,0XE4,0X18,0XA4,
0X18,0XA4,0X6A,0X88,0X6A,0X27,0X59,0XC5,0X41,0X44,0X30,0XC2,0X38,0XE3,0X38,0XC2,
0X30,0X81,0X38,0XA1,0X30,0X81,0X30,0X80,0X28,0X40,0X20,0X00,0X6A,0XEA,0X8B,0X6B,
0X59,0X82,0X38,0XA1,0X30,0X61,0X49,0X02,0X51,0X22,0X51,0X22,0X48,0XE1,0X40,0XC1,
0X02,0X9E,0X01,0XFB,0X85,0X7F,0X95,0X7C,0X01,0X99,0X02,0X5D,0X02,0X5D,0X02,0X5D,
0X02,0X5C,0X02,0X1A,0X22,0XF3,0XC6,0XCA,0XD6,0XE5,0XD6,0XE4,0XDF,0X23,0XEF,0X65,
0XFF,0XF8,0XFF,0XDF,0X31,0X66,0X00,0X00,0X08,0X21,0X00,0X20,0X00,0X00,0X00,0X00,
0X52,0X4A,0XDE,0X9B,0XE6,0XBC,0XF7,0X7F,0X95,0X39,0X01,0X53,0X02,0X18,0X01,0XD7,
0X01,0XD7,0X01,0XB6,0X01,0XF6,0X01,0XD6,0X01,0XB5,0X01,0XD5,0X01,0X74,0X01,0X12,
0X0A,0X55,0X2C,0X57,0X1B,0XD8,0X56,0X9E,0X5E,0X3B,0X56,0X5C,0X34,0XD6,0X13,0X92,
0X54,0X11,0XFF,0XF8,0XFF,0X34,0XE5,0X6F,0X9B,0X6B,0X7A,0XC9,0X7A,0XA9,0X72,0X88,
0X82,0XE9,0X82,0X87,0X82,0X46,0X8A,0XA7,0X7A,0X46,0X82,0X67,0X8A,0XA8,0X9B,0X29,
0X82,0X87,0X7A,0X25,0X69,0XA3,0X61,0XC4,0X59,0X62,0X8A,0XC7,0X7A,0X24,0X8A,0XA6,
0X9A,0XE6,0X82,0X23,0X82,0X04,0X8A,0X24,0X81,0XE2,0X8A,0X84,0X8A,0X64,0X79,0XC3,
0X02,0X9E,0X02,0X1C,0X3B,0XBD,0XCF,0X1F,0X01,0XD5,0X02,0X3D,0X02,0X9E,0X02,0X3D,
0X02,0X5C,0X01,0XFA,0X3B,0X50,0XDF,0X48,0XDF,0X04,0XE7,0X62,0XEF,0XA7,0XFF,0XF9,
0XEF,0X7D,0X18,0XC3,0X00,0X00,0X08,0X42,0X08,0X41,0X00,0X00,0X00,0X00,0X41,0XE8,
0XD6,0X3A,0XD6,0X1A,0XD6,0X5B,0XE6,0XBC,0X2A,0X50,0X01,0XB6,0X02,0X39,0X02,0X38,
0X01,0XF7,0X01,0XD7,0X01,0XD6,0X01,0XD6,0X01,0XB5,0X01,0XB5,0X01,0X95,0X01,0XB4,
0X01,0X94,0X01,0XD4,0X01,0X32,0X56,0X1E,0X35,0X39,0X35,0X39,0X02,0XAF,0X02,0X0B,
0X54,0XD4,0XFF,0XF9,0XFE,0XD3,0XE5,0XB0,0XB4,0X6F,0XDE,0X34,0XFF,0X14,0XF6,0X11,
0XFD,0XF0,0XFD,0XCF,0XFD,0XD0,0XFD,0XF0,0XFD,0XAF,0XFD,0XCF,0XFD,0XF0,0XF5,0X0D,
0XF5,0X0D,0XFD,0X4E,0XE4,0XCC,0XEC,0XCB,0XE4,0XAB,0XE4,0XCC,0XE4,0XCC,0XD3,0XE8,
0XAA,0XE4,0XED,0XD1,0XFF,0X95,0XFE,0X6F,0XF5,0X4C,0XC3,0X66,0X71,0X40,0X58,0X80,
0X02,0X9F,0X02,0X5D,0X01,0XBA,0XD7,0X7F,0X4B,0X55,0X01,0XFB,0X02,0X7D,0X02,0X7D,
0X02,0X3D,0X01,0X97,0X7C,0XCC,0XE7,0X65,0XEF,0X83,0XFF,0XEB,0XFF,0XFA,0X9C,0XB2,
0X00,0X00,0X00,0X00,0X10,0X62,0X08,0X41,0X08,0X21,0X00,0X00,0X39,0XA7,0XCE,0X1A,
0XBD,0X77,0XBD,0X57,0XD6,0X1A,0X8C,0X13,0X01,0X11,0X02,0X58,0X01,0XF8,0X02,0X38,
0X02,0X18,0X01,0XB6,0X01,0XD6,0X01,0XF6,0X01,0XD5,0X01,0XB5,0X01,0XD5,0X01,0XB4,
0X01,0XD5,0X01,0XF5,0X01,0XB4,0X02,0XD5,0X56,0X7F,0X7F,0XFF,0X4D,0XFA,0X56,0X3C,
0X4D,0X58,0X7D,0XD6,0X5C,0X10,0X53,0XF1,0X12,0X0A,0XE7,0X9C,0XFF,0XF7,0XFF,0X11,
0XFE,0X0F,0XFD,0XCE,0XFD,0X8E,0XFD,0X6E,0XFD,0XAE,0XFD,0X4D,0XFD,0X6D,0XEC,0X8A,
0XF4,0XCB,0XE4,0XAA,0XDC,0X4A,0XD3,0XE8,0XCC,0X08,0XD4,0X08,0XD4,0X29,0XC3,0X67,
0X92,0X22,0XF6,0X52,0XFE,0XB1,0XF5,0XEE,0XF5,0XCD,0XF5,0X8C,0XF5,0X6C,0XFD,0XAD,
0X02,0X9F,0X02,0X9F,0X01,0XBB,0XA6,0X5F,0XAD,0XFC,0X01,0XD5,0X02,0X3D,0X02,0X7D,
0X02,0X1A,0X42,0XF0,0XF7,0XCA,0XFF,0XE7,0XFF,0XF0,0XD6,0X55,0X29,0X44,0X00,0X00,
0X10,0X41,0X08,0X41,0X00,0X00,0X00,0X00,0X00,0X00,0X39,0X87,0XD6,0X1B,0XCD,0XFA,
0XB5,0X37,0XAD,0X16,0XE6,0XBC,0X3A,0X90,0X01,0XD7,0X02,0X38,0X02,0X38,0X02,0X38,
0X02,0X38,0X02,0X17,0X01,0XF7,0X01,0XF6,0X01,0XD6,0X01,0XF6,0X01,0XD6,0X01,0XF5,
0X01,0XF5,0X01,0XF5,0X01,0XF6,0X01,0X93,0X0B,0X37,0X6F,0X7F,0X56,0X5B,0X01,0XEB,
0X01,0X8B,0X5E,0X5C,0X02,0X4D,0X01,0X48,0X01,0XAA,0X96,0X18,0XFF,0XF8,0XFF,0X12,
0XFD,0XF0,0XFD,0XF1,0XE4,0XED,0XCC,0XCF,0XBC,0X2D,0XDD,0X2F,0XFD,0XF1,0XEC,0XED,
0XEC,0XED,0XEC,0XCD,0XDC,0X6B,0XCC,0X0A,0XC3,0XA9,0XBB,0XA9,0XB3,0X68,0X9B,0X07,
0XFE,0XB4,0XF6,0X33,0XF6,0XB5,0XFF,0XFA,0XFF,0X12,0XFE,0X4E,0XFD,0X8C,0XF5,0X0B,
0X02,0X9F,0X02,0X9F,0X02,0X3E,0X12,0X9B,0XF7,0XFF,0X4B,0X53,0X12,0X59,0X01,0X95,
0X3A,0X2E,0X83,0X07,0XEE,0X89,0XB5,0X28,0X39,0X83,0X08,0X20,0X08,0X21,0X18,0X82,
0X18,0XC3,0X00,0X00,0X00,0X00,0X00,0X00,0X6A,0XED,0XDE,0X7C,0XCD,0XFA,0XB5,0X57,
0XB5,0X16,0XB5,0X77,0XCE,0X1A,0X01,0XB3,0X01,0XF8,0X02,0X39,0X02,0X18,0X02,0X38,
0X02,0X38,0X02,0X18,0X02,0X17,0X01,0XF6,0X01,0XF6,0X01,0XF6,0X01,0XD6,0X01,0XF5,
0X02,0X16,0X01,0XD5,0X01,0XF4,0X13,0X37,0X1B,0XB8,0X03,0X54,0X5E,0XDE,0X3D,0XBB,
0X02,0XB0,0X02,0XB1,0X5E,0XDE,0X6F,0X7F,0X3D,0X38,0X02,0X6E,0X6B,0XAF,0X73,0X4C,
0X95,0X75,0X19,0X87,0X01,0X07,0X33,0XF4,0X1B,0X31,0X3C,0X33,0X09,0X25,0X19,0X46,
0X10,0X83,0X20,0XE4,0X18,0XA3,0X21,0X45,0X42,0X26,0X28,0XC1,0X20,0XA0,0X5A,0X26,
0XFE,0X95,0XEE,0X11,0XCD,0X31,0XFF,0XFB,0XFE,0XD1,0XF5,0XCD,0XED,0X2B,0XCC,0X08,
0X02,0XBF,0X02,0X9F,0X02,0X7F,0X01,0XBA,0XDF,0X9F,0XFF,0XFF,0XB6,0X5E,0XB6,0X5D,
0X18,0X83,0X28,0X60,0X28,0XA0,0X10,0X40,0X18,0X62,0X20,0XA3,0X18,0XA3,0X10,0X62,
0X00,0X00,0X00,0X00,0X39,0X66,0XBD,0X77,0XEE,0XFF,0XCE,0X1B,0XB5,0X58,0XB5,0X57,
0XB5,0X36,0XAD,0X36,0X8C,0X96,0X01,0X33,0X02,0X39,0X02,0X58,0X02,0X79,0X02,0X79,
0X02,0X18,0X02,0X17,0X02,0X17,0X01,0XF7,0X01,0XD6,0X02,0X17,0X01,0XF6,0X01,0XF6,
0X02,0X16,0X01,0XB4,0X1B,0X38,0X2C,0X37,0X02,0X4F,0X1B,0XB3,0X02,0X0D,0X02,0X2F,
0X2C,0X36,0X01,0X8C,0X01,0X0B,0X34,0XB9,0X12,0XD0,0X02,0X2F,0X01,0X09,0X01,0XAC,
0X34,0X95,0X01,0X8A,0X23,0XB3,0X00,0X25,0X01,0X48,0X6D,0X56,0X19,0XC7,0X32,0X08,
0X5A,0X27,0X49,0XE6,0X41,0X84,0X73,0X2A,0X9B,0XCB,0XAB,0XA9,0XB3,0XEA,0XCC,0X8D,
0XCC,0X4B,0XCC,0X2B,0XC4,0X4D,0XFF,0X59,0XED,0XAE,0XCC,0X89,0XB3,0X66,0X9A,0X83,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X1D,0X43,0XDC,0XFF,0XFF,0XF7,0XDF,0XFF,0XFF,
0X94,0XF4,0X21,0X04,0X08,0X00,0X10,0X62,0X18,0X82,0X10,0X62,0X00,0X00,0X10,0X21,
0X4A,0X09,0XCE,0X3B,0XFF,0X7F,0XE6,0XDE,0XD6,0X3C,0XBD,0X79,0XBD,0X78,0XBD,0X98,
0XB5,0X57,0XAD,0X76,0X3A,0X91,0X01,0XD7,0X02,0X17,0X02,0X16,0X02,0X79,0X02,0X79,
0X02,0X18,0X02,0X38,0X02,0X17,0X02,0X38,0X01,0XF6,0X01,0XD6,0X02,0X17,0X02,0X37,
0X01,0XF6,0X01,0XF5,0X01,0XB4,0X0A,0XF8,0X24,0X3A,0X56,0X5C,0X0B,0X10,0X13,0X73,
0X0A,0XF1,0X01,0XED,0X01,0X4B,0X00,0XE9,0X01,0X6B,0X01,0X4A,0X01,0X4A,0X01,0XCD,
0X2C,0X55,0X13,0X72,0X2A,0X4B,0XE6,0XD4,0XF6,0X10,0XF5,0X8E,0XF5,0X6E,0XF5,0X4E,
0XFD,0X6F,0XFD,0XB0,0XFD,0XB0,0XED,0X2E,0XED,0X2E,0XEC,0XED,0XE4,0XAC,0XE4,0X8B,
0XD4,0X0A,0XD4,0X0A,0XBB,0XA9,0XE5,0XF4,0XAB,0XA8,0X92,0X64,0X92,0X64,0X9A,0XE5,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X01,0X7A,0XC6,0X9F,0XFF,0XFF,0XF7,0XBF,
0XFF,0XFF,0XFF,0XFF,0XA5,0X15,0X62,0XEB,0X83,0XF0,0X8C,0X10,0XB5,0X77,0XDE,0XDC,
0XFF,0XFF,0XFF,0XDF,0XDE,0X9D,0XD6,0X3B,0XCE,0X1B,0XC5,0XD9,0XBD,0X98,0XCE,0X1A,
0X94,0X93,0X21,0X05,0X00,0X68,0X09,0XF4,0X01,0X91,0X01,0XF5,0X02,0X59,0X02,0X59,
0X02,0X38,0X02,0X38,0X02,0X38,0X02,0X38,0X02,0X37,0X02,0X17,0X02,0X37,0X02,0X17,
0X01,0XF6,0X01,0XD5,0X01,0XF5,0X01,0XB4,0X2C,0X7A,0X2C,0X56,0X2C,0X76,0X01,0XED,
0X02,0X4E,0X0A,0X2E,0X01,0X28,0X01,0X29,0X00,0XC7,0X02,0X0D,0X02,0X4F,0X01,0XEC,
0X00,0XA7,0X09,0XAA,0X63,0X0C,0XFF,0X76,0XFD,0XF0,0XF5,0X6E,0XF5,0X6F,0XF5,0X4F,
0XF5,0X6F,0XFD,0X4F,0XF5,0X2E,0XEC,0XCC,0XEC,0XED,0XE4,0X6A,0XE4,0X6A,0XD4,0X09,
0XC3,0XA7,0XAB,0X06,0XC3,0XC9,0XC3,0XEA,0XBB,0X87,0XCB,0XE9,0XD4,0X2A,0X92,0X43,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X3E,0X0A,0X17,0XEF,0XBF,0XFF,0XFF,
0XF7,0X9E,0XF7,0XBF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF7,0X9F,0XEF,0X5F,0XDE,0X9D,0XDE,0X5C,0XCD,0XFA,0XD6,0X5B,0XB5,0X77,0X62,0XCC,
0X00,0X00,0X00,0X00,0X00,0X45,0X09,0X09,0X01,0X2D,0X01,0XD3,0X02,0X59,0X02,0X79,
0X02,0X59,0X02,0X38,0X02,0X18,0X02,0X38,0X02,0X78,0X02,0X37,0X02,0X38,0X02,0X78,
0X02,0X17,0X02,0X37,0X01,0XD5,0X23,0XD9,0X02,0XB0,0X5E,0X9E,0X02,0XD0,0X13,0X11,
0X01,0X6B,0X01,0X49,0X01,0X2A,0X0A,0X0D,0X02,0X0D,0X12,0XB0,0X53,0X90,0XF7,0XFA,
0XFF,0X55,0XFE,0XF5,0XFE,0X93,0XF5,0XAF,0XFD,0X8F,0XFD,0XAE,0XFD,0X6D,0XFD,0X4D,
0XF5,0X0C,0XF5,0X0C,0XF5,0X0C,0XE4,0X6A,0XDC,0X6A,0XCB,0XE9,0XB3,0X67,0X9A,0XA4,
0XA2,0XC5,0XD4,0X4A,0XCC,0X4A,0XD4,0X69,0XD4,0X49,0XCC,0X08,0XDC,0X6A,0XD4,0X6A,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X01,0XFD,0X2A,0X95,0XFF,0XFF,
0XFF,0XFF,0XF7,0XBF,0XF7,0XBE,0XF7,0XBE,0XF7,0XBF,0XF7,0XBF,0XF7,0XBF,0XF7,0X9F,
0XF7,0X9F,0XEF,0X5F,0XE6,0XDE,0XEE,0XFE,0XB5,0X36,0X41,0XA7,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X01,0X08,0X86,0X00,0XEB,0X02,0X58,0X02,0X38,0X02,0X59,
0X02,0X59,0X02,0X59,0X02,0X18,0X01,0XF7,0X02,0X99,0X02,0X78,0X02,0X37,0X02,0X58,
0X02,0X78,0X02,0X57,0X01,0XD5,0X34,0X7B,0X13,0XB4,0X02,0XF1,0X2C,0X35,0X0B,0X12,
0X01,0XAC,0X02,0X0C,0X01,0XED,0X00,0XE8,0X1B,0X11,0X00,0XA8,0XD7,0X1B,0XFF,0XF8,
0XFF,0X74,0XFE,0XB1,0XFD,0XEF,0XFD,0XCF,0XFD,0X4D,0XFD,0X4D,0XF5,0X0C,0XEC,0XAB,
0XE4,0X8A,0XE4,0X8B,0XDC,0X6A,0XCC,0X2A,0XD4,0X6B,0XCC,0X2A,0XD4,0X6B,0XDC,0X8C,
0XE4,0XAB,0XD4,0XAC,0XFF,0X15,0XFE,0X70,0XF5,0X6C,0XFD,0XCE,0XFD,0XAE,0XEC,0XEB,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X01,0XBA,0X5B,0XB6,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XDF,0XEE,0XFE,0XAD,0X15,0X39,0XA7,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X65,0X01,0XF4,0X02,0XBB,0X02,0X7A,0X02,0X59,
0X02,0X38,0X02,0X59,0X02,0X38,0X02,0X18,0X02,0X79,0X02,0X79,0X02,0X38,0X02,0X17,
0X02,0X58,0X02,0X36,0X02,0X36,0X01,0XF5,0X3D,0X1B,0X3C,0XF8,0X02,0XAF,0X02,0X70,
0X01,0XCD,0X02,0X2D,0X01,0X09,0X1B,0X73,0X2C,0XD8,0X01,0XED,0XA5,0XB6,0XFF,0XF7,
0XFE,0XF2,0XF5,0XCE,0XF5,0X2D,0XE4,0XCB,0XD4,0X29,0XCC,0X29,0XE4,0XCD,0XE4,0XCC,
0XE4,0XAC,0XF5,0X4E,0XED,0X0D,0XED,0X2E,0XE4,0XED,0XED,0X0D,0XEC,0XED,0XE4,0X8B,
0XD4,0X08,0XDC,0XEE,0XFF,0X96,0XFE,0X2F,0XF5,0XAC,0XED,0X2B,0XEC,0XEA,0XE4,0X89,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X01,0XDB,
0X19,0XAE,0XAD,0X56,0XE7,0X1D,0XE7,0X3D,0XCE,0X7A,0XAD,0X15,0X6B,0X2D,0X4A,0X09,
0X29,0X25,0X00,0X00,0X00,0X00,0X08,0X40,0X29,0X64,0X08,0X41,0X00,0X00,0X00,0X20,
0X00,0X00,0X00,0X00,0X00,0X02,0X01,0XD3,0X02,0X7B,0X02,0X9B,0X02,0X39,0X02,0X59,
0X02,0X58,0X02,0X38,0X02,0X18,0X02,0X58,0X02,0X79,0X02,0X58,0X02,0X58,0X02,0X78,
0X02,0X37,0X02,0X16,0X02,0X36,0X02,0X57,0X01,0XB3,0X55,0XFC,0X02,0XF1,0X1C,0X15,
0X45,0XDC,0X01,0XCC,0X13,0X32,0X02,0XB0,0X24,0XB9,0X1C,0X56,0X4C,0X33,0XE7,0X17,
0XC5,0X50,0XE5,0XD0,0XED,0XF0,0XFE,0X51,0XFE,0X30,0XFD,0XEE,0XFD,0XCF,0XF5,0X8E,
0XFD,0XD0,0XED,0X2E,0XF5,0X2D,0XF5,0X2D,0XF4,0XEC,0XEC,0XCB,0XE4,0X8A,0XDC,0X29,
0XC3,0X87,0XCC,0X8D,0XFF,0X96,0XF5,0XED,0XED,0X2B,0XE4,0XCA,0XDC,0X89,0XCC,0X07,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X9F,0X02,0X7F,
0X02,0X7E,0X00,0X27,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X20,0X29,0X22,0X5A,0XE8,0X08,0X40,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X01,0X01,0XD2,0X0A,0X9B,0X02,0X39,0X02,0XBB,0X02,0X38,0X02,0X38,
0X02,0X59,0X02,0X79,0X02,0X79,0X02,0X79,0X02,0X79,0X02,0X59,0X02,0X38,0X02,0X78,
0X02,0X78,0X02,0X57,0X02,0X37,0X02,0X57,0X01,0XD5,0X45,0X5B,0X35,0X1C,0X45,0X9C,
0X2C,0X56,0X0B,0X72,0X1B,0X94,0X0A,0XF5,0X35,0X3B,0X45,0X7A,0X01,0XCC,0X00,0XE8,
0X7C,0X92,0XFF,0XF9,0XFF,0X53,0XFE,0X70,0XFD,0XCF,0XFD,0XAE,0XFD,0XAF,0XFD,0XAF,
0XFD,0XAF,0XFD,0X4D,0XF5,0X0C,0XF4,0XCB,0XEC,0XAA,0XEC,0X8A,0XDC,0X29,0XCB,0XA7,
0XBB,0X26,0XA3,0X4A,0XFF,0XB7,0XE5,0X2B,0XCC,0X28,0XBB,0XA7,0XBB,0X87,0X92,0X85,
0X02,0X7F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X9F,0X02,0X7F,0X02,0X7F,
0X02,0X7F,0X0A,0XDF,0X00,0XCD,0X00,0X01,0X08,0X00,0X08,0X21,0X10,0X41,0X10,0X41,
0X08,0X41,0X08,0X41,0X08,0X41,0X39,0XA5,0X29,0X64,0X00,0X00,0X00,0X00,0X08,0X42,
0X08,0X62,0X01,0X09,0X0A,0XBC,0X02,0X7A,0X02,0X7B,0X02,0XBB,0X02,0X39,0X02,0X59,
0X02,0X59,0X02,0X7A,0X02,0X99,0X02,0X18,0X02,0X99,0X02,0X99,0X02,0X58,0X02,0X58,
0X02,0X78,0X02,0X78,0X02,0X57,0X02,0X37,0X02,0X57,0X02,0X35,0X01,0X32,0X23,0XB8,
0X1B,0XD6,0X34,0XDC,0X02,0X54,0X01,0X50,0X1B,0XB7,0X45,0X9A,0X02,0X8E,0X01,0X29,
0X53,0X4F,0XFF,0XFB,0XF6,0XF3,0XFE,0XD1,0XFE,0X2F,0XFE,0X0E,0XFD,0XCE,0XFD,0X8D,
0XFD,0X4D,0XFD,0X0C,0XF4,0XCB,0XE4,0X69,0XE4,0X4A,0XD4,0X2A,0XBB,0X89,0X92,0X86,
0X61,0XA3,0X28,0X81,0XCD,0XF4,0XB4,0X4A,0X82,0X64,0X69,0XC3,0X61,0XE3,0X59,0X41,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X9F,
0X02,0X7F,0X02,0X7F,0X0A,0XDF,0X0A,0X16,0X18,0XE8,0X10,0X62,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X31,0X67,0X39,0XE9,0X5A,0XEC,
0X52,0XED,0X12,0X78,0X02,0X3A,0X02,0X9B,0X02,0X9B,0X02,0X9B,0X02,0X5A,0X02,0X5A,
0X02,0X5A,0X02,0X5A,0X02,0X9A,0X02,0X17,0X02,0X79,0X02,0XDA,0X02,0X79,0X02,0X17,
0X02,0X57,0X02,0X78,0X02,0X36,0X02,0X37,0X02,0X57,0X01,0XF5,0X01,0XF5,0X01,0X93,
0X01,0XF4,0X01,0XB3,0X01,0X92,0X02,0X33,0X5E,0X5C,0X0A,0XEF,0X00,0XE8,0X00,0X66,
0X6C,0X32,0XFF,0XFB,0XFF,0XF5,0XFF,0X11,0XFE,0X6F,0XFD,0XCD,0XFD,0XAD,0XFD,0X6C,
0XF4,0XCB,0XE4,0X6A,0XD4,0X2A,0XB3,0X28,0XA3,0X08,0X7A,0X46,0X51,0X64,0X31,0X02,
0X28,0XA2,0X28,0X81,0X20,0X80,0X5A,0X47,0X73,0XAC,0X9C,0XAF,0X6A,0X23,0X59,0X61,
0X02,0X9F,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,
0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X0A,0X7D,0X6C,0X7C,0XCE,0XBD,0XCE,0X3A,
0X8C,0X73,0X5A,0XCC,0X5A,0XCD,0X83,0XF2,0X9C,0XB5,0XA5,0X15,0X73,0XAF,0X5A,0XCC,
0X2A,0XD5,0X02,0X1A,0X02,0X5B,0X02,0X7B,0X02,0X9B,0X02,0XBB,0X02,0X9A,0X02,0X7A,
0X02,0X7A,0X02,0X39,0X02,0X7A,0X02,0X58,0X02,0X99,0X02,0XDA,0X02,0X78,0X02,0X37,
0X02,0X57,0X02,0X57,0X02,0X36,0X02,0X57,0X02,0X57,0X02,0X16,0X01,0XF5,0X02,0X15,
0X02,0X15,0X01,0XF4,0X01,0XD3,0X0A,0XB5,0X55,0XFC,0X02,0X6E,0X01,0X8A,0X01,0XCA,
0X53,0X90,0XFF,0XFC,0XFF,0XF5,0XFF,0X11,0XFE,0X4E,0XFD,0XCD,0XFD,0X6D,0XE4,0XAB,
0XCB,0XE9,0X7A,0X25,0X51,0X85,0X39,0X23,0X28,0XA1,0X28,0XC2,0X31,0X02,0X30,0XE2,
0X28,0XE2,0X28,0XE2,0X10,0X40,0X18,0X20,0X83,0X8C,0XCD,0XB3,0X61,0X81,0X51,0X62,
0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,
0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X5F,0X01,0XBC,0X0A,0X59,0XC6,0XDF,
0XFF,0XFF,0XFF,0XFF,0XE6,0XBD,0XC5,0X97,0XAC,0XB3,0X94,0X52,0X6B,0X6E,0X3A,0X71,
0X02,0X3A,0X02,0X7B,0X02,0X5B,0X02,0X7B,0X02,0X9B,0X02,0X7B,0X02,0X7A,0X02,0X7A,
0X02,0X9B,0X02,0X39,0X02,0X59,0X02,0X79,0X02,0XB9,0X02,0XBA,0X02,0X99,0X02,0X78,
0X02,0X58,0X02,0X57,0X02,0X36,0X02,0X56,0X02,0X56,0X02,0X16,0X02,0X15,0X02,0X15,
0X02,0X14,0X01,0XB3,0X44,0XDB,0X0A,0XD2,0X01,0X4B,0X23,0XF4,0X13,0X31,0X4D,0X97,
0X1A,0X4C,0XFF,0XFD,0XFF,0XF7,0XFE,0XD2,0XE5,0X2D,0XC3,0XEA,0X8B,0X28,0X73,0X29,
0X49,0XC5,0X29,0X03,0X20,0XA2,0X31,0X03,0X41,0X84,0X31,0X44,0X29,0X87,0X19,0X88,
0X11,0XE9,0X21,0X87,0X6A,0XA8,0XCC,0XAD,0XE5,0X2F,0XC4,0X09,0XBB,0X87,0X38,0X40,
0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,
0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X3E,0X02,0X1E,0X01,0X59,
0X21,0XCE,0X8C,0X73,0XA5,0X57,0X4A,0X2A,0XA4,0X30,0X5A,0X29,0X42,0XB2,0X02,0X3B,
0X02,0X5C,0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X7B,0X02,0X7B,0X02,0X3A,0X02,0X39,
0X02,0X9A,0X02,0X7A,0X02,0X7A,0X02,0X79,0X02,0X79,0X02,0X99,0X02,0XB9,0X02,0X79,
0X02,0X38,0X02,0X78,0X02,0X57,0X02,0X56,0X02,0X36,0X02,0X36,0X02,0X15,0X01,0XF5,
0X01,0XF4,0X01,0XD3,0X02,0X12,0X23,0X96,0X2C,0X57,0X56,0X5D,0X6F,0X1F,0X2C,0XF6,
0X00,0X86,0X7C,0XF3,0XBD,0XB3,0X63,0X4C,0X32,0XED,0X1B,0X4F,0X56,0XD8,0X3B,0XCA,
0X32,0X06,0X21,0X85,0X32,0X6A,0X1A,0XAC,0X00,0XE6,0X4C,0X0F,0X7C,0XF2,0XAC,0X8E,
0XCC,0XCD,0XF5,0X8E,0XE4,0XCB,0XD4,0X29,0XD4,0X29,0XC3,0XA7,0XBB,0X67,0XAB,0X06,
0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,
0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X5F,0X02,0X5F,
0X01,0XDB,0X5B,0XB6,0X11,0X05,0X39,0XA8,0XB5,0X14,0X5A,0XEE,0X02,0X19,0X02,0X3C,
0X02,0X5C,0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X7B,0X02,0X7B,0X02,0X5A,0X02,0X39,
0X02,0X59,0X02,0X9A,0X02,0X79,0X02,0X59,0X02,0X59,0X02,0X79,0X02,0XB9,0X02,0X79,
0X02,0X58,0X02,0X98,0X02,0X57,0X02,0X16,0X02,0X36,0X02,0X56,0X01,0XD4,0X01,0XF4,
0X02,0X15,0X01,0XB3,0X01,0X92,0X01,0X51,0X01,0X71,0X12,0XF2,0X12,0XF2,0X02,0X2D,
0X02,0X6E,0X01,0XCA,0X24,0X33,0X13,0X72,0X34,0X97,0X13,0X33,0X23,0XF2,0X3B,0X0B,
0X00,0XE4,0X4C,0X92,0X9E,0X37,0XBD,0X50,0XE5,0XAF,0XFD,0XEE,0XF5,0X6D,0XED,0X0C,
0XE4,0XAB,0XDC,0X69,0XD4,0X49,0XC3,0XA7,0XC3,0XA8,0XB3,0X46,0X9A,0XA5,0X79,0XE3,
0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,
0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X5F,0X02,0X5F,0X02,0X5E,
0X02,0X3E,0X01,0XBB,0XA5,0XDE,0XFF,0XDF,0XC5,0XF8,0X1A,0X55,0X02,0X3C,0X02,0X3C,
0X02,0X5D,0X02,0X5C,0X02,0X5C,0X02,0X5B,0X02,0X3B,0X02,0X7B,0X02,0X5A,0X02,0X59,
0X02,0X39,0X02,0X7A,0X02,0X39,0X02,0X39,0X02,0X79,0X02,0X79,0X02,0X99,0X02,0X79,
0X02,0X58,0X02,0X78,0X02,0X36,0X02,0X16,0X02,0X15,0X02,0X36,0X02,0X15,0X01,0XF4,
0X02,0X15,0X01,0XD3,0X01,0XF3,0X01,0XB2,0X01,0XB1,0X01,0X50,0X01,0XF1,0X0A,0X93,
0X34,0X58,0X56,0X5D,0X56,0XDE,0X56,0X5A,0X23,0XB3,0X01,0XAB,0X00,0X23,0X0A,0X8E,
0X1B,0X30,0XDF,0X9B,0XFF,0X54,0XFE,0XB0,0XFE,0X4F,0XF5,0XAC,0XED,0X4C,0XDC,0XA9,
0XDC,0X69,0XD4,0X49,0XC3,0XC8,0XAB,0X26,0XA2,0XC6,0X82,0X04,0X51,0X63,0X28,0XC2,
0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X7F,0X02,0X9F,0X02,0X9F,
0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X7F,0X02,0X5F,0X02,0X5F,0X02,0X5F,
0X02,0X3F,0X02,0X1D,0X01,0X59,0XC6,0XDF,0X9D,0X38,0X01,0XB9,0X02,0X3D,0X02,0X3D,
0X02,0X3C,0X02,0X5C,0X02,0X7C,0X02,0X5B,0X02,0X5B,0X02,0X3A,0X02,0X7B,0X02,0X7A,
0X02,0X7A,0X02,0X7A,0X02,0X5A,0X02,0X59,0X02,0XBA,0X02,0X79,0X02,0X58,0X02,0X98,
0X02,0X78,0X02,0X57,0X02,0X37,0X02,0X36,0X02,0X36,0X02,0X16,0X02,0X15,0X02,0X35,
0X02,0X14,0X01,0XD3,0X01,0XB2,0X01,0XD2,0X09,0XB1,0X01,0XB1,0X01,0X90,0X01,0XB0,
0X02,0X72,0X45,0X59,0X13,0X72,0X0A,0XF1,0X00,0X44,0X00,0XC7,0X0A,0X6E,0X1C,0X15,
0X2B,0XD4,0XF7,0XFC,0XFF,0X52,0XF6,0XF1,0XF6,0XB0,0XED,0XCD,0XDD,0X0B,0XD4,0X69,
0XCB,0XE8,0XB3,0X67,0X9A,0XC6,0X61,0XA3,0X41,0X65,0X10,0XE5,0X00,0XA3,0X01,0X28,
0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,
0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X5F,0X02,0X5E,0X02,0X5F,
0X02,0X5F,0X02,0X5E,0X02,0X3E,0X01,0X9A,0X01,0XB9,0X02,0X3D,0X02,0X3D,0X02,0X3D,
0X02,0X5D,0X02,0X5C,0X02,0X7C,0X02,0X5C,0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X7A,
0X02,0X9B,0X02,0X7A,0X02,0X7A,0X02,0X59,0X02,0XBA,0X02,0XBA,0X02,0X58,0X02,0X78,
0X02,0X78,0X02,0X77,0X02,0X57,0X02,0X57,0X02,0X36,0X02,0X35,0X02,0X35,0X02,0X15,
0X02,0X14,0X01,0XB2,0X01,0XD2,0X01,0XD2,0X09,0XD1,0X01,0X91,0X01,0XB1,0X0A,0X32,
0X01,0XD0,0X1B,0X54,0X1B,0X52,0X1B,0X52,0X55,0XFA,0X24,0X13,0X01,0XAC,0X0A,0XF1,
0X01,0XCC,0XEF,0XFE,0XFF,0X54,0XE6,0XD1,0XE6,0X70,0XDD,0X4C,0XCC,0X49,0XC3,0XC9,
0X92,0X86,0X59,0XC5,0X21,0X45,0X01,0X47,0X00,0XE5,0X01,0X28,0X32,0XED,0X9D,0X14,
0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,
0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5E,0X02,0X5E,0X02,0X5F,
0X02,0X3E,0X02,0X5E,0X02,0X5E,0X02,0X3E,0X02,0X3E,0X02,0X3D,0X02,0X3D,0X02,0X3D,
0X02,0X5D,0X02,0X5C,0X02,0X5C,0X02,0X5C,0X02,0X5B,0X02,0X5A,0X02,0X5B,0X02,0X7B,
0X02,0X9B,0X02,0X7A,0X02,0X9A,0X02,0X79,0X02,0XDB,0X02,0XBA,0X02,0X79,0X02,0X58,
0X02,0X78,0X02,0X77,0X02,0X57,0X02,0X36,0X02,0X56,0X02,0X35,0X02,0X15,0X02,0X35,
0X02,0X14,0X01,0XF3,0X01,0XD2,0X01,0XB1,0X01,0XD1,0X01,0XB1,0X01,0XF1,0X02,0X12,
0X02,0X32,0X01,0XF1,0X01,0XB0,0X34,0XB8,0X2C,0X36,0X02,0X4E,0X01,0XCB,0X02,0X4D,
0X66,0X7C,0XBF,0XFF,0XFF,0XF9,0XD6,0X31,0XC5,0X0D,0X9B,0X68,0X7A,0XA7,0X39,0X03,
0X00,0X83,0X00,0XA4,0X00,0X43,0X01,0XC9,0X0B,0X31,0X5C,0X94,0X7B,0X68,0X63,0XCD,
0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,
0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X5E,0X02,0X5F,
0X02,0X3E,0X02,0X5E,0X02,0X3E,0X02,0X5E,0X02,0X3E,0X02,0X3D,0X02,0X3D,0X02,0X3D,
0X02,0X5D,0X02,0X3C,0X02,0X5C,0X02,0X5C,0X02,0X3B,0X02,0X5A,0X02,0X5B,0X02,0X7A,
0X02,0X7A,0X02,0X5A,0X02,0X59,0X02,0X79,0X02,0XBA,0X02,0XBA,0X02,0X59,0X02,0X38,
0X02,0X78,0X02,0X57,0X02,0X57,0X02,0X16,0X02,0X36,0X02,0X36,0X02,0X35,0X01,0XF4,
0X01,0XF3,0X01,0XF3,0X01,0XD2,0X01,0XD1,0X01,0XB1,0X01,0XF2,0X02,0X32,0X02,0X32,
0X02,0X12,0X02,0X32,0X01,0XF0,0X00,0XCC,0X45,0X39,0X34,0XB5,0X01,0X48,0X55,0XBA,
0X02,0XF0,0X44,0X33,0XAD,0XF4,0X73,0X6B,0X3A,0X28,0X1A,0X8A,0X0B,0X0E,0X01,0X69,
0X01,0X27,0X5F,0X1C,0X4D,0XD6,0X01,0XEA,0X14,0X17,0X2C,0X94,0X33,0X6A,0X0A,0X47,
0X02,0XFF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,
0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X5F,
0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3E,0X02,0X5E,0X02,0X3D,0X02,0X3D,0X02,0X3D,
0X02,0X5D,0X02,0X3D,0X02,0X5C,0X02,0X5C,0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5A,
0X02,0X7A,0X02,0X7A,0X02,0X39,0X02,0X79,0X02,0X99,0X02,0XBA,0X02,0X99,0X02,0X58,
0X02,0X58,0X02,0X57,0X02,0X57,0X02,0X57,0X02,0X16,0X02,0X36,0X02,0X15,0X02,0X14,
0X02,0X13,0X01,0XF3,0X01,0XD2,0X01,0XB1,0X01,0XD1,0X02,0X12,0X0A,0X53,0X02,0X12,
0X02,0X53,0X02,0X11,0X01,0XB0,0X1B,0X56,0X13,0X14,0X01,0XCA,0X0B,0X31,0X5E,0X5D,
0X01,0XCB,0X02,0X6C,0X00,0XE6,0X00,0X24,0X34,0X95,0X5F,0X3E,0X3D,0XFA,0X01,0X8A,
0X24,0X53,0X35,0X5B,0X3D,0X9D,0X13,0XB6,0X03,0X34,0X02,0XEF,0X2C,0X70,0X01,0X63,
0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0X9F,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,
0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X5F,
0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3E,0X02,0X5E,0X02,0X1D,0X02,0X3D,0X02,0X3D,
0X02,0X3D,0X02,0X5D,0X02,0X5C,0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X3B,0X02,0X5A,
0X02,0X5A,0X02,0X7A,0X02,0X59,0X02,0X79,0X02,0X79,0X02,0X9A,0X02,0X9A,0X02,0X58,
0X02,0X58,0X02,0X57,0X02,0X57,0X02,0X56,0X01,0XF5,0X02,0X15,0X02,0X14,0X02,0X14,
0X02,0X14,0X01,0XF3,0X01,0XF2,0X01,0XB1,0X01,0XF1,0X02,0X53,0X02,0X33,0X02,0X53,
0X02,0X53,0X02,0X12,0X01,0XD0,0X23,0XF3,0X1C,0X15,0X56,0X5F,0X35,0X5A,0X35,0X17,
0X56,0X5B,0X66,0X7C,0X00,0XE7,0X01,0X27,0X01,0X28,0X00,0XC7,0X00,0XA7,0X01,0X28,
0X23,0XB5,0X02,0X0E,0X02,0X0C,0X2C,0X56,0X02,0X0F,0X02,0X4F,0X12,0XCE,0X01,0X4A,
0X0B,0X1F,0X02,0XBF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X7F,
0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5E,0X02,0X5F,
0X02,0X5E,0X02,0X5E,0X02,0X3E,0X02,0X3E,0X02,0X3E,0X02,0X3E,0X02,0X5E,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X5C,0X02,0X5C,0X02,0X3B,0X02,0X5B,0X02,0X3A,
0X02,0X5A,0X02,0X7A,0X02,0X5A,0X02,0X39,0X02,0X79,0X02,0X79,0X02,0X99,0X02,0X58,
0X02,0X58,0X02,0X37,0X02,0X57,0X02,0X77,0X02,0X15,0X02,0X14,0X02,0X14,0X01,0XF3,
0X01,0XD3,0X02,0X13,0X01,0XF2,0X01,0XB1,0X0A,0X12,0X02,0X33,0X02,0X32,0X02,0X53,
0X02,0X52,0X02,0X12,0X02,0XB3,0X57,0X1F,0X2D,0X5A,0X02,0XD1,0X02,0XD0,0X44,0XF9,
0X87,0XFF,0X02,0X0B,0X4D,0XDA,0X45,0X99,0X24,0X31,0X02,0XCB,0X13,0X4D,0X0A,0X6B,
0X00,0XE6,0X00,0X65,0X45,0X57,0X00,0X87,0X01,0XC9,0X00,0XE7,0X12,0XB0,0X00,0X87,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X0A,0XFF,0X02,0XBF,0X02,0XBF,
0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X3E,
0X02,0X5E,0X02,0X3E,0X02,0X3E,0X02,0X3E,0X02,0X5E,0X02,0X5E,0X02,0X3D,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X5C,0X02,0X3B,0X02,0X3B,0X02,0X3A,
0X02,0X5B,0X02,0X7A,0X02,0X7A,0X02,0X39,0X02,0X79,0X02,0X99,0X02,0X99,0X02,0X79,
0X02,0X58,0X02,0X16,0X01,0XF6,0X02,0X77,0X02,0X16,0X02,0X14,0X02,0X14,0X01,0XF3,
0X01,0XB2,0X01,0XF2,0X01,0XF2,0X01,0XD1,0X0A,0X32,0X02,0X33,0X01,0XF1,0X0A,0X53,
0X02,0X52,0X02,0X32,0X2C,0X38,0X02,0XD2,0X13,0X93,0X01,0XCC,0X00,0XC8,0X00,0XA9,
0X5D,0XFC,0X13,0X30,0X01,0XED,0X2C,0X77,0X67,0X3F,0X56,0XFF,0X34,0XD7,0X01,0XCA,
0X00,0XC5,0X01,0X89,0X1B,0X91,0X2C,0X94,0X46,0X1C,0X1B,0X93,0X00,0X45,0X00,0X85,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0X9F,0X02,0XBF,0X02,0XBF,
0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X5F,0X02,0X5F,
0X02,0X5E,0X02,0X3E,0X02,0X3E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,0X02,0X5D,
0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X5C,0X02,0X3B,0X02,0X3B,0X02,0X3A,
0X02,0X5A,0X02,0X5A,0X02,0X7A,0X02,0X59,0X02,0X59,0X02,0X99,0X02,0X99,0X02,0X99,
0X02,0X58,0X02,0X37,0X01,0XD5,0X02,0X16,0X02,0X36,0X02,0X14,0X01,0XF4,0X01,0XF3,
0X01,0XB2,0X01,0XF2,0X01,0XF2,0X02,0X12,0X02,0X32,0X02,0X32,0X01,0XF1,0X0A,0X52,
0X02,0X32,0X01,0XF0,0X34,0XD9,0X45,0XDC,0X34,0XF7,0X02,0X0C,0X01,0X29,0X01,0X6A,
0X00,0XE8,0X34,0X54,0X0B,0X0F,0X01,0XCC,0X02,0X0E,0X12,0XF1,0X00,0XE9,0X0A,0X0B,
0X0A,0X09,0X00,0XC6,0X2B,0XD2,0X23,0XF4,0X00,0XA8,0X0A,0X8F,0X09,0XCA,0X00,0X85,
0X02,0XFF,0X02,0XDF,0X02,0XFF,0X02,0XBF,0X02,0XDF,0X02,0X9F,0X02,0XBF,0X02,0XBF,
0X02,0XBF,0X02,0X9F,0X02,0X7F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X5E,
0X02,0X5E,0X02,0X3E,0X02,0X3E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,0X02,0X5D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X3B,0X02,0X3B,0X02,0X5A,
0X02,0X3A,0X02,0X5A,0X02,0X7A,0X02,0X59,0X02,0X39,0X02,0X79,0X02,0X99,0X02,0X99,
0X02,0X79,0X02,0X37,0X01,0XD6,0X02,0X16,0X01,0XF5,0X02,0X15,0X02,0X14,0X01,0XD4,
0X01,0XB3,0X01,0XD2,0X01,0XF2,0X01,0XF2,0X02,0X33,0X02,0X32,0X02,0X12,0X02,0X32,
0X02,0X12,0X1B,0X76,0X34,0XFA,0X02,0X31,0X00,0X69,0X02,0X2C,0X0A,0X8F,0X02,0X0B,
0X00,0X65,0X3D,0X37,0X5E,0X3A,0X2C,0X32,0X12,0XCF,0X00,0X25,0X00,0XA5,0X01,0X07,
0X01,0X06,0X01,0X88,0X4D,0X58,0X01,0XAB,0X24,0X10,0X2B,0XF2,0X00,0XC8,0X01,0X69,
0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBF,
0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7E,
0X02,0X5F,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X3B,0X02,0X1B,0X02,0X3A,
0X02,0X3A,0X02,0X5A,0X02,0X7A,0X02,0X59,0X02,0X59,0X02,0X79,0X02,0X79,0X02,0X79,
0X02,0X78,0X02,0X37,0X02,0X16,0X02,0X16,0X02,0X16,0X02,0X15,0X01,0XF4,0X01,0XB3,
0X01,0XD3,0X01,0XD2,0X01,0XD2,0X01,0XF2,0X0A,0X33,0X0A,0X32,0X02,0X32,0X02,0X12,
0X02,0X32,0X0A,0XD3,0X4D,0XBB,0X01,0X09,0X02,0X4F,0X4D,0XD9,0X02,0X6F,0X13,0X2F,
0X00,0XE7,0X55,0X7A,0X0A,0X70,0X00,0X65,0X01,0X25,0X24,0X2F,0X23,0XD1,0X01,0X8A,
0X01,0X28,0X00,0X87,0X1A,0XD0,0X09,0XCC,0X00,0X46,0X01,0XCC,0X3C,0XF8,0X01,0XEC,
0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,
0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,
0X02,0X7F,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,0X02,0X3D,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X5C,0X02,0X3B,0X02,0X5B,
0X02,0X5A,0X02,0X5A,0X02,0X5A,0X02,0X7A,0X02,0X7A,0X02,0X79,0X02,0X59,0X02,0X78,
0X02,0X57,0X02,0X37,0X02,0X16,0X02,0X16,0X02,0X15,0X01,0XF5,0X02,0X14,0X01,0XD4,
0X01,0XB3,0X01,0XB2,0X01,0XD2,0X01,0XF2,0X0A,0X12,0X0A,0X12,0X01,0XD1,0X02,0X11,
0X02,0X52,0X0A,0X92,0X34,0X76,0X1B,0XB5,0X01,0X2E,0X45,0X79,0X1C,0X35,0X56,0X5D,
0X24,0X33,0X13,0XB1,0X02,0X8D,0X3D,0XB9,0X57,0X1F,0X56,0X9F,0X2C,0X77,0X02,0X2B,
0X00,0X84,0X00,0X64,0X00,0X22,0X00,0X83,0X01,0X46,0X01,0X07,0X13,0X32,0X0A,0X6E,
0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0X9F,
0X02,0XDF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X9F,0X02,0X7F,0X02,0X7F,
0X02,0X5F,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,0X02,0X5E,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X5C,0X02,0X3C,0X02,0X3B,0X02,0X3B,
0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X5A,0X02,0X9A,0X02,0X7A,0X02,0X79,0X02,0X58,
0X02,0X37,0X02,0X37,0X02,0X17,0X02,0X16,0X02,0X15,0X01,0XD4,0X02,0X15,0X01,0XF4,
0X01,0XF3,0X01,0XB2,0X01,0XD2,0X01,0XF2,0X01,0XF2,0X01,0XD1,0X01,0XB1,0X01,0XD1,
0X02,0X32,0X02,0X11,0X02,0X11,0X01,0X6F,0X02,0X72,0X4E,0X1D,0X01,0X8B,0X02,0X0F,
0X3D,0X5B,0X56,0X9E,0X24,0X77,0X34,0XF8,0X01,0XAA,0X01,0X68,0X01,0XEB,0X01,0XA9,
0X00,0X43,0X01,0X06,0X01,0X68,0X01,0XCA,0X0A,0X0D,0X0A,0X2D,0X01,0X2A,0X00,0X64,
0X03,0X1F,0X0B,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,0X02,0XBF,
0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,0X02,0X7F,
0X02,0X5F,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5D,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X5B,
0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X5A,0X02,0X7A,0X02,0X9A,0X02,0X9A,0X02,0X79,
0X02,0X38,0X02,0X37,0X02,0X37,0X02,0X16,0X02,0X16,0X01,0XF5,0X01,0XD4,0X02,0X15,
0X02,0X14,0X01,0XF3,0X01,0XD3,0X01,0XF3,0X01,0XF2,0X01,0XF2,0X0A,0X12,0X01,0XF1,
0X0A,0X32,0X0A,0X32,0X01,0XF1,0X01,0X6E,0X34,0X39,0X02,0XF3,0X34,0XD7,0X4E,0X9E,
0X0B,0X32,0X4D,0XBB,0X1C,0X14,0X01,0X6B,0X34,0XB4,0X1B,0X4E,0X01,0X89,0X02,0X0C,
0X01,0XCA,0X01,0XEB,0X00,0XE8,0X12,0X8E,0X01,0X49,0X00,0X03,0X00,0XA5,0X00,0X84,
0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,0X02,0XBF,
0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X7E,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X5F,
0X02,0X5F,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,
0X02,0X3D,0X02,0X3D,0X02,0X5D,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X3B,
0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X3A,0X02,0X7A,0X02,0X7A,0X02,0XBA,0X02,0X79,
0X02,0X58,0X02,0X37,0X02,0X37,0X02,0X36,0X02,0X36,0X02,0X15,0X01,0XF5,0X02,0X15,
0X02,0X14,0X02,0X34,0X0A,0X34,0X02,0X13,0X01,0XF2,0X02,0X13,0X02,0X12,0X02,0X12,
0X02,0X12,0X02,0X32,0X02,0X11,0X01,0XB0,0X0A,0X31,0X0A,0X92,0X56,0X1D,0X01,0XCD,
0X13,0X12,0X55,0XDB,0X56,0X5C,0X3D,0X15,0X0A,0X2E,0X00,0XEA,0X01,0XAA,0X35,0X39,
0X02,0X2E,0X24,0X54,0X01,0XAA,0X01,0X89,0X1B,0XB2,0X13,0X2E,0X01,0X47,0X00,0X22,
0X03,0X3F,0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,
0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,
0X02,0X7E,0X02,0X3E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,
0X02,0X3D,0X02,0X3D,0X02,0X5D,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X3B,
0X02,0X3B,0X02,0X5B,0X02,0X7B,0X02,0X3A,0X02,0X7A,0X02,0X9A,0X02,0XBB,0X02,0X79,
0X02,0X79,0X02,0X58,0X02,0X37,0X02,0X37,0X02,0X36,0X02,0X16,0X02,0X15,0X02,0X15,
0X02,0X14,0X02,0X34,0X0A,0X55,0X02,0X34,0X02,0X33,0X02,0X33,0X02,0X53,0X02,0X32,
0X02,0X32,0X0A,0X73,0X02,0X32,0X01,0XF1,0X01,0X6F,0X01,0X6E,0X02,0XB0,0X56,0X7D,
0X34,0XFA,0X3C,0XD9,0X2C,0X35,0X01,0XEB,0X13,0X2E,0X1B,0X91,0X35,0X38,0X01,0XEF,
0X3C,0XF9,0X00,0XA8,0X0A,0X4C,0X3D,0X15,0X13,0XD3,0X01,0XCC,0X01,0X47,0X2B,0XD0,
0X03,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,
0X02,0XBF,0X02,0X9F,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7F,0X02,0X7F,
0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X1C,0X02,0X3C,0X02,0X5C,0X02,0X3B,
0X02,0X3B,0X02,0X3B,0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X9A,0X02,0X9B,0X02,0X79,
0X02,0X99,0X02,0X79,0X02,0X78,0X02,0X57,0X02,0X57,0X02,0X36,0X02,0X36,0X02,0X35,
0X02,0X35,0X02,0X35,0X02,0X34,0X02,0X13,0X02,0X33,0X02,0X53,0X02,0X54,0X02,0X53,
0X02,0X12,0X02,0X53,0X02,0X32,0X01,0XF1,0X01,0XB0,0X01,0X8F,0X13,0X15,0X3D,0X1B,
0X2C,0XD8,0X1B,0XF5,0X67,0X7F,0X13,0X93,0X01,0X2A,0X02,0X8D,0X0B,0X31,0X23,0XD3,
0X00,0XC7,0X00,0XA6,0X4E,0X1B,0X01,0X6D,0X1B,0X72,0X01,0X8B,0X3C,0XF8,0X00,0X06,
0X03,0X1F,0X0B,0X1F,0X03,0X1F,0X0B,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,
0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X9F,0X02,0X7E,
0X02,0X7F,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X1C,0X02,0X3C,0X02,0X3C,0X02,0X3B,
0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X9B,0X02,0X9B,0X02,0X79,
0X02,0X99,0X02,0X99,0X02,0X58,0X02,0X78,0X02,0X57,0X02,0X36,0X02,0X36,0X02,0X56,
0X02,0X55,0X02,0X34,0X02,0X14,0X02,0X13,0X02,0X33,0X02,0X53,0X02,0X94,0X02,0X53,
0X02,0X33,0X02,0X52,0X02,0X12,0X02,0X11,0X01,0XD0,0X0A,0X93,0X13,0X72,0X02,0X8E,
0X13,0X11,0X00,0X27,0X00,0XEA,0X3C,0XB6,0X2C,0X76,0X2C,0XF8,0X02,0XB1,0X00,0X65,
0X00,0XC3,0X45,0X97,0X67,0X5F,0X4D,0XFD,0X01,0X2A,0X00,0X23,0X01,0X4A,0X09,0XEE,
0X03,0X1F,0X0B,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,
0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X9F,0X02,0X5E,
0X02,0X7F,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X5D,0X02,0X1C,0X02,0X3C,0X02,0X3C,0X02,0X3B,
0X02,0X3B,0X02,0X3B,0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X7A,0X02,0X9B,0X02,0X9A,
0X02,0X99,0X02,0X99,0X02,0X78,0X02,0X78,0X02,0X36,0X02,0X16,0X02,0X36,0X02,0X56,
0X02,0X55,0X02,0X34,0X01,0XF3,0X02,0X13,0X02,0X54,0X02,0X74,0X02,0X95,0X02,0X53,
0X02,0X33,0X02,0X32,0X0A,0X32,0X01,0XF1,0X02,0X11,0X02,0X11,0X56,0X5E,0X56,0X5C,
0X00,0XC8,0X00,0XE8,0X00,0X66,0X00,0XA8,0X00,0X07,0X3D,0X59,0X13,0X71,0X1B,0X70,
0X4E,0X3A,0X24,0XB6,0X2C,0XB8,0X00,0X87,0X00,0XC5,0X00,0XA4,0X00,0XC6,0X01,0X29,
0X03,0X1F,0X03,0X3F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XDF,
0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,0X02,0X7E,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X3D,0X02,0X3D,
0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X3B,
0X02,0X3B,0X02,0X3B,0X02,0X5B,0X02,0X5A,0X02,0X3A,0X02,0X7A,0X02,0XBB,0X02,0X9A,
0X02,0X9A,0X02,0X99,0X02,0X99,0X02,0X78,0X02,0X37,0X02,0X16,0X02,0X36,0X02,0X35,
0X02,0X55,0X02,0X34,0X02,0X14,0X02,0X33,0X02,0X95,0X02,0XD5,0X02,0X95,0X02,0X12,
0X02,0X12,0X01,0XF2,0X0A,0X32,0X02,0X11,0X02,0X52,0X01,0XF1,0X56,0X5F,0X01,0X4C,
0X0A,0X6D,0X00,0XE6,0X01,0X07,0X12,0X6D,0X00,0X24,0X12,0XAF,0X01,0X4B,0X23,0XD4,
0X35,0X19,0X24,0X56,0X4E,0X1C,0X00,0XC6,0X00,0X22,0X01,0X89,0X1A,0XD0,0X01,0X6A,
0X03,0X1F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X0B,0X1F,0X02,0XFF,0X02,0XDF,0X02,0XDF,
0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9E,0X02,0X9F,0X02,0X9F,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X3D,0X02,0X5D,0X02,0X5D,
0X02,0X5D,0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X3C,
0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5A,0X02,0X9B,0X02,0X9B,0X02,0X9A,
0X02,0X59,0X02,0X79,0X02,0X78,0X02,0X78,0X02,0X37,0X02,0X57,0X02,0X36,0X02,0X36,
0X02,0X56,0X02,0X14,0X02,0X14,0X02,0X13,0X0A,0XD6,0X02,0XD6,0X02,0X74,0X01,0XF2,
0X0A,0X13,0X01,0XF1,0X02,0X11,0X01,0XF1,0X0A,0X73,0X02,0X52,0X0A,0X92,0X23,0XB5,
0X1B,0XB2,0X12,0XCF,0X2C,0X34,0X00,0X87,0X01,0X4B,0X1B,0X13,0X12,0XF1,0X45,0X5A,
0X2C,0X77,0X0A,0XF3,0X2C,0X79,0X13,0X31,0X12,0XF0,0X02,0X8E,0X22,0XAB,0X3A,0XCA,
0X03,0X1F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X0B,0X1F,0X02,0XFF,0X02,0XDF,0X02,0XDF,
0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9F,0X02,0X7F,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5D,0X02,0X5D,
0X02,0X5D,0X02,0X3D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X5C,0X02,0X3C,
0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5A,0X02,0X7A,0X02,0X7A,0X02,0X9A,
0X02,0X59,0X02,0X79,0X02,0X58,0X02,0X58,0X02,0X57,0X02,0X37,0X02,0X36,0X02,0X36,
0X02,0X56,0X02,0X35,0X02,0X14,0X02,0X14,0X0A,0XD7,0X0A,0XD6,0X02,0X94,0X02,0X12,
0X02,0X12,0X0A,0X32,0X01,0XB0,0X02,0X12,0X0A,0X93,0X02,0X31,0X01,0X8F,0X01,0X6F,
0X01,0X4E,0X01,0X6E,0X1A,0X71,0X09,0X8D,0X09,0XF0,0X02,0X11,0X01,0XD0,0X0A,0XF3,
0X3C,0XD9,0X13,0X53,0X02,0X10,0X02,0X72,0X01,0X6C,0X8C,0XAA,0XD5,0XE6,0X6B,0X25,
0X03,0X1F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XDF,0X02,0XDF,
0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5D,
0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X5C,0X02,0X3C,
0X02,0X3B,0X02,0X3B,0X02,0X3B,0X02,0X5A,0X02,0X5A,0X02,0X5A,0X02,0X7A,0X02,0X9A,
0X02,0X9A,0X02,0X79,0X02,0X79,0X02,0X38,0X02,0X58,0X02,0X57,0X02,0X36,0X02,0X76,
0X02,0X35,0X02,0X35,0X02,0X14,0X02,0X14,0X02,0XD6,0X0A,0XF7,0X02,0X95,0X02,0X13,
0X02,0X12,0X02,0X12,0X01,0XB1,0X02,0X11,0X0A,0X73,0X02,0X32,0X01,0XD0,0X09,0XB0,
0X09,0X8F,0X09,0X8F,0X09,0X4E,0X09,0X6F,0X01,0XAF,0X02,0X11,0X01,0XB0,0X09,0X08,
0X08,0XE6,0X22,0X0A,0X22,0X09,0X3A,0XC9,0XBD,0X66,0XD5,0XE3,0XB5,0X04,0X4A,0X84,
0X03,0X1F,0X03,0X1F,0X03,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XDF,0X02,0XDF,
0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,
0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X5D,
0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X1C,0X02,0X3C,0X02,0X3C,0X02,0X5C,0X02,0X3C,
0X02,0X5C,0X02,0X3B,0X02,0X3B,0X02,0X5A,0X02,0X5A,0X02,0X7A,0X02,0X5A,0X02,0X9A,
0X02,0X9A,0X02,0X59,0X02,0X79,0X02,0X58,0X02,0X38,0X02,0X98,0X02,0X77,0X02,0X77,
0X02,0X56,0X02,0X35,0X02,0X34,0X02,0X34,0X0A,0XF7,0X02,0XD6,0X02,0X75,0X02,0X33,
0X02,0X53,0X02,0X12,0X01,0XB1,0X01,0XF1,0X0A,0X53,0X02,0X12,0X01,0XB0,0X01,0X8F,
0X09,0X8F,0X09,0X8F,0X01,0X8F,0X01,0X8E,0X01,0X4E,0X01,0XAC,0X6B,0X48,0X82,0XC2,
0X41,0X40,0X41,0X80,0X83,0XC1,0X94,0X00,0XA4,0X81,0XAD,0X03,0X9C,0X86,0X3A,0X45,
0X03,0X3F,0X0B,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XBF,
0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X7F,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5E,0X02,0X5D,
0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X5C,
0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5A,0X02,0X5A,0X02,0X7A,
0X02,0X9A,0X02,0X59,0X02,0X78,0X02,0X78,0X02,0X38,0X02,0XB8,0X02,0X98,0X02,0X57,
0X02,0X76,0X02,0X35,0X02,0X14,0X02,0X14,0X02,0XD6,0X0A,0XF7,0X02,0XB5,0X02,0X54,
0X02,0X74,0X01,0XF1,0X01,0XD1,0X0A,0X32,0X0A,0X73,0X02,0X12,0X01,0XD0,0X01,0X8F,
0X01,0X6E,0X09,0X8F,0X01,0X6E,0X00,0XCB,0X19,0XC8,0XC5,0X86,0XD5,0XA3,0XFF,0X29,
0XFF,0X4C,0XBD,0X64,0XBD,0X63,0XBD,0X43,0XAD,0X45,0X73,0X41,0X94,0X44,0X5B,0X04,
0X03,0X3F,0X03,0X1F,0X0B,0X1F,0X03,0X1F,0X02,0XFF,0X0B,0X1F,0X02,0XFF,0X02,0XDF,
0X02,0XDF,0X02,0XFF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,0X02,0X9F,0X02,0X9E,
0X02,0X9F,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X7D,
0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X3D,0X02,0X3D,0X02,0X3C,0X02,0X3C,0X02,0X5C,
0X02,0X5C,0X02,0X5B,0X02,0X7B,0X02,0X5B,0X02,0X7B,0X02,0X5A,0X02,0X7A,0X02,0X59,
0X02,0X7A,0X02,0X79,0X02,0X59,0X02,0X58,0X02,0X79,0X02,0X98,0X02,0X97,0X02,0X77,
0X02,0X76,0X02,0X55,0X02,0X14,0X02,0X55,0X02,0XD7,0X02,0XF7,0X02,0XB5,0X02,0XB5,
0X02,0X54,0X01,0XF2,0X02,0X12,0X02,0X12,0X02,0X32,0X0A,0X12,0X01,0XB0,0X09,0X8F,
0X09,0X8F,0X00,0XCC,0X09,0X48,0X94,0X46,0XF6,0X64,0XDD,0XC2,0XDD,0XE2,0XDE,0X44,
0XE6,0X65,0XEE,0XA5,0XE6,0X85,0XB5,0X04,0X5A,0X40,0X73,0X01,0XB5,0X47,0X73,0XA3,
0X03,0X3F,0X03,0X1F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XDF,
0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0X9E,0X02,0XBF,0X02,0XBE,0X02,0XBF,0X02,0X9F,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X5D,
0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5C,0X02,0X3C,0X02,0X3C,0X02,0X3C,0X02,0X5C,
0X02,0X7C,0X02,0X7C,0X02,0X5B,0X02,0X3B,0X02,0X5B,0X02,0X5A,0X02,0X7B,0X02,0X5A,
0X02,0X5A,0X02,0X9A,0X02,0X7A,0X02,0X79,0X02,0X78,0X02,0X98,0X02,0X78,0X02,0X57,
0X02,0X56,0X02,0X36,0X02,0X35,0X02,0X97,0X02,0XF7,0X02,0XF7,0X0A,0XD6,0X02,0X95,
0X02,0X33,0X02,0X13,0X02,0X12,0X01,0XF1,0X01,0XF1,0X09,0XF1,0X01,0X8F,0X01,0X6E,
0X00,0X6A,0X63,0X27,0XE6,0X25,0XDD,0XC1,0XD5,0X80,0XD5,0XA0,0XDE,0X02,0XEE,0X63,
0XEE,0X84,0XEE,0XC6,0XDE,0X26,0XB5,0X04,0XB4,0XE4,0X94,0X04,0X8B,0XE5,0X9C,0XC8,
0X03,0X3F,0X0B,0X3F,0X03,0X1F,0X0B,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XDF,0X02,0XBE,0X02,0XBF,0X02,0XBF,
0X02,0X9F,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X7D,0X02,0X5D,
0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X3C,0X02,0X3C,0X02,0X3C,
0X02,0X7C,0X02,0X7C,0X02,0X5B,0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5A,0X02,0X5A,
0X02,0X7A,0X02,0X9A,0X02,0X9A,0X02,0X79,0X02,0X99,0X02,0X78,0X02,0X37,0X02,0X36,
0X02,0X57,0X02,0X56,0X02,0XB7,0X0A,0XF7,0X02,0XB7,0X02,0XD6,0X0A,0XF6,0X02,0X54,
0X01,0XF3,0X01,0XF3,0X01,0XD2,0X01,0XF2,0X01,0XF1,0X01,0XF1,0X01,0X4E,0X00,0XC9,
0X8C,0X66,0XEE,0X84,0XE5,0XC1,0XDD,0XA0,0XD5,0XA0,0XDE,0X01,0XE6,0X22,0XE6,0X22,
0XE6,0X43,0XFF,0X67,0XF6,0XE7,0XF7,0X08,0XB5,0X24,0XBD,0X46,0X8C,0X04,0X9C,0XC6,
0X0B,0X5F,0X03,0X3F,0X0B,0X3F,0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XFF,0X02,0XFF,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XDF,0X02,0XBE,0X02,0XBF,0X02,0XBF,
0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X7D,0X02,0X5D,
0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X3C,0X02,0X3C,
0X02,0X5C,0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5A,0X02,0X5A,
0X02,0X5A,0X02,0X5A,0X02,0X9A,0X02,0X59,0X02,0X78,0X02,0X78,0X02,0X57,0X02,0X57,
0X02,0X57,0X02,0X56,0X02,0XD7,0X0B,0X18,0X02,0XF7,0X02,0XB6,0X0A,0XD6,0X02,0X34,
0X01,0XF3,0X01,0XF2,0X01,0XD2,0X09,0XF2,0X01,0XF1,0X01,0X8F,0X00,0XCA,0X9C,0XE6,
0XE6,0X63,0XDD,0XE1,0XE5,0XC0,0XDD,0XA0,0XDD,0XE0,0XE6,0X21,0XE6,0X21,0XE6,0X42,
0XE6,0X42,0XFF,0X66,0XF7,0X07,0XDE,0X26,0XC5,0XA4,0XD6,0X26,0XCD,0XE6,0XAD,0X25,
0X03,0X3F,0X03,0X3F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XFF,0X02,0XDF,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,
0X02,0X9F,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X7D,0X02,0X5D,
0X02,0X7D,0X02,0X7D,0X02,0X7D,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5C,0X02,0X3C,
0X02,0X5C,0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X7B,0X02,0X7B,0X02,0X5A,
0X02,0X7A,0X02,0X7A,0X02,0X7A,0X02,0X99,0X02,0X99,0X02,0XB9,0X02,0X78,0X02,0X57,
0X02,0X57,0X02,0X57,0X02,0XB7,0X02,0XF8,0X02,0XD8,0X02,0X75,0X02,0X95,0X02,0X13,
0X01,0XF3,0X01,0XF2,0X01,0XD2,0X01,0XF2,0X01,0XB0,0X00,0XCA,0X94,0XA6,0XDE,0X83,
0XD5,0XE0,0XDD,0XE0,0XE5,0XC0,0XDD,0XC0,0XE6,0X21,0XE6,0X21,0XE6,0X21,0XE6,0X42,
0XE6,0X41,0XFF,0X86,0XEE,0XA6,0XD5,0XE5,0XE6,0X66,0XDE,0X86,0XE6,0X88,0XBD,0X86,
0X0B,0X5F,0X03,0X3F,0X03,0X3F,0X03,0X1F,0X0B,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XDF,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBE,0X02,0X9F,
0X02,0X9F,0X02,0X7E,0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X5E,0X02,0X7E,
0X02,0X5E,0X02,0X5E,0X02,0X7E,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X5C,
0X02,0X5C,0X02,0X7C,0X02,0X3B,0X02,0X5B,0X02,0X7B,0X02,0X5B,0X02,0X5B,0X02,0X5B,
0X02,0X9B,0X02,0X7A,0X02,0XBB,0X02,0XBA,0X02,0X79,0X02,0X99,0X02,0X78,0X02,0X78,
0X02,0X37,0X02,0X57,0X0A,0XD8,0X02,0XF8,0X02,0XD8,0X02,0X96,0X02,0X75,0X02,0X33,
0X01,0XF3,0X01,0XF2,0X01,0XF2,0X01,0XF2,0X01,0X2E,0X63,0X87,0XE6,0XC3,0XD6,0X00,
0XD5,0XE0,0XE5,0XE0,0XE5,0XE0,0XDD,0XE0,0XE6,0X21,0XE6,0X21,0XE6,0X00,0XE6,0X41,
0XE6,0X21,0XFF,0X46,0XD6,0X24,0XEE,0XC7,0XEE,0XC7,0XE6,0X86,0XEE,0XC8,0XDE,0X68,
0X0B,0X5F,0X03,0X3F,0X03,0X3F,0X03,0X1F,0X0B,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XDF,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,
0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X5E,0X02,0X5E,
0X02,0X5E,0X02,0X5E,0X02,0X7E,0X02,0X5D,0X02,0X5D,0X02,0X5D,0X02,0X7D,0X02,0X5C,
0X02,0X5C,0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X7B,0X02,0X5B,0X02,0X7B,
0X02,0X9B,0X02,0X7B,0X02,0X9B,0X02,0XBB,0X02,0X9A,0X02,0X99,0X02,0X78,0X02,0X58,
0X02,0X57,0X02,0X57,0X02,0XD8,0X02,0XB7,0X02,0XB7,0X02,0X96,0X02,0X74,0X02,0X34,
0X0A,0X13,0X01,0XF2,0X01,0XF2,0X01,0XD1,0X01,0X4A,0XCE,0X26,0XDE,0X81,0XDE,0X40,
0XD5,0XE0,0XE6,0X00,0XE5,0XE0,0XDD,0XE0,0XE6,0X21,0XE6,0X20,0XE6,0X21,0XE6,0X41,
0XE6,0X42,0XEF,0X05,0XDE,0X65,0XFF,0X28,0XF6,0XE7,0XE6,0X86,0XDE,0X66,0XC6,0X05,
0X0B,0X5F,0X03,0X3F,0X03,0X3F,0X03,0X1F,0X0B,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XFF,
0X02,0XFF,0X02,0XFF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9E,0X02,0X9E,
0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X7E,0X02,0X7E,
0X02,0X7E,0X02,0X5E,0X02,0X5E,0X02,0X7D,0X02,0X7D,0X02,0X5D,0X02,0X7D,0X02,0X3C,
0X02,0X7C,0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X7B,
0X02,0X7B,0X02,0X5A,0X02,0X9B,0X02,0XBB,0X02,0XBA,0X02,0X79,0X02,0X38,0X02,0X58,
0X02,0X37,0X02,0X98,0X02,0X97,0X02,0X76,0X02,0X96,0X02,0X96,0X02,0X74,0X02,0X34,
0X01,0XD2,0X01,0XB1,0X02,0X12,0X01,0X2E,0X6B,0XC7,0XEF,0X03,0XE6,0X81,0XDE,0X40,
0XD6,0X00,0XE6,0X41,0XE6,0X01,0XDD,0XE0,0XE6,0X20,0XE6,0X41,0XE6,0X00,0XDE,0X21,
0XE6,0X42,0XFF,0X87,0XFF,0X69,0XF7,0X28,0XEE,0XA6,0XE6,0XC7,0XEE,0XA7,0XD6,0X27,
0X0B,0X5F,0X0B,0X5F,0X0B,0X5F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XDF,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBE,0X02,0X9E,0X13,0X1F,
0X02,0X7E,0X02,0X9E,0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X7D,0X02,0X7D,0X02,0X5C,
0X02,0X7C,0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X7B,0X02,0X7B,
0X02,0X7B,0X02,0X5A,0X02,0X9B,0X02,0XBB,0X02,0X9A,0X02,0X99,0X02,0X78,0X02,0X58,
0X02,0X58,0X02,0X77,0X02,0X77,0X02,0X97,0X02,0X97,0X02,0XB6,0X02,0X55,0X02,0X13,
0X01,0XD2,0X02,0X12,0X01,0XD1,0X09,0X8B,0XCE,0X66,0XE6,0X81,0XDE,0X60,0XDE,0X40,
0XD6,0X20,0XE6,0X60,0XE6,0X01,0XDD,0XE0,0XE6,0X01,0XE6,0X21,0XE6,0X21,0XE6,0X42,
0XE6,0X22,0XFF,0XA7,0XFF,0X48,0XFF,0X48,0XEE,0XA6,0XDE,0X65,0XEE,0XA7,0XDE,0X88,
0X0B,0X5F,0X0B,0X5F,0X0B,0X5F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X03,0X1F,0X02,0XFF,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0X9E,0X02,0XBE,0X02,0XBF,0X02,0X9E,
0X02,0X9F,0X02,0X7E,0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,
0X02,0X7E,0X02,0X7D,0X02,0X7D,0X02,0X7E,0X02,0X7D,0X02,0X7D,0X02,0X7D,0X02,0X5C,
0X02,0X5B,0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X5C,0X02,0X7B,0X02,0X7B,0X02,0X7B,
0X02,0X7B,0X02,0X5A,0X02,0X9B,0X02,0XBB,0X02,0X9A,0X02,0X59,0X02,0X78,0X02,0X38,
0X02,0X37,0X02,0X36,0X02,0X36,0X02,0X76,0X02,0X96,0X0A,0X96,0X02,0X75,0X02,0X13,
0X01,0XF2,0X0A,0X13,0X01,0X4F,0X53,0X28,0XEF,0X04,0XDE,0X60,0XDE,0X40,0XD6,0X40,
0XD6,0X20,0XE6,0X60,0XE6,0X21,0XE6,0X01,0XE6,0X21,0XE6,0X01,0XE6,0X21,0XE6,0X41,
0XE6,0X01,0XFF,0X46,0XF7,0X06,0XFF,0X07,0XF6,0XC7,0XE6,0X66,0XCD,0XC5,0XC5,0XC6,
0X0B,0X5F,0X0B,0X5F,0X03,0X3F,0X03,0X3F,0X03,0X3F,0X02,0XFF,0X03,0X1F,0X03,0X1F,
0X02,0XFF,0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0XBF,0X02,0X9F,
0X02,0X9F,0X02,0X7E,0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,
0X02,0X7E,0X02,0X7D,0X02,0X7D,0X02,0X7E,0X02,0X7D,0X02,0X7D,0X02,0X7D,0X02,0X3C,
0X02,0X5C,0X02,0X3B,0X02,0X5B,0X02,0X5B,0X02,0X7C,0X02,0X7B,0X02,0X5B,0X02,0X7B,
0X02,0X7B,0X02,0X7A,0X02,0X9B,0X02,0XBB,0X02,0X9A,0X02,0X59,0X02,0X79,0X02,0X58,
0X02,0X57,0X02,0X16,0X02,0X36,0X02,0X56,0X02,0X76,0X02,0X96,0X02,0X75,0X02,0X34,
0X02,0X13,0X02,0X13,0X01,0X0E,0XA5,0X67,0XDE,0X82,0XDE,0X41,0XD6,0X40,0XD6,0X20,
0XD6,0X20,0XDE,0X40,0XE6,0X61,0XE6,0X21,0XE6,0X21,0XE6,0X00,0XDD,0XE0,0XE6,0X21,
0XDD,0XE1,0XF7,0X25,0XF6,0XE5,0XF6,0X85,0XF6,0XA7,0XE6,0X68,0XD6,0X07,0XB5,0X25,
0X0B,0X7F,0X0B,0X5F,0X03,0X5F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X03,0X1F,0X03,0X1F,
0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBE,0X02,0X9F,
0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X9E,0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X5D,0X02,0X5D,
0X02,0X5C,0X02,0X3C,0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X3B,0X02,0X7B,0X02,0X7B,
0X02,0X7B,0X02,0X7A,0X02,0X7A,0X0A,0XDB,0X02,0XBB,0X02,0X7A,0X02,0X79,0X02,0X78,
0X02,0X37,0X02,0X37,0X02,0X36,0X02,0X56,0X02,0X56,0X02,0X55,0X02,0X55,0X02,0X34,
0X02,0X13,0X02,0X13,0X00,0XEE,0XB5,0XE8,0XD6,0X63,0XCE,0X20,0XD6,0X41,0XD6,0X20,
0XD6,0X21,0XD6,0X60,0XE6,0X61,0XE6,0X21,0XDE,0X00,0XDE,0X00,0XDE,0X00,0XDD,0XE1,
0XDD,0XE1,0XEE,0X83,0XE6,0X64,0XEE,0X65,0XE6,0X66,0XDE,0X27,0XD6,0X06,0XB5,0X46,
0X0B,0X7F,0X0B,0X5F,0X03,0X3F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X03,0X1F,0X03,0X1F,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBE,0X02,0X9F,
0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7E,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X7D,0X02,0X7D,
0X02,0X5C,0X02,0X5C,0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X3B,0X02,0X5B,0X02,0X5B,
0X02,0X7B,0X02,0X7A,0X02,0X7A,0X02,0XBB,0X02,0X9B,0X02,0X7A,0X02,0X99,0X02,0X78,
0X02,0X38,0X02,0X37,0X02,0X36,0X02,0X76,0X02,0X36,0X02,0X55,0X02,0X54,0X02,0X14,
0X02,0X13,0X02,0X13,0X01,0X4E,0XAD,0XA6,0XC6,0X02,0XC5,0XE0,0XD6,0X21,0XC5,0XC0,
0XCE,0X01,0XCE,0X20,0XE6,0X61,0XE6,0X61,0XE6,0X41,0XDE,0X21,0XD5,0XC0,0XD5,0XC0,
0XE6,0X42,0XEE,0X84,0XE6,0X24,0XE6,0X45,0XDE,0X46,0XD6,0X06,0XC5,0XA5,0XA4,0XC4,
0X0B,0X5F,0X0B,0X5F,0X03,0X5F,0X03,0X3F,0X0B,0X3F,0X03,0X1F,0X03,0X1F,0X02,0XFF,
0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XDF,0X02,0XBF,0X02,0XBF,0X02,0X9E,
0X02,0X9E,0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X9E,0X02,0X5E,0X02,0X7E,0X02,0X5D,
0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X7D,0X02,0X7D,
0X02,0X7D,0X02,0X7C,0X02,0X5C,0X02,0X5B,0X02,0X3B,0X02,0X3B,0X02,0X5B,0X02,0X5B,
0X02,0X7C,0X02,0X5A,0X02,0X7A,0X02,0XBB,0X02,0X9B,0X02,0X7A,0X02,0X79,0X02,0X79,
0X02,0X58,0X02,0X37,0X02,0X37,0X02,0X56,0X02,0X56,0X02,0X55,0X02,0X34,0X01,0XF3,
0X01,0XF3,0X02,0X13,0X01,0X2E,0XA5,0X88,0XBD,0XE2,0XBD,0XC1,0XC5,0XE1,0XBD,0XA1,
0XBD,0XA1,0XBD,0XC1,0XDE,0X41,0XE6,0X61,0XE6,0X41,0XDE,0X21,0XDD,0XE1,0XD5,0XC0,
0XDD,0XE1,0XE6,0X22,0XE6,0X44,0XDE,0X25,0XD6,0X24,0XCD,0XE4,0XBD,0X84,0X94,0X62,
0X0B,0X7F,0X0B,0X5F,0X03,0X5F,0X03,0X3F,0X03,0X3F,0X03,0X1F,0X03,0X1F,0X03,0X1F,
0X03,0X1F,0X02,0XFF,0X02,0XDF,0X02,0XDF,0X02,0XDE,0X02,0XBF,0X02,0XBF,0X02,0XBE,
0X02,0X9F,0X02,0X9E,0X02,0X9E,0X02,0X9E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X5E,
0X02,0X5E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X7D,0X02,0X7D,
0X02,0X7D,0X02,0X7C,0X02,0X7C,0X02,0X5C,0X02,0X5B,0X02,0X5B,0X02,0X5B,0X02,0X3B,
0X02,0X9C,0X02,0X7B,0X02,0X7B,0X02,0XBB,0X02,0X9B,0X02,0X7A,0X02,0X79,0X02,0X79,
0X02,0X59,0X02,0X58,0X02,0X37,0X02,0X57,0X02,0X76,0X02,0X55,0X02,0X55,0X02,0X35,
0X01,0XF3,0X01,0XF3,0X01,0X50,0X63,0XEA,0XBE,0X23,0XB5,0XA1,0XB5,0X82,0XB5,0X62,
0XAD,0X21,0XBD,0XA2,0XBD,0XA1,0XE6,0X82,0XE6,0X41,0XDE,0X21,0XDD,0XE0,0XD5,0XC0,
0XDD,0XC0,0XDD,0XC1,0XDE,0X03,0XD6,0X04,0XCD,0XE4,0XC5,0XA3,0XAD,0X02,0X8C,0X00,
0X0B,0X5F,0X0B,0X7F,0X03,0X5F,0X03,0X3F,0X03,0X3F,0X0B,0X3F,0X03,0X1F,0X03,0X1F,
0X02,0XFF,0X02,0XFF,0X02,0XFF,0X02,0XBE,0X02,0XDE,0X02,0XDF,0X02,0XDF,0X02,0XBE,
0X02,0XBF,0X02,0X9E,0X02,0X9D,0X02,0X9E,0X02,0X5E,0X01,0XDA,0X01,0XBB,0X01,0XBA,
0X02,0X3D,0X02,0X7D,0X02,0X7E,0X02,0X7E,0X02,0X7D,0X02,0X7E,0X02,0X7D,0X02,0X7D,
0X02,0X7D,0X02,0X7C,0X02,0X7C,0X02,0X7C,0X02,0X5B,0X02,0X5B,0X02,0X3B,0X02,0X5B,
0X02,0X7B,0X02,0X7B,0X02,0X9B,0X02,0X9B,0X02,0X9B,0X02,0X9B,0X02,0X7A,0X02,0X79,
0X02,0X38,0X02,0X38,0X02,0X37,0X02,0X36,0X02,0X56,0X02,0X55,0X02,0X75,0X02,0X34,
0X02,0X14,0X01,0XF3,0X01,0XB1,0X12,0X0C,0XBE,0X47,0XB5,0XA2,0XAD,0X62,0XAD,0X42,
0XA5,0X22,0XAD,0X22,0XAD,0X42,0XC5,0XC1,0XEE,0X82,0XE6,0X41,0XE6,0X21,0XD5,0XC0,
0XDD,0XC0,0XDD,0XC1,0XDD,0XE2,0XD5,0XE3,0XCD,0XC3,0XBD,0X62,0X9C,0X60,0X8C,0X00,

};




class ER5517Basic
{
	private:
		
	public:
	void SPIInit();
	void SPISetCs(int cs);
	unsigned char SPIRwByte(unsigned char value);
	void SPI_CmdWrite(int cmd);
	void SPI_DataWrite(int data);
	void SPI_DataWrite_Pixel(int data);
	int SPI_StatusRead(void);
	int SPI_DataRead(void);
	void SPI_RegisterWrite(unsigned char Cmd,unsigned char Data);
	unsigned char SPI_RegisterRead(unsigned char Cmd);
	void IICInit();	
	void IIC_CmdWrite(int cmd);
	void IIC_DataWrite(int data);
	void IIC_DataWrite_Pixel(int data);
	int IIC_StatusRead(void);
	int IIC_DataRead(void);
	void IIC_RegisterWrite(unsigned char Cmd,unsigned char Data);
	unsigned char IIC_RegisterRead(unsigned char Cmd);
	void Parallel_Init(void);
	void LCD_CmdWrite(unsigned char cmd);
	void LCD_DataWrite(unsigned char data);
	void LCD_DataWrite_Pixel(unsigned int data);
	unsigned char LCD_StatusRead(void);
	unsigned int LCD_DataRead(void);
	void LCD_RegisterWrite(unsigned char Cmd,unsigned char Data);
	unsigned char LCD_RegisterRead(unsigned char Cmd);


	void TFT_24bit(void);
	void Host_Bus_16bit(void);
	void RGB_16b_16bpp(void);
	void MemRead_Left_Right_Top_Down(void);
	void Graphic_Mode(void);
        void Text_Mode(void);
	void Memory_Select_SDRAM(void);
	void HSCAN_L_to_R(void);
	void VSCAN_T_to_B(void);
	void PDATA_Set_RGB(void);
	void PCLK_Rising(void);
	void PCLK_Falling(void);
	void HSYNC_Low_Active(void);
	void HSYNC_High_Active(void);
	void VSYNC_Low_Active(void);
	void VSYNC_High_Active(void);
	void DE_Low_Active(void);
	void DE_High_Active(void);
	void Set_PCLK(unsigned char val);
	void Set_HSYNC_Active(unsigned char val);
	void Set_VSYNC_Active(unsigned char val);
	void Set_DE_Active(unsigned char val);
	void LCD_HorizontalWidth_VerticalHeight(unsigned short WX,unsigned short HY);
	void LCD_Horizontal_Non_Display(unsigned short WX);
	void LCD_HSYNC_Start_Position(unsigned short WX);
	void LCD_HSYNC_Pulse_Width(unsigned short WX);
	void LCD_Vertical_Non_Display(unsigned short HY);
	void LCD_VSYNC_Start_Position(unsigned short HY);
	void LCD_VSYNC_Pulse_Width(unsigned short HY);
	void Select_Main_Window_16bpp(void);
	void Memory_XY_Mode(void); 
        void Memory_Linear_Mode(void);
	void Memory_16bpp_Mode(void);
	void MemWrite_Left_Right_Top_Down(void);
	void HW_Reset(void);
	void System_Check_Temp(void);
	void PLL_Initial(void);
	void SDRAM_initail(void);
	void initial(void);
	void Display_ON(void);
	void Main_Image_Start_Address(unsigned long Addr);
	void Main_Image_Width(unsigned short WX);
	void Main_Window_Start_XY(unsigned short WX,unsigned short HY);
	void Canvas_Image_Start_address(unsigned long Addr);
	void Canvas_image_width(unsigned short WX);
	void Active_Window_XY(unsigned short WX,unsigned short HY);
	void Active_Window_WH(unsigned short WX,unsigned short HY);
	void Foreground_color_65k(unsigned short temp);
        void Background_color_65k(unsigned short temp);
        void Check_SDRAM_Ready(void);
	void Check_Busy_Draw(void);
	void Check_2D_Busy(void);
	void Check_Mem_WR_FIFO_not_Full(void);
	void Check_Mem_WR_FIFO_Empty(void);
	void Check_Mem_RD_FIFO_not_Full(void);
	void Check_Mem_RD_FIFO_not_Empty(void);
	void DrawSquare_Fill(unsigned short X1,unsigned short Y1,unsigned short X2,unsigned short Y2,unsigned long ForegroundColor);
        void DrawCircle_Fill(unsigned short X1,unsigned short Y1,unsigned short R,unsigned long ForegroundColor );
	void Enable_SFlash_SPI(void);
	void Goto_Pixel_XY(unsigned short WX,unsigned short HY);
        void Goto_Text_XY(unsigned short WX,unsigned short HY);
	void DMA_24bit_Block
	(
	 unsigned char SCS
	,unsigned char Clk
	,unsigned short X1
	,unsigned short Y1
	,unsigned short X_W
	,unsigned short Y_H
	,unsigned short P_W
	,unsigned long Addr
	);
	void DMA_24bit_Linear
	(
         unsigned char SCS             
        ,unsigned char Clk             
        ,unsigned long flash_addr     
        ,unsigned long memory_addr  
        ,unsigned long data_num 
	);

    

	void DrawPixel(unsigned short x,unsigned short y,unsigned short color);
	void Show_String(char *str);
	void Show_picture(unsigned long numbers,const unsigned char *data);

////////////////////////////////////////////////////////////////////////
	////**** [ Function : Draw ] ****////
	//**[67h]**//
	void Start_Line(void);
	void Start_Triangle(void);
	void Start_Triangle_Fill(void);
	//**[68h]~[73h]**//
	void Line_Start_XY(unsigned short WX,unsigned short HY);		
	void Line_End_XY(unsigned short WX,unsigned short HY);			
	void Triangle_Point1_XY(unsigned short WX,unsigned short HY);	
	void Triangle_Point2_XY(unsigned short WX,unsigned short HY);	
	void Triangle_Point3_XY (unsigned short WX,unsigned short HY);	
	void Square_Start_XY(unsigned short WX,unsigned short HY);		
	void Square_End_XY(unsigned short WX,unsigned short HY);		
	//**[76h]**//
	void Start_Circle_or_Ellipse(void);
	void Start_Circle_or_Ellipse_Fill(void);
	void Start_Left_Down_Curve(void);
	void Start_Left_Up_Curve(void);
	void Start_Right_Up_Curve(void);
	void Start_Right_Down_Curve(void);
	void Start_Left_Down_Curve_Fill(void);
	void Start_Left_Up_Curve_Fill(void);
	void Start_Right_Up_Curve_Fill(void);
	void Start_Right_Down_Curve_Fill(void);
	void Start_Square(void);
	void Start_Square_Fill(void);
	void Start_Circle_Square(void);
	void Start_Circle_Square_Fill(void);
	//**[77h]~[7Eh]**//
	void Circle_Center_XY(unsigned short WX,unsigned short HY);				
	void Ellipse_Center_XY(unsigned short WX,unsigned short HY);			
	void Circle_Radius_R(unsigned short WX);								
	void Ellipse_Radius_RxRy(unsigned short WX,unsigned short HY);			
	void Circle_Square_Radius_RxRy(unsigned short WX,unsigned short HY);	

	////////////////////////////////////////////////////////////////////////
	////**** [ Function : PWM ] ****////
	//**[84h]**//
	void Set_PWM_Prescaler_1_to_256(unsigned short WX);
	//**[85h]**//
	void Select_PWM1_Clock_Divided_By_1(void);
	void Select_PWM1_Clock_Divided_By_2(void);
	void Select_PWM1_Clock_Divided_By_4(void);
	void Select_PWM1_Clock_Divided_By_8(void);
	void Select_PWM0_Clock_Divided_By_1(void);
	void Select_PWM0_Clock_Divided_By_2(void);
	void Select_PWM0_Clock_Divided_By_4(void);
	void Select_PWM0_Clock_Divided_By_8(void);
	//[85h].[bit3][bit2]
	void Select_PWM1_is_ErrorFlag(void);
	void Select_PWM1(void);
	void Select_PWM1_is_Osc_Clock(void);
	//[85h].[bit1][bit0]
	void Select_PWM0_is_GPIO_C7(void);
	void Select_PWM0(void);
	void Select_PWM0_is_Core_Clock(void);
	//**[86h]**//
	//[86h]PWM1
	void Enable_PWM1_Inverter(void);
	void Disable_PWM1_Inverter(void);
	void Auto_Reload_PWM1(void);
	void One_Shot_PWM1(void);
	void Start_PWM1(void);
	void Stop_PWM1(void);
	//[86h]PWM0
	void Enable_PWM0_Dead_Zone(void);
	void Disable_PWM0_Dead_Zone(void);
	void Enable_PWM0_Inverter(void);
	void Disable_PWM0_Inverter(void);
	void Auto_Reload_PWM0(void);
	void One_Shot_PWM0(void);
	void Start_PWM0(void);
	void Stop_PWM0(void);
	//**[87h]**//
	void Set_Timer0_Dead_Zone_Length(unsigned char temp);
	//**[88h][89h]**//
	void Set_Timer0_Compare_Buffer(unsigned short WX);
	//**[8Ah][8Bh]**//
	void Set_Timer0_Count_Buffer(unsigned short WX);
	//**[8Ch][8Dh]**//
	void Set_Timer1_Compare_Buffer(unsigned short WX);
	//**[8Eh][8Fh]**//
	void Set_Timer1_Count_Buffer(unsigned short WX);

	////////////////////////////////////////////////////////////////////////
	////**** [ Function : BTE ] ****////
	//**[90h]**//

	//[90h]=========================================================================
	void BTE_Enable(void);
	void BTE_Disable(void);

	void Check_BTE_Busy(void);

	void Pattern_Format_8X8(void);
	void Pattern_Format_16X16(void);

	//[91h]=========================================================================
	void BTE_ROP_Code(unsigned char setx);
	void BTE_Operation_Code(unsigned char setx);

	//[92h]=========================================================================
	void BTE_S0_Color_8bpp(void);
	void BTE_S0_Color_16bpp(void);
	void BTE_S0_Color_24bpp(void);

	void BTE_S1_Color_8bpp(void);
	void BTE_S1_Color_16bpp(void);
	void BTE_S1_Color_24bpp(void);
	void BTE_S1_Color_Constant(void);
	void BTE_S1_Color_8bit_Alpha(void);
	void BTE_S1_Color_16bit_Alpha(void);

	void BTE_Destination_Color_8bpp(void);
	void BTE_Destination_Color_16bpp(void);
	void BTE_Destination_Color_24bpp(void);

	//[93h][94h][95h][96h]=========================================================================
	void BTE_S0_Memory_Start_Address(unsigned long Addr);	

	//[97h][98h]=========================================================================
	void BTE_S0_Image_Width(unsigned short WX);	

	//[99h][9Ah][9Bh][9Ch]=========================================================================
	void BTE_S0_Window_Start_XY(unsigned short WX,unsigned short HY);	

	//[9Dh][9Eh][9Fh][A0h]=========================================================================
	void BTE_S1_Memory_Start_Address(unsigned long Addr);
	void S1_Constant_color_256(unsigned char temp);
	void S1_Constant_color_65k(unsigned short temp);
	void S1_Constant_color_16M(unsigned long temp);	

	//[A1h][A2h]=========================================================================
	void BTE_S1_Image_Width(unsigned short WX);	

	//[A3h][A4h][A5h][A6h]=========================================================================
	void BTE_S1_Window_Start_XY(unsigned short WX,unsigned short HY);	

	//[A7h][A8h][A9h][AAh]=========================================================================
	void BTE_Destination_Memory_Start_Address(unsigned long Addr);	

	//[ABh][ACh]=========================================================================
	void BTE_Destination_Image_Width(unsigned short WX);	

	//[ADh][AEh][AFh][B0h]=========================================================================
	void BTE_Destination_Window_Start_XY(unsigned short WX,unsigned short HY);	

	//[B1h][B2h][B3h][B4h]=========================================================================
	void BTE_Window_Size(unsigned short WX, unsigned short WY);

	//[B5h]=========================================================================
	void BTE_Alpha_Blending_Effect(unsigned char temp);


	//**[B5h]**//

	////////////////////////////////////////////////////////////////////////
	////**** [ Function : Serial Flash ] ****////


	//REG[B6h] Serial flash DMA Controller REG (DMA_CTRL) 
	void Start_SFI_DMA(void);
	void Check_Busy_SFI_DMA(void);

	//REG[B7h] Serial Flash/ROM Controller Register (SFL_CTRL) 
	void Select_SFI_0(void);
	void Select_SFI_1(void);
	void Select_SFI_Font_Mode(void);
	void Select_SFI_DMA_Mode(void);
	void Select_SFI_24bit_Address(void);
	void Select_SFI_32bit_Address(void);
	void Select_SFI_Waveform_Mode_0(void);
	void Select_SFI_Waveform_Mode_3(void);
	void Select_SFI_0_DummyRead(void);
	void Select_SFI_8_DummyRead(void);
	void Select_SFI_16_DummyRead(void);
	void Select_SFI_24_DummyRead(void);
	void Select_SFI_Single_Mode(void);
	void Select_SFI_Dual_Mode0(void);
	void Select_SFI_Dual_Mode1(void);

	//REG[B8h] SPI master Tx /Rx FIFO Data Register (SPIDR) 
	unsigned char SPI_Master_FIFO_Data_Put(unsigned char Data);
	unsigned char SPI_Master_FIFO_Data_Get(void);

	//REG[B9h] SPI master Control Register (SPIMCR2) 
	void Mask_SPI_Master_Interrupt_Flag(void);
	void Select_nSS_drive_on_xnsfcs0(void);
	void Select_nSS_drive_on_xnsfcs1(void);
	void nSS_Inactive(void);
	void nSS_Active(void);
	void OVFIRQEN_Enable(void);
	void EMTIRQEN_Enable(void);
	void Reset_CPOL(void);
	void Set_CPOL(void);
	void Reset_CPHA(void);
	void Set_CPHA(void);

	//REG[BAh] SPI master Status Register (SPIMSR)
	unsigned char Tx_FIFO_Empty_Flag(void);
	unsigned char Tx_FIFO_Full_Flag(void);
	unsigned char Rx_FIFO_Empty_Flag(void);
	unsigned char Rx_FIFO_full_flag(void);
	unsigned char OVFI_Flag(void);
	void Clear_OVFI_Flag(void);
	unsigned char EMTI_Flag(void);
	void Clear_EMTI_Flag(void);

	//REG[BB] SPI Clock period (SPIDIV) 
	void SPI_Clock_Period(unsigned char temp);


	//**[BCh][BDh][BEh][BFh]**//
	void SFI_DMA_Source_Start_Address(unsigned long Addr);
	//**[C0h][C1h][C2h][C3h]**//
	void SFI_DMA_Destination_Start_Address(unsigned long Addr);
	void SFI_DMA_Destination_Upper_Left_Corner(unsigned short WX,unsigned short HY);
	//**[C4h][C5h]**//
	void SFI_DMA_Destination_Width(unsigned short WX);
	//**[C6h][C7h][C8h][C9h]**//
	void SFI_DMA_Transfer_Number(unsigned long Addr);
	void SFI_DMA_Transfer_Width_Height(unsigned short WX,unsigned short HY);
	//**[CAh][CBh]**//
	void SFI_DMA_Source_Width(unsigned short WX);

	////////////////////////////////////////////////////////////////////////
	////**** [ Function : Font ] ****////
	//**[CCh]**//

	void Font_Select_UserDefine_Mode(void);
	void CGROM_Select_Internal_CGROM(void);
	void CGROM_Select_Genitop_FontROM(void);
	void Font_Select_8x16_16x16(void);
	void Font_Select_12x24_24x24(void);
	void Font_Select_16x32_32x32(void);
	void Internal_CGROM_Select_ISOIEC8859_1(void);
	void Internal_CGROM_Select_ISOIEC8859_2(void);
	void Internal_CGROM_Select_ISOIEC8859_3(void);
	void Internal_CGROM_Select_ISOIEC8859_4(void);
	//**[CDh]**//
	void Enable_Font_Alignment(void);
	void Disable_Font_Alignment(void);
	void Font_Background_select_Transparency(void);
	void Font_Background_select_Color(void);
	void Font_0_degree(void);
	void Font_90_degree(void);
	void Font_Width_X1(void);
	void Font_Width_X2(void);
	void Font_Width_X3(void);
	void Font_Width_X4(void);
	void Font_Height_X1(void);
	void Font_Height_X2(void);
	void Font_Height_X3(void);
	void Font_Height_X4(void);

	//**[CFh]**//
	void Set_GTFont_Decoder(unsigned char temp);
	//**[D0h]**//
	void Font_Line_Distance(unsigned char temp);
	//**[D1h]**//
	void Set_Font_to_Font_Width(unsigned char temp);
        //[DBh]~[DEh]=========================================================================
        void CGRAM_Start_address(unsigned long Addr);

};
extern ER5517Basic ER5517;
#endif
