#ifndef LCD_init_h
#define LCD_init_h
#include "Arduino.h"
//#include <avr/pgmspace.h>
#include <SPI.h>

#define  SPI_CS     0
#define  SPI_RST    2
#define  SPI_DI     4
#define  SPI_CLK    12 


#define  SPI_RST_0   digitalWrite(SPI_RST, LOW)
#define  SPI_RST_1   digitalWrite(SPI_RST, HIGH)
#define  SPI_CS_0  digitalWrite(SPI_CS, LOW)
#define  SPI_CS_1  digitalWrite(SPI_CS, HIGH)
#define  SPI_CLK_0   digitalWrite(SPI_CLK, LOW)
#define  SPI_CLK_1   digitalWrite(SPI_CLK, HIGH)
#define  SPI_DI_0   digitalWrite(SPI_DI, LOW)
#define  SPI_DI_1   digitalWrite(SPI_DI, HIGH)



#define	HBPD  60
#define	HFPD  60 
#define	HSPW  6
   
#define	VBPD  24
#define	VFPD 24
#define	VSPW  2

#define hsize 480
#define vsize 480



void SPI_WriteCmd(unsigned char Sdata) { 
	unsigned char i;	
	SPI_CS_0;
	SPI_DI_0;
	SPI_CLK_0; 
	SPI_CLK_1;
	
	for(i=8; i>0; i--) {
		if(Sdata&0x80)
			SPI_DI_1;
		else
			SPI_DI_0;
		SPI_CLK_0; 
		SPI_CLK_1;
		Sdata <<= 1;
	}
	SPI_CLK_0;
	SPI_CS_1;
}

void SPI_WriteData(unsigned char Sdata) {
	unsigned char i;
	SPI_CS_0;
	SPI_DI_1;
	SPI_CLK_0; 
	SPI_CLK_1;
	
	for(i=8; i>0; i--) {
		if(Sdata&0x80)
			SPI_DI_1;
		else
			SPI_DI_0;
		SPI_CLK_0; 
		SPI_CLK_1;
		Sdata <<= 1;
	}
	SPI_CLK_0;
	SPI_CS_1;
}


void GP_COMMAD_PA(unsigned int num) 
{
	SPI_WriteCmd(0xbc);
	SPI_WriteData(num&0xff);	
	SPI_WriteData((num>>8)&0xff);	
	SPI_WriteCmd(0xbf);
}




void  LCD_initial()
{

	GP_COMMAD_PA(6);
	SPI_WriteData(0xFF);     
	SPI_WriteData(0x77);   
	SPI_WriteData(0x01);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x13);   

 	GP_COMMAD_PA(2);
	SPI_WriteData(0xEF);     
	SPI_WriteData(0x08);   

	GP_COMMAD_PA(6);
	SPI_WriteData(0xFF);     
	SPI_WriteData(0x77);   
	SPI_WriteData(0x01);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x10);   

 /*	GP_COMMAD_PA(3);
	SPI_WriteData(0xC0);     
	SPI_WriteData(0x3B);   
	SPI_WriteData(0x00);   

	GP_COMMAD_PA(3);
	SPI_WriteData(0xC1);     
	SPI_WriteData(0x10);   
	SPI_WriteData(0x0C);   

	GP_COMMAD_PA(3);
	SPI_WriteData(0xC2);     
	SPI_WriteData(0x07);   
	SPI_WriteData(0x0A);   

	GP_COMMAD_PA(2);
	SPI_WriteData(0xC7);     
	SPI_WriteData(0x00); 
	  
	GP_COMMAD_PA(2);
	SPI_WriteData(0xCC);     
	SPI_WriteData(0x10);   

	GP_COMMAD_PA(2);
	SPI_WriteData(0xCD);     
	SPI_WriteData(0x08); */

 	GP_COMMAD_PA(3);
	SPI_WriteData(0xC0);
	SPI_WriteData(0x3b);
	SPI_WriteData(0x00);

	GP_COMMAD_PA(3);
	SPI_WriteData(0xC1);
	SPI_WriteData(0x10);
	SPI_WriteData(0x10);

	GP_COMMAD_PA(3);
	SPI_WriteData(0xC2);
	SPI_WriteData(0x01);
	SPI_WriteData(0x08);

	GP_COMMAD_PA(2);
	SPI_WriteData(0xCC);
	SPI_WriteData(0x18);

	GP_COMMAD_PA(17);
	SPI_WriteData(0xB0);     
	SPI_WriteData(0x05);   
	SPI_WriteData(0x12);   
	SPI_WriteData(0x98);   
	SPI_WriteData(0x0E);   
	SPI_WriteData(0x0F);   
	SPI_WriteData(0x07);   
	SPI_WriteData(0x07);   
	SPI_WriteData(0x09);   
	SPI_WriteData(0x09);   
	SPI_WriteData(0x23);   
	SPI_WriteData(0x05);   
	SPI_WriteData(0x52);   
	SPI_WriteData(0x0F);   
	SPI_WriteData(0x67);   
	SPI_WriteData(0x2C);   
	SPI_WriteData(0x11);   

	GP_COMMAD_PA(17);
	SPI_WriteData(0xB1);     
	SPI_WriteData(0x0B);   
	SPI_WriteData(0x11);   
	SPI_WriteData(0x97);   
	SPI_WriteData(0x0C);   
	SPI_WriteData(0x12);   
	SPI_WriteData(0x06);   
	SPI_WriteData(0x06);   
	SPI_WriteData(0x08);   
	SPI_WriteData(0x08);   
	SPI_WriteData(0x22);   
	SPI_WriteData(0x03);   
	SPI_WriteData(0x51);   
	SPI_WriteData(0x11);   
	SPI_WriteData(0x66);   
	SPI_WriteData(0x2B);   
	SPI_WriteData(0x0F);   

	GP_COMMAD_PA(6);
	SPI_WriteData(0xFF);     
	SPI_WriteData(0x77);   
	SPI_WriteData(0x01);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x11);  
	 
        GP_COMMAD_PA(2);
        SPI_WriteData (0xB0);     
	SPI_WriteData (0x4D);  //6D 
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xB1);   //vcom  
	SPI_WriteData (0x3E);   
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xB2);     
	SPI_WriteData (0x87);   
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xB3);     
	SPI_WriteData (0x80);   
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xB5);     
	SPI_WriteData (0x4F);   
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xB7);     
	SPI_WriteData (0x85);   
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xB8);     
	SPI_WriteData (0x20);   
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xC1);     
	SPI_WriteData (0x78);   
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xC2);     
	SPI_WriteData (0x78);   
	GP_COMMAD_PA(2);	
	SPI_WriteData (0xD0);     
	SPI_WriteData (0x88);      

 	GP_COMMAD_PA(4);
	SPI_WriteData(0xE0);     
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x02);  
	 
	GP_COMMAD_PA(12);
	SPI_WriteData(0xE1);     
	SPI_WriteData(0x06);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0x08);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0x05);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0x07);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x33);   
	SPI_WriteData(0x33);
	   
	GP_COMMAD_PA(14);
	SPI_WriteData(0xE2);     
	SPI_WriteData(0x11);   
	SPI_WriteData(0x11);   
	SPI_WriteData(0x33);   
	SPI_WriteData(0x33);   
	SPI_WriteData(0xF4);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0xF4);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00); 

 	GP_COMMAD_PA(5);
	SPI_WriteData(0xE3);     
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x11);   
	SPI_WriteData(0x11);   

 	GP_COMMAD_PA(3);
	SPI_WriteData(0xE4);     
	SPI_WriteData(0x44);   
	SPI_WriteData(0x44);   

 	GP_COMMAD_PA(17);
	SPI_WriteData(0xE5);     
	SPI_WriteData(0x0D);   
	SPI_WriteData(0xF5);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0xF0);   
	SPI_WriteData(0x0F);   
	SPI_WriteData(0xF7);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0xF0);   
	SPI_WriteData(0x09);   
	SPI_WriteData(0xF1);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0xF0);   
	SPI_WriteData(0x0B);   
	SPI_WriteData(0xF3);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0xF0);   

  	GP_COMMAD_PA(5);
	SPI_WriteData(0xE6);     
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x11);   
	SPI_WriteData(0x11);   

  	GP_COMMAD_PA(3);
	SPI_WriteData(0xE7);     
	SPI_WriteData(0x44);   
	SPI_WriteData(0x44);   

 	GP_COMMAD_PA(17);
	SPI_WriteData(0xE8);     
	SPI_WriteData(0x0C);   
	SPI_WriteData(0xF4);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0xF0);   
	SPI_WriteData(0x0E);   
	SPI_WriteData(0xF6);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0xF0);   
	SPI_WriteData(0x08);   
	SPI_WriteData(0xF0);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0xF0);   
	SPI_WriteData(0x0A);   
	SPI_WriteData(0xF2);   
	SPI_WriteData(0x30);   
	SPI_WriteData(0xF0);   

 	GP_COMMAD_PA(3);
	SPI_WriteData(0xE9);     
	SPI_WriteData(0x36);   
	SPI_WriteData(0x01);  
	 
 	GP_COMMAD_PA(8);
	SPI_WriteData(0xEB);     
	SPI_WriteData(0x00);   
	SPI_WriteData(0x01);   
	SPI_WriteData(0xE4);   
	SPI_WriteData(0xE4);   
	SPI_WriteData(0x44);   
	SPI_WriteData(0x88);   
	SPI_WriteData(0x40); 
	  
 	GP_COMMAD_PA(17);
	SPI_WriteData(0xED);     
	SPI_WriteData(0xFF);   
	SPI_WriteData(0x10);   
	SPI_WriteData(0xAF);   
	SPI_WriteData(0x76);   
	SPI_WriteData(0x54);   
	SPI_WriteData(0x2B);   
	SPI_WriteData(0xCF);   
	SPI_WriteData(0xFF);   
	SPI_WriteData(0xFF);   
	SPI_WriteData(0xFC);   
	SPI_WriteData(0xB2);   
	SPI_WriteData(0x45);   
	SPI_WriteData(0x67);   
	SPI_WriteData(0xFA);   
	SPI_WriteData(0x01);   
	SPI_WriteData(0xFF);   

 	GP_COMMAD_PA(7);
	SPI_WriteData(0xEF);     
	SPI_WriteData(0x08);   
	SPI_WriteData(0x08);   
	SPI_WriteData(0x08);   
	SPI_WriteData(0x45);   
	SPI_WriteData(0x3F);   
	SPI_WriteData(0x54);   

 	GP_COMMAD_PA(6);
	SPI_WriteData(0xFF);     
	SPI_WriteData(0x77);   
	SPI_WriteData(0x01);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   
	SPI_WriteData(0x00);   


   
  	GP_COMMAD_PA(1);
	SPI_WriteData(0x11);     
	delay(120);                //ms

 /*
  	GP_COMMAD_PA(2);
	SPI_WriteData(0x3A);     
	SPI_WriteData(0x77);   
  
 	GP_COMMAD_PA(2);
	SPI_WriteData(0x36);     
	SPI_WriteData(0x00);   

 	GP_COMMAD_PA(2);
	SPI_WriteData(0x35);     
	SPI_WriteData(0x00); */ 	

 	GP_COMMAD_PA(1);
	SPI_WriteData(0x29);  
 	delay(10);  				
}


void SSD2828_Initial(void)
{  
    pinMode(SPI_CS,   OUTPUT);   
    pinMode(SPI_CLK,   OUTPUT);
    pinMode(SPI_DI,   OUTPUT);
    pinMode(SPI_RST,   OUTPUT); 
    SPI_RST_1;
    SPI_CS_1;
    SPI_CLK_0;
    SPI_DI_1;
    SPI_RST_0;						   
    delay(30);
    SPI_RST_1;
    delay(50);	 
   
 //SSD2828_Initial
	SPI_WriteCmd(0xb7);
	SPI_WriteData(0x50);//50=TX_CLK 70=PCLK
	SPI_WriteData(0x00);   //Configuration Register

	SPI_WriteCmd(0xb8);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);   //VC(Virtual ChannelID) Control Register

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x00);//1=PLL disable
	SPI_WriteData(0x00);
	 //TX_CLK/MS should be between 5Mhz to100Mhz
	SPI_WriteCmd(0xBA);//PLL=(TX_CLK/MS)*NS 8228=480M 4428=240M  061E=120M 4214=240M 821E=360M 8219=300M
	SPI_WriteData(0x14);//D7-0=NS(0x01 : NS=1)
	SPI_WriteData(0x42);//D15-14=PLL范围 00=62.5-125 01=126-250 10=251-500 11=501-1000  DB12-8=MS(01:MS=1)

	SPI_WriteCmd(0xBB);//LP Clock Divider LP clock = 400MHz / LPD / 8 = 240 / 8 / 4 = 7.5MHz
	SPI_WriteData(0x03);//D5-0=LPD=0x1 – Divide by 2
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x01);//1=PLL disable
	SPI_WriteData(0x00);
	//MIPI lane configuration
	SPI_WriteData(0xDE);//通道数
	SPI_WriteData(0x01);//11=4LANE 10=3LANE 01=2LANE 00=1LANE
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xc9);
	SPI_WriteData(0x02);
	SPI_WriteData(0x23);   //p1: HS-Data-zero  p2: HS-Data- prepare  --> 8031 issue
	 delay(100);



	//LCD driver initialization
 	//==Video Mode Initial Code	    				    
	SPI_WriteCmd(0xB7);
	SPI_WriteData(0x50);//10=TX_CLK 30=PCLK
	SPI_WriteData(0x02);

	SPI_WriteCmd(0xBD);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);

     LCD_initial();//LCD driver initialization	  

  
/////////////////SSD2828_Initial////////////////

	SPI_WriteCmd(0xb7);
	SPI_WriteData(0x50);
	SPI_WriteData(0x00);   //Configuration Register

	SPI_WriteCmd(0xb8);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);   //VC(Virtual ChannelID) Control Register

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x00);//1=PLL disable
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xBA);//PLL=(TX_CLK/MS)*NS 8228=480M 4428=240M  061E=120M 4214=240M 821E=360M 8219=300M 8225=444M 8224=432
	SPI_WriteData(0x27);//D7-0=NS(0x01 : NS=1)
	SPI_WriteData(0x82);//D15-14=PLL范围 00=62.5-125 01=126-250 10=251-500 11=501-1000  DB12-8=MS(01:MS=1)

	SPI_WriteCmd(0xBB);//LP Clock Divider LP clock = 400MHz / LPD / 8 = 480 / 8/ 8 = 7MHz
	SPI_WriteData(0x07);//D5-0=LPD=0x1 – Divide by 2
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x01);//1=PLL disable
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xc9);
	SPI_WriteData(0x02);
	SPI_WriteData(0x23);   //p1: HS-Data-zero  p2: HS-Data- prepare  --> 8031 issue
	delay(100);

	SPI_WriteCmd(0xCA);
	SPI_WriteData(0x01);//CLK Prepare
	SPI_WriteData(0x23);//Clk Zero

	SPI_WriteCmd(0xCB); //local_write_reg(addr=0xCB,data=0x0510)
	SPI_WriteData(0x10); //Clk Post
	SPI_WriteData(0x05); //Clk Per

	SPI_WriteCmd(0xCC); //local_write_reg(addr=0xCC,data=0x100A)
	SPI_WriteData(0x05); //HS Trail
	SPI_WriteData(0x10); //Clk Trail

	SPI_WriteCmd(0xD0);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);

		//RGB interface configuration
	SPI_WriteCmd(0xB1);
	SPI_WriteData(HSPW);//HSPW 07
	SPI_WriteData(VSPW);//VSPW 05

	SPI_WriteCmd(0xB2);
	SPI_WriteData(HBPD);//HBPD 0x64=100
	SPI_WriteData(VBPD);//VBPD 8 减小下移

	SPI_WriteCmd(0xB3);
	SPI_WriteData(HFPD);//HFPD 8
	SPI_WriteData(VFPD);//VFPD 10

	SPI_WriteCmd(0xB4);//Horizontal active period 
	SPI_WriteData(hsize);//
	SPI_WriteData(hsize>>8);//

	SPI_WriteCmd(0xB5);//Vertical active period 
	SPI_WriteData(vsize);//
	SPI_WriteData(vsize>>8);//

	SPI_WriteCmd(0xB6);//RGB CLK  16BPP=00 18BPP=01
	SPI_WriteData(0x07);//D7=0 D6=0 D5=0  D1-0=11 – 24bpp
	SPI_WriteData(0x20);//D15=VS D14=HS D13=CLK D12-9=NC D8=0=Video with blanking packet. 00-F0



		//MIPI lane configuration
	SPI_WriteCmd(0xDE);//通道数
	SPI_WriteData(0x01);//11=4LANE 10=3LANE 01=2LANE 00=1LANE
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xD6);//  05=BGR  04=RGB
	SPI_WriteData(0x05);//D0=0=RGB 1:BGR D1=1=Most significant byte sent first
	SPI_WriteData(0x00);


	SPI_WriteCmd(0xB7);
	SPI_WriteData(0x4B);
	SPI_WriteData(0x02); 

}

#endif


