#ifndef LCD_init_h
#define LCD_init_h
#include "Arduino.h"
//#include <avr/pgmspace.h>
#include <SPI.h>

#define  SPI_CS     0
#define  SPI_RST    2
#define  SPI_DI     4
#define  SPI_CLK    12


#define  SPI_RST_0   digitalWrite(SPI_RST, LOW)
#define  SPI_RST_1   digitalWrite(SPI_RST, HIGH)
#define  SPI_CS_0  digitalWrite(SPI_CS, LOW)
#define  SPI_CS_1  digitalWrite(SPI_CS, HIGH)
#define  SPI_CLK_0   digitalWrite(SPI_CLK, LOW)
#define  SPI_CLK_1   digitalWrite(SPI_CLK, HIGH)
#define  SPI_DI_0   digitalWrite(SPI_DI, LOW)
#define  SPI_DI_1   digitalWrite(SPI_DI, HIGH)

#define hsize 600
#define vsize 1424
#define LINE 4

void SPI_WriteCmd(unsigned char Sdata) { 
	unsigned char i;	
	SPI_CS_0;
	SPI_DI_0;
	SPI_CLK_0; 
	SPI_CLK_1;
	
	for(i=8; i>0; i--) {
		if(Sdata&0x80)
			SPI_DI_1;
		else
			SPI_DI_0;
		SPI_CLK_0; 
		SPI_CLK_1;
		Sdata <<= 1;
	}
	SPI_CLK_0;
	SPI_CS_1;
}

void SPI_WriteData(unsigned char Sdata) {
	unsigned char i;
	SPI_CS_0;
	SPI_DI_1;
	SPI_CLK_0; 
	SPI_CLK_1;
	
	for(i=8; i>0; i--) {
		if(Sdata&0x80)
			SPI_DI_1;
		else
			SPI_DI_0;
		SPI_CLK_0; 
		SPI_CLK_1;
		Sdata <<= 1;
	}
	SPI_CLK_0;
	SPI_CS_1;
}


void GP_COMMAD_PA(unsigned int num) 
{
	SPI_WriteCmd(0xbc);
	SPI_WriteData(num&0xff);	
	SPI_WriteData((num>>8)&0xff);	
	SPI_WriteCmd(0xbf);
}




void  LCD_initial()
{
     GP_COMMAD_PA(2);  SPI_WriteData(0xE0); SPI_WriteData(0x00);

     GP_COMMAD_PA(2);  SPI_WriteData(0xE1); SPI_WriteData(0x93);
     GP_COMMAD_PA(2);  SPI_WriteData(0xE2); SPI_WriteData(0x65);
     GP_COMMAD_PA(2);  SPI_WriteData(0xE3); SPI_WriteData(0xF8);
     GP_COMMAD_PA(2);  SPI_WriteData(0x80); SPI_WriteData(0x03);

     GP_COMMAD_PA(2);  SPI_WriteData(0xE0); SPI_WriteData(0x01);

     GP_COMMAD_PA(2);  SPI_WriteData(0x00); SPI_WriteData(0x00);
     GP_COMMAD_PA(2);  SPI_WriteData(0x01); SPI_WriteData(0x5B); //0xA0
     GP_COMMAD_PA(2);  SPI_WriteData(0x03); SPI_WriteData(0x10);
     GP_COMMAD_PA(2);  SPI_WriteData(0x04); SPI_WriteData(0x37); //0xA0

     GP_COMMAD_PA(2);  SPI_WriteData(0x0C); SPI_WriteData(0x74);

     GP_COMMAD_PA(2);  SPI_WriteData(0x17); SPI_WriteData(0x00);
     GP_COMMAD_PA(2);  SPI_WriteData(0x18); SPI_WriteData(0xDF); //VGMP=4.9
     GP_COMMAD_PA(2);  SPI_WriteData(0x19); SPI_WriteData(0x01);
     GP_COMMAD_PA(2);  SPI_WriteData(0x1A); SPI_WriteData(0x00);
     GP_COMMAD_PA(2);  SPI_WriteData(0x1B); SPI_WriteData(0xDF); //VGMN=-4.9
     GP_COMMAD_PA(2);  SPI_WriteData(0x1C); SPI_WriteData(0x01);

     GP_COMMAD_PA(2);  SPI_WriteData(0x1F); SPI_WriteData(0x2F);  //VGH_R  = 15V ,0X72   888
     GP_COMMAD_PA(2);  SPI_WriteData(0x20); SPI_WriteData(0x2F);  //VGL_R  = -12V
     GP_COMMAD_PA(2);  SPI_WriteData(0x21); SPI_WriteData(0x2F);  //VGL_R2 = -12V
     GP_COMMAD_PA(2);  SPI_WriteData(0x22); SPI_WriteData(0x0E);  //PA[6]=0, PA[5]=0, PA[4]=0, PA[0]=0


     GP_COMMAD_PA(2);  SPI_WriteData(0x24); SPI_WriteData(0xFE);
     GP_COMMAD_PA(2);  SPI_WriteData(0x37); SPI_WriteData(0x09);   //SS=1,BGR=1

     GP_COMMAD_PA(2);  SPI_WriteData(0x38); SPI_WriteData(0x04);//JDT=101 
     GP_COMMAD_PA(2);  SPI_WriteData(0x39); SPI_WriteData(0x00);//RGB_N_EQ1
     GP_COMMAD_PA(2);  SPI_WriteData(0x3A); SPI_WriteData(0x01);//RGB_N_EQ2
     GP_COMMAD_PA(2);  SPI_WriteData(0x3C); SPI_WriteData(0x90);//SET EQ3 for TE_H
     GP_COMMAD_PA(2);  SPI_WriteData(0x3D); SPI_WriteData(0xFF);//SET CHGEN_ON,
     GP_COMMAD_PA(2);  SPI_WriteData(0x3E); SPI_WriteData(0xFF);//SET CHGEN_OFF,
     GP_COMMAD_PA(2);  SPI_WriteData(0x3F); SPI_WriteData(0xFF); //SET CHGEN_OFF2,

     GP_COMMAD_PA(2);  SPI_WriteData(0x40); SPI_WriteData(0x02);//RSO=720 RGB
     GP_COMMAD_PA(2);  SPI_WriteData(0x41); SPI_WriteData(0xB2);//LN=712->1424 line
     GP_COMMAD_PA(2);  SPI_WriteData(0x43); SPI_WriteData(0x06);//VFP
     GP_COMMAD_PA(2);  SPI_WriteData(0x44); SPI_WriteData(0x0A);//VBP
     GP_COMMAD_PA(2);  SPI_WriteData(0x45); SPI_WriteData(0x3C);//HBP
     GP_COMMAD_PA(2);  SPI_WriteData(0x4B); SPI_WriteData(0x04);//source EQ off



     GP_COMMAD_PA(2);  SPI_WriteData(0x55); SPI_WriteData(0x02);//02=2power mode 0C=3power mode
     GP_COMMAD_PA(2);  SPI_WriteData(0x56); SPI_WriteData(0x01);
     GP_COMMAD_PA(2);  SPI_WriteData(0x57); SPI_WriteData(0x89);
     GP_COMMAD_PA(2);  SPI_WriteData(0x58); SPI_WriteData(0x0A);
     GP_COMMAD_PA(2);  SPI_WriteData(0x59); SPI_WriteData(0x0A);//VCL = -2.9V
     GP_COMMAD_PA(2);  SPI_WriteData(0x5A); SPI_WriteData(0x28);//VGH = 15.2V
     GP_COMMAD_PA(2);  SPI_WriteData(0x5B); SPI_WriteData(0x1A);//VGL = -12.2V

     GP_COMMAD_PA(2);  SPI_WriteData(0x5D); SPI_WriteData(0x7C);
     GP_COMMAD_PA(2);  SPI_WriteData(0x5E); SPI_WriteData(0x57);
     GP_COMMAD_PA(2);  SPI_WriteData(0x5F); SPI_WriteData(0x44);
     GP_COMMAD_PA(2);  SPI_WriteData(0x60); SPI_WriteData(0x36);
     GP_COMMAD_PA(2);  SPI_WriteData(0x61); SPI_WriteData(0x31);
     GP_COMMAD_PA(2);  SPI_WriteData(0x62); SPI_WriteData(0x23);
     GP_COMMAD_PA(2);  SPI_WriteData(0x63); SPI_WriteData(0x26);
     GP_COMMAD_PA(2);  SPI_WriteData(0x64); SPI_WriteData(0x0F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x65); SPI_WriteData(0x28);
     GP_COMMAD_PA(2);  SPI_WriteData(0x66); SPI_WriteData(0x26);
     GP_COMMAD_PA(2);  SPI_WriteData(0x67); SPI_WriteData(0x27);
     GP_COMMAD_PA(2);  SPI_WriteData(0x68); SPI_WriteData(0x45);
     GP_COMMAD_PA(2);  SPI_WriteData(0x69); SPI_WriteData(0x35);
     GP_COMMAD_PA(2);  SPI_WriteData(0x6A); SPI_WriteData(0x3D);
     GP_COMMAD_PA(2);  SPI_WriteData(0x6B); SPI_WriteData(0x2F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x6C); SPI_WriteData(0x2B);
     GP_COMMAD_PA(2);  SPI_WriteData(0x6D); SPI_WriteData(0x1E);
     GP_COMMAD_PA(2);  SPI_WriteData(0x6E); SPI_WriteData(0x0D);
     GP_COMMAD_PA(2);  SPI_WriteData(0x6F); SPI_WriteData(0x00);

     GP_COMMAD_PA(2);  SPI_WriteData(0x70); SPI_WriteData(0x7C);
     GP_COMMAD_PA(2);  SPI_WriteData(0x71); SPI_WriteData(0x57);
     GP_COMMAD_PA(2);  SPI_WriteData(0x72); SPI_WriteData(0x44);
     GP_COMMAD_PA(2);  SPI_WriteData(0x73); SPI_WriteData(0x36);
     GP_COMMAD_PA(2);  SPI_WriteData(0x74); SPI_WriteData(0x31);
     GP_COMMAD_PA(2);  SPI_WriteData(0x75); SPI_WriteData(0x23);
     GP_COMMAD_PA(2);  SPI_WriteData(0x76); SPI_WriteData(0x26);
     GP_COMMAD_PA(2);  SPI_WriteData(0x77); SPI_WriteData(0x0F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x78); SPI_WriteData(0x28);
     GP_COMMAD_PA(2);  SPI_WriteData(0x79); SPI_WriteData(0x26);
     GP_COMMAD_PA(2);  SPI_WriteData(0x7A); SPI_WriteData(0x27);
     GP_COMMAD_PA(2);  SPI_WriteData(0x7B); SPI_WriteData(0x45);
     GP_COMMAD_PA(2);  SPI_WriteData(0x7C); SPI_WriteData(0x35);
     GP_COMMAD_PA(2);  SPI_WriteData(0x7D); SPI_WriteData(0x3D);
     GP_COMMAD_PA(2);  SPI_WriteData(0x7E); SPI_WriteData(0x2F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x7F); SPI_WriteData(0x2B);
     GP_COMMAD_PA(2);  SPI_WriteData(0x80); SPI_WriteData(0x1E);
     GP_COMMAD_PA(2);  SPI_WriteData(0x81); SPI_WriteData(0x0D);
     GP_COMMAD_PA(2);  SPI_WriteData(0x82); SPI_WriteData(0x00);

     GP_COMMAD_PA(2);  SPI_WriteData(0xE0); SPI_WriteData(0x02);
     GP_COMMAD_PA(2);  SPI_WriteData(0x00); SPI_WriteData(0x75);//GCL
     GP_COMMAD_PA(2);  SPI_WriteData(0x01); SPI_WriteData(0x50);//STV0
     GP_COMMAD_PA(2);  SPI_WriteData(0x02); SPI_WriteData(0x55); //GCH
     GP_COMMAD_PA(2);  SPI_WriteData(0x03); SPI_WriteData(0x43);//STV3
     GP_COMMAD_PA(2);  SPI_WriteData(0x04); SPI_WriteData(0x5E);//VDS
     GP_COMMAD_PA(2);  SPI_WriteData(0x05); SPI_WriteData(0x4F); //VSD
     GP_COMMAD_PA(2);  SPI_WriteData(0x06); SPI_WriteData(0x41);//STV1
     GP_COMMAD_PA(2);  SPI_WriteData(0x07); SPI_WriteData(0x5F);//VGL
     GP_COMMAD_PA(2);  SPI_WriteData(0x08); SPI_WriteData(0x45);//CLK5
     GP_COMMAD_PA(2);  SPI_WriteData(0x09); SPI_WriteData(0x47);//CLK7
     GP_COMMAD_PA(2);  SPI_WriteData(0x0A); SPI_WriteData(0x49);//CLK1
     GP_COMMAD_PA(2);  SPI_WriteData(0x0B); SPI_WriteData(0x4B);//CLK3
     GP_COMMAD_PA(2);  SPI_WriteData(0x0C); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x0D); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x0E); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x0F); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x10); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x11); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x12); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x13); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x14); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x15); SPI_WriteData(0x5F);

     GP_COMMAD_PA(2);  SPI_WriteData(0x16); SPI_WriteData(0x75);//GCL
     GP_COMMAD_PA(2);  SPI_WriteData(0x17); SPI_WriteData(0x50); //STV0
     GP_COMMAD_PA(2);  SPI_WriteData(0x18); SPI_WriteData(0x55);//GCH
     GP_COMMAD_PA(2);  SPI_WriteData(0x19); SPI_WriteData(0x42);//STV4
     GP_COMMAD_PA(2);  SPI_WriteData(0x1A); SPI_WriteData(0x5E);//VDS
     GP_COMMAD_PA(2);  SPI_WriteData(0x1B); SPI_WriteData(0x5F);//VSD
     GP_COMMAD_PA(2);  SPI_WriteData(0x1C); SPI_WriteData(0x40);//STV2
     GP_COMMAD_PA(2);  SPI_WriteData(0x1D); SPI_WriteData(0x5F);//VGL
     GP_COMMAD_PA(2);  SPI_WriteData(0x1E); SPI_WriteData(0x44); //CLK6
     GP_COMMAD_PA(2);  SPI_WriteData(0x1F); SPI_WriteData(0x46);//CLK8
     GP_COMMAD_PA(2);  SPI_WriteData(0x20); SPI_WriteData(0x48);//CLK2
     GP_COMMAD_PA(2);  SPI_WriteData(0x21); SPI_WriteData(0x4A);//CLK4
     GP_COMMAD_PA(2);  SPI_WriteData(0x22); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x23); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x24); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x25); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x26); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x27); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x28); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x29); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x2A); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x2B); SPI_WriteData(0x5F);

     GP_COMMAD_PA(2);  SPI_WriteData(0x2C); SPI_WriteData(0x5E);
     GP_COMMAD_PA(2);  SPI_WriteData(0x2D); SPI_WriteData(0x5E);
     GP_COMMAD_PA(2);  SPI_WriteData(0x2E); SPI_WriteData(0x75);
     GP_COMMAD_PA(2);  SPI_WriteData(0x2F); SPI_WriteData(0x50);
     GP_COMMAD_PA(2);  SPI_WriteData(0x30); SPI_WriteData(0x47);
     GP_COMMAD_PA(2);  SPI_WriteData(0x31); SPI_WriteData(0x47);
     GP_COMMAD_PA(2);  SPI_WriteData(0x32); SPI_WriteData(0x45);
     GP_COMMAD_PA(2);  SPI_WriteData(0x33); SPI_WriteData(0x45);
     GP_COMMAD_PA(2);  SPI_WriteData(0x34); SPI_WriteData(0x4B);
     GP_COMMAD_PA(2);  SPI_WriteData(0x35); SPI_WriteData(0x4B);
     GP_COMMAD_PA(2);  SPI_WriteData(0x36); SPI_WriteData(0x49);
     GP_COMMAD_PA(2);  SPI_WriteData(0x37); SPI_WriteData(0x49);
     GP_COMMAD_PA(2);  SPI_WriteData(0x38); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x39); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x3A); SPI_WriteData(0x55);
     GP_COMMAD_PA(2);  SPI_WriteData(0x3B); SPI_WriteData(0x55);
     GP_COMMAD_PA(2);  SPI_WriteData(0x3C); SPI_WriteData(0x43);
     GP_COMMAD_PA(2);  SPI_WriteData(0x3D); SPI_WriteData(0x41);
     GP_COMMAD_PA(2);  SPI_WriteData(0x3E); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x3F); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x40); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x41); SPI_WriteData(0x5F);

     GP_COMMAD_PA(2);  SPI_WriteData(0x42); SPI_WriteData(0x5E);
     GP_COMMAD_PA(2);  SPI_WriteData(0x43); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x44); SPI_WriteData(0x75);
     GP_COMMAD_PA(2);  SPI_WriteData(0x45); SPI_WriteData(0x50);
     GP_COMMAD_PA(2);  SPI_WriteData(0x46); SPI_WriteData(0x46);
     GP_COMMAD_PA(2);  SPI_WriteData(0x47); SPI_WriteData(0x46);
     GP_COMMAD_PA(2);  SPI_WriteData(0x48); SPI_WriteData(0x44);
     GP_COMMAD_PA(2);  SPI_WriteData(0x49); SPI_WriteData(0x44);
     GP_COMMAD_PA(2);  SPI_WriteData(0x4A); SPI_WriteData(0x4A);
     GP_COMMAD_PA(2);  SPI_WriteData(0x4B); SPI_WriteData(0x4A);
     GP_COMMAD_PA(2);  SPI_WriteData(0x4C); SPI_WriteData(0x48);
     GP_COMMAD_PA(2);  SPI_WriteData(0x4D); SPI_WriteData(0x48);
     GP_COMMAD_PA(2);  SPI_WriteData(0x4E); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x4F); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x50); SPI_WriteData(0x55);
     GP_COMMAD_PA(2);  SPI_WriteData(0x51); SPI_WriteData(0x55);
     GP_COMMAD_PA(2);  SPI_WriteData(0x52); SPI_WriteData(0x42);
     GP_COMMAD_PA(2);  SPI_WriteData(0x53); SPI_WriteData(0x40);
     GP_COMMAD_PA(2);  SPI_WriteData(0x54); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x55); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x56); SPI_WriteData(0x5F);
     GP_COMMAD_PA(2);  SPI_WriteData(0x57); SPI_WriteData(0x5F);

     GP_COMMAD_PA(2);  SPI_WriteData(0x58); SPI_WriteData(0x00);
     GP_COMMAD_PA(2);  SPI_WriteData(0x59); SPI_WriteData(0x00);
     GP_COMMAD_PA(2);  SPI_WriteData(0x5A); SPI_WriteData(0x00);
     GP_COMMAD_PA(2);  SPI_WriteData(0x5B); SPI_WriteData(0x30);//STV_Num
     GP_COMMAD_PA(2);  SPI_WriteData(0x5C); SPI_WriteData(0x00);//STV_S0          888
     GP_COMMAD_PA(2);  SPI_WriteData(0x5D); SPI_WriteData(0x30);//STV_W,STV_S1
     GP_COMMAD_PA(2);  SPI_WriteData(0x5E); SPI_WriteData(0x00);//STV_S2
     GP_COMMAD_PA(2);  SPI_WriteData(0x5F); SPI_WriteData(0x00);//STV_S3
     GP_COMMAD_PA(2);  SPI_WriteData(0x60); SPI_WriteData(0x30);//ETV_W,ETV_S1
     GP_COMMAD_PA(2);  SPI_WriteData(0x61); SPI_WriteData(0x00);//ETV_S2
     GP_COMMAD_PA(2);  SPI_WriteData(0x62); SPI_WriteData(0x00);//ETV_S3
     GP_COMMAD_PA(2);  SPI_WriteData(0x63); SPI_WriteData(0x06);//SETV_ON
     GP_COMMAD_PA(2);  SPI_WriteData(0x64); SPI_WriteData(0x6A);//SETV_OFF
     GP_COMMAD_PA(2);  SPI_WriteData(0x65); SPI_WriteData(0x45);//ETV_EN,ETV_NUM
     GP_COMMAD_PA(2);  SPI_WriteData(0x66); SPI_WriteData(0xAF);//ETV_S0
     GP_COMMAD_PA(2);  SPI_WriteData(0x67); SPI_WriteData(0x73);//CKV0_NUM,CKV0_W
     GP_COMMAD_PA(2);  SPI_WriteData(0x68); SPI_WriteData(0x04);//CKV0_S0
     GP_COMMAD_PA(2);  SPI_WriteData(0x69); SPI_WriteData(0x06);//CKV0_ON
     GP_COMMAD_PA(2);  SPI_WriteData(0x6A); SPI_WriteData(0x6A);//CKV0_OFF
     GP_COMMAD_PA(2);  SPI_WriteData(0x6B); SPI_WriteData(0x08);//CKV0_DUM        888
     GP_COMMAD_PA(2);  SPI_WriteData(0x6C); SPI_WriteData(0x00);//EOLR,GEQ_LINE,GEQ_W
     GP_COMMAD_PA(2);  SPI_WriteData(0x6D); SPI_WriteData(0x04);//GEQ_GGND1
     GP_COMMAD_PA(2);  SPI_WriteData(0x6E); SPI_WriteData(0x04);//GEQ_GGND2
     GP_COMMAD_PA(2);  SPI_WriteData(0x6F); SPI_WriteData(0x88);//GIPDR,VGHO_SEL,VGLO_SEL


     GP_COMMAD_PA(2);  SPI_WriteData(0x70); SPI_WriteData(0x00);//CKV1_NUM,CKV1_W
     GP_COMMAD_PA(2);  SPI_WriteData(0x71); SPI_WriteData(0x00);//CKV1_S0
     GP_COMMAD_PA(2);  SPI_WriteData(0x72); SPI_WriteData(0x06);//CKV1_ON
     GP_COMMAD_PA(2);  SPI_WriteData(0x73); SPI_WriteData(0x7B);//CKV1_OFF
     GP_COMMAD_PA(2);  SPI_WriteData(0x74); SPI_WriteData(0x00);//CKV1_DUM
     GP_COMMAD_PA(2);  SPI_WriteData(0x75); SPI_WriteData(0x07);//FLM_EN,FLM_W    888
     GP_COMMAD_PA(2);  SPI_WriteData(0x76); SPI_WriteData(0x00);//FLM_ON 
     GP_COMMAD_PA(2);  SPI_WriteData(0x77); SPI_WriteData(0xD0);//VEN_EN,VEN_W,FLM_NUM
     GP_COMMAD_PA(2);  SPI_WriteData(0x78); SPI_WriteData(0x17);//FLM_OFF
     GP_COMMAD_PA(2);  SPI_WriteData(0x79); SPI_WriteData(0xB0);//VEN_W
     GP_COMMAD_PA(2);  SPI_WriteData(0x7A); SPI_WriteData(0x00);//VEN_S0
     GP_COMMAD_PA(2);  SPI_WriteData(0x7B); SPI_WriteData(0x00);//VEN_S1 
     GP_COMMAD_PA(2);  SPI_WriteData(0x7C); SPI_WriteData(0x00);//VEN_DUM
     GP_COMMAD_PA(2);  SPI_WriteData(0x7D); SPI_WriteData(0x06);//VEN_ON
     GP_COMMAD_PA(2);  SPI_WriteData(0x7E); SPI_WriteData(0x6A);//VEN_OFF
     GP_COMMAD_PA(2);  SPI_WriteData(0x7F); SPI_WriteData(0x40);

 
     GP_COMMAD_PA(2);  SPI_WriteData(0xE0); SPI_WriteData(0x00);
     GP_COMMAD_PA(2);  SPI_WriteData(0xE6); SPI_WriteData(0x02);
     GP_COMMAD_PA(2);  SPI_WriteData(0xE7); SPI_WriteData(0x0C);
	

     GP_COMMAD_PA(2);SPI_WriteData(0x11);  SPI_WriteData(0x00);
     delay(120);
     GP_COMMAD_PA(2);SPI_WriteData(0x29);  SPI_WriteData(0x00);
	 delay(10);
     GP_COMMAD_PA(2);  SPI_WriteData(0x35); SPI_WriteData(0x00);
}


void SSD2828_Initial(void)
{  
    pinMode(SPI_CS,   OUTPUT);   
    pinMode(SPI_CLK,   OUTPUT);
    pinMode(SPI_DI,   OUTPUT);
    pinMode(SPI_RST,   OUTPUT); 
    SPI_RST_1;
    SPI_CS_1;
    SPI_CLK_0;
    SPI_DI_1;
    SPI_RST_0;						   
    delay(30);
    SPI_RST_1;
    delay(50);	 
   
SPI_WriteCmd(0xb7);
	SPI_WriteData(0x50);//50=TX_CLK 70=PCLK
	SPI_WriteData(0x00);   //Configuration Register

	SPI_WriteCmd(0xb8);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);   //VC(Virtual ChannelID) Control Register

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x00);//1=PLL disable
	SPI_WriteData(0x00);



 	SPI_WriteCmd(0xBA);//PLL=(TX_CLK/MS)*NS 
	SPI_WriteData(0x14);//14,D7-0=NS(0x01 : NS=1)
	SPI_WriteData(0x42);//42,D15-14=PLL00=62.5-125 01=126-250 10=251-500 11=501-1000  DB12-8=MS(01:MS=1)



	SPI_WriteCmd(0xBB);//LP Clock Divider LP clock = 400MHz / LPD / 8 = 480 / 8/ 8 = 7MHz
	SPI_WriteData(0x03);//D5-0=LPD=0x1 – Divide by 2
	SPI_WriteData(0x00);

	 SPI_WriteCmd(0xb9);
	SPI_WriteData(0x01);//1=PLL disable
	SPI_WriteData(0x00);
	//MIPI lane configuration
	SPI_WriteCmd(0xDE);
	SPI_WriteData(0x00);//11=4LANE 10=3LANE 01=2LANE 00=1LANE
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xc9);
	SPI_WriteData(0x02);
	SPI_WriteData(0x23);   //p1: HS-Data-zero  p2: HS-Data- prepare  --> 8031 issue
//	delay(100);


     LCD_initial();	  

				 

	SPI_WriteCmd(0xb7);
	SPI_WriteData(0x50);
	SPI_WriteData(0x00);   //Configuration Register

	SPI_WriteCmd(0xb8);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);   //VC(Virtual ChannelID) Control Register

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x00);//1=PLL disable
	SPI_WriteData(0x00);

    SPI_WriteCmd(0xBA);//
	SPI_WriteData(0x31);//14,D7-0=NS(0x01 : NS=1)		 //0x25
	SPI_WriteData(0x82);//42,D15-14=PLL00=62.5-125 01=126-250 10=251-500 11=501-1000  DB12-8=MS(01:MS=1)


	SPI_WriteCmd(0xBB);//LP Clock Divider LP clock = 400MHz / LPD / 8 = 480 / 8/ 8 = 7MHz
	SPI_WriteData(0x07);//D5-0=LPD=0x1 – Divide by 2
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xb9);
	SPI_WriteData(0x01);//1=PLL disable
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xc9);
	SPI_WriteData(0x02);
	SPI_WriteData(0x23);   //p1: HS-Data-zero  p2: HS-Data- prepare  --> 8031 issue
	delay(100);

	SPI_WriteCmd(0xCA);
	SPI_WriteData(0x01);//CLK Prepare
	SPI_WriteData(0x23);//Clk Zero

	SPI_WriteCmd(0xCB); //local_write_reg(addr=0xCB,data=0x0510)
	SPI_WriteData(0x10); //Clk Post
	SPI_WriteData(0x05); //Clk Per

	SPI_WriteCmd(0xCC); //local_write_reg(addr=0xCC,data=0x100A)
	SPI_WriteData(0x05); //HS Trail
	SPI_WriteData(0x10); //Clk Trail

	SPI_WriteCmd(0xD0);
	SPI_WriteData(0x00);
	SPI_WriteData(0x00);  



	
    SPI_WriteCmd(0xB1); //local_write_reg(addr=0xB2,data=0x1224)
	SPI_WriteData(LCD_HSPW); //HSA
	SPI_WriteData(LCD_VSPW); //VSA 


	SPI_WriteCmd(0xB2); //local_write_reg(addr=0xB2,data=0x1224)
	SPI_WriteData(LCD_HBPD); //HBP
	SPI_WriteData(LCD_VBPD); //VBP 

	SPI_WriteCmd(0xB3); //local_write_reg(addr=0xB3,data=0x060C)
	SPI_WriteData(LCD_HFPD); //HFP
	SPI_WriteData(LCD_VFPD); //VFP  

 
	SPI_WriteCmd(0xB4);//Horizontal active period 280
	SPI_WriteData(hsize);//
	SPI_WriteData(hsize>>8);

	SPI_WriteCmd(0xB5);//Vertical active period 1424
	SPI_WriteData(vsize);//
	SPI_WriteData(vsize>>8);

	
	SPI_WriteCmd(0xB6);//RGB CLK  16BPP=00 18BPP=01
	SPI_WriteData(0x0b);//D7=0 D6=0 D5=0  D1-0=11 – 24bpp	 //07
	SPI_WriteData(0x00);//D15=VS D14=HS D13=CLK D12-9=NC D8=0=Video with blanking packet. 00-F0
	 


	//MIPI lane configuration
	SPI_WriteCmd(0xDE);//
	SPI_WriteData(0x03);//11=4LANE 10=3LANE 01=2LANE 00=1LANE
	SPI_WriteData(0x00);

	SPI_WriteCmd(0xD6);//  05=BGR  04=RGB
	SPI_WriteData(0x01);//D0=0=RGB 1:BGR D1=1=Most significant byte sent first
	SPI_WriteData(0x00);

 	SPI_WriteCmd(0xDB);
	SPI_WriteData(0x58);
	SPI_WriteData(0x00);


	SPI_WriteCmd(0xB7);
	SPI_WriteData(0x4B);   
	SPI_WriteData(0x02);

	SPI_WriteCmd(0x2c);			     

}

#endif


