#include "epd.h"
#include "epd_font.h"
#include "string.h"

uint8_t ImageBW[ALLSCREEN_BYTES];

/**
 * @brief       EPDϻһ
 * @param       x:ص
 * @param       y:ص
 * @param       color:ɫֵ
 * @retval      
 */
void EPD_DrawPoint(uint16_t x, uint16_t y, uint8_t color)
{
    uint8_t dat = 0;
    uint16_t xpoint, ypoint;
    uint32_t Addr;
    switch (USE_HORIZONTIAL)
    {
    case 0:
        xpoint = EPD_H - y - 1;
        ypoint = x;
        break;
    case 1:
        xpoint = x;
        ypoint = y;
        break;
    case 2:
        xpoint = y;
        ypoint = EPD_W - x - 1;
        break;
    case 3:
        xpoint = EPD_W - x - 1;
        ypoint = EPD_H - y - 1;
        break;
    default:
        return;
    }
#if USE_HORIZONTIAL == 0 | USE_HORIZONTIAL == 2
    Addr = xpoint / 4 + ypoint * ((EPD_H % 4 == 0) ? (EPD_H / 4) : (EPD_H / 4 + 1));
#else
    Addr = xpoint / 4 + ypoint * ((EPD_W % 4 == 0) ? (EPD_W / 4) : (EPD_W / 4 + 1));
#endif
    dat = ImageBW[Addr];
    color = color % 4;
    dat = dat & (~(0xC0 >> ((xpoint % 4) * 2)));
    ImageBW[Addr] = dat | ((color << 6) >> ((xpoint % 4) * 2));
}

/**
 * @brief       仺溯
 * @param       xs:λõʼ
 * @param       ys:λõʼ
 * @param       xe:λõĽ
 * @param       ye:λõĽ
 * @param       color:λõɫֵ
 * @retval      
 */
void EPD_Clear(uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye, uint8_t color)
{
    uint16_t x, y;
    for (y = ys; y < ye; y++)
    {
        for (x = xs; x < xe; x++)
        {
            EPD_DrawPoint(x, y, color);
        }
    }
}

/**
 * @brief       ֮仭ߺ
 * @param       xs:ߵʼ
 * @param       ys:ߵʼ
 * @param       xe:ߵĽ
 * @param       ye:ߵĽ
 * @param       color:ߵɫֵ
 * @retval      
 */
void EPD_DrawLine(uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye, uint8_t color)
{
    uint16_t t;
    int xerr = 0, yerr = 0, delta_x, delta_y, distance;
    int incx, incy, uRow, uCol;
    delta_x = xe - xs; // 
    delta_y = ye - ys;
    uRow = xs;
    uCol = ys;
    if (delta_x > 0)
    {
        incx = 1; // õ
    }
    else if (delta_x == 0)
    {
        incx = 0; // ֱ
    }
    else
    {
        incx = -1;
        delta_x = -delta_x;
    }
    if (delta_y > 0)
    {
        incy = 1;
    }
    else if (delta_y == 0)
    {
        incy = 0; // ˮƽ
    }
    else
    {
        incy = -1;
        delta_y = -delta_y;
    }
    if (delta_x > delta_y)
    {
        distance = delta_x; // ѡȡ
    }
    else
    {
        distance = delta_y;
    }
    for (t = 0; t <= distance + 1; t++) // 
    {
        EPD_DrawPoint(uRow, uCol, color); // 
        xerr += delta_x;
        yerr += delta_y;
        if (xerr > distance)
        {
            xerr -= distance;
            uRow += incx;
        }
        if (yerr > distance)
        {
            yerr -= distance;
            uCol += incy;
        }
    }
}

/**
 * @brief       ƿľκ
 * @param       xs:εʼ
 * @param       ys:εʼ
 * @param       xe:εĽ
 * @param       ye:εĽ
 * @param       color:εɫֵ
 * @param       mode:Ƿ
 * @retval      
 */
void EPD_DrawRectangle(uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye, uint8_t color, uint8_t mode)
{
    uint16_t i;
    if (mode)
    {
        for (i = ys; i < ye; i++)
        {
            EPD_DrawLine(xs, i, xe, i, color);
        }
    }
    else
    {
        EPD_DrawLine(xs, ys, xe, ys, color);
        EPD_DrawLine(xs, ys, xs, ye, color);
        EPD_DrawLine(xs, ye, xe, ye, color);
        EPD_DrawLine(xe, ys, xe, ye, color);
    }
}

/**
 * @brief       8ַԲ(ڲ)
 * @param       xc:Բ
 * @param       yc:Բ
 * @param       x:Բĵ
 * @param       y:Բĵ
 * @param       color:Բεɫֵ
 * @retval      
 */
void Draw_Circle(int xc, int yc, int x, int y, uint8_t color)
{
    EPD_DrawPoint(xc + x, yc + y, color);
    EPD_DrawPoint(xc - x, yc + y, color);
    EPD_DrawPoint(xc + x, yc - y, color);
    EPD_DrawPoint(xc - x, yc - y, color);
    EPD_DrawPoint(xc + y, yc + x, color);
    EPD_DrawPoint(xc - y, yc + x, color);
    EPD_DrawPoint(xc + y, yc - x, color);
    EPD_DrawPoint(xc - y, yc - x, color);
}

/**
 * @brief       Բ
 * @param       xc:Բ
 * @param       yc:Բ
 * @param       r:Բΰ뾶
 * @param       color:Բεɫֵ
 * @param       mode:ǷԲ
 * @retval      
 */
void EPD_DrawCircle(uint16_t xc, uint16_t yc, uint16_t r, uint8_t color, uint16_t mode)
{
    int x = 0, y = r, yi, d;
    d = 3 - 2 * r;
    /*ʵԲ*/
    if (mode)
    {
        while (x <= y)
        {
            for (yi = x; yi <= y; yi++)
            {
                Draw_Circle(xc, yc, x, yi, color);
            }
            if (d < 0)
            {
                d = d + 4 * x + 6;
            }
            else
            {
                d = d + 4 * (x - y) + 10;
                y--;
            }
            x++;
        }
    }
    /*ƿԲ*/
    else
    {
        while (x <= y)
        {
            Draw_Circle(xc, yc, x, y, color);
            if (d < 0)
            {
                d = d + 4 * x + 6;
            }
            else
            {
                d = d + 4 * (x - y) + 10;
                y--;
            }
            x++;
        }
    }
}

/**
 * @brief       ƿ
 * @param       x:ʼ
 * @param       y:ʼ
 * @param       xs:ζ
 * @param       ys:ζ
 * @param       xe:ĩ
 * @param       ye:ĩ
 * @param       color:εɫֵ
 * @retval      
 */
void EPD_DrawTriangel(uint16_t x, uint16_t y, uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye, uint8_t color)
{
    EPD_DrawLine(x, y, xs, ys, color);
    EPD_DrawLine(xs, ys, xe, ye, color);
    EPD_DrawLine(xe, ye, x, y, color);
}

/**
 * @brief       ʾַ
 * @param       x:ַʾλʼ
 * @param       y:ַʾλʼ
 * @param       num:ʾַASCII
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowChar(uint16_t x, uint16_t y, uint8_t num, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint8_t temp, sizex, t;
    uint16_t i, TypefaceNum; // һַռֽڴС
    uint16_t x0 = x;
    sizex = sizey / 2;
    TypefaceNum = (sizex / 8 + ((sizex % 8) ? 1 : 0)) * sizey;
    num = num - ' '; // õƫƺֵ
    for (i = 0; i < TypefaceNum; i++)
    {
        if (sizey == 12)
            temp = ascii_1206[num][i]; // 6x12
        else if (sizey == 16)
            temp = ascii_1608[num][i]; // 8x16
        else if (sizey == 24)
            temp = ascii_2412[num][i]; // 12x24
        else if (sizey == 48)
            temp = ascii_4824[num][i]; // 24x48
        else
            return;
        for (t = 0; t < 8; t++)
        {
            if (temp & (0x01 << t))
            {
                EPD_DrawPoint(x, y, fc); // һ
            }
            else
            {
                EPD_DrawPoint(x, y, bc);
            }
            x++;
            if ((x - x0) == sizex)
            {
                x = x0;
                y++;
                break;
            }
        }
    }
}

/**
 * @brief       ʾַ
 * @param       x:ַʾλʼ
 * @param       y:ַʾλʼ
 * @param       *s:ʾַ
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowString(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint16_t sizey)
{
    while ((*s <= '~') && (*s >= ' ')) // жǲǷǷַ
    {
        if (x > (EPD_W - 1) || y > (EPD_H - 1))
            return;
        EPD_ShowChar(x, y, *s, fc, bc, sizey);
        x += sizey / 2;
        s++;
    }
}

/**
 * @brief       (ڲ)
 * @param       m:
 * @param       n:ָ
 * @retval      result:mn
 */
uint32_t mypow(uint8_t m, uint8_t n)
{
    uint32_t result = 1;
    while (n--)
    {
        result *= m;
    }
    return result;
}

/**
 * @brief       ʾ
 * @param       x:ʾλʼ
 * @param       y:ʾλʼ
 * @param       num:ʾ(0~4294967295)
 * @param       len:ʾֵλ
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint8_t t, temp, enshow = 0;
    uint8_t sizex = sizey / 2;
    for (t = 0; t < len; t++)
    {
        temp = (num / mypow(10, len - t - 1)) % 10;
        if (enshow == 0 && t < (len - 1))
        {
            if (temp == 0)
            {
                EPD_ShowChar(x + t * sizex, y, ' ', fc, bc, sizey);
                continue;
            }
            else
            {
                enshow = 1;
            }
        }
        EPD_ShowChar(x + t * sizex, y, temp + '0', fc, bc, sizey);
    }
}

/**
 * @brief       ʾ
 * @param       x:ʾλʼ
 * @param       y:ʾλʼ
 * @param       num:ʾĸ
 * @param       pre:ʾ
 * @param       len:ʾλ(С)
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowFloatNum(uint16_t x, uint16_t y, float num, uint8_t pre, uint8_t len, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint32_t i, temp, num1;
    uint8_t sizex = sizey / 2;
    num1 = num * mypow(10, pre);
    for (i = 0; i < len; i++)
    {
        temp = (num1 / mypow(10, len - i - 1)) % 10;
        if (i == (len - pre))
        {
            EPD_ShowChar(x + (len - pre) * sizex, y, '.', fc, bc, sizey);
            i++;
            len += 1;
        }
        EPD_ShowChar(x + i * sizex, y, temp + '0', fc, bc, sizey);
    }
}

/**
 * @brief       ʾ12x12
 * @param       x:ʾλʼ
 * @param       y:ʾλʼ
 * @param       *s:ʾַʼַ
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowChinese12x12(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint8_t i, j;
    uint16_t k, HZnum;    // Ŀ
    uint16_t TypefaceNum; // һַռֽڴС
    uint16_t x0 = x;
    TypefaceNum = (sizey / 8 + ((sizey % 8) ? 1 : 0)) * sizey;
    HZnum = sizeof(tfont12) / sizeof(typFONT_GB12); // ͳƺĿ
    for (k = 0; k < HZnum; k++)
    {
        if ((tfont12[k].Index[0] == *(s)) && (tfont12[k].Index[1] == *(s + 1)))
        {
            for (i = 0; i < TypefaceNum; i++)
            {
                for (j = 0; j < 8; j++)
                {
                    if (tfont12[k].Msk[i] & (0x01 << j))
                    {
                        EPD_DrawPoint(x, y, fc); // һ
                    }
                    else
                    {
                        EPD_DrawPoint(x, y, bc);
                    }
                    x++;
                    if ((x - x0) == sizey)
                    {
                        x = x0;
                        y++;
                        break;
                    }
                }
            }
        }
        continue; // ҵӦֿ˳ֹظȡģӰ
    }
}

/**
 * @brief       ʾ16x16
 * @param       x:ʾλʼ
 * @param       y:ʾλʼ
 * @param       *s:ʾַʼַ
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowChinese16x16(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint8_t i, j;
    uint16_t k, HZnum;    // Ŀ
    uint16_t TypefaceNum; // һַռֽڴС
    uint16_t x0 = x;
    TypefaceNum = (sizey / 8 + ((sizey % 8) ? 1 : 0)) * sizey;
    HZnum = sizeof(tfont16) / sizeof(typFONT_GB16); // ͳƺĿ
    for (k = 0; k < HZnum; k++)
    {
        if ((tfont16[k].Index[0] == *(s)) && (tfont16[k].Index[1] == *(s + 1)))
        {
            for (i = 0; i < TypefaceNum; i++)
            {
                for (j = 0; j < 8; j++)
                {
                    if (tfont16[k].Msk[i] & (0x01 << j))
                    {
                        EPD_DrawPoint(x, y, fc); // һ
                    }
                    else
                    {
                        EPD_DrawPoint(x, y, bc);
                    }
                    x++;
                    if ((x - x0) == sizey)
                    {
                        x = x0;
                        y++;
                        break;
                    }
                }
            }
        }
        continue; // ҵӦֿ˳ֹظȡģӰ
    }
}

/**
 * @brief       ʾ24x24
 * @param       x:ʾλʼ
 * @param       y:ʾλʼ
 * @param       *s:ʾַʼַ
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowChinese24x24(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint8_t i, j;
    uint16_t k, HZnum;    // Ŀ
    uint16_t TypefaceNum; // һַռֽڴС
    uint16_t x0 = x;
    TypefaceNum = (sizey / 8 + ((sizey % 8) ? 1 : 0)) * sizey;
    HZnum = sizeof(tfont24) / sizeof(typFONT_GB24); // ͳƺĿ
    for (k = 0; k < HZnum; k++)
    {
        if ((tfont24[k].Index[0] == *(s)) && (tfont24[k].Index[1] == *(s + 1)))
        {
            for (i = 0; i < TypefaceNum; i++)
            {
                for (j = 0; j < 8; j++)
                {
                    if (tfont24[k].Msk[i] & (0x01 << j))
                    {
                        EPD_DrawPoint(x, y, fc); // һ
                    }
                    else
                    {
                        EPD_DrawPoint(x, y, bc);
                    }
                    x++;
                    if ((x - x0) == sizey)
                    {
                        x = x0;
                        y++;
                        break;
                    }
                }
            }
        }
        continue; // ҵӦֿ˳ֹظȡģӰ
    }
}

/**
 * @brief       ʾִ
 * @param       x:ʾλʼ
 * @param       y:ʾλʼ
 * @param       *s:ʾַ
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowChinese(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    while (*s != 0)
    {
        if (sizey == 12)
            EPD_ShowChinese12x12(x, y, s, fc, bc, sizey);
        else if (sizey == 16)
            EPD_ShowChinese16x16(x, y, s, fc, bc, sizey);
        else if (sizey == 24)
            EPD_ShowChinese24x24(x, y, s, fc, bc, sizey);
        else
            return;
        s += 2;
        x += sizey;
    }
}

/**
 * @brief       Ӣַ
 * @param       x:ʾλʼ
 * @param       y:ʾλʼ
 * @param       *s:ʾַʼַ
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowStr(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint16_t x0 = x;
    uint8_t bHz = 0; // ַ
    while (*s != 0)  // δ
    {
        if (!bHz) // Ӣ
        {
            if (x > (EPD_W - sizey / 2) || y > (EPD_H - sizey))
            {
                return;
            }
            if (*s > 0x80)
            {
                bHz = 1; // 
            }
            else // ַ
            {
                if (*s == 0x0D) // з
                {
                    y += sizey;
                    x = x0;
                    s++;
                }
                else
                {
                    EPD_ShowChar(x, y, *s, fc, bc, sizey);
                    x += sizey / 2; // ַ,Ϊȫֵһ
                }
                s++;
            }
        }
        else // 
        {
            if (x > (EPD_W - sizey) || y > (EPD_H - sizey))
            {
                return;
            }
            bHz = 0;
            if (sizey == 12)
                EPD_ShowChinese12x12(x, y, s, fc, bc, sizey);
            else if (sizey == 16)
                EPD_ShowChinese16x16(x, y, s, fc, bc, sizey);
            else if (sizey == 24)
                EPD_ShowChinese24x24(x, y, s, fc, bc, sizey);
            s += 2;
            x += sizey;
        }
    }
}

/**
 * @brief       ַʾ
 * @param       x:Ч
 * @param       y:ʾλʼ
 * @param       *s:ʾַʼַ
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_StrCenter(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint16_t len = strlen((const char *)s);
    uint16_t x1 = (EPD_W - len * 8) / 2;
    EPD_ShowStr(x1, y, s, fc, bc, sizey);
}

/**
 * @brief       ͼƬʾ
 * @param       x:ͼƬʾλʼ
 * @param       y:ͼƬʾλʼ
 * @param       width:ͼƬ
 * @param       height:ͼƬ߶
 * @param       pic:ͼƬȡģ
 * @note        ͼƬȱ4ı
 * @retval      
 */
void EPD_ShowPicture(uint16_t x, uint16_t y, uint16_t width, uint16_t height, const uint8_t pic[])
{
    uint8_t temp;
    uint16_t x0 = x;
    uint32_t i, TypefaceNum; // һͼƬռֽڴС
    TypefaceNum = ((width % 4) ? (width / 4 + 1) : (width / 4)) * height;
    for (i = 0; i < TypefaceNum; i++)
    {
        temp = pic[i];
        EPD_DrawPoint(x, y, (temp >> 6 & 0x03));
        EPD_DrawPoint(x + 1, y, (temp >> 4 & 0x03));
        EPD_DrawPoint(x + 2, y, (temp >> 2 & 0x03));
        EPD_DrawPoint(x + 3, y, (temp & 0x03));
        x += 4;
        if ((x - x0) == width)
        {
            x = x0;
            y++;
        }
    }
}

/**
 * @brief       ַʵUI
 * @param       x:UIʾλʼ
 * @param       y:UIʾλʼ
 * @param       num:ʾĸ
 * @param       pre:ʾ
 * @param       len:ʾλ(С)
 * @param       fc:ַɫ
 * @param       bc:ַɫ
 * @param       sizey:ַС
 * @retval      
 */
void EPD_ShowWatch(uint16_t x, uint16_t y, float num, uint8_t pre, uint8_t len, uint8_t fc, uint8_t bc, uint8_t sizey)
{
    uint8_t t, temp, sizex;
    uint16_t num1;
    sizex = sizey / 2;
    num1 = num * mypow(10, pre);
    for (t = 0; t < len; t++)
    {
        temp = (num1 / mypow(10, len - t - 1)) % 10;
        if (t == (len - pre))
        {
            EPD_ShowChar(x + (len - pre) * sizex + (sizex / 2 - 2), y - 6, ':', fc, bc, sizey);
            t++;
            len += 1;
        }
        EPD_ShowChar(x + t * sizex, y, temp + 48, fc, bc, sizey);
    }
}



