#ifndef _EPD_H_
#define _EPD_H_

#include "epd_init.h"

/* ˵ */
void EPD_DrawPoint(uint16_t x, uint16_t y, uint8_t color);
void EPD_Clear(uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye, uint8_t color);                                         // 仺溯
void EPD_DrawLine(uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye, uint8_t color);                                      // ߺ
void EPD_DrawRectangle(uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye, uint8_t color, uint8_t mode);                   // ƿľ
void Draw_Circle(int xc, int yc, int x, int y, uint8_t color);                                                             // 8ַԲڲ
void EPD_DrawCircle(uint16_t xc, uint16_t yc, uint16_t r, uint8_t color, uint16_t mode);                                   // Բ
void EPD_DrawTriangel(uint16_t x, uint16_t y, uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye, uint8_t color);          // ƿ
void EPD_ShowChar(uint16_t x, uint16_t y, uint8_t num, uint8_t fc, uint8_t bc, uint8_t sizey);                             // ʾַ
void EPD_ShowString(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint16_t sizey);                        // ʾַ
uint32_t mypow(uint8_t m, uint8_t n);                                                                                      // ڲ
void EPD_ShowNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t fc, uint8_t bc, uint8_t sizey);                // ʾ
void EPD_ShowFloatNum(uint16_t x, uint16_t y, float num, uint8_t pre, uint8_t len, uint8_t fc, uint8_t bc, uint8_t sizey); // ʾ
void EPD_ShowChinese12x12(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey);                   // ʾ12x12ַ
void EPD_ShowChinese16x16(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey);                   // ʾ16x16ַ
void EPD_ShowChinese24x24(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey);                   // ʾ24x24ַ
void EPD_ShowChinese32x32(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey);                   // ʾ32x32ַ
void EPD_ShowChinese(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey);                        // ʾַ
void EPD_ShowStr(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey);                            // Ӣ
void EPD_StrCenter(uint16_t x, uint16_t y, const char *s, uint8_t fc, uint8_t bc, uint8_t sizey);                          // ʾ
void EPD_ShowPicture(uint16_t x, uint16_t y, uint16_t width, uint16_t height, const uint8_t pic[]);                        // ͼƬʾ
void EPD_ShowWatch(uint16_t x, uint16_t y, float num, uint8_t pre, uint8_t len, uint8_t fc, uint8_t bc, uint8_t sizey);    // ʾ

#endif

