#include "epd_init.h"
#include "delay.h"

/**
 * @brief       ʼEPD˿
 * @param       
 * @retval      
 */
void EPD_GPIOInit(void)
{
    GPIO_InitTypeDef GPIO_InitStructure;
    RCC_APB2PeriphClockCmd(EPD_RES_GPIO_CLK|EPD_DC_GPIO_CLK|EPD_BUSY_GPIO_CLK,ENABLE);

    GPIO_InitStructure.GPIO_Pin=EPD_RES_GPIO_PIN;
    GPIO_InitStructure.GPIO_Mode =GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_Init(EPD_RES_GPIO_PORT,&GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin=EPD_DC_GPIO_PIN;
    GPIO_InitStructure.GPIO_Mode =GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_Init(EPD_DC_GPIO_PORT,&GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin=EPD_BUSY_GPIO_PIN;
    GPIO_InitStructure.GPIO_Mode =GPIO_Mode_IN_FLOATING;
    GPIO_Init(EPD_BUSY_GPIO_PORT,&GPIO_InitStructure);
}

/**
 * @brief       īˮдĴ
 * @param       reg: Ҫд
 * @retval      
 */
void EPD_WR_REG(uint8_t reg)
{
    EPD_DC_Clr();
    BSP_SPI_WR_Bus(reg);
    EPD_DC_Set();
}

/**
 * @brief       īˮдһֽ
 * @param       dat: Ҫд
 * @retval      
 */
void EPD_WR_DATA8(uint8_t dat)
{
    EPD_DC_Set();
    BSP_SPI_WR_Bus(dat);
    EPD_DC_Set();
}

/**
 * @brief       EPDæ
 * @param       
 * @retval      
 * @note        BUSY ͵ƽΪæ״̬ ߵƽΪ״̬
 */
void EPD_READBUSY(void)
{
    while (1)
    {
        if (EPD_ReadBUSY == 1)
        {
            break;
        }
    }
}

/**
 * @brief       EPDӲλ
 * @param       
 * @retval      
 * @note        ˳ʱҪһӲλ
 */
void EPD_HW_RESET(void)
{
    EPD_RES_Set();
    delay_ms(100);
    EPD_RES_Clr();
    delay_ms(100);
    EPD_RES_Set();
    delay_ms(100);
}

/**
 * @brief       EPDģʽ
 * @param       
 * @retval      
 * @note        ͬģʽ¹Ĳͬ Ĭģʽ1 RAM
 */
void EPD_Sleep(void)
{
    EPD_WR_REG(0x02); // 0x02 Power OFF 
    EPD_WR_DATA8(0x00);
    EPD_READBUSY();

    EPD_WR_REG(0x07); // 0x07 Deep_Sleep 
    EPD_WR_DATA8(0xA5);
}

/**
 * @brief       EPDȫˢģʽʾ
 * @param       
 * @retval      
 */
void EPD_Update(void)
{
    EPD_WR_REG(0X04); // power on 
    delay_ms(50);
    EPD_READBUSY();

    EPD_WR_REG(0x12); // 0x12 Display Refresh 
    EPD_WR_DATA8(0x00);
    EPD_READBUSY();
}

/**
 * @brief       EPDȫɫ
 * @param       colorɫֵ
 * @retval      
 */
void EPD_All_Fill(uint8_t color)
{
    uint8_t dat;
    uint32_t i;
    EPD_WR_REG(0x10); /* дRAMָ οSSD1680 datasheet */
    switch (color)
    {
    case 0x00:
        dat = 0x00;
        break;
    case 0x01:
        dat = 0x55;
        break;
    case 0x02:
        dat = 0xAA;
        break;
    case 0x03:
        dat = 0xFF;
    default:
        break;
    }
    for (i = 0; i < ALLSCREEN_BYTES; i++)
    {
        EPD_WR_DATA8(dat);
    }
    EPD_READBUSY();
}

/**
 * @brief       EPDȫʾͼ
 * @param       ImageBWͼ
 * @retval      
 */
void EPD_DisplayImage(const uint8_t *ImageBW)
{
    uint8_t temp, dataH1, dataH2, dataL1, dataL2, dat;
    uint32_t i;
    EPD_WR_REG(0x10);
    for (i = 0; i < ALLSCREEN_BYTES; i++)
    {
        temp = ImageBW[i];
        dataH1 = (temp >> 6 & 0x03) << 6;
        dataH2 = (temp >> 4 & 0x03) << 4;
        dataL1 = (temp >> 2 & 0x03) << 2;
        dataL2 = (temp & 0x03);
        dat = dataH1 | dataH2 | dataL1 | dataL2;
        EPD_WR_DATA8(dat);
    }
}

/**
 * @brief       ʼEPD
 * @param       
 * @retval      
 */
void EPD_Init(void)
{
    EPD_GPIOInit(); /* ʼEPDź */
    
    EPD_HW_RESET();/* ִӲλ EPD */

   

   EPD_WR_REG(0x00);     
   EPD_WR_DATA8(0xCF);
   EPD_WR_DATA8(0x29);

    
   EPD_WR_REG(0x01);  
   EPD_WR_DATA8(0x07);

    
   EPD_WR_REG(0x06);   //bst level modify    
   EPD_WR_DATA8(0x80);  //PWM0[7:6]	x	x,	x	x	x	x		default=0x00	
   EPD_WR_DATA8(0x80);  //PWM1[7:6]	x	x,	x	x	x	x		default=0x00
   EPD_WR_DATA8(0x80);  //x	x	x	x,	x	x	x	x		default=0x00 
 
   
   EPD_WR_REG(0x61);   // RESOLUTION SETTING
   EPD_WR_DATA8(0x00);  	 //240
   EPD_WR_DATA8(0xF0);
   EPD_WR_DATA8(0x01);	 //416
   EPD_WR_DATA8(0xA0);   
   
   
   EPD_WR_REG(0x30);    // Controlling PLL    
   EPD_WR_DATA8(0x08);  // 02:50HZ
   
   EPD_WR_REG(0x03);  
   EPD_WR_DATA8(0x10);
   EPD_WR_DATA8(0x54); 
   EPD_WR_DATA8(0x44); 

   EPD_WR_REG(0x50);  
   EPD_WR_DATA8(0x37); 
   
   EPD_WR_REG(0x60);  
   EPD_WR_DATA8(0x03); 
   EPD_WR_DATA8(0x03); 

   
   EPD_WR_REG(0xE7);
   EPD_WR_DATA8(0x1C);  
   
   EPD_WR_REG(0xE9);
   EPD_WR_DATA8(0x01); 


   EPD_WR_REG(0xFF);     
   EPD_WR_DATA8(0xA5);
   
   EPD_WR_REG(0xEF);     
   EPD_WR_DATA8(3);//H0
   EPD_WR_DATA8(50);//L0
   
   EPD_WR_DATA8(6);//H1
   EPD_WR_DATA8(65);//L1
   
   EPD_WR_DATA8(7);//H2
   EPD_WR_DATA8(32);//L2   
  
   EPD_WR_REG(0xDC); //CPCK EN    
   EPD_WR_DATA8(0x01);
   
   EPD_WR_REG(0xDD); //CPCK H   
   EPD_WR_DATA8(6);  
   
   EPD_WR_REG(0xDE); //CPCK L   
   EPD_WR_DATA8(66);      
  

   
   EPD_WR_REG(0xFD); //VDLOS_EN
   EPD_WR_DATA8(0x00); 
   
   EPD_WR_REG(0xE8); 
   EPD_WR_DATA8(0x03);    
   
   EPD_WR_REG(0xDA); 
   EPD_WR_DATA8(0x0E);    
   
   EPD_WR_REG(0xC9); 
   EPD_WR_DATA8(0x00);     
   
   EPD_WR_REG(0xA8); 
   EPD_WR_DATA8(0x0E);     
   
   EPD_WR_REG(0xFF); // Exit Test command	  ***********
   EPD_WR_DATA8(0xE3); 



}






