#ifndef _EPD_INIT_H_
#define _EDP_INIT_H_

#include "spi.h"

/* īˮʾ */
#define USE_HORIZONTIAL 1 /* 0 1 2 3 */

#if USE_HORIZONTIAL == 0 | USE_HORIZONTIAL == 2
#define EPD_W 416
#define EPD_H 240
#define ALLSCREEN_BYTES ((EPD_H % 4) ? (EPD_H / 4 + 1) : (EPD_H / 4)) * EPD_W
#else
#define EPD_W 240
#define EPD_H 416
#define ALLSCREEN_BYTES ((EPD_W % 4) ? (EPD_W / 4 + 1) : (EPD_W / 4)) * EPD_H
#endif

/* ɫ */
#define BLACK 0x00
#define WHITE 0x01
#define YELLOW 0x02
#define RED 0x03


/* ˿ڶ */
#define EPD_RES_GPIO_PORT   GPIOD
#define EPD_RES_GPIO_PIN    GPIO_Pin_2
#define EPD_RES_GPIO_CLK    RCC_APB2Periph_GPIOD

#define EPD_DC_GPIO_PORT    GPIOB
#define EPD_DC_GPIO_PIN GPIO_Pin_5
#define EPD_DC_GPIO_CLK RCC_APB2Periph_GPIOB

#define EPD_BUSY_GPIO_PORT  GPIOB
#define EPD_BUSY_GPIO_PIN   GPIO_Pin_6
#define EPD_BUSY_GPIO_CLK   RCC_APB2Periph_GPIOB

#define EPD_RES_Clr() GPIO_ResetBits(EPD_RES_GPIO_PORT,EPD_RES_GPIO_PIN)
#define EPD_RES_Set() GPIO_SetBits(EPD_RES_GPIO_PORT,EPD_RES_GPIO_PIN)

#define EPD_DC_Clr() GPIO_ResetBits(EPD_DC_GPIO_PORT,EPD_DC_GPIO_PIN)
#define EPD_DC_Set() GPIO_SetBits(EPD_DC_GPIO_PORT,EPD_DC_GPIO_PIN)

#define EPD_ReadBUSY GPIO_ReadInputDataBit(EPD_BUSY_GPIO_PORT,EPD_BUSY_GPIO_PIN)

/* ˵ */
void EPD_WR_REG(uint8_t reg);
void EPD_WR_DATA8(uint8_t dat);
void EPD_READBUSY(void);
void EPD_HW_RESET(void);
void EPD_Sleep(void);
void EPD_Update(void);
void EPD_All_Fill(uint8_t color);
void EPD_DisplayImage(const uint8_t *ImageBW);
void EPD_Init(void);
#endif


