#include "spi.h"

/**
 * @brief       ˿ڳʼ
 * @param       
 * @retval      
 */
void BSP_SPI_GPIOInit(void)
{
    SPI_InitTypeDef SPI_InitStructure;
    GPIO_InitTypeDef GPIO_InitStructure;
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_SPI1, ENABLE);                                    // SPIʱ
    RCC_APB2PeriphClockCmd(BSP_SPI_SCK_GPIO_CLK | BSP_SPI_MOSI_GPIO_CLK | BSP_SPI_CS_GPIO_CLK, ENABLE); // ܽŶӦʱ
    /********************GPIO***********************/

    GPIO_InitStructure.GPIO_Pin = BSP_SPI_SCK_GPIO_PIN;    // SCKܽ
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;    // Ϊ
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;  // IOڷתٶΪ50Mhz
    GPIO_Init(BSP_SPI_SCK_GPIO_PORT, &GPIO_InitStructure); // ʼSCKܽ
    GPIO_SetBits(BSP_SPI_SCK_GPIO_PORT, BSP_SPI_SCK_GPIO_PIN); // SCKܽ

    GPIO_InitStructure.GPIO_Pin = BSP_SPI_MOSI_GPIO_PIN;     // MOSIܽ
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;      // Ϊ
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;    // IOڷתٶΪ50Mhz
    GPIO_Init(BSP_SPI_MOSI_GPIO_PORT, &GPIO_InitStructure);  // ʼMOSIܽ
    GPIO_SetBits(BSP_SPI_MOSI_GPIO_PORT, BSP_SPI_MOSI_GPIO_PIN); // MOSIܽ

    GPIO_InitStructure.GPIO_Pin=BSP_SPI_CS_GPIO_PIN;
    GPIO_InitStructure.GPIO_Mode =GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_Init(BSP_SPI_CS_GPIO_PORT,&GPIO_InitStructure);
    GPIO_SetBits(BSP_SPI_CS_GPIO_PORT, BSP_SPI_CS_GPIO_PIN);
    
    /********************SPI***********************/
    SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_4; // SPI1APB2(ٶ:72Mhz)4ƵΪ18Mhz
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;                       // ڶʱؽв
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;                        // ʱ״̬Ϊ
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;                  // ݿΪ8bit
    SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex; // ȫ˫ģʽ
    SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;                 // ݸʽλǰ
    SPI_InitStructure.SPI_Mode = SPI_Mode_Master;                      // SPI1Ϊģʽ
    SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;                          // SPIƬѡͨ
    SPI_Init(SPI1, &SPI_InitStructure);                                // SPI1
    SPI_Cmd(SPI1, ENABLE);                                             // ʹSPI1
}

/**
 * @brief       IOģSPIһֽ
 * @param       dat: Ҫ͵ֽ
 * @retval      
 */
void BSP_SPI_WR_Bus(uint8_t TxData)
{
    BSP_SPI_CS_Clr();
    while(SPI_I2S_GetFlagStatus(SPI1,SPI_I2S_FLAG_TXE)==RESET);//ͻΪNULL־λ1ʼ
    SPI_I2S_SendData(SPI1,TxData);//SPI跢
    while(SPI_I2S_GetFlagStatus(SPI1,SPI_I2S_FLAG_BSY)==SET);//ⷢSPI账ڿ״̬
    BSP_SPI_CS_Set();
}
